/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.buildcraft;

import buildcraft.api.recipes.RefineryRecipes;
import codechicken.core.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import mods.neiplugins.common.ICachedRecipeWithLiquidTank;
import mods.neiplugins.common.LiquidHelper;
import mods.neiplugins.common.LiquidTank;
import mods.neiplugins.common.LiquidTemplateRecipeHandler;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class RefineryRecipeHandler
extends LiquidTemplateRecipeHandler {
    static final int yoffset = 20;
    static Rectangle input1Tank = new Rectangle(33, 23, 16, 16);
    static Rectangle input2Tank = new Rectangle(121, 23, 16, 16);
    static Rectangle outputTank = new Rectangle(77, 23, 16, 16);
    static Point overlayTank = new Point(177, 1);

    @Override
    public String getRecipeId() {
        return "buildcraft.refinery";
    }

    public String getRecipeName() {
        return "Refinery";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(52, 24, 23, 15), this.getRecipeId(), new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(96, 24, 23, 15), this.getRecipeId(), new Object[0]));
    }

    public Collection<RefineryRecipes.Recipe> getRecipes() {
        return RefineryRecipes.getRecipes();
    }

    @Override
    public void loadCraftingRecipes(FluidStack result) {
        for (RefineryRecipes.Recipe irecipe : this.getRecipes()) {
            if (!LiquidHelper.areSameLiquid(result, irecipe.result)) continue;
            this.arecipes.add(new CachedRefineryRecipe(irecipe));
        }
    }

    @Override
    public void loadUsageRecipes(FluidStack ingredient) {
        for (RefineryRecipes.Recipe irecipe : this.getRecipes()) {
            if (!LiquidHelper.areSameLiquid(ingredient, irecipe.ingredient1) && !LiquidHelper.areSameLiquid(ingredient, irecipe.ingredient2)) continue;
            this.arecipes.add(new CachedRefineryRecipe(irecipe));
        }
    }

    @Override
    public void loadSameRecipeId() {
        for (RefineryRecipes.Recipe irecipe : this.getRecipes()) {
            this.arecipes.add(new CachedRefineryRecipe(irecipe));
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        FluidStack t = LiquidHelper.getFluidStack(result);
        if (t != null) {
            this.loadCraftingRecipes(t);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        FluidStack t = LiquidHelper.getFluidStack(ingredient);
        if (t != null) {
            this.loadUsageRecipes(t);
        }
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)31, (int)166, (int)65);
    }

    public void drawExtras(int recipe) {
        int energy = ((CachedRefineryRecipe)this.arecipes.get((int)recipe)).energy;
        int delay = ((CachedRefineryRecipe)this.arecipes.get((int)recipe)).delay;
        GuiDraw.drawStringC((String)("Require " + energy + " MJ each " + (delay > 1 ? delay + " ticks" : "tick")), (int)82, (int)45, (int)-8355712, (boolean)false);
    }

    public String getGuiTexture() {
        return "buildcraft:textures/gui/refinery_filter.png";
    }

    public class CachedRefineryRecipe
    extends TemplateRecipeHandler.CachedRecipe
    implements ICachedRecipeWithLiquidTank {
        int energy;
        int delay;
        ArrayList<LiquidTank> tanks;

        public CachedRefineryRecipe(RefineryRecipes.Recipe recipe) {
            super((TemplateRecipeHandler)RefineryRecipeHandler.this);
            this.tanks = new ArrayList();
            LiquidTank tank = new LiquidTank(recipe.result, 4000, outputTank);
            tank.ignoreCapacity = true;
            tank.showMillBuckets = true;
            this.tanks.add(tank);
            tank = new LiquidTank(recipe.ingredient1, 4000, input1Tank);
            tank.ignoreCapacity = true;
            tank.showMillBuckets = true;
            this.tanks.add(tank);
            tank = new LiquidTank(recipe.ingredient2, 4000, input2Tank);
            tank.ignoreCapacity = true;
            tank.showMillBuckets = true;
            this.tanks.add(tank);
            this.energy = recipe.energy;
            this.delay = recipe.delay;
        }

        public PositionedStack getResult() {
            return null;
        }

        @Override
        public ArrayList<LiquidTank> getLiquidTanks() {
            return this.tanks;
        }
    }
}

