/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination;

import codechicken.lib.lighting.LightModel;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.IUVTransformation;
import codechicken.lib.render.IconTransformation;
import codechicken.lib.render.TextureUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import java.util.Map;
import mrtjp.projectred.ProjectRedIllumination;
import mrtjp.projectred.core.InvertX;
import mrtjp.projectred.illumination.LanternPart;
import mrtjp.projectred.illumination.RenderHalo;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderLantern
implements IItemRenderer {
    public static RenderLantern instance = new RenderLantern();
    private static Map<String, CCModel> models;
    public static final Cuboid6 lightBox;
    public static ms[] onIcons;
    public static ms[] offIcons;

    public static void registerIcons(mt mt2) {
        int n;
        offIcons = new ms[16];
        for (n = 0; n < 16; ++n) {
            RenderLantern.offIcons[n] = mt2.a("projectred:lights/lanternoff/" + n);
        }
        onIcons = new ms[16];
        for (n = 0; n < 16; ++n) {
            RenderLantern.onIcons[n] = mt2.a("projectred:lights/lanternon/" + n);
        }
    }

    public void renderLantern(LanternPart lanternPart) {
        ms ms2 = lanternPart.isOn() ? onIcons[lanternPart.type] : offIcons[lanternPart.type];
        TextureUtils.bindAtlas((int)0);
        CCRenderState.reset();
        CCRenderState.setBrightness((acf)lanternPart.world(), (int)lanternPart.x(), (int)lanternPart.y(), (int)lanternPart.z());
        CCRenderState.useModelColours((boolean)true);
        this.renderLanternBulb(ms2, lanternPart.x(), lanternPart.y(), lanternPart.z(), lanternPart.side);
    }

    public void renderLanternBulb(ms ms2, double d, double d2, double d3, int n) {
        this.renderPart(ms2, models.get("bulb"), d, d2, d3, 2);
        if (n == 0) {
            this.renderPart(ms2, models.get("standbottom"), d, d2, d3, 2);
            this.renderPart(ms2, models.get("goldringbottom"), d, d2, d3, 2);
        } else if (n == 1) {
            this.renderPart(ms2, models.get("standtop"), d, d2, d3, 2);
            this.renderPart(ms2, models.get("goldringtop"), d, d2, d3, 2);
        } else {
            this.renderPart(ms2, models.get("standside"), d, d2, d3, n);
            this.renderPart(ms2, models.get("goldringtop"), d, d2, d3, n);
        }
    }

    public boolean handleRenderType(ye ye2, IItemRenderer.ItemRenderType itemRenderType) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType itemRenderType, ye ye2, IItemRenderer.ItemRendererHelper itemRendererHelper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType itemRenderType, ye ye2, Object ... objectArray) {
        boolean bl = ye2.b() == ProjectRedIllumination.itemPartInvLantern();
        int n = ye2.k();
        switch (itemRenderType) {
            case ENTITY: {
                this.renderInventory(bl, n, -0.25, 0.0, -0.25, 1.0);
                return;
            }
            case EQUIPPED: {
                this.renderInventory(bl, n, -0.15, -0.15, -0.15, 2.0);
                return;
            }
            case EQUIPPED_FIRST_PERSON: {
                this.renderInventory(bl, n, -0.15, -0.15, -0.15, 2.0);
                return;
            }
            case INVENTORY: {
                this.renderInventory(bl, n, 0.0, -0.05, 0.0, 2.0);
                return;
            }
        }
    }

    public void renderInventory(boolean bl, int n, double d, double d2, double d3, double d4) {
        if (n > 15 || n < 0) {
            return;
        }
        ms ms2 = bl ? onIcons[n] : offIcons[n];
        GL11.glPushMatrix();
        GL11.glTranslated((double)d, (double)d2, (double)d3);
        GL11.glScaled((double)d4, (double)d4, (double)d4);
        CCRenderState.reset();
        TextureUtils.bindAtlas((int)0);
        CCRenderState.useNormals((boolean)true);
        CCRenderState.startDrawing((int)7);
        this.renderPart(ms2, models.get("bulb"), d, d2, d3, 2);
        this.renderPart(ms2, models.get("goldringtop"), d, d2, d3, 2);
        CCRenderState.draw();
        if (bl) {
            RenderHalo.prepareRenderState();
            RenderHalo.renderHalo(bfq.a, lightBox, n, (Transformation)new Translation(d, d2, d3));
            RenderHalo.restoreRenderState();
        }
        GL11.glPopMatrix();
    }

    public void renderPart(ms ms2, CCModel cCModel, double d, double d2, double d3, int n) {
        cCModel.render(0, cCModel.verts.length, (Transformation)Rotation.sideOrientation((int)0, (int)Rotation.rotationTo((int)0, (int)n)).at(Vector3.center).with((Transformation)new Translation(d, d2, d3)), (IUVTransformation)new IconTransformation(ms2), null);
    }

    static {
        lightBox = new Cuboid6(0.35, 0.25, 0.35, 0.65, 0.75, 0.65).expand(-0.015625);
        models = CCModel.parseObjModels((bjo)new bjo("projectred", "textures/obj/lights/lantern.obj"), (int)7, (Transformation)new InvertX());
        for (CCModel cCModel : models.values()) {
            cCModel.apply((Transformation)new Translation(0.5, 0.0, 0.5));
            cCModel.computeLighting(LightModel.standardLightModel);
            cCModel.shrinkUVs(5.0E-4);
        }
    }
}

