/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.lighting.LazyLightMatrix;
import codechicken.lib.render.IUVTransformation;
import codechicken.lib.render.IconTransformation;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.IRedstonePart;
import codechicken.multipart.JCuboidPart;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.NormalOcclusionTest;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TSlottedPart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import mrtjp.projectred.ProjectRedIllumination;
import mrtjp.projectred.core.BasicUtils;
import mrtjp.projectred.core.BasicWireUtils;
import mrtjp.projectred.illumination.ILight;
import mrtjp.projectred.illumination.RenderHalo;
import mrtjp.projectred.illumination.TileAirousLight;
import net.minecraftforge.common.ForgeDirection;

public abstract class BaseLightPart
extends JCuboidPart
implements TSlottedPart,
JNormalOcclusion,
IRedstonePart,
ILight {
    protected byte type;
    protected boolean isInverted;
    protected boolean powered;
    protected byte side;

    public void preparePlacement(int n, int n2, boolean bl) {
        this.isInverted = bl;
        this.side = (byte)n;
        this.type = (byte)n2;
    }

    public void writeDesc(MCDataOutput mCDataOutput) {
        mCDataOutput.writeByte((int)this.type);
        mCDataOutput.writeBoolean(this.isInverted);
        mCDataOutput.writeByte((int)this.side);
        mCDataOutput.writeBoolean(this.powered);
    }

    public void readDesc(MCDataInput mCDataInput) {
        this.type = mCDataInput.readByte();
        this.isInverted = mCDataInput.readBoolean();
        this.side = mCDataInput.readByte();
        this.powered = mCDataInput.readBoolean();
    }

    public void save(by by2) {
        by2.a("inverted", this.isInverted);
        by2.a("meta", this.type);
        by2.a("rot", this.side);
        by2.a("powered", this.powered);
    }

    public void load(by by2) {
        this.isInverted = by2.n("inverted");
        this.type = by2.c("meta");
        this.side = by2.a("rot") instanceof cf ? (byte)by2.e("rot") : by2.c("rot");
        this.powered = by2.n("powered");
    }

    public void onNeighborChanged() {
        if (this.checkSupport()) {
            return;
        }
        this.updateState(false);
    }

    public void onPartChanged(TMultiPart tMultiPart) {
        this.updateState(false);
    }

    public void onAdded() {
        this.updateState(true);
    }

    private boolean isBeingPowered() {
        return this.world().C(this.x(), this.y(), this.z());
    }

    public void updateState(boolean bl) {
        boolean bl2 = false;
        if (!this.world().I && this.powered != this.isBeingPowered()) {
            this.powered = !this.powered;
            this.updateRender();
            bl2 = true;
        }
        if (bl && !bl2) {
            this.updateRender();
        }
    }

    public void updateRender() {
        this.world().j(this.x(), this.y(), this.z());
        this.world().A(this.x(), this.y(), this.z());
        if (!this.world().I) {
            this.sendDescUpdate();
        }
    }

    public boolean checkSupport() {
        if (BasicUtils.isClient((abw)this.world())) {
            return false;
        }
        BlockCoord blockCoord = new BlockCoord(this.x(), this.y(), this.z()).offset((int)this.side);
        if (!(BasicWireUtils.canPlaceWireOnSide((abw)this.world(), (int)blockCoord.x, (int)blockCoord.y, (int)blockCoord.z, (ForgeDirection)ForgeDirection.getOrientation((int)(this.side ^ 1)), (boolean)false) || BasicWireUtils.canPlaceTorchOnBlock((abw)this.world(), (int)blockCoord.x, (int)blockCoord.y, (int)blockCoord.z, (boolean)false) && (this.side ^ 1) == 0)) {
            BasicUtils.dropItemFromLocation((abw)this.world(), (ye)this.getItem(), (boolean)false, null, (int)this.side, (int)10, (BlockCoord)new BlockCoord(this.x(), this.y(), this.z()));
            this.tile().remPart((TMultiPart)this);
            return true;
        }
        return false;
    }

    public boolean doesTick() {
        return this.isAirous();
    }

    public void update() {
        if (!this.world().I && this.isOn() && this.isAirous()) {
            int n = 16;
            int n2 = this.x() + this.world().s.nextInt(n) - this.world().s.nextInt(n);
            int n3 = this.y() + this.world().s.nextInt(n) - this.world().s.nextInt(n);
            int n4 = this.z() + this.world().s.nextInt(n) - this.world().s.nextInt(n);
            if (n3 > this.world().f(n2, n4) + 4) {
                n3 = this.world().f(n2, n4) + 4;
            }
            if (n3 < 7) {
                n3 = 7;
            }
            if (this.world().c(n2, n3, n4) && this.world().n(n2, n3, n4) < 8) {
                this.world().f(n2, n3, n4, ProjectRedIllumination.blockAirousLight().cF, this.getColor(), 3);
                TileAirousLight tileAirousLight = (TileAirousLight)this.world().r(n2, n3, n4);
                if (tileAirousLight != null) {
                    tileAirousLight.setSource(new BlockCoord((asp)this.tile()), this.getColor(), this.side);
                }
            }
        }
    }

    public boolean isAirous() {
        return false;
    }

    public int getLightValue() {
        if (this.powered != this.isInverted) {
            return 15;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void renderStatic(Vector3 var1, LazyLightMatrix var2, int var3);

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Vector3 vector3, float f, int n) {
        if (n == 0 && this.isOn()) {
            RenderHalo.addLight(this.x(), this.y(), this.z(), this.type, this.getLightBounds());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawBreaking(bfr bfr2) {
        RenderUtils.renderBlock((Cuboid6)this.getLightBounds(), (int)0, (Transformation)new Translation((double)this.x(), (double)this.y(), (double)this.z()), (IUVTransformation)new IconTransformation(bfr2.d), null);
    }

    public abstract String getType();

    public abstract Cuboid6 getBounds();

    public abstract Cuboid6 getLightBounds();

    public abstract ye getItem();

    public int getSlotMask() {
        return 1 << this.side;
    }

    public float getStrength(ata ata2, uf uf2) {
        return 2.0f;
    }

    public Iterable<ye> getDrops() {
        return Arrays.asList(this.getItem());
    }

    public ye pickItem(ata ata2) {
        return this.getItem();
    }

    public boolean occlusionTest(TMultiPart tMultiPart) {
        return NormalOcclusionTest.apply((JNormalOcclusion)this, (TMultiPart)tMultiPart);
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        return Arrays.asList(this.getBounds());
    }

    public boolean canConnectRedstone(int n) {
        return true;
    }

    public int strongPowerLevel(int n) {
        return 0;
    }

    public int weakPowerLevel(int n) {
        return 0;
    }

    @Override
    public boolean isOn() {
        return this.getLightValue() == 15;
    }

    @Override
    public int getColor() {
        return this.type;
    }
}

