/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.integration;

import biomesoplenty.api.Biomes;
import biomesoplenty.configuration.BOPConfigurationBiomeGen;
import biomesoplenty.integration.atg.GenModAbyss;
import biomesoplenty.integration.atg.GenModCanyonRavine;
import biomesoplenty.integration.atg.GenModGlacier;
import net.minecraft.world.biome.BiomeGenBase;
import ttftcuts.atg.api.ATGBiomes;
import ttftcuts.atg.api.IGenMod;

public class ATGIntegration {
    static double nb = 0.1;
    static double[] tiers = new double[]{1.0, 0.5, 0.3, 0.2, 0.1, 0.04};
    private static ATGBiomes.BiomeType land = ATGBiomes.BiomeType.LAND;
    private static ATGBiomes.BiomeType coast = ATGBiomes.BiomeType.COAST;
    private static ATGBiomes.BiomeType sea = ATGBiomes.BiomeType.SEA;

    protected static void init() {
        ATGIntegration.addSubBiomes();
        ATGIntegration.addLandBiomesGroup();
        ATGIntegration.addBeachBiomesGroup();
        ATGIntegration.addOceanBiomesGroup();
    }

    private static void addSubBiomes() {
        if (BOPConfigurationBiomeGen.meadowGen) {
            ATGBiomes.addSubBiome((BiomeGenBase)((BiomeGenBase)Biomes.meadow.get()), (BiomeGenBase)((BiomeGenBase)Biomes.meadowForest.get()), (double)1.0);
        }
        if (BOPConfigurationBiomeGen.canyonGen) {
            ATGBiomes.addSubBiome((BiomeGenBase)((BiomeGenBase)Biomes.canyon.get()), (BiomeGenBase)((BiomeGenBase)Biomes.canyonRavine.get()), (double)1.0);
        }
        if (BOPConfigurationBiomeGen.shrublandGen) {
            ATGBiomes.addSubBiome((BiomeGenBase)((BiomeGenBase)Biomes.shrubland.get()), (BiomeGenBase)((BiomeGenBase)Biomes.shrublandForest.get()), (double)0.5);
        }
        if (BOPConfigurationBiomeGen.ominousWoodsGen) {
            ATGBiomes.addSubBiome((BiomeGenBase)((BiomeGenBase)Biomes.ominousWoods.get()), (BiomeGenBase)((BiomeGenBase)Biomes.ominousWoodsThick.get()), (double)0.5);
        }
        if (BOPConfigurationBiomeGen.pastureGen) {
            ATGBiomes.addSubBiome((BiomeGenBase)((BiomeGenBase)Biomes.pasture.get()), (BiomeGenBase)((BiomeGenBase)Biomes.pastureMeadow.get()), (double)1.0);
        }
        if (BOPConfigurationBiomeGen.pastureGen) {
            ATGBiomes.addSubBiome((BiomeGenBase)((BiomeGenBase)Biomes.pasture.get()), (BiomeGenBase)((BiomeGenBase)Biomes.pastureThin.get()), (double)1.0);
        }
        if (BOPConfigurationBiomeGen.timberGen) {
            ATGBiomes.addSubBiome((BiomeGenBase)((BiomeGenBase)Biomes.timber.get()), (BiomeGenBase)((BiomeGenBase)Biomes.timberThin.get()), (double)0.5);
        }
        if (BOPConfigurationBiomeGen.alpsGen) {
            ATGBiomes.addSubBiome((BiomeGenBase)((BiomeGenBase)Biomes.alps.get()), (BiomeGenBase)((BiomeGenBase)Biomes.alpsForest.get()), (double)1.0);
        }
        if (BOPConfigurationBiomeGen.alpsGen) {
            ATGBiomes.addSubBiome((BiomeGenBase)((BiomeGenBase)Biomes.alps.get()), (BiomeGenBase)((BiomeGenBase)Biomes.alpsBase.get()), (double)1.0);
        }
        if (BOPConfigurationBiomeGen.seasonalForestGen) {
            ATGBiomes.addSubBiome((BiomeGenBase)((BiomeGenBase)Biomes.seasonalForest.get()), (BiomeGenBase)((BiomeGenBase)Biomes.seasonalSpruceForest.get()), (double)1.0);
        }
        if (BOPConfigurationBiomeGen.fieldGen) {
            ATGBiomes.addSubBiome((BiomeGenBase)((BiomeGenBase)Biomes.field.get()), (BiomeGenBase)((BiomeGenBase)Biomes.fieldForest.get()), (double)1.0);
        }
    }

    private static void addLandBiomesGroup() {
        ATGIntegration.addForestBiomesGroup();
        ATGIntegration.addJungleBiomesGroup();
        ATGIntegration.addPlainsBiomesGroup();
        ATGIntegration.addIcePlainsBiomesGroup();
        ATGIntegration.addTaigaBiomesGroup();
        ATGIntegration.addDesertBiomesGroup();
        ATGIntegration.addShrublandBiomesGroup();
        ATGIntegration.addBorealForestBiomesGroup();
        ATGIntegration.addTundraBiomesGroup();
        ATGIntegration.addSteppeBiomesGroup();
        ATGIntegration.addSavannahBiomesGroup();
        ATGIntegration.addTropicalShrublandBiomesGroup();
        ATGIntegration.addWoodlandBiomesGroup();
        ATGIntegration.addMesaBiomesGroup();
        ATGIntegration.addSwamplandBiomesGroup();
    }

    private static void addForestBiomesGroup() {
        if (BOPConfigurationBiomeGen.forestGen) {
            ATGBiomes.replaceBiome((ATGBiomes.BiomeType)land, (String)"Forest", (BiomeGenBase)BiomeGenBase.field_76767_f, (BiomeGenBase)((BiomeGenBase)Biomes.forestNew.get()), (double)tiers[0]);
        }
        if (BOPConfigurationBiomeGen.birchForestGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Forest", (BiomeGenBase)((BiomeGenBase)Biomes.birchForest.get()), (double)tiers[1]);
        }
        if (BOPConfigurationBiomeGen.woodlandGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Forest", (BiomeGenBase)((BiomeGenBase)Biomes.woodland.get()), (double)(tiers[1] * nb));
        }
        if (BOPConfigurationBiomeGen.spruceWoodsGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Forest", (BiomeGenBase)((BiomeGenBase)Biomes.spruceWoods.get()), (double)(tiers[1] * nb));
        }
        if (BOPConfigurationBiomeGen.coniferousForestGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Forest", (BiomeGenBase)((BiomeGenBase)Biomes.coniferousForest.get()), (double)(tiers[2] * nb));
        }
        if (BOPConfigurationBiomeGen.temperateRainforestGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Forest", (BiomeGenBase)((BiomeGenBase)Biomes.temperateRainforest.get()), (double)tiers[2]);
        }
        if (BOPConfigurationBiomeGen.redwoodForestGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Forest", (BiomeGenBase)((BiomeGenBase)Biomes.redwoodForest.get()), (double)tiers[2]);
        }
        if (BOPConfigurationBiomeGen.mountainGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Forest", (BiomeGenBase)((BiomeGenBase)Biomes.mountain.get()), (double)tiers[2]);
        }
        if (BOPConfigurationBiomeGen.autumnHillsGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Forest", (BiomeGenBase)((BiomeGenBase)Biomes.autumnHills.get()), (double)tiers[3]);
        }
        if (BOPConfigurationBiomeGen.mapleWoodsGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Forest", (BiomeGenBase)((BiomeGenBase)Biomes.mapleWoods.get()), (double)tiers[3]);
        }
        if (BOPConfigurationBiomeGen.seasonalForestGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Forest", (BiomeGenBase)((BiomeGenBase)Biomes.seasonalForest.get()), (double)tiers[3]);
        }
        if (BOPConfigurationBiomeGen.borealForestGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Forest", (BiomeGenBase)((BiomeGenBase)Biomes.borealForest.get()), (double)(tiers[3] * nb));
        }
        if (BOPConfigurationBiomeGen.deciduousForestGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Forest", (BiomeGenBase)((BiomeGenBase)Biomes.deciduousForest.get()), (double)tiers[3]);
        }
        if (BOPConfigurationBiomeGen.highlandGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Forest", (BiomeGenBase)((BiomeGenBase)Biomes.highland.get()), (double)(tiers[3] * nb));
        }
        if (BOPConfigurationBiomeGen.deadForestGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Forest", (BiomeGenBase)((BiomeGenBase)Biomes.deadForest.get()), (double)tiers[4]);
        }
        if (BOPConfigurationBiomeGen.groveGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Forest", (BiomeGenBase)((BiomeGenBase)Biomes.grove.get()), (double)tiers[4]);
        }
        if (BOPConfigurationBiomeGen.timberGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Forest", (BiomeGenBase)((BiomeGenBase)Biomes.timber.get()), (double)tiers[4]);
        }
        if (BOPConfigurationBiomeGen.thicketGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Forest", (BiomeGenBase)((BiomeGenBase)Biomes.thicket.get()), (double)tiers[4]);
        }
        if (BOPConfigurationBiomeGen.shieldGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Forest", (BiomeGenBase)((BiomeGenBase)Biomes.shield.get()), (double)tiers[4]);
        }
        if (BOPConfigurationBiomeGen.fungiForestGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Forest", (BiomeGenBase)((BiomeGenBase)Biomes.fungiForest.get()), (double)tiers[5]);
        }
        if (BOPConfigurationBiomeGen.cherryBlossomGroveGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Forest", (BiomeGenBase)((BiomeGenBase)Biomes.cherryBlossomGrove.get()), (double)tiers[5]);
        }
        if (BOPConfigurationBiomeGen.mysticGroveGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Forest", (BiomeGenBase)((BiomeGenBase)Biomes.mysticGrove.get()), (double)tiers[5]);
        }
        if (BOPConfigurationBiomeGen.hotSpringsGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Forest", (BiomeGenBase)((BiomeGenBase)Biomes.hotSprings.get()), (double)tiers[5]);
        }
        if (BOPConfigurationBiomeGen.originValleyGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Forest", (BiomeGenBase)((BiomeGenBase)Biomes.originValley.get()), (double)(tiers[5] * 0.5));
        }
    }

    private static void addJungleBiomesGroup() {
        if (BOPConfigurationBiomeGen.jungleGen) {
            ATGBiomes.replaceBiome((ATGBiomes.BiomeType)land, (String)"Jungle", (BiomeGenBase)BiomeGenBase.field_76782_w, (BiomeGenBase)((BiomeGenBase)Biomes.jungleNew.get()), (double)tiers[0]);
        }
        if (BOPConfigurationBiomeGen.tropicalRainforestGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Jungle", (BiomeGenBase)((BiomeGenBase)Biomes.tropicalRainforest.get()), (double)tiers[1]);
        }
        if (BOPConfigurationBiomeGen.rainforestGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Jungle", (BiomeGenBase)((BiomeGenBase)Biomes.rainforest.get()), (double)tiers[1]);
        }
        if (BOPConfigurationBiomeGen.tropicsGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Jungle", (BiomeGenBase)((BiomeGenBase)Biomes.tropics.get()), (double)tiers[2]);
        }
        if (BOPConfigurationBiomeGen.bambooForestGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Jungle", (BiomeGenBase)((BiomeGenBase)Biomes.bambooForest.get()), (double)tiers[3]);
        }
        if (BOPConfigurationBiomeGen.jadeCliffsGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Jungle", (BiomeGenBase)((BiomeGenBase)Biomes.jadeCliffs.get()), (double)tiers[3]);
        }
        if (BOPConfigurationBiomeGen.sacredSpringsGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Jungle", (BiomeGenBase)((BiomeGenBase)Biomes.sacredSprings.get()), (double)tiers[5]);
        }
    }

    private static void addPlainsBiomesGroup() {
        if (BOPConfigurationBiomeGen.plainsGen) {
            ATGBiomes.replaceBiome((ATGBiomes.BiomeType)land, (String)"Plains", (BiomeGenBase)BiomeGenBase.field_76772_c, (BiomeGenBase)((BiomeGenBase)Biomes.plainsNew.get()), (double)tiers[0]);
        }
        if (BOPConfigurationBiomeGen.shrublandGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Plains", (BiomeGenBase)((BiomeGenBase)Biomes.shrubland.get()), (double)(tiers[1] * nb));
        }
        if (BOPConfigurationBiomeGen.chaparralGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Plains", (BiomeGenBase)((BiomeGenBase)Biomes.chaparral.get()), (double)tiers[1]);
        }
        if (BOPConfigurationBiomeGen.prairieGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Plains", (BiomeGenBase)((BiomeGenBase)Biomes.prairie.get()), (double)tiers[1]);
        }
        if (BOPConfigurationBiomeGen.fieldGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Plains", (BiomeGenBase)((BiomeGenBase)Biomes.field.get()), (double)tiers[2]);
        }
        if (BOPConfigurationBiomeGen.grasslandGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Plains", (BiomeGenBase)((BiomeGenBase)Biomes.grassland.get()), (double)tiers[2]);
        }
        if (BOPConfigurationBiomeGen.pastureGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Plains", (BiomeGenBase)((BiomeGenBase)Biomes.pasture.get()), (double)tiers[3]);
        }
        if (BOPConfigurationBiomeGen.meadowGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Plains", (BiomeGenBase)((BiomeGenBase)Biomes.meadow.get()), (double)tiers[3]);
        }
        if (BOPConfigurationBiomeGen.orchardGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Plains", (BiomeGenBase)((BiomeGenBase)Biomes.orchard.get()), (double)tiers[4]);
        }
        if (BOPConfigurationBiomeGen.overgrownGreensGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Plains", (BiomeGenBase)((BiomeGenBase)Biomes.overgrownGreens.get()), (double)tiers[4]);
        }
        if (BOPConfigurationBiomeGen.lavenderFieldsGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Plains", (BiomeGenBase)((BiomeGenBase)Biomes.lavenderFields.get()), (double)tiers[4]);
        }
        if (BOPConfigurationBiomeGen.gardenGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Plains", (BiomeGenBase)((BiomeGenBase)Biomes.garden.get()), (double)tiers[5]);
        }
    }

    private static void addIcePlainsBiomesGroup() {
        if (BOPConfigurationBiomeGen.alpsGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Ice Plains", (BiomeGenBase)((BiomeGenBase)Biomes.alps.get()), (double)tiers[0]);
        }
        if (BOPConfigurationBiomeGen.polarGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Ice Plains", (BiomeGenBase)((BiomeGenBase)Biomes.polar.get()), (double)tiers[2]);
        }
        if (BOPConfigurationBiomeGen.glacierGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Ice Plains", (BiomeGenBase)((BiomeGenBase)Biomes.glacier.get()), (double)tiers[2]);
        }
        if (BOPConfigurationBiomeGen.glacierGen) {
            ATGBiomes.addGenMod((BiomeGenBase)((BiomeGenBase)Biomes.glacier.get()), (IGenMod)new GenModGlacier());
        }
        if (BOPConfigurationBiomeGen.arcticGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Ice Plains", (BiomeGenBase)((BiomeGenBase)Biomes.arctic.get()), (double)tiers[2]);
        }
        if (BOPConfigurationBiomeGen.icyHillsGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Ice Plains", (BiomeGenBase)((BiomeGenBase)Biomes.icyHills.get()), (double)tiers[5]);
        }
    }

    private static void addTaigaBiomesGroup() {
        if (BOPConfigurationBiomeGen.taigaGen) {
            ATGBiomes.replaceBiome((ATGBiomes.BiomeType)land, (String)"Taiga", (BiomeGenBase)BiomeGenBase.field_76768_g, (BiomeGenBase)((BiomeGenBase)Biomes.taigaNew.get()), (double)tiers[0]);
        }
        if (BOPConfigurationBiomeGen.alpsGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Taiga", (BiomeGenBase)((BiomeGenBase)Biomes.alpsForest.get()), (double)tiers[1]);
        }
        if (BOPConfigurationBiomeGen.coniferousForestSnowGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Taiga", (BiomeGenBase)((BiomeGenBase)Biomes.coniferousForestSnow.get()), (double)tiers[1]);
        }
        if (BOPConfigurationBiomeGen.frostForestGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Taiga", (BiomeGenBase)((BiomeGenBase)Biomes.frostForest.get()), (double)tiers[1]);
        }
        if (BOPConfigurationBiomeGen.deadForestSnowGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Taiga", (BiomeGenBase)((BiomeGenBase)Biomes.deadForestSnow.get()), (double)tiers[4]);
        }
        if (BOPConfigurationBiomeGen.icyHillsGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Taiga", (BiomeGenBase)((BiomeGenBase)Biomes.icyHills.get()), (double)(tiers[5] * nb));
        }
    }

    private static void addDesertBiomesGroup() {
        if (BOPConfigurationBiomeGen.desertGen) {
            ATGBiomes.replaceBiome((ATGBiomes.BiomeType)land, (String)"Desert", (BiomeGenBase)BiomeGenBase.field_76769_d, (BiomeGenBase)((BiomeGenBase)Biomes.desertNew.get()), (double)tiers[0]);
        }
        if (BOPConfigurationBiomeGen.dunesGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Desert", (BiomeGenBase)((BiomeGenBase)Biomes.dunes.get()), (double)tiers[1]);
        }
        if (BOPConfigurationBiomeGen.outbackGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Desert", (BiomeGenBase)((BiomeGenBase)Biomes.outback.get()), (double)tiers[2]);
        }
        if (BOPConfigurationBiomeGen.lushDesertGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Desert", (BiomeGenBase)((BiomeGenBase)Biomes.lushDesert.get()), (double)tiers[3]);
        }
        if (BOPConfigurationBiomeGen.oasisGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Desert", (BiomeGenBase)((BiomeGenBase)Biomes.oasis.get()), (double)tiers[5]);
        }
    }

    private static void addShrublandBiomesGroup() {
        if (BOPConfigurationBiomeGen.shrublandGen) {
            ATGBiomes.replaceBiome((ATGBiomes.BiomeType)land, (String)"Shrubland", (BiomeGenBase)ATGBiomes.getBiome((String)"Shrubland"), (BiomeGenBase)((BiomeGenBase)Biomes.shrubland.get()), (double)tiers[0]);
        }
        if (BOPConfigurationBiomeGen.heathlandGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Shrubland", (BiomeGenBase)((BiomeGenBase)Biomes.heathland.get()), (double)tiers[2]);
        }
        if (BOPConfigurationBiomeGen.thicketGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Shrubland", (BiomeGenBase)((BiomeGenBase)Biomes.thicket.get()), (double)tiers[4]);
        }
    }

    private static void addBorealForestBiomesGroup() {
        if (BOPConfigurationBiomeGen.borealForestGen) {
            ATGBiomes.replaceBiome((ATGBiomes.BiomeType)land, (String)"Boreal Forest", (BiomeGenBase)ATGBiomes.getBiome((String)"BorealForest"), (BiomeGenBase)((BiomeGenBase)Biomes.borealForest.get()), (double)tiers[0]);
        }
        if (BOPConfigurationBiomeGen.coniferousForestGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Boreal Forest", (BiomeGenBase)((BiomeGenBase)Biomes.coniferousForest.get()), (double)tiers[1]);
        }
        if (BOPConfigurationBiomeGen.spruceWoodsGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Boreal Forest", (BiomeGenBase)((BiomeGenBase)Biomes.spruceWoods.get()), (double)tiers[1]);
        }
        if (BOPConfigurationBiomeGen.forestGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Boreal Forest", (BiomeGenBase)((BiomeGenBase)Biomes.forestNew.get()), (double)(tiers[2] * nb));
        }
        if (BOPConfigurationBiomeGen.shieldGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Boreal Forest", (BiomeGenBase)((BiomeGenBase)Biomes.shield.get()), (double)tiers[3]);
        }
        if (BOPConfigurationBiomeGen.timberGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Boreal Forest", (BiomeGenBase)((BiomeGenBase)Biomes.timber.get()), (double)tiers[3]);
        }
        if (BOPConfigurationBiomeGen.deadForestGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Boreal Forest", (BiomeGenBase)((BiomeGenBase)Biomes.deadForest.get()), (double)tiers[4]);
        }
    }

    private static void addTundraBiomesGroup() {
        if (BOPConfigurationBiomeGen.tundraGen) {
            ATGBiomes.replaceBiome((ATGBiomes.BiomeType)land, (String)"Tundra", (BiomeGenBase)ATGBiomes.getBiome((String)"Tundra"), (BiomeGenBase)((BiomeGenBase)Biomes.tundra.get()), (double)tiers[0]);
        }
        ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Tundra", (BiomeGenBase)BiomeGenBase.field_76774_n, (double)tiers[2]);
        if (BOPConfigurationBiomeGen.borealForestGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Tundra", (BiomeGenBase)((BiomeGenBase)Biomes.borealForest.get()), (double)(tiers[4] * nb));
        }
        if (BOPConfigurationBiomeGen.steppeGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Tundra", (BiomeGenBase)((BiomeGenBase)Biomes.steppe.get()), (double)tiers[5]);
        }
    }

    private static void addSteppeBiomesGroup() {
        if (BOPConfigurationBiomeGen.cragGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Steppe", (BiomeGenBase)((BiomeGenBase)Biomes.crag.get()), (double)tiers[2]);
        }
        if (BOPConfigurationBiomeGen.mountainGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Steppe", (BiomeGenBase)((BiomeGenBase)Biomes.mountain.get()), (double)tiers[4]);
        }
        if (BOPConfigurationBiomeGen.deadForestGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Steppe", (BiomeGenBase)((BiomeGenBase)Biomes.deadForest.get()), (double)tiers[5]);
        }
        if (BOPConfigurationBiomeGen.deadlandsGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Steppe", (BiomeGenBase)((BiomeGenBase)Biomes.deadlands.get()), (double)tiers[5]);
        }
        if (BOPConfigurationBiomeGen.wastelandGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Steppe", (BiomeGenBase)((BiomeGenBase)Biomes.wasteland.get()), (double)tiers[5]);
        }
    }

    private static void addSavannahBiomesGroup() {
        if (BOPConfigurationBiomeGen.savannaGen) {
            ATGBiomes.replaceBiome((ATGBiomes.BiomeType)land, (String)"Savanna", (BiomeGenBase)ATGBiomes.getBiome((String)"Savanna"), (BiomeGenBase)((BiomeGenBase)Biomes.savanna.get()), (double)1.0);
        }
        if (BOPConfigurationBiomeGen.scrublandGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Savanna", (BiomeGenBase)((BiomeGenBase)Biomes.scrubland.get()), (double)tiers[2]);
        }
        if (BOPConfigurationBiomeGen.outbackGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Savanna", (BiomeGenBase)((BiomeGenBase)Biomes.outback.get()), (double)(tiers[2] * nb));
        }
        if (BOPConfigurationBiomeGen.steppeGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Savanna", (BiomeGenBase)((BiomeGenBase)Biomes.steppe.get()), (double)tiers[2]);
        }
        if (BOPConfigurationBiomeGen.lushDesertGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Savanna", (BiomeGenBase)((BiomeGenBase)Biomes.lushDesert.get()), (double)tiers[3]);
        }
        if (BOPConfigurationBiomeGen.brushlandGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Savanna", (BiomeGenBase)((BiomeGenBase)Biomes.brushland.get()), (double)tiers[4]);
        }
    }

    private static void addTropicalShrublandBiomesGroup() {
        if (BOPConfigurationBiomeGen.tropicsGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Tropical Shrubland", (BiomeGenBase)((BiomeGenBase)Biomes.tropics.get()), (double)tiers[1]);
        }
        if (BOPConfigurationBiomeGen.bambooForestGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Tropical Shrubland", (BiomeGenBase)((BiomeGenBase)Biomes.bambooForest.get()), (double)tiers[3]);
        }
        if (BOPConfigurationBiomeGen.sacredSpringsGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Tropical Shrubland", (BiomeGenBase)((BiomeGenBase)Biomes.sacredSprings.get()), (double)tiers[5]);
        }
    }

    private static void addWoodlandBiomesGroup() {
        if (BOPConfigurationBiomeGen.woodlandGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Woodland", (BiomeGenBase)((BiomeGenBase)Biomes.woodland.get()), (double)tiers[1]);
        }
        if (BOPConfigurationBiomeGen.thicketGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Woodland", (BiomeGenBase)((BiomeGenBase)Biomes.thicket.get()), (double)tiers[3]);
        }
        if (BOPConfigurationBiomeGen.birchForestGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Woodland", (BiomeGenBase)((BiomeGenBase)Biomes.birchForest.get()), (double)tiers[5]);
        }
    }

    private static void addMesaBiomesGroup() {
        if (BOPConfigurationBiomeGen.mesaGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Mesa", (BiomeGenBase)((BiomeGenBase)Biomes.mesa.get()), (double)tiers[0]);
        }
        if (BOPConfigurationBiomeGen.badlandsGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Mesa", (BiomeGenBase)((BiomeGenBase)Biomes.badlands.get()), (double)tiers[0]);
        }
        if (BOPConfigurationBiomeGen.canyonGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)land, (String)"Mesa", (BiomeGenBase)((BiomeGenBase)Biomes.canyon.get()), (double)tiers[0]);
        }
        if (BOPConfigurationBiomeGen.canyonGen) {
            ATGBiomes.addGenMod((BiomeGenBase)((BiomeGenBase)Biomes.canyonRavine.get()), (IGenMod)new GenModCanyonRavine());
        }
    }

    private static void addSwamplandBiomesGroup() {
        if (BOPConfigurationBiomeGen.wetlandGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)coast, (String)"Swampland", (BiomeGenBase)((BiomeGenBase)Biomes.wetland.get()), (double)tiers[0]);
        }
        if (BOPConfigurationBiomeGen.marshGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)coast, (String)"Swampland", (BiomeGenBase)((BiomeGenBase)Biomes.marsh.get()), (double)tiers[1]);
        }
        if (BOPConfigurationBiomeGen.lushSwampGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)coast, (String)"Swampland", (BiomeGenBase)((BiomeGenBase)Biomes.lushSwamp.get()), (double)tiers[1]);
        }
        if (BOPConfigurationBiomeGen.bayouGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)coast, (String)"Swampland", (BiomeGenBase)((BiomeGenBase)Biomes.bayou.get()), (double)tiers[1]);
        }
        if (BOPConfigurationBiomeGen.swamplandGen) {
            ATGBiomes.replaceBiome((ATGBiomes.BiomeType)coast, (String)"Swampland", (BiomeGenBase)BiomeGenBase.field_76780_h, (BiomeGenBase)((BiomeGenBase)Biomes.swamplandNew.get()), (double)tiers[2]);
        }
        if (BOPConfigurationBiomeGen.fenGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)coast, (String)"Swampland", (BiomeGenBase)((BiomeGenBase)Biomes.fen.get()), (double)tiers[2]);
        }
        if (BOPConfigurationBiomeGen.bogGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)coast, (String)"Swampland", (BiomeGenBase)((BiomeGenBase)Biomes.bog.get()), (double)tiers[2]);
        }
        if (BOPConfigurationBiomeGen.mangroveGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)coast, (String)"Swampland", (BiomeGenBase)((BiomeGenBase)Biomes.mangrove.get()), (double)tiers[2]);
        }
        if (BOPConfigurationBiomeGen.moorGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)coast, (String)"Swampland", (BiomeGenBase)((BiomeGenBase)Biomes.moor.get()), (double)tiers[3]);
        }
        if (BOPConfigurationBiomeGen.deadSwampGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)coast, (String)"Swampland", (BiomeGenBase)((BiomeGenBase)Biomes.deadSwamp.get()), (double)tiers[3]);
        }
        if (BOPConfigurationBiomeGen.quagmireGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)coast, (String)"Swampland", (BiomeGenBase)((BiomeGenBase)Biomes.quagmire.get()), (double)tiers[4]);
        }
        if (BOPConfigurationBiomeGen.sludgepitGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)coast, (String)"Swampland", (BiomeGenBase)((BiomeGenBase)Biomes.sludgepit.get()), (double)tiers[4]);
        }
        if (BOPConfigurationBiomeGen.ominousWoodsGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)coast, (String)"Swampland", (BiomeGenBase)((BiomeGenBase)Biomes.ominousWoods.get()), (double)tiers[5]);
        }
        if (BOPConfigurationBiomeGen.silkgladesGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)coast, (String)"Swampland", (BiomeGenBase)((BiomeGenBase)Biomes.silkglades.get()), (double)tiers[5]);
        }
        IGenMod swampmod = (IGenMod)ATGBiomes.getGenMod((BiomeGenBase)BiomeGenBase.field_76780_h).get();
        if (BOPConfigurationBiomeGen.wetlandGen) {
            ATGBiomes.addGenMod((BiomeGenBase)((BiomeGenBase)Biomes.wetland.get()), (IGenMod)swampmod);
        }
        if (BOPConfigurationBiomeGen.lushSwampGen) {
            ATGBiomes.addGenMod((BiomeGenBase)((BiomeGenBase)Biomes.lushSwamp.get()), (IGenMod)swampmod);
        }
        if (BOPConfigurationBiomeGen.bayouGen) {
            ATGBiomes.addGenMod((BiomeGenBase)((BiomeGenBase)Biomes.bayou.get()), (IGenMod)swampmod);
        }
        if (BOPConfigurationBiomeGen.swamplandGen) {
            ATGBiomes.addGenMod((BiomeGenBase)((BiomeGenBase)Biomes.swamplandNew.get()), (IGenMod)swampmod);
        }
        if (BOPConfigurationBiomeGen.fenGen) {
            ATGBiomes.addGenMod((BiomeGenBase)((BiomeGenBase)Biomes.fen.get()), (IGenMod)swampmod);
        }
        if (BOPConfigurationBiomeGen.bogGen) {
            ATGBiomes.addGenMod((BiomeGenBase)((BiomeGenBase)Biomes.bog.get()), (IGenMod)swampmod);
        }
        if (BOPConfigurationBiomeGen.moorGen) {
            ATGBiomes.addGenMod((BiomeGenBase)((BiomeGenBase)Biomes.moor.get()), (IGenMod)swampmod);
        }
        if (BOPConfigurationBiomeGen.deadSwampGen) {
            ATGBiomes.addGenMod((BiomeGenBase)((BiomeGenBase)Biomes.deadSwamp.get()), (IGenMod)swampmod);
        }
        if (BOPConfigurationBiomeGen.quagmireGen) {
            ATGBiomes.addGenMod((BiomeGenBase)((BiomeGenBase)Biomes.quagmire.get()), (IGenMod)swampmod);
        }
        if (BOPConfigurationBiomeGen.sludgepitGen) {
            ATGBiomes.addGenMod((BiomeGenBase)((BiomeGenBase)Biomes.sludgepit.get()), (IGenMod)swampmod);
        }
        if (BOPConfigurationBiomeGen.ominousWoodsGen) {
            ATGBiomes.addGenMod((BiomeGenBase)((BiomeGenBase)Biomes.ominousWoods.get()), (IGenMod)swampmod);
        }
        if (BOPConfigurationBiomeGen.silkgladesGen) {
            ATGBiomes.addGenMod((BiomeGenBase)((BiomeGenBase)Biomes.silkglades.get()), (IGenMod)swampmod);
        }
    }

    private static void addBeachBiomesGroup() {
        if (BOPConfigurationBiomeGen.overgrownBeachGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)coast, (String)"Beach", (BiomeGenBase)((BiomeGenBase)Biomes.beachOvergrown.get()), (double)0.2);
        }
        if (BOPConfigurationBiomeGen.gravelBeachGen) {
            ATGBiomes.replaceBiome((ATGBiomes.BiomeType)coast, (String)"Gravel Beach", (BiomeGenBase)ATGBiomes.getBiome((String)"GravelBeach"), (BiomeGenBase)((BiomeGenBase)Biomes.beachGravel.get()), (double)1.0);
        }
    }

    private static void addOceanBiomesGroup() {
        if (BOPConfigurationBiomeGen.coralReefGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)sea, (String)"Ocean", (BiomeGenBase)((BiomeGenBase)Biomes.oceanCoral.get()), (double)0.05);
        }
        if (BOPConfigurationBiomeGen.kelpForestGen) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)sea, (String)"Ocean", (BiomeGenBase)((BiomeGenBase)Biomes.oceanKelp.get()), (double)0.1);
        }
        if (BOPConfigurationBiomeGen.oceanicAbyssGen) {
            ATGBiomes.replaceBiome((ATGBiomes.BiomeType)sea, (String)"Deep Ocean", (BiomeGenBase)BiomeGenBase.field_76771_b, (BiomeGenBase)((BiomeGenBase)Biomes.oceanAbyss.get()), (double)1.0);
        }
        if (BOPConfigurationBiomeGen.oceanicAbyssGen) {
            ATGBiomes.addGenMod((BiomeGenBase)((BiomeGenBase)Biomes.oceanAbyss.get()), (IGenMod)new GenModAbyss());
        }
    }
}

