/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.blocks;

import biomesoplenty.BiomesOPlenty;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockBOPLog
extends Block {
    private static final String[] types = new String[]{"acacia", "cherry", "dark", "fir", "holy", "magic", "mangrove", "palm", "redwood", "willow", "dead", "bigflowerstem", "pine", "hellbark", "jacaranda"};
    private Icon[] textures;
    private Icon[] logHearts;
    private final LogCategory category;

    public BlockBOPLog(int blockID, LogCategory cat) {
        super(blockID, Material.field_76245_d);
        this.category = cat;
        this.func_71848_c(2.0f);
        this.func_71894_b(5.0f);
        this.func_71884_a(Block.field_71967_e);
        this.func_71849_a(BiomesOPlenty.tabBiomesOPlenty);
    }

    public void func_94332_a(IconRegister iconRegister) {
        this.textures = new Icon[types.length];
        this.logHearts = new Icon[types.length];
        for (int i = 0; i < types.length; ++i) {
            if (i == 11) continue;
            this.textures[i] = iconRegister.func_94245_a("biomesoplenty:log_" + types[i] + "_side");
            this.logHearts[i] = iconRegister.func_94245_a("biomesoplenty:log_" + types[i] + "_heart");
        }
        this.textures[11] = iconRegister.func_94245_a("biomesoplenty:bigflowerstem_side");
        this.logHearts[11] = iconRegister.func_94245_a("biomesoplenty:bigflowerstem_heart");
    }

    public Icon func_71858_a(int side, int meta) {
        int pos = meta & 0xC;
        if (pos == 0 && (side == 1 || side == 0) || pos == 4 && (side == 5 || side == 4) || pos == 8 && (side == 2 || side == 3)) {
            return this.logHearts[BlockBOPLog.getTypeFromMeta(meta) + this.category.ordinal() * 4];
        }
        return this.textures[BlockBOPLog.getTypeFromMeta(meta) + this.category.ordinal() * 4];
    }

    public void func_71879_a(int blockID, CreativeTabs creativeTabs, List list) {
        if (this.category != LogCategory.CAT4) {
            for (int i = 0; i < 4; ++i) {
                list.add(new ItemStack((Block)this, 1, i));
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                list.add(new ItemStack((Block)this, 1, i));
            }
        }
    }

    public void func_71852_a(World world, int x, int y, int z, int par5, int par6) {
        int radius = 4;
        int bounds = radius + 1;
        if (world.func_72904_c(x - bounds, y - bounds, z - bounds, x + bounds, y + bounds, z + bounds)) {
            for (int i = -radius; i <= radius; ++i) {
                for (int j = -radius; j <= radius; ++j) {
                    for (int k = -radius; k <= radius; ++k) {
                        int blockID = world.func_72798_a(x + i, y + j, z + k);
                        if (Block.field_71973_m[blockID] == null) continue;
                        Block.field_71973_m[blockID].beginLeavesDecay(world, x + i, y + j, z + k);
                    }
                }
            }
        }
    }

    public int func_85104_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int meta) {
        int type = BlockBOPLog.getTypeFromMeta(meta);
        int orientation = 0;
        switch (side) {
            case 0: 
            case 1: {
                orientation = 0;
                break;
            }
            case 2: 
            case 3: {
                orientation = 8;
                break;
            }
            case 4: 
            case 5: {
                orientation = 4;
            }
        }
        return type | orientation;
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, int metadata, ForgeDirection face) {
        if (this.category == LogCategory.CAT4 && metadata == 1) {
            return 0;
        }
        Block.setBurnProperties((int)this.field_71990_ca, (int)5, (int)5);
        return blockFlammability[this.field_71990_ca];
    }

    public int getFireSpreadSpeed(World world, int x, int y, int z, int metadata, ForgeDirection face) {
        if (this.category == LogCategory.CAT4 && metadata == 1) {
            return 0;
        }
        return blockFireSpreadSpeed[this.field_71990_ca];
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, int metadata, ForgeDirection face) {
        if (this.category == LogCategory.CAT4 && metadata == 1) {
            return false;
        }
        return this.getFlammability(world, x, y, z, metadata, face) > 0;
    }

    public int func_71899_b(int meta) {
        return BlockBOPLog.getTypeFromMeta(meta);
    }

    protected ItemStack func_71880_c_(int meta) {
        return new ItemStack(this.field_71990_ca, 1, BlockBOPLog.getTypeFromMeta(meta));
    }

    public int func_71857_b() {
        return 31;
    }

    public boolean canSustainLeaves(World world, int x, int y, int z) {
        return true;
    }

    public boolean isWood(World world, int x, int y, int z) {
        return true;
    }

    public String getWoodType(int meta) {
        return types[BlockBOPLog.getTypeFromMeta(meta) + this.category.ordinal() * 4];
    }

    private static int getTypeFromMeta(int meta) {
        return meta & 3;
    }

    public static enum LogCategory {
        CAT1,
        CAT2,
        CAT3,
        CAT4;

    }
}

