/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.utils;

import org.dynmap.Log;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;
import org.dynmap.utils.BlockStep;
import org.dynmap.utils.Vector3D;

public class PatchDefinition
implements RenderPatch {
    public double x0;
    public double y0;
    public double z0;
    public double xu;
    public double yu;
    public double zu;
    public double xv;
    public double yv;
    public double zv;
    public double umin;
    public double umax;
    public double vmin;
    public double vmax;
    public double uplusvmax;
    public Vector3D u;
    public Vector3D v;
    public RenderPatchFactory.SideVisible sidevis;
    public int textureindex;
    public BlockStep step;
    private int hc;
    private static final Vector3D offsetCenter = new Vector3D(0.5, 0.5, 0.5);

    PatchDefinition() {
        this.z0 = 0.0;
        this.y0 = 0.0;
        this.x0 = 0.0;
        this.zu = 0.0;
        this.xu = 0.0;
        this.yu = 1.0;
        this.zv = 0.0;
        this.yv = 0.0;
        this.xv = 1.0;
        this.vmin = 0.0;
        this.umin = 0.0;
        this.vmax = 1.0;
        this.umax = 1.0;
        this.uplusvmax = 100.0;
        this.u = new Vector3D();
        this.v = new Vector3D();
        this.sidevis = RenderPatchFactory.SideVisible.BOTH;
        this.textureindex = 0;
        this.update();
    }

    PatchDefinition(PatchDefinition pd) {
        this.x0 = pd.x0;
        this.y0 = pd.y0;
        this.z0 = pd.z0;
        this.xu = pd.xu;
        this.yu = pd.yu;
        this.zu = pd.zu;
        this.xv = pd.xv;
        this.yv = pd.yv;
        this.zv = pd.zv;
        this.umin = pd.umin;
        this.vmin = pd.vmin;
        this.umax = pd.umax;
        this.vmax = pd.vmax;
        this.uplusvmax = pd.uplusvmax;
        this.u = new Vector3D(pd.u);
        this.v = new Vector3D(pd.v);
        this.sidevis = pd.sidevis;
        this.textureindex = pd.textureindex;
        this.step = pd.step;
        this.hc = pd.hc;
    }

    PatchDefinition(PatchDefinition orig, int rotatex, int rotatey, int rotatez, int textureindex) {
        Vector3D vec = new Vector3D(orig.x0, orig.y0, orig.z0);
        this.rotate(vec, rotatex, rotatey, rotatez);
        this.x0 = vec.x;
        this.y0 = vec.y;
        this.z0 = vec.z;
        vec.x = orig.xu;
        vec.y = orig.yu;
        vec.z = orig.zu;
        this.rotate(vec, rotatex, rotatey, rotatez);
        this.xu = vec.x;
        this.yu = vec.y;
        this.zu = vec.z;
        vec.x = orig.xv;
        vec.y = orig.yv;
        vec.z = orig.zv;
        this.rotate(vec, rotatex, rotatey, rotatez);
        this.xv = vec.x;
        this.yv = vec.y;
        this.zv = vec.z;
        this.umin = orig.umin;
        this.vmin = orig.vmin;
        this.umax = orig.umax;
        this.vmax = orig.vmax;
        this.uplusvmax = orig.uplusvmax;
        this.sidevis = orig.sidevis;
        this.textureindex = textureindex;
        this.u = new Vector3D();
        this.v = new Vector3D();
        this.update();
    }

    private void rotate(Vector3D vec, int xcnt, int ycnt, int zcnt) {
        vec.subtract(offsetCenter);
        double rot = Math.toRadians(xcnt);
        double nval = vec.z * Math.sin(rot) + vec.y * Math.cos(rot);
        vec.z = vec.z * Math.cos(rot) - vec.y * Math.sin(rot);
        vec.y = nval;
        rot = Math.toRadians(ycnt);
        nval = vec.x * Math.cos(rot) - vec.z * Math.sin(rot);
        vec.z = vec.x * Math.sin(rot) + vec.z * Math.cos(rot);
        vec.x = nval;
        rot = Math.toRadians(zcnt);
        nval = vec.y * Math.sin(rot) + vec.x * Math.cos(rot);
        vec.y = vec.y * Math.cos(rot) - vec.x * Math.sin(rot);
        vec.x = nval;
        vec.add(offsetCenter);
    }

    public void update(double x0, double y0, double z0, double xu, double yu, double zu, double xv, double yv, double zv, double umin, double umax, double vmin, double vmax, double uplusvmax, RenderPatchFactory.SideVisible sidevis, int textureids) {
        this.x0 = x0;
        this.y0 = y0;
        this.z0 = z0;
        this.xu = xu;
        this.yu = yu;
        this.zu = zu;
        this.xv = xv;
        this.yv = yv;
        this.zv = zv;
        this.umin = umin;
        this.umax = umax;
        this.vmin = vmin;
        this.vmax = vmax;
        this.uplusvmax = uplusvmax;
        this.sidevis = sidevis;
        this.textureindex = textureids;
        this.update();
    }

    public void update() {
        this.u.x = this.xu - this.x0;
        this.u.y = this.yu - this.y0;
        this.u.z = this.zu - this.z0;
        this.v.x = this.xv - this.x0;
        this.v.y = this.yv - this.y0;
        this.v.z = this.zv - this.z0;
        this.hc = (int)(Double.doubleToLongBits(this.x0 + this.xu + this.xv) >> 32 ^ Double.doubleToLongBits(this.y0 + this.yu + this.yv) >> 34 ^ Double.doubleToLongBits(this.z0 + this.yu + this.yv) >> 36 ^ Double.doubleToLongBits(this.umin + this.umax + this.vmin + this.vmax + this.uplusvmax) >> 38) ^ this.sidevis.ordinal() << 8 ^ this.textureindex;
        double crossx = this.u.y * this.v.z - this.u.z * this.v.y;
        double crossy = this.u.z * this.v.x - this.u.x * this.v.z;
        double crossz = this.u.x * this.v.y - this.u.y * this.v.x;
        this.step = Math.abs(crossx) > Math.abs(crossy) * 0.9 ? (Math.abs(crossx) > Math.abs(crossz) ? (crossx > 0.0 ? BlockStep.X_PLUS : BlockStep.X_MINUS) : (crossz > 0.0 ? BlockStep.Z_PLUS : BlockStep.Z_MINUS)) : (Math.abs(crossy) * 0.9 > Math.abs(crossz) ? (crossy > 0.0 ? BlockStep.Y_PLUS : BlockStep.Y_MINUS) : (crossz > 0.0 ? BlockStep.Z_PLUS : BlockStep.Z_MINUS));
    }

    public boolean validate() {
        boolean good = true;
        if (this.x0 < -1.0 || this.x0 > 2.0) {
            Log.severe("Invalid x0=" + this.x0);
            good = false;
        }
        if (this.y0 < -1.0 || this.y0 > 2.0) {
            Log.severe("Invalid y0=" + this.y0);
            good = false;
        }
        if (this.z0 < -1.0 || this.z0 > 2.0) {
            Log.severe("Invalid z0=" + this.z0);
            good = false;
        }
        if (this.xu < -1.0 || this.xu > 2.0) {
            Log.severe("Invalid xu=" + this.xu);
            good = false;
        }
        if (this.yu < -1.0 || this.yu > 2.0) {
            Log.severe("Invalid yu=" + this.yu);
            good = false;
        }
        if (this.zu < -1.0 || this.zu > 2.0) {
            Log.severe("Invalid zu=" + this.zu);
            good = false;
        }
        if (this.xv < -1.0 || this.xv > 2.0) {
            Log.severe("Invalid xv=" + this.xv);
            good = false;
        }
        if (this.yv < -1.0 || this.yv > 2.0) {
            Log.severe("Invalid yv=" + this.yv);
            good = false;
        }
        if (this.zv < -1.0 || this.zv > 2.0) {
            Log.severe("Invalid zv=" + this.zv);
            good = false;
        }
        if (this.umin < 0.0 || this.umin >= this.umax) {
            Log.severe("Invalid umin=" + this.umin);
            good = false;
        }
        if (this.vmin < 0.0 || this.vmin >= this.vmax) {
            Log.severe("Invalid vmin=" + this.vmin);
            good = false;
        }
        if (this.umax > 1.0) {
            Log.severe("Invalid umax=" + this.umax);
            good = false;
        }
        if (this.vmax > 1.0) {
            Log.severe("Invalid vmax=" + this.vmax);
            good = false;
        }
        if (!good) {
            Log.severe(new Exception("Trace Stack"));
        }
        return good;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PatchDefinition) {
            PatchDefinition p = (PatchDefinition)o;
            if (this.hc == p.hc && this.textureindex == p.textureindex && this.x0 == p.x0 && this.y0 == p.y0 && this.z0 == p.z0 && this.xu == p.xu && this.yu == p.yu && this.zu == p.zu && this.xv == p.xv && this.yv == p.yv && this.zv == p.zv && this.umin == p.umin && this.umax == p.umax && this.vmin == p.vmin && this.vmax == p.vmax && this.uplusvmax == p.uplusvmax && this.sidevis == p.sidevis) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.hc;
    }

    @Override
    public int getTextureIndex() {
        return this.textureindex;
    }
}

