/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.standalone;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.dynmap.DynmapChunk;
import org.dynmap.DynmapLocation;
import org.dynmap.DynmapWorld;
import org.dynmap.Log;
import org.dynmap.nbt.ByteTag;
import org.dynmap.nbt.CompoundMap;
import org.dynmap.nbt.CompoundTag;
import org.dynmap.nbt.IntTag;
import org.dynmap.nbt.LongTag;
import org.dynmap.nbt.Tag;
import org.dynmap.nbt.TagType;
import org.dynmap.nbt.stream.NBTInputStream;
import org.dynmap.standalone.StandaloneChunkSnapshot;
import org.dynmap.utils.MapChunkCache;

public class StandaloneWorld
extends DynmapWorld {
    private CompoundMap level_dat;
    private File wdir;
    private File regiondir;
    private DynmapLocation spawn;
    private String env;
    private boolean is_nether;
    private boolean is_raining;
    private boolean is_thunder;
    private long world_time;
    private RegionMap regions;
    private Object regionsem = new Object();
    private static final int MAX_FILES_ACTIVE = 10;
    private static final int SECTOR_SIZE = 4096;
    private static final int VERSION_GZIP = 1;
    private static final int VERSION_DEFLATE = 2;

    public static void main(String[] v) {
        try {
            StandaloneWorld w = new StandaloneWorld("world", new File("/Users/mike/mcpc/world_nether"), "nether");
            CompoundTag t = w.getChunk(0, 0);
            StandaloneChunkSnapshot standaloneChunkSnapshot = new StandaloneChunkSnapshot(t);
        }
        catch (IOException x) {
            Log.severe("Error: " + x.getMessage());
        }
    }

    public void updateLevelDat() throws IOException {
        File lvl = new File(this.wdir, "level.dat");
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(lvl);
            NBTInputStream nis = new NBTInputStream(fis);
            Tag t = nis.readTag();
            if (t.getType() == TagType.TAG_COMPOUND) {
                CompoundTag ct = (CompoundTag)((CompoundTag)t).getValue().get("Data");
                this.level_dat = ct.getValue();
                this.spawn.x = ((IntTag)this.level_dat.get("SpawnX")).getValue().intValue();
                this.spawn.y = ((IntTag)this.level_dat.get("SpawnY")).getValue().intValue();
                this.spawn.z = ((IntTag)this.level_dat.get("SpawnZ")).getValue().intValue();
                this.is_raining = ((ByteTag)this.level_dat.get("raining")).getValue() != 0;
                this.is_thunder = ((ByteTag)this.level_dat.get("thundering")).getValue() != 0;
                this.world_time = ((LongTag)this.level_dat.get("Time")).getValue();
            }
            nis.close();
        }
        catch (IOException iox) {
            Log.info("Error opening level.dat for world " + this.getName() + " in " + this.wdir.getPath());
            throw iox;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iox) {}
            }
        }
    }

    public StandaloneWorld(String wname, File wdir, String env) throws IOException {
        super(wname, 256, 64);
        this.wdir = wdir;
        this.env = env;
        this.is_nether = env.equals("nether");
        this.regiondir = env.equals("nether") ? new File(wdir, "DIM-1/region") : (env.equals("the_end") ? new File(wdir, "DIM1/region") : new File(wdir, "region"));
        this.spawn = new DynmapLocation();
        this.spawn.world = this.getName();
        this.regions = new RegionMap();
        this.updateLevelDat();
    }

    @Override
    public boolean isNether() {
        return this.is_nether;
    }

    @Override
    public DynmapLocation getSpawnLocation() {
        return this.spawn;
    }

    @Override
    public long getTime() {
        return this.world_time;
    }

    @Override
    public boolean hasStorm() {
        return this.is_raining;
    }

    @Override
    public boolean isThundering() {
        return this.is_thunder;
    }

    @Override
    public boolean isLoaded() {
        return false;
    }

    @Override
    public int getLightLevel(int x, int y, int z) {
        return 0;
    }

    @Override
    public int getHighestBlockYAt(int x, int z) {
        return 0;
    }

    @Override
    public boolean canGetSkyLightLevel() {
        return true;
    }

    @Override
    public int getSkyLightLevel(int x, int y, int z) {
        return 0;
    }

    @Override
    public String getEnvironment() {
        return this.env;
    }

    @Override
    public MapChunkCache getChunkCache(List<DynmapChunk> chunks) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompoundTag getChunk(int x, int z) {
        RegionFileHandler rf = null;
        CoordPair cp = new CoordPair();
        cp.x = x >> 5;
        cp.z = z >> 5;
        Object object = this.regionsem;
        synchronized (object) {
            rf = (RegionFileHandler)this.regions.get(cp);
            if (rf == null) {
                try {
                    rf = new RegionFileHandler(this.regiondir, cp.x, cp.z);
                }
                catch (IOException iox) {
                    return null;
                }
                this.regions.put(cp, rf);
            }
        }
        return rf.readChunk(x & 0x1F, z & 0x1F);
    }

    @Override
    public void setWorldUnloaded() {
    }

    static class RegionMap
    extends LinkedHashMap<CoordPair, RegionFileHandler> {
        public RegionMap() {
            super(10, 0.7f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<CoordPair, RegionFileHandler> eldest) {
            if (this.size() >= 10) {
                eldest.getValue().cleanup();
                return true;
            }
            return false;
        }
    }

    private static class RegionFileHandler {
        private File f;
        private RandomAccessFile raf;
        private int[] offsets;
        private int[] timestamps;

        public RegionFileHandler(File dir, int x, int z) throws IOException {
            int i;
            this.f = new File(dir, "r." + x + "." + z + ".mca");
            if (!this.f.canRead()) {
                throw new IOException();
            }
            this.raf = new RandomAccessFile(this.f, "rw");
            this.offsets = new int[1024];
            this.timestamps = new int[1024];
            this.raf.seek(0L);
            for (i = 0; i < this.offsets.length; ++i) {
                this.offsets[i] = this.raf.readInt();
            }
            for (i = 0; i < this.timestamps.length; ++i) {
                this.timestamps[i] = this.raf.readInt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CompoundTag readChunk(int x, int z) {
            byte[] rec = null;
            byte ver = 0;
            RegionFileHandler regionFileHandler = this;
            synchronized (regionFileHandler) {
                int off = this.offsets[x + 32 * z];
                if (off == 0 || this.raf == null) {
                    return null;
                }
                try {
                    this.raf.seek((off >> 8) * 4096);
                    int len = this.raf.readInt();
                    if (len > (off & 0xFF) * 4096) {
                        return null;
                    }
                    ver = this.raf.readByte();
                    rec = new byte[len - 1];
                    this.raf.read(rec);
                }
                catch (IOException iox) {
                    return null;
                }
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(rec);
            InflaterInputStream in = null;
            if (ver == 1) {
                try {
                    in = new GZIPInputStream(bais);
                }
                catch (IOException iox) {
                    return null;
                }
            } else if (ver == 2) {
                in = new InflaterInputStream(bais);
            } else {
                return null;
            }
            CompoundTag t = null;
            try {
                NBTInputStream nis = new NBTInputStream(new BufferedInputStream(in), false);
                t = (CompoundTag)nis.readTag();
                nis.close();
            }
            catch (IOException iox) {
                return null;
            }
            return t;
        }

        public synchronized void cleanup() {
            if (this.raf != null) {
                try {
                    this.raf.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.raf = null;
            }
        }
    }

    private static class CoordPair {
        int x;
        int z;

        private CoordPair() {
        }

        public int hashCode() {
            return this.x ^ this.z * 71;
        }

        public boolean equals(Object o) {
            if (o instanceof CoordPair) {
                CoordPair c = (CoordPair)o;
                return c.x == this.x && c.z == this.z;
            }
            return false;
        }
    }
}

