/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.servlet;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dynmap.Log;
import org.dynmap.jetty.server.Request;
import org.dynmap.jetty.server.handler.ResourceHandler;
import org.dynmap.jetty.util.resource.Resource;
import org.dynmap.utils.FileLockManager;

public class FileLockResourceHandler
extends ResourceHandler {
    private static String getNormalizedPath(String p) {
        int i;
        p = p.replace('\\', '/');
        String[] tok = p.split("/");
        int j = 0;
        for (i = 0; i < tok.length; ++i) {
            if (tok[i] == null || tok[i].length() == 0 || tok[i].equals(".")) {
                tok[i] = null;
                continue;
            }
            if (tok[i].equals("..")) {
                if (j > 0) {
                    tok[--j] = null;
                }
                tok[i] = null;
                continue;
            }
            tok[j] = tok[i];
            ++j;
        }
        String path = "";
        for (i = 0; i < j; ++i) {
            if (tok[i] == null) continue;
            path = path + "/" + tok[i];
        }
        if (path.length() == 0) {
            path = "/";
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Resource resource;
        target = FileLockResourceHandler.getNormalizedPath(target);
        try {
            resource = this.getResource(target);
        }
        catch (MalformedURLException ex) {
            return;
        }
        if (resource == null) {
            return;
        }
        File file = resource.getFile();
        if (file == null) {
            return;
        }
        if (!FileLockManager.getReadLock(file, 5000L)) {
            Log.severe("Timeout waiting for lock on file '" + file.getPath() + "' while handling HTTP-request.");
            response.sendError(408);
            return;
        }
        try {
            super.handle(target, baseRequest, request, response);
        }
        finally {
            FileLockManager.releaseReadLock(file);
        }
    }
}

