/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.nbt;

import org.dynmap.nbt.Tag;
import org.dynmap.nbt.TagType;

public final class FloatTag
extends Tag<Float> {
    private final float value;

    public FloatTag(String name, float value) {
        super(TagType.TAG_FLOAT, name);
        this.value = value;
    }

    @Override
    public Float getValue() {
        return Float.valueOf(this.value);
    }

    public String toString() {
        String name = this.getName();
        String append = "";
        if (name != null && !name.equals("")) {
            append = "(\"" + this.getName() + "\")";
        }
        return "TAG_Float" + append + ": " + this.value;
    }

    @Override
    public FloatTag clone() {
        return new FloatTag(this.getName(), this.value);
    }
}

