/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.kzedmap;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapChunk;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapWorld;
import org.dynmap.Log;
import org.dynmap.MapTile;
import org.dynmap.MapType;
import org.dynmap.json.simple.JSONObject;
import org.dynmap.kzedmap.KzedMapTile;
import org.dynmap.kzedmap.MapTileRenderer;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.TileFlags;

public class KzedMap
extends MapType {
    public static final int tileWidth = 128;
    public static final int tileHeight = 128;
    public static final int zTileWidth = 256;
    public static final int zTileHeight = 256;
    public MapTileRenderer[] renderers;
    private boolean isbigmap;
    private static final int[] stepseq = new int[]{0, 2, 1, 3};

    public KzedMap(DynmapCore core, ConfigurationNode configuration) {
        Log.verboseinfo("Loading renderers for map '" + this.getClass().toString() + "'...");
        List<MapTileRenderer> renderers = configuration.createInstances("renderers", new Class[]{DynmapCore.class}, new Object[]{core});
        this.renderers = new MapTileRenderer[renderers.size()];
        renderers.toArray(this.renderers);
        Log.verboseinfo("Loaded " + renderers.size() + " renderers for map '" + this.getClass().toString() + "'.");
        this.isbigmap = configuration.getBoolean("isbigmap", false);
        this.setTileUpdateDelay(configuration.getInteger("tileupdatedelay", -1));
    }

    @Override
    public ConfigurationNode saveConfiguration() {
        ConfigurationNode cn = super.saveConfiguration();
        cn.put("isbigmap", (Object)this.isbigmap);
        if (this.tileupdatedelay > 0) {
            cn.put("tileupdatedelay", (Object)this.tileupdatedelay);
        }
        ArrayList<Map<String, Object>> rendinfo = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < this.renderers.length; ++i) {
            ConfigurationNode rcn = this.renderers[i].saveConfiguration();
            rendinfo.add(rcn.entries);
        }
        return cn;
    }

    @Override
    public List<TileFlags.TileCoord> getTileCoords(DynmapWorld world, int x, int y, int z) {
        int dx = x;
        int dy = y - 127;
        int dz = z;
        int px = dx + dz;
        int py = dx - dz - dy;
        int tx = KzedMap.tilex(px);
        int ty = KzedMap.tiley(py);
        ArrayList<TileFlags.TileCoord> tiles = new ArrayList<TileFlags.TileCoord>();
        boolean ledge = KzedMap.tilex(px - 4) != tx;
        boolean tedge = KzedMap.tiley(py - 4) != ty;
        boolean redge = KzedMap.tilex(px + 4) != tx;
        boolean bedge = KzedMap.tiley(py + 4) != ty;
        int tilex = tx >> 7;
        int tiley = ty >> 7;
        tiles.add(new TileFlags.TileCoord(tilex, tiley));
        if (ledge) {
            tiles.add(new TileFlags.TileCoord(tilex - 1, tiley));
        }
        if (redge) {
            tiles.add(new TileFlags.TileCoord(tilex + 1, tiley));
        }
        if (tedge) {
            tiles.add(new TileFlags.TileCoord(tilex, tiley - 1));
        }
        if (bedge) {
            tiles.add(new TileFlags.TileCoord(tilex, tiley + 1));
        }
        if (ledge && tedge) {
            tiles.add(new TileFlags.TileCoord(tilex - 1, tiley - 1));
        }
        if (ledge && bedge) {
            tiles.add(new TileFlags.TileCoord(tilex - 1, tiley + 1));
        }
        if (redge && tedge) {
            tiles.add(new TileFlags.TileCoord(tilex + 1, tiley - 1));
        }
        if (redge && bedge) {
            tiles.add(new TileFlags.TileCoord(tilex + 1, tiley + 1));
        }
        return tiles;
    }

    @Override
    public List<TileFlags.TileCoord> getTileCoords(DynmapWorld world, int minx, int miny, int minz, int maxx, int maxy, int maxz) {
        ArrayList<TileFlags.TileCoord> tiles = new ArrayList<TileFlags.TileCoord>();
        int dx = minx;
        int dy = miny - 127;
        int dz = minz;
        int px0 = dx + dz;
        int py0 = dx - dz - dy;
        dx = maxx;
        dy = maxy - 127;
        dz = maxz;
        int px1 = dx + dz;
        int py1 = dx - dz - dy;
        int mintx = px1 < px0 ? px0 : px1;
        int maxtx = px1 < px0 ? px1 + 1 : px0 + 1;
        int minty = py1 < py0 ? py0 : py1;
        int maxty = py1 < py0 ? py1 + 1 : py0 + 1;
        for (int i = mintx >> 7; i <= maxtx >> 7; ++i) {
            for (int j = minty >> 7; j < maxty >> 7; ++j) {
                tiles.add(new TileFlags.TileCoord(i, j));
            }
        }
        return tiles;
    }

    @Override
    public MapTile[] getAdjecentTiles(MapTile tile) {
        if (tile instanceof KzedMapTile) {
            KzedMapTile t = (KzedMapTile)tile;
            DynmapWorld world = tile.getDynmapWorld();
            MapTileRenderer renderer = t.renderer;
            return new MapTile[]{new KzedMapTile(world, this, renderer, t.px - 128, t.py + 128), new KzedMapTile(world, this, renderer, t.px + 128, t.py - 128), new KzedMapTile(world, this, renderer, t.px - 128, t.py - 128), new KzedMapTile(world, this, renderer, t.px + 128, t.py + 128), new KzedMapTile(world, this, renderer, t.px - 128, t.py), new KzedMapTile(world, this, renderer, t.px + 128, t.py), new KzedMapTile(world, this, renderer, t.px, t.py - 128), new KzedMapTile(world, this, renderer, t.px, t.py + 128)};
        }
        return new MapTile[0];
    }

    private boolean testPointInRectangle(int x, int z, int r0x, int r0z, int s1x, int s1z, int s2x, int s2z) {
        int xr = x - r0x;
        int zr = z - r0z;
        int dots1 = xr * s1x + zr * s1z;
        int dots2 = xr * s2x + zr * s2z;
        return dots1 >= 0 && dots1 <= s1x * s1x + s1z * s1z && dots2 >= 0 && dots2 <= s2x * s2x + s2z * s2z;
    }

    @Override
    public List<DynmapChunk> getRequiredChunks(MapTile tile) {
        if (tile instanceof KzedMapTile) {
            KzedMapTile t = (KzedMapTile)tile;
            int vscale = tile.getDynmapWorld().worldheight / 128;
            int ix = t.px / 2 + t.py / 2;
            int iz = t.px / 2 - t.py / 2;
            int x1 = ix - 64;
            int x2 = ix + 128 * vscale;
            int z1 = iz - 64 * vscale;
            int z2 = iz + 64 + 64;
            ArrayList<DynmapChunk> chunks = new ArrayList<DynmapChunk>();
            int prismx = 128 * (vscale + 1) / 2;
            int prismz = -(128 + (vscale + 1) / 2);
            for (int x = x1; x < x2; x += 16) {
                for (int z = z1; z < z2; z += 16) {
                    if (!this.testPointInRectangle(x, z, x1, iz + 64, 64, 64, prismx, prismz) && !this.testPointInRectangle(x + 15, z, x1, iz + 64, 64, 64, prismx, prismz) && !this.testPointInRectangle(x + 15, z + 15, x1, iz + 64, 64, 64, prismx, prismz) && !this.testPointInRectangle(x, z + 15, x1, iz + 64, 64, 64, prismx, prismz)) continue;
                    DynmapChunk chunk = new DynmapChunk(x / 16, z / 16);
                    chunks.add(chunk);
                }
            }
            return chunks;
        }
        return new ArrayList<DynmapChunk>();
    }

    public boolean render(MapChunkCache cache, MapTile tile, File outputFile) {
        if (tile instanceof KzedMapTile) {
            return ((KzedMapTile)tile).renderer.render(cache, (KzedMapTile)tile, outputFile);
        }
        return false;
    }

    static int tilex(int x) {
        if (x < 0) {
            return x - (128 + x % 128);
        }
        return x - x % 128;
    }

    static int tiley(int y) {
        if (y < 0) {
            return y - (128 + y % 128);
        }
        return y - y % 128;
    }

    static int ztilex(int x) {
        if (x < 0) {
            return x + x % 256;
        }
        return x - x % 256;
    }

    static int ztiley(int y) {
        if (y < 0) {
            return y + y % 256;
        }
        return y - y % 256;
    }

    public boolean isBiomeDataNeeded() {
        for (MapTileRenderer r : this.renderers) {
            if (!r.isBiomeDataNeeded()) continue;
            return true;
        }
        return false;
    }

    public boolean isRawBiomeDataNeeded() {
        for (MapTileRenderer r : this.renderers) {
            if (!r.isRawBiomeDataNeeded()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<MapType.ZoomInfo> baseZoomFileInfo() {
        ArrayList<MapType.ZoomInfo> s = new ArrayList<MapType.ZoomInfo>();
        for (MapTileRenderer r : this.renderers) {
            s.add(new MapType.ZoomInfo("z" + r.getPrefix(), 0));
            if (!r.isNightAndDayEnabled()) continue;
            s.add(new MapType.ZoomInfo("z" + r.getPrefix() + "_day", 0));
        }
        return s;
    }

    @Override
    public int baseZoomFileStepSize() {
        return 256;
    }

    @Override
    public MapType.MapStep zoomFileMapStep() {
        return MapType.MapStep.X_MINUS_Y_PLUS;
    }

    @Override
    public int[] zoomFileStepSequence() {
        return stepseq;
    }

    @Override
    public int getBigWorldShift() {
        return 12;
    }

    @Override
    public boolean isBigWorldMap(DynmapWorld w) {
        return w.bigworld || this.isbigmap;
    }

    @Override
    public String getName() {
        return "KzedMap";
    }

    @Override
    public List<MapType> getMapsSharingRender(DynmapWorld w) {
        return Collections.singletonList(this);
    }

    @Override
    public List<String> getMapNamesSharingRender(DynmapWorld w) {
        ArrayList<String> lst = new ArrayList<String>();
        for (MapTileRenderer rend : this.renderers) {
            if (rend.isNightAndDayEnabled()) {
                lst.add(rend.getName() + "(night/day)");
                continue;
            }
            lst.add(rend.getName());
        }
        return lst;
    }

    @Override
    public void buildClientConfiguration(JSONObject worldObject, DynmapWorld world) {
        for (MapTileRenderer renderer : this.renderers) {
            renderer.buildClientConfiguration(worldObject, world, this);
        }
    }

    @Override
    public String getPrefix() {
        return "kzed";
    }

    @Override
    public void addMapTiles(List<MapTile> list, DynmapWorld w, int tx, int ty) {
        for (int i = 0; i < this.renderers.length; ++i) {
            list.add(new KzedMapTile(w, this, this.renderers[i], tx << 7, ty << 7));
        }
    }
}

