/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.kzedmap;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import javax.imageio.ImageIO;
import org.dynmap.Client;
import org.dynmap.Color;
import org.dynmap.ColorScheme;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapWorld;
import org.dynmap.JSONUtils;
import org.dynmap.MapManager;
import org.dynmap.MapType;
import org.dynmap.TileHashManager;
import org.dynmap.common.BiomeMap;
import org.dynmap.debug.Debug;
import org.dynmap.json.simple.JSONObject;
import org.dynmap.kzedmap.KzedMap;
import org.dynmap.kzedmap.KzedMapTile;
import org.dynmap.kzedmap.KzedZoomedMapTile;
import org.dynmap.kzedmap.MapTileRenderer;
import org.dynmap.utils.BlockStep;
import org.dynmap.utils.DynmapBufferedImage;
import org.dynmap.utils.FileLockManager;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.MapIterator;

public class DefaultTileRenderer
implements MapTileRenderer {
    protected static final Color translucent = new Color(0, 0, 0, 0);
    protected String name;
    protected String prefix;
    protected int maximumHeight = 127;
    protected ColorScheme colorScheme;
    protected HashSet<Integer> highlightBlocks = new HashSet();
    protected Color highlightColor = new Color(255, 0, 0);
    protected int[] shadowscale;
    protected int[] lightscale;
    protected boolean night_and_day;
    protected boolean transparency;
    private String title;
    private String icon;
    private String bg_cfg;
    private String bg_day_cfg;
    private String bg_night_cfg;
    private int mapzoomin;
    private double shadowstrength;
    private int ambientlight;
    private boolean is_protected;
    protected BiomeColorOption biomecolored = BiomeColorOption.NONE;

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isNightAndDayEnabled() {
        return this.night_and_day;
    }

    public DefaultTileRenderer(DynmapCore core, ConfigurationNode configuration) {
        int i;
        this.name = configuration.getString("name", null);
        this.prefix = configuration.getString("prefix", this.name);
        this.maximumHeight = configuration.getInteger("maximumheight", 127);
        this.shadowstrength = configuration.getDouble("shadowstrength", 0.0);
        if (this.shadowstrength > 0.0) {
            this.shadowscale = new int[16];
            this.shadowscale[15] = 256;
            for (i = 14; i >= 0; --i) {
                double v = (double)this.shadowscale[i + 1] * (1.0 - 0.2 * this.shadowstrength);
                this.shadowscale[i] = (int)v;
                if (this.shadowscale[i] > 256) {
                    this.shadowscale[i] = 256;
                }
                if (this.shadowscale[i] >= 0) continue;
                this.shadowscale[i] = 0;
            }
        }
        this.ambientlight = configuration.getInteger("ambientlight", 15);
        if (this.ambientlight < 15) {
            this.lightscale = new int[16];
            for (i = 0; i < 16; ++i) {
                this.lightscale[i] = i < 15 - this.ambientlight ? 0 : i - (15 - this.ambientlight);
            }
        }
        this.colorScheme = ColorScheme.getScheme(core, (String)configuration.get("colorscheme"));
        this.night_and_day = configuration.getBoolean("night-and-day", false);
        this.transparency = configuration.getBoolean("transparency", true);
        String biomeopt = configuration.getString("biomecolored", "none");
        this.biomecolored = biomeopt.equals("biome") ? BiomeColorOption.BIOME : (biomeopt.equals("temperature") ? BiomeColorOption.TEMPERATURE : (biomeopt.equals("rainfall") ? BiomeColorOption.RAINFALL : BiomeColorOption.NONE));
        this.title = configuration.getString("title");
        this.icon = configuration.getString("icon");
        this.bg_cfg = configuration.getString("background");
        this.bg_day_cfg = configuration.getString("backgroundday");
        this.bg_night_cfg = configuration.getString("backgroundnight");
        this.mapzoomin = configuration.getInteger("mapzoomin", 2);
        this.is_protected = configuration.getBoolean("protected", false);
    }

    @Override
    public ConfigurationNode saveConfiguration() {
        ConfigurationNode cn = new ConfigurationNode();
        cn.put("class", (Object)this.getClass().getName());
        cn.put("name", (Object)this.name);
        if (this.title != null) {
            cn.put("title", (Object)this.title);
        }
        if (this.icon != null) {
            cn.put("icon", (Object)this.icon);
        }
        cn.put("maximumheight", (Object)this.maximumHeight);
        cn.put("shadowstrength", (Object)this.shadowstrength);
        cn.put("ambientlight", (Object)this.ambientlight);
        if (this.colorScheme != null) {
            cn.put("colorscheme", (Object)this.colorScheme.name);
        }
        cn.put("night-and-day", (Object)this.night_and_day);
        cn.put("transparency", (Object)this.transparency);
        cn.put("protected", (Object)this.is_protected);
        String bcolor = "none";
        switch (this.biomecolored) {
            case BIOME: {
                bcolor = "biome";
                break;
            }
            case TEMPERATURE: {
                bcolor = "temperature";
                break;
            }
            case RAINFALL: {
                bcolor = "rainfall";
            }
        }
        cn.put("biomecolored", (Object)bcolor);
        if (this.bg_cfg != null) {
            cn.put("background", (Object)this.bg_cfg);
        }
        if (this.bg_day_cfg != null) {
            cn.put("backgroundday", (Object)this.bg_day_cfg);
        }
        if (this.bg_night_cfg != null) {
            cn.put("backgroundnight", (Object)this.bg_night_cfg);
        }
        cn.put("mapzoomin", (Object)this.mapzoomin);
        return cn;
    }

    @Override
    public boolean isBiomeDataNeeded() {
        return this.biomecolored.equals((Object)BiomeColorOption.BIOME);
    }

    @Override
    public boolean isRawBiomeDataNeeded() {
        return this.biomecolored.equals((Object)BiomeColorOption.RAINFALL) || this.biomecolored.equals((Object)BiomeColorOption.TEMPERATURE);
    }

    @Override
    public boolean render(MapChunkCache cache, KzedMapTile tile, File outputFile) {
        DynmapWorld world = tile.getDynmapWorld();
        boolean isnether = world.isNether();
        DynmapBufferedImage im = DynmapBufferedImage.allocateBufferedImage(128, 128);
        DynmapBufferedImage zim = DynmapBufferedImage.allocateBufferedImage(64, 64);
        DynmapBufferedImage im_day = null;
        DynmapBufferedImage zim_day = null;
        if (this.night_and_day) {
            im_day = DynmapBufferedImage.allocateBufferedImage(128, 128);
            zim_day = DynmapBufferedImage.allocateBufferedImage(64, 64);
        }
        if (cache.getWorld().worldheight > 128 && this.maximumHeight == 127) {
            this.maximumHeight = cache.getWorld().worldheight - 1;
        }
        int ix = tile.px / 2 + tile.py / 2 - (127 - this.maximumHeight) / 2;
        int iy = this.maximumHeight;
        int iz = tile.px / 2 - tile.py / 2 + (127 - this.maximumHeight) / 2;
        if (this.maximumHeight < 127) {
            isnether = false;
        }
        MapIterator mapiter = cache.getIterator(ix, iy, iz);
        Color c1 = new Color();
        Color c2 = new Color();
        int[] argb = im.argb_buf;
        int[] zargb = zim.argb_buf;
        Color c1_day = null;
        Color c2_day = null;
        int[] argb_day = null;
        int[] zargb_day = null;
        if (this.night_and_day) {
            c1_day = new Color();
            c2_day = new Color();
            argb_day = im_day.argb_buf;
            zargb_day = zim_day.argb_buf;
        }
        int rowoff = 0;
        int y = 0;
        while (y < 128) {
            int x;
            int jx = ix;
            int jz = iz;
            for (x = 127; x >= 0; x -= 2) {
                mapiter.initialize(jx, iy, jz);
                this.scan(world, 0, isnether, c1, c1_day, mapiter);
                mapiter.initialize(jx, iy, jz);
                this.scan(world, 2, isnether, c2, c2_day, mapiter);
                argb[rowoff + x] = c1.getARGB();
                argb[rowoff + x - 1] = c2.getARGB();
                if (this.night_and_day) {
                    argb_day[rowoff + x] = c1_day.getARGB();
                    argb_day[rowoff + x - 1] = c2_day.getARGB();
                }
                ++jx;
                ++jz;
            }
            ++y;
            rowoff += 128;
            jx = ix;
            jz = iz - 1;
            for (x = 127; x >= 0; x -= 2) {
                mapiter.initialize(jx, iy, jz);
                this.scan(world, 2, isnether, c1, c1_day, mapiter);
                mapiter.initialize(++jx, iy, ++jz);
                this.scan(world, 0, isnether, c2, c2_day, mapiter);
                argb[rowoff + x] = c1.getARGB();
                argb[rowoff + x - 1] = c2.getARGB();
                if (!this.night_and_day) continue;
                argb_day[rowoff + x] = c1_day.getARGB();
                argb_day[rowoff + x - 1] = c2_day.getARGB();
            }
            ++y;
            rowoff += 128;
            ++ix;
            --iz;
        }
        this.doScaleWithBilinear(argb, zargb, 128, 128);
        if (this.night_and_day) {
            this.doScaleWithBilinear(argb_day, zargb_day, 128, 128);
        }
        KzedZoomedMapTile zmtile = new KzedZoomedMapTile(tile.getDynmapWorld(), tile);
        File zoomFile = MapManager.mapman.getTileFile(zmtile);
        return this.doFileWrites(outputFile, tile, im, im_day, zmtile, zoomFile, zim, zim_day);
    }

    private void doScaleWithBilinear(int[] argb, int[] zargb, int width, int height) {
        Color c1 = new Color();
        for (int y = 0; y < height; y += 2) {
            for (int x = 0; x < width; x += 2) {
                int red = 0;
                int green = 0;
                int blue = 0;
                int alpha = 0;
                for (int yy = y; yy < y + 2; ++yy) {
                    for (int xx = x; xx < x + 2; ++xx) {
                        c1.setARGB(argb[yy * width + xx]);
                        red += c1.getRed();
                        green += c1.getGreen();
                        blue += c1.getBlue();
                        alpha += c1.getAlpha();
                    }
                }
                c1.setRGBA(red >> 2, green >> 2, blue >> 2, alpha >> 2);
                zargb[y * width / 4 + x / 2] = c1.getARGB();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doFileWrites(File fname, KzedMapTile mtile, DynmapBufferedImage img, DynmapBufferedImage img_day, KzedZoomedMapTile zmtile, File zoomFile, DynmapBufferedImage zimg, DynmapBufferedImage zimg_day) {
        int ty;
        int tx;
        boolean updated_fname;
        long crc;
        TileHashManager hashman;
        int oy;
        int ox;
        boolean didwrite;
        block24: {
            didwrite = false;
            ox = mtile.px == zmtile.getTileX() ? 0 : 64;
            oy = mtile.py == zmtile.getTileY() ? 0 : 64;
            hashman = MapManager.mapman.hashman;
            crc = hashman.calculateTileHash(img.argb_buf);
            updated_fname = false;
            tx = mtile.px / 128;
            ty = mtile.py / 128;
            FileLockManager.getWriteLock(fname);
            try {
                if (fname.exists() && crc == hashman.getImageHashCode(mtile.getKey(this.prefix), null, tx, ty)) break block24;
                Debug.debug("saving image " + fname.getPath());
                if (!fname.getParentFile().exists()) {
                    fname.getParentFile().mkdirs();
                }
                try {
                    FileLockManager.imageIOWrite(img.buf_img, MapType.ImageFormat.FORMAT_PNG, fname);
                }
                catch (IOException e) {
                    Debug.error("Failed to save image: " + fname.getPath(), e);
                }
                catch (NullPointerException e) {
                    Debug.error("Failed to save image (NullPointerException): " + fname.getPath(), e);
                }
                MapManager.mapman.pushUpdate(mtile.getDynmapWorld(), (Client.Update)new Client.Tile(mtile.getFilename()));
                hashman.updateHashCode(mtile.getKey(this.prefix), null, tx, ty, crc);
                updated_fname = true;
                didwrite = true;
            }
            finally {
                FileLockManager.releaseWriteLock(fname);
                DynmapBufferedImage.freeBufferedImage(img);
            }
        }
        MapManager.mapman.updateStatistics(mtile, this.prefix, true, updated_fname, true);
        mtile.file = fname;
        boolean updated_dfname = false;
        File dfname = new File(mtile.getDynmapWorld().worldtilepath, mtile.getDayFilename());
        if (img_day != null) {
            block25: {
                crc = hashman.calculateTileHash(img.argb_buf);
                FileLockManager.getWriteLock(dfname);
                try {
                    if (dfname.exists() && crc == hashman.getImageHashCode(mtile.getKey(this.prefix), "day", tx, ty)) break block25;
                    Debug.debug("saving image " + dfname.getPath());
                    if (!dfname.getParentFile().exists()) {
                        dfname.getParentFile().mkdirs();
                    }
                    try {
                        FileLockManager.imageIOWrite(img_day.buf_img, MapType.ImageFormat.FORMAT_PNG, dfname);
                    }
                    catch (IOException e) {
                        Debug.error("Failed to save image: " + dfname.getPath(), e);
                    }
                    catch (NullPointerException e) {
                        Debug.error("Failed to save image (NullPointerException): " + dfname.getPath(), e);
                    }
                    MapManager.mapman.pushUpdate(mtile.getDynmapWorld(), (Client.Update)new Client.Tile(mtile.getDayFilename()));
                    hashman.updateHashCode(mtile.getKey(this.prefix), "day", tx, ty, crc);
                    updated_dfname = true;
                    didwrite = true;
                }
                finally {
                    FileLockManager.releaseWriteLock(dfname);
                    DynmapBufferedImage.freeBufferedImage(img_day);
                }
            }
            MapManager.mapman.updateStatistics(mtile, this.prefix + "_day", true, updated_dfname, true);
        }
        boolean ztile_updated = false;
        FileLockManager.getWriteLock(zoomFile);
        try {
            if (updated_fname || !zoomFile.exists()) {
                this.saveZoomedTile(zmtile, zoomFile, zimg, ox, oy, null);
                MapManager.mapman.pushUpdate(zmtile.getDynmapWorld(), (Client.Update)new Client.Tile(zmtile.getFilename()));
                zmtile.getDynmapWorld().enqueueZoomOutUpdate(zoomFile);
                ztile_updated = true;
            }
        }
        finally {
            FileLockManager.releaseWriteLock(zoomFile);
            DynmapBufferedImage.freeBufferedImage(zimg);
        }
        MapManager.mapman.updateStatistics(zmtile, null, true, ztile_updated, true);
        if (zimg_day != null) {
            File zoomFile_day = new File(zmtile.getDynmapWorld().worldtilepath, zmtile.getDayFilename());
            ztile_updated = false;
            FileLockManager.getWriteLock(zoomFile_day);
            try {
                if (updated_dfname || !zoomFile_day.exists()) {
                    this.saveZoomedTile(zmtile, zoomFile_day, zimg_day, ox, oy, "day");
                    MapManager.mapman.pushUpdate(zmtile.getDynmapWorld(), (Client.Update)new Client.Tile(zmtile.getDayFilename()));
                    zmtile.getDynmapWorld().enqueueZoomOutUpdate(zoomFile_day);
                    ztile_updated = true;
                }
            }
            finally {
                FileLockManager.releaseWriteLock(zoomFile_day);
                DynmapBufferedImage.freeBufferedImage(zimg_day);
            }
            MapManager.mapman.updateStatistics(zmtile, "day", true, ztile_updated, true);
        }
        return didwrite;
    }

    private void saveZoomedTile(KzedZoomedMapTile zmtile, File zoomFile, DynmapBufferedImage zimg, int ox, int oy, String subkey) {
        BufferedImage zIm = null;
        DynmapBufferedImage kzIm = null;
        try {
            zIm = ImageIO.read(zoomFile);
        }
        catch (IOException e) {
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        boolean zIm_allocated = false;
        if (zIm == null) {
            kzIm = DynmapBufferedImage.allocateBufferedImage(128, 128);
            zIm = kzIm.buf_img;
            zIm_allocated = true;
            Debug.debug("New zoom-out tile created " + zmtile.getFilename());
        } else {
            Debug.debug("Loaded zoom-out tile from " + zmtile.getFilename());
        }
        zIm.setRGB(ox, oy, 64, 64, zimg.argb_buf, 0, 64);
        if (!zoomFile.getParentFile().exists()) {
            zoomFile.getParentFile().mkdirs();
        }
        try {
            FileLockManager.imageIOWrite(zIm, MapType.ImageFormat.FORMAT_PNG, zoomFile);
            Debug.debug("Saved zoom-out tile at " + zoomFile.getName());
        }
        catch (IOException e) {
            Debug.error("Failed to save zoom-out tile: " + zoomFile.getName(), e);
        }
        catch (NullPointerException e) {
            Debug.error("Failed to save zoom-out tile (NullPointerException): " + zoomFile.getName(), e);
        }
        if (zIm_allocated) {
            DynmapBufferedImage.freeBufferedImage(kzIm);
        } else {
            zIm.flush();
        }
    }

    protected void scan(DynmapWorld world, int seq, boolean isnether, Color result, Color result_day, MapIterator mapiter) {
        Color c;
        int lightlevel = 15;
        int lightlevel_day = 15;
        BiomeMap bio = null;
        double rain = 0.0;
        double temp = 0.0;
        result.setTransparent();
        if (result_day != null) {
            result_day.setTransparent();
        }
        while (true) {
            if (mapiter.getY() < 0) {
                return;
            }
            int id = mapiter.getBlockTypeID();
            int data = 0;
            if (isnether) {
                if (id != 0) {
                    if (result.isTransparent()) {
                        try {
                            if (this.colorScheme.colors[id] != null) {
                                result.setColor(this.colorScheme.colors[id][seq]);
                            }
                        }
                        catch (ArrayIndexOutOfBoundsException aioobx) {
                            this.colorScheme.resizeColorArray(id);
                        }
                    }
                    id = 0;
                } else {
                    isnether = false;
                }
            }
            if (id != 0) {
                switch (this.biomecolored) {
                    case NONE: {
                        try {
                            if (this.colorScheme.datacolors[id] == null) break;
                            data = mapiter.getBlockData();
                        }
                        catch (ArrayIndexOutOfBoundsException aioobx) {
                            this.colorScheme.resizeColorArray(id);
                        }
                        break;
                    }
                    case BIOME: {
                        bio = mapiter.getBiome();
                        break;
                    }
                    case RAINFALL: {
                        rain = mapiter.getBiome().getRainfall();
                        break;
                    }
                    case TEMPERATURE: {
                        temp = mapiter.getBiome().getTemperature();
                    }
                }
                if (this.shadowscale != null && mapiter.getY() < mapiter.getWorldHeight() - 1) {
                    BlockStep last = mapiter.unstepPosition();
                    lightlevel = lightlevel_day = mapiter.getBlockSkyLight();
                    if (this.lightscale != null) {
                        lightlevel = this.lightscale[lightlevel];
                    }
                    if (lightlevel < 15 || lightlevel_day < 15) {
                        int emitted = mapiter.getBlockEmittedLight();
                        lightlevel = Math.max(emitted, lightlevel);
                        lightlevel_day = Math.max(emitted, lightlevel_day);
                    }
                    mapiter.stepPosition(last);
                }
            }
            switch (seq) {
                case 0: {
                    mapiter.stepPosition(BlockStep.X_MINUS);
                    break;
                }
                case 1: 
                case 3: {
                    mapiter.stepPosition(BlockStep.Y_MINUS);
                    break;
                }
                case 2: {
                    mapiter.stepPosition(BlockStep.Z_PLUS);
                }
            }
            seq = seq + 1 & 3;
            if (id == 0) continue;
            if (this.highlightBlocks.contains(id)) {
                result.setColor(this.highlightColor);
                return;
            }
            Color[] colors = null;
            switch (this.biomecolored) {
                case NONE: {
                    try {
                        if (data != 0) {
                            colors = this.colorScheme.datacolors[id][data];
                            break;
                        }
                        colors = this.colorScheme.colors[id];
                    }
                    catch (ArrayIndexOutOfBoundsException aioobx) {
                        this.colorScheme.resizeColorArray(id);
                    }
                    break;
                }
                case BIOME: {
                    if (bio == null) break;
                    colors = this.colorScheme.biomecolors[bio.ordinal()];
                    break;
                }
                case RAINFALL: {
                    colors = this.colorScheme.getRainColor(rain);
                    break;
                }
                case TEMPERATURE: {
                    colors = this.colorScheme.getTempColor(temp);
                }
            }
            if (colors != null && (c = colors[seq]).getAlpha() > 0) break;
        }
        if (!this.transparency || c.getAlpha() == 255) {
            result.setARGB(c.getARGB() | 0xFF000000);
            if (lightlevel < 15) {
                this.shadowColor(result, lightlevel);
            }
            if (result_day != null) {
                if (lightlevel_day == lightlevel) {
                    result_day.setColor(result);
                } else {
                    result_day.setColor(c);
                    if (lightlevel_day < 15) {
                        this.shadowColor(result_day, lightlevel_day);
                    }
                }
            }
            return;
        }
        this.scan(world, seq, isnether, result, result_day, mapiter);
        int cr = c.getRed();
        int cg = c.getGreen();
        int cb = c.getBlue();
        int ca = c.getAlpha();
        if (lightlevel < 15) {
            int scale = this.shadowscale[lightlevel];
            cr = cr * scale >> 8;
            cg = cg * scale >> 8;
            cb = cb * scale >> 8;
        }
        int na = 255 - ca;
        result.setRGBA(result.getRed() * na + (cr *= ca) >> 8, result.getGreen() * na + (cg *= ca) >> 8, result.getBlue() * na + (cb *= ca) >> 8, 255);
        if (result_day != null) {
            cr = c.getRed();
            cg = c.getGreen();
            cb = c.getBlue();
            if (lightlevel_day < 15) {
                int scale = this.shadowscale[lightlevel_day];
                cr = cr * scale >> 8;
                cg = cg * scale >> 8;
                cb = cb * scale >> 8;
            }
            result_day.setRGBA(result_day.getRed() * na + (cr *= ca) >> 8, result_day.getGreen() * na + (cg *= ca) >> 8, result_day.getBlue() * na + (cb *= ca) >> 8, 255);
        }
    }

    private final void shadowColor(Color c, int lightlevel) {
        int scale = this.shadowscale[lightlevel];
        if (scale < 256) {
            c.setRGBA(c.getRed() * scale >> 8, c.getGreen() * scale >> 8, c.getBlue() * scale >> 8, c.getAlpha());
        }
    }

    @Override
    public void buildClientConfiguration(JSONObject worldObject, DynmapWorld world, KzedMap map) {
        JSONObject o = new JSONObject();
        JSONUtils.s(o, "type", "KzedMapType");
        JSONUtils.s(o, "name", this.name);
        JSONUtils.s(o, "title", this.title);
        JSONUtils.s(o, "icon", this.icon);
        JSONUtils.s(o, "prefix", this.prefix);
        JSONUtils.s(o, "background", this.bg_cfg);
        JSONUtils.s(o, "nightandday", this.night_and_day);
        JSONUtils.s(o, "backgroundday", this.bg_day_cfg);
        JSONUtils.s(o, "backgroundnight", this.bg_night_cfg);
        JSONUtils.s(o, "bigmap", map.isBigWorldMap(world));
        JSONUtils.s(o, "mapzoomin", this.mapzoomin);
        JSONUtils.s(o, "protected", this.is_protected);
        JSONUtils.s(o, "mapzoomout", world.getExtraZoomOutLevels() + 1);
        if (MapManager.mapman.getCompassMode() != DynmapCore.CompassMode.PRE19) {
            JSONUtils.s(o, "compassview", "NE");
        } else {
            JSONUtils.s(o, "compassview", "SE");
        }
        JSONUtils.s(o, "image-format", MapType.ImageFormat.FORMAT_PNG.getFileExt());
        JSONUtils.a(worldObject, "maps", o);
    }

    @Override
    public boolean isProtected() {
        return this.is_protected;
    }

    public static enum BiomeColorOption {
        NONE,
        BIOME,
        TEMPERATURE,
        RAINFALL;

    }
}

