/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.jetty.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.ServletSecurityElement;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dynmap.jetty.continuation.ContinuationThrowable;
import org.dynmap.jetty.http.HttpException;
import org.dynmap.jetty.http.PathMap;
import org.dynmap.jetty.io.EofException;
import org.dynmap.jetty.io.RuntimeIOException;
import org.dynmap.jetty.security.IdentityService;
import org.dynmap.jetty.security.SecurityHandler;
import org.dynmap.jetty.server.AbstractHttpConnection;
import org.dynmap.jetty.server.Request;
import org.dynmap.jetty.server.Server;
import org.dynmap.jetty.server.ServletRequestHttpWrapper;
import org.dynmap.jetty.server.ServletResponseHttpWrapper;
import org.dynmap.jetty.server.UserIdentity;
import org.dynmap.jetty.server.handler.ContextHandler;
import org.dynmap.jetty.server.handler.ScopedHandler;
import org.dynmap.jetty.servlet.FilterHolder;
import org.dynmap.jetty.servlet.FilterMapping;
import org.dynmap.jetty.servlet.Holder;
import org.dynmap.jetty.servlet.ServletContextHandler;
import org.dynmap.jetty.servlet.ServletHolder;
import org.dynmap.jetty.servlet.ServletMapping;
import org.dynmap.jetty.util.LazyList;
import org.dynmap.jetty.util.MultiException;
import org.dynmap.jetty.util.MultiMap;
import org.dynmap.jetty.util.TypeUtil;
import org.dynmap.jetty.util.URIUtil;
import org.dynmap.jetty.util.component.AbstractLifeCycle;
import org.dynmap.jetty.util.log.Log;
import org.dynmap.jetty.util.log.Logger;

public class ServletHandler
extends ScopedHandler {
    private static final Logger LOG = Log.getLogger(ServletHandler.class);
    public static final String __DEFAULT_SERVLET = "default";
    private ServletContextHandler _contextHandler;
    private ContextHandler.Context _servletContext;
    private FilterHolder[] _filters = new FilterHolder[0];
    private FilterMapping[] _filterMappings;
    private int _matchBeforeIndex = -1;
    private int _matchAfterIndex = -1;
    private boolean _filterChainsCached = true;
    private int _maxFilterChainsCacheSize = 512;
    private boolean _startWithUnavailable = false;
    private IdentityService _identityService;
    private ServletHolder[] _servlets = new ServletHolder[0];
    private ServletMapping[] _servletMappings;
    private final Map<String, FilterHolder> _filterNameMap = new HashMap<String, FilterHolder>();
    private List<FilterMapping> _filterPathMappings;
    private MultiMap<String> _filterNameMappings;
    private final Map<String, ServletHolder> _servletNameMap = new HashMap<String, ServletHolder>();
    private PathMap _servletPathMap;
    protected final ConcurrentMap<String, FilterChain>[] _chainCache = new ConcurrentMap[31];
    protected final Queue<String>[] _chainLRU = new Queue[31];

    @Override
    public void setServer(Server server) {
        Server old = this.getServer();
        if (old != null && old != server) {
            this.getServer().getContainer().update((Object)this, this._filters, null, "filter", true);
            this.getServer().getContainer().update((Object)this, this._filterMappings, null, "filterMapping", true);
            this.getServer().getContainer().update((Object)this, this._servlets, null, "servlet", true);
            this.getServer().getContainer().update((Object)this, this._servletMappings, null, "servletMapping", true);
        }
        super.setServer(server);
        if (server != null && old != server) {
            server.getContainer().update((Object)this, null, this._filters, "filter", true);
            server.getContainer().update((Object)this, null, this._filterMappings, "filterMapping", true);
            server.getContainer().update((Object)this, null, this._servlets, "servlet", true);
            server.getContainer().update((Object)this, null, this._servletMappings, "servletMapping", true);
        }
    }

    @Override
    protected synchronized void doStart() throws Exception {
        SecurityHandler security_handler;
        this._servletContext = ContextHandler.getCurrentContext();
        this._contextHandler = (ServletContextHandler)(this._servletContext == null ? null : this._servletContext.getContextHandler());
        if (this._contextHandler != null && (security_handler = this._contextHandler.getChildHandlerByClass(SecurityHandler.class)) != null) {
            this._identityService = security_handler.getIdentityService();
        }
        this.updateNameMappings();
        this.updateMappings();
        if (this._filterChainsCached) {
            this._chainCache[1] = new ConcurrentHashMap<String, FilterChain>();
            this._chainCache[2] = new ConcurrentHashMap<String, FilterChain>();
            this._chainCache[4] = new ConcurrentHashMap<String, FilterChain>();
            this._chainCache[8] = new ConcurrentHashMap<String, FilterChain>();
            this._chainCache[16] = new ConcurrentHashMap<String, FilterChain>();
            this._chainLRU[1] = new ConcurrentLinkedQueue<String>();
            this._chainLRU[2] = new ConcurrentLinkedQueue<String>();
            this._chainLRU[4] = new ConcurrentLinkedQueue<String>();
            this._chainLRU[8] = new ConcurrentLinkedQueue<String>();
            this._chainLRU[16] = new ConcurrentLinkedQueue<String>();
        }
        super.doStart();
        if (this._contextHandler == null || !(this._contextHandler instanceof ServletContextHandler)) {
            this.initialize();
        }
    }

    @Override
    protected synchronized void doStop() throws Exception {
        super.doStop();
        ArrayList<FilterHolder> filterHolders = new ArrayList<FilterHolder>();
        List<FilterMapping> filterMappings = LazyList.array2List(this._filterMappings);
        if (this._filters != null) {
            int i = this._filters.length;
            while (i-- > 0) {
                try {
                    this._filters[i].stop();
                }
                catch (Exception e) {
                    LOG.warn("EXCEPTION ", e);
                }
                if (this._filters[i].getSource() != Holder.Source.EMBEDDED) {
                    this._filterNameMap.remove(this._filters[i].getName());
                    ListIterator<FilterMapping> fmitor = filterMappings.listIterator();
                    while (fmitor.hasNext()) {
                        FilterMapping fm = fmitor.next();
                        if (!fm.getFilterName().equals(this._filters[i].getName())) continue;
                        fmitor.remove();
                    }
                    continue;
                }
                filterHolders.add(this._filters[i]);
            }
        }
        this._filters = (FilterHolder[])LazyList.toArray(filterHolders, FilterHolder.class);
        this._filterMappings = (FilterMapping[])LazyList.toArray(filterMappings, FilterMapping.class);
        this._matchAfterIndex = this._filterMappings == null || this._filterMappings.length == 0 ? -1 : this._filterMappings.length - 1;
        this._matchBeforeIndex = -1;
        ArrayList<ServletHolder> servletHolders = new ArrayList<ServletHolder>();
        List<ServletMapping> servletMappings = LazyList.array2List(this._servletMappings);
        if (this._servlets != null) {
            int i = this._servlets.length;
            while (i-- > 0) {
                try {
                    this._servlets[i].stop();
                }
                catch (Exception e) {
                    LOG.warn("EXCEPTION ", e);
                }
                if (this._servlets[i].getSource() != Holder.Source.EMBEDDED) {
                    this._servletNameMap.remove(this._servlets[i].getName());
                    ListIterator<ServletMapping> smitor = servletMappings.listIterator();
                    while (smitor.hasNext()) {
                        ServletMapping sm = smitor.next();
                        if (!sm.getServletName().equals(this._servlets[i].getName())) continue;
                        smitor.remove();
                    }
                    continue;
                }
                servletHolders.add(this._servlets[i]);
            }
        }
        this._servlets = (ServletHolder[])LazyList.toArray(servletHolders, ServletHolder.class);
        this._servletMappings = (ServletMapping[])LazyList.toArray(servletMappings, ServletMapping.class);
        this._filterPathMappings = null;
        this._filterNameMappings = null;
        this._servletPathMap = null;
    }

    IdentityService getIdentityService() {
        return this._identityService;
    }

    public Object getContextLog() {
        return null;
    }

    public FilterMapping[] getFilterMappings() {
        return this._filterMappings;
    }

    public FilterHolder[] getFilters() {
        return this._filters;
    }

    public PathMap.Entry getHolderEntry(String pathInContext) {
        if (this._servletPathMap == null) {
            return null;
        }
        return this._servletPathMap.getMatch(pathInContext);
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    public ServletMapping[] getServletMappings() {
        return this._servletMappings;
    }

    public ServletMapping getServletMapping(String pattern) {
        ServletMapping theMapping = null;
        if (this._servletMappings != null) {
            for (ServletMapping m : this._servletMappings) {
                String[] paths = m.getPathSpecs();
                if (paths == null) continue;
                for (String path : paths) {
                    if (!pattern.equals(path)) continue;
                    theMapping = m;
                }
            }
        }
        return theMapping;
    }

    public ServletHolder[] getServlets() {
        return this._servlets;
    }

    public ServletHolder getServlet(String name) {
        return this._servletNameMap.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doScope(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String old_servlet_path = baseRequest.getServletPath();
        String old_path_info = baseRequest.getPathInfo();
        DispatcherType type = baseRequest.getDispatcherType();
        ServletHolder servlet_holder = null;
        UserIdentity.Scope old_scope = null;
        if (target.startsWith("/")) {
            PathMap.Entry entry = this.getHolderEntry(target);
            if (entry != null) {
                servlet_holder = (ServletHolder)entry.getValue();
                String servlet_path_spec = (String)entry.getKey();
                String servlet_path = entry.getMapped() != null ? entry.getMapped() : PathMap.pathMatch(servlet_path_spec, target);
                String path_info = PathMap.pathInfo(servlet_path_spec, target);
                if (DispatcherType.INCLUDE.equals((Object)type)) {
                    baseRequest.setAttribute("javax.servlet.include.servlet_path", servlet_path);
                    baseRequest.setAttribute("javax.servlet.include.path_info", path_info);
                } else {
                    baseRequest.setServletPath(servlet_path);
                    baseRequest.setPathInfo(path_info);
                }
            }
        } else {
            servlet_holder = this._servletNameMap.get(target);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("servlet {}|{}|{} -> {}", baseRequest.getContextPath(), baseRequest.getServletPath(), baseRequest.getPathInfo(), servlet_holder);
        }
        try {
            old_scope = baseRequest.getUserIdentityScope();
            baseRequest.setUserIdentityScope(servlet_holder);
            if (this.never()) {
                this.nextScope(target, baseRequest, request, response);
            } else if (this._nextScope != null) {
                this._nextScope.doScope(target, baseRequest, request, response);
            } else if (this._outerScope != null) {
                this._outerScope.doHandle(target, baseRequest, request, response);
            } else {
                this.doHandle(target, baseRequest, request, response);
            }
        }
        finally {
            if (old_scope != null) {
                baseRequest.setUserIdentityScope(old_scope);
            }
            if (!DispatcherType.INCLUDE.equals((Object)type)) {
                baseRequest.setServletPath(old_servlet_path);
                baseRequest.setPathInfo(old_path_info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        DispatcherType type = baseRequest.getDispatcherType();
        ServletHolder servlet_holder = (ServletHolder)baseRequest.getUserIdentityScope();
        FilterChain chain = null;
        if (target.startsWith("/")) {
            if (servlet_holder != null && this._filterMappings != null && this._filterMappings.length > 0) {
                chain = this.getFilterChain(baseRequest, target, servlet_holder);
            }
        } else if (servlet_holder != null && this._filterMappings != null && this._filterMappings.length > 0) {
            chain = this.getFilterChain(baseRequest, null, servlet_holder);
        }
        LOG.debug("chain={}", chain);
        try {
            if (servlet_holder == null) {
                if (this.getHandler() == null) {
                    this.notFound(request, response);
                } else {
                    this.nextHandle(target, baseRequest, request, response);
                }
            } else {
                ServletResponse res;
                ServletRequest req = request;
                if (req instanceof ServletRequestHttpWrapper) {
                    req = ((ServletRequestHttpWrapper)req).getRequest();
                }
                if ((res = response) instanceof ServletResponseHttpWrapper) {
                    res = ((ServletResponseHttpWrapper)res).getResponse();
                }
                if (chain != null) {
                    chain.doFilter(req, res);
                } else {
                    servlet_holder.handle(baseRequest, req, res);
                }
            }
        }
        catch (EofException e) {
            throw e;
        }
        catch (RuntimeIOException e) {
            throw e;
        }
        catch (ContinuationThrowable e) {
            throw e;
        }
        catch (Exception e) {
            Throwable th;
            if (!DispatcherType.REQUEST.equals((Object)type) && !DispatcherType.ASYNC.equals((Object)type)) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof ServletException) {
                    throw (ServletException)e;
                }
            }
            if ((th = e) instanceof UnavailableException) {
                LOG.debug(th);
            } else if (th instanceof ServletException) {
                LOG.warn(th);
                Throwable cause = ((ServletException)th).getRootCause();
                if (cause != null) {
                    th = cause;
                }
            }
            if (th instanceof HttpException) {
                throw (HttpException)th;
            }
            if (th instanceof RuntimeIOException) {
                throw (RuntimeIOException)th;
            }
            if (th instanceof EofException) {
                throw (EofException)th;
            }
            if (LOG.isDebugEnabled()) {
                LOG.warn(request.getRequestURI(), th);
                LOG.debug(request.toString(), new Object[0]);
            } else if (th instanceof IOException || th instanceof UnavailableException) {
                LOG.debug(request.getRequestURI(), th);
            } else {
                LOG.warn(request.getRequestURI(), th);
            }
            request.setAttribute("javax.servlet.error.exception_type", th.getClass());
            request.setAttribute("javax.servlet.error.exception", th);
            if (!response.isCommitted()) {
                if (th instanceof UnavailableException) {
                    UnavailableException ue = (UnavailableException)th;
                    if (ue.isPermanent()) {
                        response.sendError(404);
                    } else {
                        response.sendError(503);
                    }
                } else {
                    response.sendError(500);
                }
            } else {
                LOG.debug("Response already committed for handling " + th, new Object[0]);
            }
            if (request.isAsyncStarted()) {
                request.getAsyncContext().complete();
            }
        }
        catch (Error e) {
            if (!DispatcherType.REQUEST.equals((Object)type) && !DispatcherType.ASYNC.equals((Object)type)) {
                throw e;
            }
            LOG.warn("Error for " + request.getRequestURI(), e);
            if (LOG.isDebugEnabled()) {
                LOG.debug(request.toString(), new Object[0]);
            }
            request.setAttribute("javax.servlet.error.exception_type", e.getClass());
            request.setAttribute("javax.servlet.error.exception", e);
            if (!response.isCommitted()) {
                response.sendError(500);
            } else {
                LOG.debug("Response already committed for handling ", e);
            }
            if (request.isAsyncStarted()) {
                request.getAsyncContext().complete();
            }
        }
        finally {
            if (servlet_holder != null) {
                baseRequest.setHandled(true);
            }
        }
    }

    private FilterChain getFilterChain(Request baseRequest, String pathInContext, ServletHolder servletHolder) {
        FilterChain chain;
        String key = pathInContext == null ? servletHolder.getName() : pathInContext;
        int dispatch = FilterMapping.dispatch(baseRequest.getDispatcherType());
        if (this._filterChainsCached && this._chainCache != null && (chain = (FilterChain)this._chainCache[dispatch].get(key)) != null) {
            return chain;
        }
        Object filters = null;
        if (pathInContext != null && this._filterPathMappings != null) {
            for (int i = 0; i < this._filterPathMappings.size(); ++i) {
                FilterMapping mapping = this._filterPathMappings.get(i);
                if (!mapping.appliesTo(pathInContext, dispatch)) continue;
                filters = LazyList.add(filters, mapping.getFilterHolder());
            }
        }
        if (servletHolder != null && this._filterNameMappings != null && this._filterNameMappings.size() > 0 && this._filterNameMappings.size() > 0) {
            FilterMapping mapping;
            int i;
            Object o = this._filterNameMappings.get(servletHolder.getName());
            for (i = 0; i < LazyList.size(o); ++i) {
                mapping = (FilterMapping)LazyList.get(o, i);
                if (!mapping.appliesTo(dispatch)) continue;
                filters = LazyList.add(filters, mapping.getFilterHolder());
            }
            o = this._filterNameMappings.get("*");
            for (i = 0; i < LazyList.size(o); ++i) {
                mapping = (FilterMapping)LazyList.get(o, i);
                if (!mapping.appliesTo(dispatch)) continue;
                filters = LazyList.add(filters, mapping.getFilterHolder());
            }
        }
        if (filters == null) {
            return null;
        }
        FilterChain chain2 = null;
        if (this._filterChainsCached) {
            if (LazyList.size(filters) > 0) {
                chain2 = new CachedChain(filters, servletHolder);
            }
            ConcurrentMap<String, FilterChain> cache = this._chainCache[dispatch];
            Queue<String> lru = this._chainLRU[dispatch];
            while (this._maxFilterChainsCacheSize > 0 && cache.size() >= this._maxFilterChainsCacheSize) {
                String k = lru.poll();
                if (k == null) {
                    cache.clear();
                    break;
                }
                cache.remove(k);
            }
            cache.put(key, chain2);
            lru.add(key);
        } else if (LazyList.size(filters) > 0) {
            chain2 = new Chain(baseRequest, filters, servletHolder);
        }
        return chain2;
    }

    private void invalidateChainsCache() {
        if (this._chainLRU[1] != null) {
            this._chainLRU[1].clear();
            this._chainLRU[2].clear();
            this._chainLRU[4].clear();
            this._chainLRU[8].clear();
            this._chainLRU[16].clear();
            this._chainCache[1].clear();
            this._chainCache[2].clear();
            this._chainCache[4].clear();
            this._chainCache[8].clear();
            this._chainCache[16].clear();
        }
    }

    public boolean isAvailable() {
        if (!this.isStarted()) {
            return false;
        }
        ServletHolder[] holders = this.getServlets();
        for (int i = 0; i < holders.length; ++i) {
            ServletHolder holder = holders[i];
            if (holder == null || holder.isAvailable()) continue;
            return false;
        }
        return true;
    }

    public void setStartWithUnavailable(boolean start) {
        this._startWithUnavailable = start;
    }

    public boolean isStartWithUnavailable() {
        return this._startWithUnavailable;
    }

    public void initialize() throws Exception {
        MultiException mx = new MultiException();
        if (this._filters != null) {
            for (int i = 0; i < this._filters.length; ++i) {
                this._filters[i].start();
            }
        }
        if (this._servlets != null) {
            Object[] servlets = (ServletHolder[])this._servlets.clone();
            Arrays.sort(servlets);
            for (int i = 0; i < servlets.length; ++i) {
                try {
                    if (((Holder)servlets[i]).getClassName() == null && ((ServletHolder)servlets[i]).getForcedPath() != null) {
                        ServletHolder forced_holder = (ServletHolder)this._servletPathMap.match(((ServletHolder)servlets[i]).getForcedPath());
                        if (forced_holder == null || forced_holder.getClassName() == null) {
                            mx.add(new IllegalStateException("No forced path servlet for " + ((ServletHolder)servlets[i]).getForcedPath()));
                            continue;
                        }
                        ((Holder)servlets[i]).setClassName(forced_holder.getClassName());
                    }
                    ((AbstractLifeCycle)servlets[i]).start();
                    continue;
                }
                catch (Throwable e) {
                    LOG.debug("EXCEPTION ", e);
                    mx.add(e);
                }
            }
            mx.ifExceptionThrow();
        }
    }

    public boolean isFilterChainsCached() {
        return this._filterChainsCached;
    }

    public ServletHolder newServletHolder(Holder.Source source) {
        return new ServletHolder(source);
    }

    public ServletHolder addServletWithMapping(String className, String pathSpec) {
        ServletHolder holder = this.newServletHolder(Holder.Source.EMBEDDED);
        holder.setClassName(className);
        this.addServletWithMapping(holder, pathSpec);
        return holder;
    }

    public ServletHolder addServletWithMapping(Class<? extends Servlet> servlet, String pathSpec) {
        ServletHolder holder = this.newServletHolder(Holder.Source.EMBEDDED);
        holder.setHeldClass(servlet);
        this.addServletWithMapping(holder, pathSpec);
        return holder;
    }

    public void addServletWithMapping(ServletHolder servlet, String pathSpec) {
        ServletHolder[] holders = this.getServlets();
        if (holders != null) {
            holders = (ServletHolder[])holders.clone();
        }
        try {
            this.setServlets(LazyList.addToArray(holders, servlet, ServletHolder.class));
            ServletMapping mapping = new ServletMapping();
            mapping.setServletName(servlet.getName());
            mapping.setPathSpec(pathSpec);
            this.setServletMappings(LazyList.addToArray(this.getServletMappings(), mapping, ServletMapping.class));
        }
        catch (Exception e) {
            this.setServlets(holders);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public void addServlet(ServletHolder holder) {
        this.setServlets(LazyList.addToArray(this.getServlets(), holder, ServletHolder.class));
    }

    public void addServletMapping(ServletMapping mapping) {
        this.setServletMappings(LazyList.addToArray(this.getServletMappings(), mapping, ServletMapping.class));
    }

    public Set<String> setServletSecurity(ServletRegistration.Dynamic registration, ServletSecurityElement servletSecurityElement) {
        if (this._contextHandler != null) {
            return this._contextHandler.setServletSecurity(registration, servletSecurityElement);
        }
        return Collections.emptySet();
    }

    public FilterHolder newFilterHolder(Holder.Source source) {
        return new FilterHolder(source);
    }

    public FilterHolder getFilter(String name) {
        return this._filterNameMap.get(name);
    }

    public FilterHolder addFilterWithMapping(Class<? extends Filter> filter, String pathSpec, EnumSet<DispatcherType> dispatches) {
        FilterHolder holder = this.newFilterHolder(Holder.Source.EMBEDDED);
        holder.setHeldClass(filter);
        this.addFilterWithMapping(holder, pathSpec, dispatches);
        return holder;
    }

    public FilterHolder addFilterWithMapping(String className, String pathSpec, EnumSet<DispatcherType> dispatches) {
        FilterHolder holder = this.newFilterHolder(Holder.Source.EMBEDDED);
        holder.setClassName(className);
        this.addFilterWithMapping(holder, pathSpec, dispatches);
        return holder;
    }

    public void addFilterWithMapping(FilterHolder holder, String pathSpec, EnumSet<DispatcherType> dispatches) {
        FilterHolder[] holders = this.getFilters();
        if (holders != null) {
            holders = (FilterHolder[])holders.clone();
        }
        try {
            this.setFilters(LazyList.addToArray(holders, holder, FilterHolder.class));
            FilterMapping mapping = new FilterMapping();
            mapping.setFilterName(holder.getName());
            mapping.setPathSpec(pathSpec);
            mapping.setDispatcherTypes(dispatches);
            this.addFilterMapping(mapping);
        }
        catch (RuntimeException e) {
            this.setFilters(holders);
            throw e;
        }
        catch (Error e) {
            this.setFilters(holders);
            throw e;
        }
    }

    public FilterHolder addFilterWithMapping(Class<? extends Filter> filter, String pathSpec, int dispatches) {
        FilterHolder holder = this.newFilterHolder(Holder.Source.EMBEDDED);
        holder.setHeldClass(filter);
        this.addFilterWithMapping(holder, pathSpec, dispatches);
        return holder;
    }

    public FilterHolder addFilterWithMapping(String className, String pathSpec, int dispatches) {
        FilterHolder holder = this.newFilterHolder(Holder.Source.EMBEDDED);
        holder.setClassName(className);
        this.addFilterWithMapping(holder, pathSpec, dispatches);
        return holder;
    }

    public void addFilterWithMapping(FilterHolder holder, String pathSpec, int dispatches) {
        FilterHolder[] holders = this.getFilters();
        if (holders != null) {
            holders = (FilterHolder[])holders.clone();
        }
        try {
            this.setFilters(LazyList.addToArray(holders, holder, FilterHolder.class));
            FilterMapping mapping = new FilterMapping();
            mapping.setFilterName(holder.getName());
            mapping.setPathSpec(pathSpec);
            mapping.setDispatches(dispatches);
            this.addFilterMapping(mapping);
        }
        catch (RuntimeException e) {
            this.setFilters(holders);
            throw e;
        }
        catch (Error e) {
            this.setFilters(holders);
            throw e;
        }
    }

    public FilterHolder addFilter(String className, String pathSpec, EnumSet<DispatcherType> dispatches) {
        return this.addFilterWithMapping(className, pathSpec, dispatches);
    }

    public void addFilter(FilterHolder filter, FilterMapping filterMapping) {
        if (filter != null) {
            this.setFilters(LazyList.addToArray(this.getFilters(), filter, FilterHolder.class));
        }
        if (filterMapping != null) {
            this.addFilterMapping(filterMapping);
        }
    }

    public void addFilter(FilterHolder filter) {
        if (filter != null) {
            this.setFilters(LazyList.addToArray(this.getFilters(), filter, FilterHolder.class));
        }
    }

    public void addFilterMapping(FilterMapping mapping) {
        if (mapping != null) {
            Holder.Source source = mapping.getFilterHolder() == null ? null : mapping.getFilterHolder().getSource();
            FilterMapping[] mappings = this.getFilterMappings();
            if (mappings == null || mappings.length == 0) {
                this.setFilterMappings(this.insertFilterMapping(mapping, 0, false));
                if (source != null && source == Holder.Source.JAVAX_API) {
                    this._matchAfterIndex = 0;
                }
            } else if (source != null && Holder.Source.JAVAX_API == source) {
                this.setFilterMappings(this.insertFilterMapping(mapping, mappings.length - 1, false));
                if (this._matchAfterIndex < 0) {
                    this._matchAfterIndex = this.getFilterMappings().length - 1;
                }
            } else if (this._matchAfterIndex < 0) {
                this.setFilterMappings(this.insertFilterMapping(mapping, mappings.length - 1, false));
            } else {
                FilterMapping[] new_mappings = this.insertFilterMapping(mapping, this._matchAfterIndex, true);
                ++this._matchAfterIndex;
                this.setFilterMappings(new_mappings);
            }
        }
    }

    public void prependFilterMapping(FilterMapping mapping) {
        if (mapping != null) {
            Holder.Source source = mapping.getFilterHolder().getSource();
            FilterMapping[] mappings = this.getFilterMappings();
            if (mappings == null || mappings.length == 0) {
                this.setFilterMappings(this.insertFilterMapping(mapping, 0, false));
                if (source != null && Holder.Source.JAVAX_API == source) {
                    this._matchBeforeIndex = 0;
                }
            } else {
                if (source != null && Holder.Source.JAVAX_API == source) {
                    if (this._matchBeforeIndex < 0) {
                        this._matchBeforeIndex = 0;
                        FilterMapping[] new_mappings = this.insertFilterMapping(mapping, 0, true);
                        this.setFilterMappings(new_mappings);
                    } else {
                        FilterMapping[] new_mappings = this.insertFilterMapping(mapping, this._matchBeforeIndex, false);
                        ++this._matchBeforeIndex;
                        this.setFilterMappings(new_mappings);
                    }
                } else {
                    FilterMapping[] new_mappings = this.insertFilterMapping(mapping, 0, true);
                    this.setFilterMappings(new_mappings);
                }
                if (this._matchAfterIndex >= 0) {
                    ++this._matchAfterIndex;
                }
            }
        }
    }

    protected FilterMapping[] insertFilterMapping(FilterMapping mapping, int pos, boolean before) {
        if (pos < 0) {
            throw new IllegalArgumentException("FilterMapping insertion pos < 0");
        }
        FilterMapping[] mappings = this.getFilterMappings();
        if (mappings == null || mappings.length == 0) {
            return new FilterMapping[]{mapping};
        }
        FilterMapping[] new_mappings = new FilterMapping[mappings.length + 1];
        if (before) {
            System.arraycopy(mappings, 0, new_mappings, 0, pos);
            new_mappings[pos] = mapping;
            System.arraycopy(mappings, pos, new_mappings, pos + 1, mappings.length - pos);
        } else {
            System.arraycopy(mappings, 0, new_mappings, 0, pos + 1);
            new_mappings[pos + 1] = mapping;
            if (mappings.length > pos + 1) {
                System.arraycopy(mappings, pos + 1, new_mappings, pos + 2, mappings.length - (pos + 1));
            }
        }
        return new_mappings;
    }

    protected synchronized void updateNameMappings() {
        int i;
        this._filterNameMap.clear();
        if (this._filters != null) {
            for (i = 0; i < this._filters.length; ++i) {
                this._filterNameMap.put(this._filters[i].getName(), this._filters[i]);
                this._filters[i].setServletHandler(this);
            }
        }
        this._servletNameMap.clear();
        if (this._servlets != null) {
            for (i = 0; i < this._servlets.length; ++i) {
                this._servletNameMap.put(this._servlets[i].getName(), this._servlets[i]);
                this._servlets[i].setServletHandler(this);
            }
        }
    }

    protected synchronized void updateMappings() {
        int i;
        if (this._filterMappings == null) {
            this._filterPathMappings = null;
            this._filterNameMappings = null;
        } else {
            this._filterPathMappings = new ArrayList<FilterMapping>();
            this._filterNameMappings = new MultiMap();
            for (i = 0; i < this._filterMappings.length; ++i) {
                FilterHolder filter_holder = this._filterNameMap.get(this._filterMappings[i].getFilterName());
                if (filter_holder == null) {
                    throw new IllegalStateException("No filter named " + this._filterMappings[i].getFilterName());
                }
                this._filterMappings[i].setFilterHolder(filter_holder);
                if (this._filterMappings[i].getPathSpecs() != null) {
                    this._filterPathMappings.add(this._filterMappings[i]);
                }
                if (this._filterMappings[i].getServletNames() == null) continue;
                String[] names = this._filterMappings[i].getServletNames();
                for (int j = 0; j < names.length; ++j) {
                    if (names[j] == null) continue;
                    this._filterNameMappings.add(names[j], this._filterMappings[i]);
                }
            }
        }
        if (this._servletMappings == null || this._servletNameMap == null) {
            this._servletPathMap = null;
        } else {
            PathMap pm = new PathMap();
            for (int i2 = 0; i2 < this._servletMappings.length; ++i2) {
                ServletHolder servlet_holder = this._servletNameMap.get(this._servletMappings[i2].getServletName());
                if (servlet_holder == null) {
                    throw new IllegalStateException("No such servlet: " + this._servletMappings[i2].getServletName());
                }
                if (!servlet_holder.isEnabled() || this._servletMappings[i2].getPathSpecs() == null) continue;
                String[] pathSpecs = this._servletMappings[i2].getPathSpecs();
                for (int j = 0; j < pathSpecs.length; ++j) {
                    if (pathSpecs[j] == null) continue;
                    pm.put(pathSpecs[j], servlet_holder);
                }
            }
            this._servletPathMap = pm;
        }
        if (this._chainCache != null) {
            i = this._chainCache.length;
            while (i-- > 0) {
                if (this._chainCache[i] == null) continue;
                this._chainCache[i].clear();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("filterNameMap=" + this._filterNameMap, new Object[0]);
            LOG.debug("pathFilters=" + this._filterPathMappings, new Object[0]);
            LOG.debug("servletFilterMap=" + this._filterNameMappings, new Object[0]);
            LOG.debug("servletPathMap=" + this._servletPathMap, new Object[0]);
            LOG.debug("servletNameMap=" + this._servletNameMap, new Object[0]);
        }
        try {
            if (this._contextHandler != null && this._contextHandler.isStarted() || this._contextHandler == null && this.isStarted()) {
                this.initialize();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void notFound(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Not Found " + request.getRequestURI(), new Object[0]);
        }
    }

    public void setFilterChainsCached(boolean filterChainsCached) {
        this._filterChainsCached = filterChainsCached;
    }

    public void setFilterMappings(FilterMapping[] filterMappings) {
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, this._filterMappings, filterMappings, "filterMapping", true);
        }
        this._filterMappings = filterMappings;
        this.updateMappings();
        this.invalidateChainsCache();
    }

    public synchronized void setFilters(FilterHolder[] holders) {
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, this._filters, holders, "filter", true);
        }
        this._filters = holders;
        this.updateNameMappings();
        this.invalidateChainsCache();
    }

    public void setServletMappings(ServletMapping[] servletMappings) {
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, this._servletMappings, servletMappings, "servletMapping", true);
        }
        this._servletMappings = servletMappings;
        this.updateMappings();
        this.invalidateChainsCache();
    }

    public synchronized void setServlets(ServletHolder[] holders) {
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, this._servlets, holders, "servlet", true);
        }
        this._servlets = holders;
        this.updateNameMappings();
        this.invalidateChainsCache();
    }

    public int getMaxFilterChainsCacheSize() {
        return this._maxFilterChainsCacheSize;
    }

    public void setMaxFilterChainsCacheSize(int maxFilterChainsCacheSize) {
        this._maxFilterChainsCacheSize = maxFilterChainsCacheSize;
    }

    void destroyServlet(Servlet servlet) {
        if (this._contextHandler != null) {
            this._contextHandler.destroyServlet(servlet);
        }
    }

    void destroyFilter(Filter filter) {
        if (this._contextHandler != null) {
            this._contextHandler.destroyFilter(filter);
        }
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        super.dumpThis(out);
        ServletHandler.dump(out, indent, TypeUtil.asList(this.getHandlers()), this.getBeans(), TypeUtil.asList(this.getFilterMappings()), TypeUtil.asList(this.getFilters()), TypeUtil.asList(this.getServletMappings()), TypeUtil.asList(this.getServlets()));
    }

    private class Chain
    implements FilterChain {
        final Request _baseRequest;
        final Object _chain;
        final ServletHolder _servletHolder;
        int _filter = 0;

        Chain(Request baseRequest, Object filters, ServletHolder servletHolder) {
            this._baseRequest = baseRequest;
            this._chain = filters;
            this._servletHolder = servletHolder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("doFilter " + this._filter, new Object[0]);
            }
            if (this._filter < LazyList.size(this._chain)) {
                FilterHolder holder = (FilterHolder)LazyList.get(this._chain, this._filter++);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("call filter " + holder, new Object[0]);
                }
                Filter filter = holder.getFilter();
                if (holder.isAsyncSupported() || !this._baseRequest.isAsyncSupported()) {
                    filter.doFilter(request, response, this);
                } else {
                    try {
                        this._baseRequest.setAsyncSupported(false);
                        filter.doFilter(request, response, this);
                    }
                    finally {
                        this._baseRequest.setAsyncSupported(true);
                    }
                }
                return;
            }
            HttpServletRequest srequest = (HttpServletRequest)request;
            if (this._servletHolder != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("call servlet " + this._servletHolder, new Object[0]);
                }
                this._servletHolder.handle(this._baseRequest, request, response);
            } else if (ServletHandler.this.getHandler() == null) {
                ServletHandler.this.notFound(srequest, (HttpServletResponse)response);
            } else {
                Request baseRequest = request instanceof Request ? (Request)request : AbstractHttpConnection.getCurrentConnection().getRequest();
                ServletHandler.this.nextHandle(URIUtil.addPaths(srequest.getServletPath(), srequest.getPathInfo()), baseRequest, srequest, (HttpServletResponse)response);
            }
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < LazyList.size(this._chain); ++i) {
                Object o = LazyList.get(this._chain, i);
                b.append(o.toString());
                b.append("->");
            }
            b.append(this._servletHolder);
            return b.toString();
        }
    }

    private class CachedChain
    implements FilterChain {
        FilterHolder _filterHolder;
        CachedChain _next;
        ServletHolder _servletHolder;

        CachedChain(Object filters, ServletHolder servletHolder) {
            if (LazyList.size(filters) > 0) {
                this._filterHolder = (FilterHolder)LazyList.get(filters, 0);
                filters = LazyList.remove(filters, 0);
                this._next = new CachedChain(filters, servletHolder);
            } else {
                this._servletHolder = servletHolder;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            Request baseRequest;
            Request request2 = baseRequest = request instanceof Request ? (Request)request : AbstractHttpConnection.getCurrentConnection().getRequest();
            if (this._filterHolder != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("call filter " + this._filterHolder, new Object[0]);
                }
                Filter filter = this._filterHolder.getFilter();
                if (this._filterHolder.isAsyncSupported()) {
                    filter.doFilter(request, response, this._next);
                } else {
                    boolean suspendable = baseRequest.isAsyncSupported();
                    if (suspendable) {
                        try {
                            baseRequest.setAsyncSupported(false);
                            filter.doFilter(request, response, this._next);
                        }
                        finally {
                            baseRequest.setAsyncSupported(true);
                        }
                    } else {
                        filter.doFilter(request, response, this._next);
                    }
                }
                return;
            }
            HttpServletRequest srequest = (HttpServletRequest)request;
            if (this._servletHolder != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("call servlet " + this._servletHolder, new Object[0]);
                }
                this._servletHolder.handle(baseRequest, request, response);
            } else if (ServletHandler.this.getHandler() == null) {
                ServletHandler.this.notFound(srequest, (HttpServletResponse)response);
            } else {
                ServletHandler.this.nextHandle(URIUtil.addPaths(srequest.getServletPath(), srequest.getPathInfo()), baseRequest, srequest, (HttpServletResponse)response);
            }
        }

        public String toString() {
            if (this._filterHolder != null) {
                return this._filterHolder + "->" + this._next.toString();
            }
            if (this._servletHolder != null) {
                return this._servletHolder.toString();
            }
            return "null";
        }
    }
}

