/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.jetty.server.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.ByteChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Set;
import org.dynmap.jetty.http.HttpException;
import org.dynmap.jetty.io.Buffer;
import org.dynmap.jetty.io.ConnectedEndPoint;
import org.dynmap.jetty.io.Connection;
import org.dynmap.jetty.io.EndPoint;
import org.dynmap.jetty.io.EofException;
import org.dynmap.jetty.io.nio.ChannelEndPoint;
import org.dynmap.jetty.server.BlockingHttpConnection;
import org.dynmap.jetty.server.Request;
import org.dynmap.jetty.server.nio.AbstractNIOConnector;
import org.dynmap.jetty.util.ConcurrentHashSet;
import org.dynmap.jetty.util.log.Log;
import org.dynmap.jetty.util.log.Logger;

public class BlockingChannelConnector
extends AbstractNIOConnector {
    private static final Logger LOG = Log.getLogger(BlockingChannelConnector.class);
    private transient ServerSocketChannel _acceptChannel;
    private final Set<BlockingChannelEndPoint> _endpoints = new ConcurrentHashSet<BlockingChannelEndPoint>();

    @Override
    public Object getConnection() {
        return this._acceptChannel;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.getThreadPool().dispatch(new Runnable(){

            @Override
            public void run() {
                while (BlockingChannelConnector.this.isRunning()) {
                    try {
                        Thread.sleep(400L);
                        long now = System.currentTimeMillis();
                        for (BlockingChannelEndPoint endp : BlockingChannelConnector.this._endpoints) {
                            endp.checkIdleTimestamp(now);
                        }
                    }
                    catch (InterruptedException e) {
                        LOG.ignore(e);
                    }
                    catch (Exception e) {
                        LOG.warn(e);
                    }
                }
            }
        });
    }

    @Override
    public void open() throws IOException {
        this._acceptChannel = ServerSocketChannel.open();
        this._acceptChannel.configureBlocking(true);
        InetSocketAddress addr = this.getHost() == null ? new InetSocketAddress(this.getPort()) : new InetSocketAddress(this.getHost(), this.getPort());
        this._acceptChannel.socket().bind(addr, this.getAcceptQueueSize());
    }

    @Override
    public void close() throws IOException {
        if (this._acceptChannel != null) {
            this._acceptChannel.close();
        }
        this._acceptChannel = null;
    }

    @Override
    public void accept(int acceptorID) throws IOException, InterruptedException {
        SocketChannel channel = this._acceptChannel.accept();
        channel.configureBlocking(true);
        Socket socket = channel.socket();
        this.configure(socket);
        BlockingChannelEndPoint connection = new BlockingChannelEndPoint(channel);
        connection.dispatch();
    }

    @Override
    public void customize(EndPoint endpoint, Request request) throws IOException {
        super.customize(endpoint, request);
        endpoint.setMaxIdleTime(this._maxIdleTime);
        this.configure(((SocketChannel)endpoint.getTransport()).socket());
    }

    @Override
    public int getLocalPort() {
        if (this._acceptChannel == null || !this._acceptChannel.isOpen()) {
            return -1;
        }
        return this._acceptChannel.socket().getLocalPort();
    }

    private class BlockingChannelEndPoint
    extends ChannelEndPoint
    implements Runnable,
    ConnectedEndPoint {
        private Connection _connection;
        private int _timeout;
        private volatile long _idleTimestamp;

        BlockingChannelEndPoint(ByteChannel channel) throws IOException {
            super(channel, BlockingChannelConnector.this._maxIdleTime);
            this._connection = new BlockingHttpConnection(BlockingChannelConnector.this, this, BlockingChannelConnector.this.getServer());
        }

        @Override
        public Connection getConnection() {
            return this._connection;
        }

        @Override
        public void setConnection(Connection connection) {
            this._connection = connection;
        }

        public void checkIdleTimestamp(long now) {
            if (this._idleTimestamp != 0L && this._timeout > 0 && now > this._idleTimestamp + (long)this._timeout) {
                this.idleExpired();
            }
        }

        protected void idleExpired() {
            try {
                super.close();
            }
            catch (IOException e) {
                LOG.ignore(e);
            }
        }

        void dispatch() throws IOException {
            if (!BlockingChannelConnector.this.getThreadPool().dispatch(this)) {
                LOG.warn("dispatch failed for  {}", this._connection);
                super.close();
            }
        }

        @Override
        public int fill(Buffer buffer) throws IOException {
            this._idleTimestamp = System.currentTimeMillis();
            return super.fill(buffer);
        }

        @Override
        public int flush(Buffer buffer) throws IOException {
            this._idleTimestamp = System.currentTimeMillis();
            return super.flush(buffer);
        }

        @Override
        public int flush(Buffer header, Buffer buffer, Buffer trailer) throws IOException {
            this._idleTimestamp = System.currentTimeMillis();
            return super.flush(header, buffer, trailer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this._timeout = this.getMaxIdleTime();
                BlockingChannelConnector.this.connectionOpened(this._connection);
                BlockingChannelConnector.this._endpoints.add(this);
                while (this.isOpen()) {
                    this._idleTimestamp = System.currentTimeMillis();
                    if (this._connection.isIdle()) {
                        int lrmit;
                        if (BlockingChannelConnector.this.getServer().getThreadPool().isLowOnThreads() && (lrmit = BlockingChannelConnector.this.getLowResourcesMaxIdleTime()) >= 0 && this._timeout != lrmit) {
                            this._timeout = lrmit;
                        }
                    } else if (this._timeout != this.getMaxIdleTime()) {
                        this._timeout = this.getMaxIdleTime();
                    }
                    this._connection = this._connection.handle();
                }
            }
            catch (EofException e) {
                LOG.debug("EOF", e);
                try {
                    this.close();
                }
                catch (IOException e2) {
                    LOG.ignore(e2);
                }
            }
            catch (HttpException e) {
                LOG.debug("BAD", e);
                try {
                    super.close();
                }
                catch (IOException e2) {
                    LOG.ignore(e2);
                }
            }
            catch (Throwable e) {
                LOG.warn("handle failed", e);
                try {
                    super.close();
                }
                catch (IOException e2) {
                    LOG.ignore(e2);
                }
            }
            finally {
                BlockingChannelConnector.this.connectionClosed(this._connection);
                BlockingChannelConnector.this._endpoints.remove(this);
                try {
                    if (!this._socket.isClosed()) {
                        long timestamp = System.currentTimeMillis();
                        int max_idle = this.getMaxIdleTime();
                        this._socket.setSoTimeout(this.getMaxIdleTime());
                        int c = 0;
                        while ((c = this._socket.getInputStream().read()) >= 0 && System.currentTimeMillis() - timestamp < (long)max_idle) {
                        }
                        if (!this._socket.isClosed()) {
                            this._socket.close();
                        }
                    }
                }
                catch (IOException e) {
                    LOG.ignore(e);
                }
            }
        }

        public String toString() {
            return String.format("BCEP@%x{l(%s)<->r(%s),open=%b,ishut=%b,oshut=%b}-{%s}", this.hashCode(), this._socket.getRemoteSocketAddress(), this._socket.getLocalSocketAddress(), this.isOpen(), this.isInputShutdown(), this.isOutputShutdown(), this._connection);
        }
    }
}

