/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.dynmap.Client;
import org.dynmap.Color;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapChunk;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapWorld;
import org.dynmap.JSONUtils;
import org.dynmap.Log;
import org.dynmap.MapManager;
import org.dynmap.MapTile;
import org.dynmap.MapType;
import org.dynmap.MapTypeState;
import org.dynmap.TileHashManager;
import org.dynmap.debug.Debug;
import org.dynmap.hdmap.HDBlockModels;
import org.dynmap.hdmap.HDLighting;
import org.dynmap.hdmap.HDMapTile;
import org.dynmap.hdmap.HDPerspective;
import org.dynmap.hdmap.HDPerspectiveState;
import org.dynmap.hdmap.HDShaderState;
import org.dynmap.hdmap.TexturePack;
import org.dynmap.json.simple.JSONObject;
import org.dynmap.markers.impl.MarkerAPIImpl;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;
import org.dynmap.utils.BlockStep;
import org.dynmap.utils.DynLongHashMap;
import org.dynmap.utils.DynmapBufferedImage;
import org.dynmap.utils.FileLockManager;
import org.dynmap.utils.LightLevels;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.MapIterator;
import org.dynmap.utils.Matrix3D;
import org.dynmap.utils.PatchDefinition;
import org.dynmap.utils.Polygon;
import org.dynmap.utils.TileFlags;
import org.dynmap.utils.Vector3D;

public class IsoHDPerspective
implements HDPerspective {
    private final String name;
    private final int hashcode;
    public final double azimuth;
    public final double inclination;
    public final double maxheight;
    public final double minheight;
    private final Matrix3D world_to_map;
    private final Matrix3D map_to_world;
    private final int basemodscale;
    public static final int tileWidth = 128;
    public static final int tileHeight = 128;
    public static final double MAX_INCLINATION = 90.0;
    public static final double MIN_INCLINATION = 20.0;
    public static final int MAX_SCALE = 64;
    public static final int MIN_SCALE = 1;
    private boolean need_biomedata = false;
    private boolean need_rawbiomedata = false;
    private static final int REDSTONE_BLKTYPEID = 55;
    private static final int FENCEGATE_BLKTYPEID = 107;
    private static final BlockStep[] semi_steps = new BlockStep[]{BlockStep.Y_PLUS, BlockStep.X_MINUS, BlockStep.X_PLUS, BlockStep.Z_MINUS, BlockStep.Z_PLUS};
    private static final int[][] corners_by_side = new int[][]{{1, 3, 7, 5}, {0, 2, 6, 4}, {0, 1, 3, 2}, {4, 5, 7, 6}, {2, 3, 7, 6}, {0, 1, 5, 4}};
    private static String[] directions = new String[]{"N", "NE", "E", "SE", "S", "SW", "W", "NW"};

    public IsoHDPerspective(DynmapCore core, ConfigurationNode configuration) {
        this.name = configuration.getString("name", null);
        if (this.name == null) {
            Log.severe("Perspective definition missing name - must be defined and unique");
            this.hashcode = 0;
        } else {
            this.hashcode = this.name.hashCode();
        }
        double az = configuration.getDouble("azimuth", 135.0);
        if (MapManager.mapman.getCompassMode() == DynmapCore.CompassMode.NEWNORTH && (az += 90.0) >= 360.0) {
            az -= 360.0;
        }
        this.azimuth = az;
        double inc = configuration.getDouble("inclination", 60.0);
        if (inc > 90.0) {
            inc = 90.0;
        }
        if (inc < 20.0) {
            inc = 20.0;
        }
        this.inclination = inc;
        int mscale = (int)Math.ceil(configuration.getDouble("scale", 1.0));
        if (mscale < 1) {
            mscale = 1;
        }
        if (mscale > 64) {
            mscale = 64;
        }
        this.basemodscale = mscale;
        this.maxheight = configuration.getInteger("maximumheight", -1);
        int minh = configuration.getInteger("minimumheight", 0);
        if (minh < 0) {
            minh = 0;
        }
        this.minheight = minh;
        Matrix3D transform = new Matrix3D(0.0, 0.0, -1.0, -1.0, 0.0, 0.0, 0.0, 1.0, 0.0);
        transform.rotateXY(180.0 - this.azimuth);
        transform.rotateYZ(90.0 - this.inclination);
        transform.shearZ(0.0, Math.tan(Math.toRadians(90.0 - this.inclination)));
        transform.scale(this.basemodscale, this.basemodscale, Math.sin(Math.toRadians(this.inclination)));
        this.world_to_map = transform;
        transform = new Matrix3D();
        transform.scale(1.0 / (double)this.basemodscale, 1.0 / (double)this.basemodscale, 1.0 / Math.sin(Math.toRadians(this.inclination)));
        transform.shearZ(0.0, -Math.tan(Math.toRadians(90.0 - this.inclination)));
        transform.rotateYZ(-(90.0 - this.inclination));
        transform.rotateXY(-180.0 + this.azimuth);
        Matrix3D coordswap = new Matrix3D(0.0, -1.0, 0.0, 0.0, 0.0, 1.0, -1.0, 0.0, 0.0);
        transform.multiply(coordswap);
        this.map_to_world = transform;
    }

    @Override
    public List<TileFlags.TileCoord> getTileCoords(DynmapWorld world, int x, int y, int z) {
        HashSet<TileFlags.TileCoord> tiles = new HashSet<TileFlags.TileCoord>();
        Vector3D block = new Vector3D();
        block.x = x;
        block.y = y;
        block.z = z;
        Vector3D corner = new Vector3D();
        for (int i = 0; i < 2; ++i) {
            double inity = block.y;
            for (int j = 0; j < 2; ++j) {
                double initz = block.z;
                for (int k = 0; k < 2; ++k) {
                    this.world_to_map.transform(block, corner);
                    tiles.add(new TileFlags.TileCoord(IsoHDPerspective.fastFloor(corner.x / 128.0), IsoHDPerspective.fastFloor(corner.y / 128.0)));
                    block.z += 1.0;
                }
                block.z = initz;
                block.y += 1.0;
            }
            block.y = inity;
            block.x += 1.0;
        }
        return new ArrayList<TileFlags.TileCoord>(tiles);
    }

    @Override
    public List<TileFlags.TileCoord> getTileCoords(DynmapWorld world, int minx, int miny, int minz, int maxx, int maxy, int maxz) {
        int j;
        int i;
        ArrayList<TileFlags.TileCoord> tiles = new ArrayList<TileFlags.TileCoord>();
        Vector3D[] blocks = new Vector3D[]{new Vector3D(), new Vector3D()};
        blocks[0].x = minx - 1;
        blocks[0].y = miny - 1;
        blocks[0].z = minz - 1;
        blocks[1].x = maxx + 1;
        blocks[1].y = maxy + 1;
        blocks[1].z = maxz + 1;
        Vector3D corner = new Vector3D();
        Vector3D tcorner = new Vector3D();
        int mintilex = Integer.MAX_VALUE;
        int maxtilex = Integer.MIN_VALUE;
        int mintiley = Integer.MAX_VALUE;
        int maxtiley = Integer.MIN_VALUE;
        for (i = 0; i < 2; ++i) {
            corner.x = blocks[i].x;
            for (j = 0; j < 2; ++j) {
                corner.y = blocks[j].y;
                for (int k = 0; k < 2; ++k) {
                    corner.z = blocks[k].z;
                    this.world_to_map.transform(corner, tcorner);
                    int tx = IsoHDPerspective.fastFloor(tcorner.x / 128.0);
                    int ty = IsoHDPerspective.fastFloor(tcorner.y / 128.0);
                    if (mintilex > tx) {
                        mintilex = tx;
                    }
                    if (maxtilex < tx) {
                        maxtilex = tx;
                    }
                    if (mintiley > ty) {
                        mintiley = ty;
                    }
                    if (maxtiley >= ty) continue;
                    maxtiley = ty;
                }
            }
        }
        for (i = mintilex; i <= maxtilex; ++i) {
            for (j = mintiley - 1; j <= maxtiley; ++j) {
                tiles.add(new TileFlags.TileCoord(i, j));
            }
        }
        return tiles;
    }

    @Override
    public MapTile[] getAdjecentTiles(MapTile tile) {
        HDMapTile t = (HDMapTile)tile;
        DynmapWorld w = t.getDynmapWorld();
        int x = t.tx;
        int y = t.ty;
        return new MapTile[]{new HDMapTile(w, this, x - 1, y - 1, t.boostzoom), new HDMapTile(w, this, x + 1, y - 1, t.boostzoom), new HDMapTile(w, this, x - 1, y + 1, t.boostzoom), new HDMapTile(w, this, x + 1, y + 1, t.boostzoom), new HDMapTile(w, this, x, y - 1, t.boostzoom), new HDMapTile(w, this, x + 1, y, t.boostzoom), new HDMapTile(w, this, x, y + 1, t.boostzoom), new HDMapTile(w, this, x - 1, y, t.boostzoom)};
    }

    @Override
    public List<DynmapChunk> getRequiredChunks(MapTile tile) {
        if (!(tile instanceof HDMapTile)) {
            return Collections.emptyList();
        }
        HDMapTile t = (HDMapTile)tile;
        int min_chunk_x = Integer.MAX_VALUE;
        int max_chunk_x = Integer.MIN_VALUE;
        int min_chunk_z = Integer.MAX_VALUE;
        int max_chunk_z = Integer.MIN_VALUE;
        Vector3D[] corners = new Vector3D[8];
        double dx = -this.basemodscale;
        double dy = -this.basemodscale;
        int idx = 0;
        for (int x = t.tx; x <= t.tx + 1; ++x) {
            dy = -this.basemodscale;
            for (int y = t.ty; y <= t.ty + 1; ++y) {
                for (int z = 0; z <= 1; ++z) {
                    corners[idx] = new Vector3D();
                    corners[idx].x = (double)(x * 128) + dx;
                    corners[idx].y = (double)(y * 128) + dy;
                    corners[idx].z = z * t.getDynmapWorld().worldheight;
                    this.map_to_world.transform(corners[idx]);
                    int cx = IsoHDPerspective.fastFloor(corners[idx].x / 16.0);
                    int cz = IsoHDPerspective.fastFloor(corners[idx].z / 16.0);
                    if (min_chunk_x > cx) {
                        min_chunk_x = cx;
                    }
                    if (max_chunk_x < cx) {
                        max_chunk_x = cx;
                    }
                    if (min_chunk_z > cz) {
                        min_chunk_z = cz;
                    }
                    if (max_chunk_z < cz) {
                        max_chunk_z = cz;
                    }
                    ++idx;
                }
                dy = this.basemodscale;
            }
            dx = this.basemodscale;
        }
        Polygon[] side = new Polygon[6];
        for (int sidenum = 0; sidenum < side.length; ++sidenum) {
            side[sidenum] = new Polygon();
            for (int corner = 0; corner < corners_by_side[sidenum].length; ++corner) {
                int cid = corners_by_side[sidenum][corner];
                side[sidenum].addVertex(corners[cid].x, corners[cid].z);
            }
        }
        ArrayList<DynmapChunk> chunks = new ArrayList<DynmapChunk>();
        int cnt1 = 0;
        int cnt2 = 0;
        for (int x = min_chunk_x; x <= max_chunk_x; ++x) {
            for (int z = min_chunk_z; z <= max_chunk_z; ++z) {
                boolean hit = false;
                for (int sidenum = 0; !hit && sidenum < side.length; ++sidenum) {
                    if (side[sidenum].clip(16.0 * (double)x, 16.0 * (double)z, 16.0 * (double)(x + 1), 16.0 * (double)(z + 1)) == null) continue;
                    hit = true;
                    ++cnt1;
                }
                if (hit) {
                    DynmapChunk chunk = new DynmapChunk(x, z);
                    chunks.add(chunk);
                }
                ++cnt2;
            }
        }
        return chunks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean render(MapChunkCache cache, HDMapTile tile, String mapname) {
        int i;
        int i2;
        int sizescale;
        HDShaderState[] shaderstate;
        int numshaders;
        Color rslt = new Color();
        MapIterator mapiter = cache.getIterator(0, 0, 0);
        DynmapWorld world = tile.getDynmapWorld();
        int scaled = 0;
        if (tile.boostzoom > 0 && MarkerAPIImpl.testTileForBoostMarkers(cache.getWorld(), this, tile.tx * 128, tile.ty * 128, 128.0)) {
            scaled = tile.boostzoom;
        }
        if ((numshaders = (shaderstate = MapManager.mapman.hdmapman.getShaderStateForTile(tile, cache, mapiter, mapname, (sizescale = 1 << scaled) * this.basemodscale)).length) == 0) {
            return false;
        }
        boolean isnether = world.isNether();
        DynmapBufferedImage[] im = new DynmapBufferedImage[numshaders];
        DynmapBufferedImage[] dayim = new DynmapBufferedImage[numshaders];
        int[][] argb_buf = new int[numshaders][];
        int[][] day_argb_buf = new int[numshaders][];
        boolean[] isjpg = new boolean[numshaders];
        int[] bgday = new int[numshaders];
        int[] bgnight = new int[numshaders];
        for (i2 = 0; i2 < numshaders; ++i2) {
            HDLighting lighting = shaderstate[i2].getLighting();
            im[i2] = DynmapBufferedImage.allocateBufferedImage(128 * sizescale, 128 * sizescale);
            argb_buf[i2] = im[i2].argb_buf;
            if (lighting.isNightAndDayEnabled()) {
                dayim[i2] = DynmapBufferedImage.allocateBufferedImage(128 * sizescale, 128 * sizescale);
                day_argb_buf[i2] = dayim[i2].argb_buf;
            }
            isjpg[i2] = shaderstate[i2].getMap().getImageFormat() != MapType.ImageFormat.FORMAT_PNG;
            bgday[i2] = shaderstate[i2].getMap().getBackgroundARGBDay();
            bgnight[i2] = shaderstate[i2].getMap().getBackgroundARGBNight();
        }
        for (i2 = 0; i2 < numshaders; ++i2) {
            MapTypeState mts = world.getMapState(shaderstate[i2].getMap());
            if (mts == null) continue;
            mts.validateTile(tile.tx, tile.ty);
        }
        OurPerspectiveState ps = new OurPerspectiveState(mapiter, isnether, scaled);
        ps.top = new Vector3D();
        ps.bottom = new Vector3D();
        ps.direction = new Vector3D();
        double xbase = tile.tx * 128;
        double ybase = tile.ty * 128;
        boolean[] shaderdone = new boolean[numshaders];
        boolean[] rendered = new boolean[numshaders];
        double height = this.maxheight;
        if (height < 0.0) {
            height = isnether ? 127.0 : (double)(tile.getDynmapWorld().worldheight - 1);
        }
        for (int x = 0; x < 128 * sizescale; ++x) {
            ps.px = x;
            for (int y = 0; y < 128 * sizescale; ++y) {
                ps.top.x = ps.bottom.x = xbase + (double)x / (double)sizescale + 0.5;
                ps.top.y = ps.bottom.y = ybase + (double)y / (double)sizescale + 0.5;
                ps.top.z = height + 0.5;
                ps.bottom.z = this.minheight - 0.5;
                this.map_to_world.transform(ps.top);
                this.map_to_world.transform(ps.bottom);
                ps.direction.set(ps.bottom);
                ps.direction.subtract(ps.top);
                ps.py = y / sizescale;
                for (i = 0; i < numshaders; ++i) {
                    shaderstate[i].reset(ps);
                }
                try {
                    ps.raytrace(cache, shaderstate, shaderdone);
                }
                catch (Exception ex) {
                    Log.severe("Error while raytracing tile: perspective=" + this.name + ", coord=" + mapiter.getX() + "," + mapiter.getY() + "," + mapiter.getZ() + ", blockid=" + mapiter.getBlockTypeID() + ":" + mapiter.getBlockData() + ", lighting=" + mapiter.getBlockSkyLight() + ":" + mapiter.getBlockEmittedLight() + ", biome=" + mapiter.getBiome().toString(), ex);
                }
                for (i = 0; i < numshaders; ++i) {
                    if (!shaderdone[i]) {
                        shaderstate[i].rayFinished(ps);
                    } else {
                        shaderdone[i] = false;
                        rendered[i] = true;
                    }
                    shaderstate[i].getRayColor(rslt, 0);
                    int c_argb = rslt.getARGB();
                    if (c_argb != 0) {
                        rendered[i] = true;
                    }
                    argb_buf[i][(128 * sizescale - y - 1) * 128 * sizescale + x] = isjpg[i] && c_argb == 0 ? bgnight[i] : c_argb;
                    if (day_argb_buf[i] == null) continue;
                    shaderstate[i].getRayColor(rslt, 1);
                    c_argb = rslt.getARGB();
                    day_argb_buf[i][(128 * sizescale - y - 1) * 128 * sizescale + x] = isjpg[i] && c_argb == 0 ? bgday[i] : c_argb;
                }
            }
        }
        boolean renderone = false;
        TileHashManager hashman = MapManager.mapman.hashman;
        for (i = 0; i < numshaders; ++i) {
            long crc = hashman.calculateTileHash(argb_buf[i]);
            boolean tile_update = false;
            String prefix = shaderstate[i].getMap().getPrefix();
            MapType.ImageFormat fmt = shaderstate[i].getMap().getImageFormat();
            String fname = tile.getFilename(prefix, fmt);
            File f = new File(tile.getDynmapWorld().worldtilepath, fname);
            FileLockManager.getWriteLock(f);
            try {
                if (!f.exists() || crc != hashman.getImageHashCode(tile.getKey(prefix), null, tile.tx, tile.ty)) {
                    if (rendered[i]) {
                        Debug.debug("saving image " + f.getPath());
                        if (!f.getParentFile().exists()) {
                            f.getParentFile().mkdirs();
                        }
                        try {
                            FileLockManager.imageIOWrite(im[i].buf_img, fmt, f);
                        }
                        catch (IOException e) {
                            Debug.error("Failed to save image: " + f.getPath(), e);
                        }
                        catch (NullPointerException e) {
                            Debug.error("Failed to save image (NullPointerException): " + f.getPath(), e);
                        }
                    } else {
                        f.delete();
                    }
                    MapManager.mapman.pushUpdate(tile.getDynmapWorld(), (Client.Update)new Client.Tile(fname));
                    hashman.updateHashCode(tile.getKey(prefix), null, tile.tx, tile.ty, crc);
                    tile.getDynmapWorld().enqueueZoomOutUpdate(f);
                    tile_update = true;
                    renderone = true;
                } else {
                    Debug.debug("skipping image " + f.getPath() + " - hash match");
                    if (!rendered[i]) {
                        f.delete();
                        hashman.updateHashCode(tile.getKey(prefix), null, tile.tx, tile.ty, -1L);
                        tile.getDynmapWorld().enqueueZoomOutUpdate(f);
                    }
                }
            }
            finally {
                FileLockManager.releaseWriteLock(f);
                DynmapBufferedImage.freeBufferedImage(im[i]);
            }
            MapManager.mapman.updateStatistics(tile, prefix, true, tile_update, !rendered[i]);
            if (dayim[i] == null) continue;
            fname = tile.getDayFilename(prefix, fmt);
            f = new File(tile.getDynmapWorld().worldtilepath, fname);
            FileLockManager.getWriteLock(f);
            tile_update = false;
            try {
                if (!f.exists() || crc != hashman.getImageHashCode(tile.getKey(prefix), "day", tile.tx, tile.ty)) {
                    if (rendered[i]) {
                        Debug.debug("saving image " + f.getPath());
                        if (!f.getParentFile().exists()) {
                            f.getParentFile().mkdirs();
                        }
                        try {
                            FileLockManager.imageIOWrite(dayim[i].buf_img, fmt, f);
                        }
                        catch (IOException e) {
                            Debug.error("Failed to save image: " + f.getPath(), e);
                        }
                        catch (NullPointerException e) {
                            Debug.error("Failed to save image (NullPointerException): " + f.getPath(), e);
                        }
                    } else {
                        f.delete();
                    }
                    MapManager.mapman.pushUpdate(tile.getDynmapWorld(), (Client.Update)new Client.Tile(fname));
                    hashman.updateHashCode(tile.getKey(prefix), "day", tile.tx, tile.ty, crc);
                    tile.getDynmapWorld().enqueueZoomOutUpdate(f);
                    tile_update = true;
                    renderone = true;
                } else {
                    Debug.debug("skipping image " + f.getPath() + " - hash match");
                    if (!rendered[i]) {
                        hashman.updateHashCode(tile.getKey(prefix), "day", tile.tx, tile.ty, -1L);
                        tile.getDynmapWorld().enqueueZoomOutUpdate(f);
                        f.delete();
                    }
                }
            }
            finally {
                FileLockManager.releaseWriteLock(f);
                DynmapBufferedImage.freeBufferedImage(dayim[i]);
            }
            MapManager.mapman.updateStatistics(tile, prefix + "_day", true, tile_update, !rendered[i]);
        }
        return renderone;
    }

    @Override
    public boolean isBiomeDataNeeded() {
        return this.need_biomedata;
    }

    @Override
    public boolean isRawBiomeDataNeeded() {
        return this.need_rawbiomedata;
    }

    @Override
    public boolean isHightestBlockYDataNeeded() {
        return false;
    }

    @Override
    public boolean isBlockTypeDataNeeded() {
        return true;
    }

    @Override
    public double getScale() {
        return this.basemodscale;
    }

    @Override
    public int getModelScale() {
        return this.basemodscale;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addClientConfiguration(JSONObject mapObject) {
        JSONUtils.s(mapObject, "perspective", this.name);
        JSONUtils.s(mapObject, "azimuth", this.azimuth);
        JSONUtils.s(mapObject, "inclination", this.inclination);
        JSONUtils.s(mapObject, "scale", this.basemodscale);
        JSONUtils.s(mapObject, "worldtomap", this.world_to_map.toJSON());
        JSONUtils.s(mapObject, "maptoworld", this.map_to_world.toJSON());
        int dir = (360 + (int)(22.5 + this.azimuth)) / 45 % 8;
        if (MapManager.mapman.getCompassMode() != DynmapCore.CompassMode.PRE19) {
            dir = (dir + 6) % 8;
        }
        JSONUtils.s(mapObject, "compassview", directions[dir]);
    }

    private static final int fastFloor(double f) {
        return (int)(f + 1.0E9) - 1000000000;
    }

    @Override
    public void transformWorldToMapCoord(Vector3D input, Vector3D rslt) {
        this.world_to_map.transform(input, rslt);
    }

    @Override
    public int hashCode() {
        return this.hashcode;
    }

    private class OurPerspectiveState
    implements HDPerspectiveState {
        int blocktypeid = 0;
        int blockdata = 0;
        int blockrenderdata = -1;
        int lastblocktypeid = 0;
        Vector3D top;
        Vector3D bottom;
        Vector3D direction;
        int px;
        int py;
        BlockStep laststep = BlockStep.Y_MINUS;
        BlockStep stepx;
        BlockStep stepy;
        BlockStep stepz;
        private final HDBlockModels.HDScaledBlockModels scalemodels;
        private final int modscale;
        int sx;
        int sy;
        int sz;
        double sdt_dx;
        double sdt_dy;
        double sdt_dz;
        double st_next_x;
        double st_next_y;
        double st_next_z;
        double dx;
        double dy;
        double dz;
        int x;
        int y;
        int z;
        double dt_dx;
        double dt_dy;
        double dt_dz;
        double t;
        int n;
        int x_inc;
        int y_inc;
        int z_inc;
        double t_next_y;
        double t_next_x;
        double t_next_z;
        boolean nonairhit;
        int mx;
        int my;
        int mz;
        double xx;
        double yy;
        double zz;
        double mdt_dx;
        double mdt_dy;
        double mdt_dz;
        double togo;
        double mt_next_x;
        double mt_next_y;
        double mt_next_z;
        int subalpha;
        double mt;
        double mtend;
        int mxout;
        int myout;
        int mzout;
        Vector3D v0 = new Vector3D();
        Vector3D vS = new Vector3D();
        Vector3D d_cross_uv = new Vector3D();
        double[] patch_t = new double[HDBlockModels.getMaxPatchCount()];
        double[] patch_u = new double[HDBlockModels.getMaxPatchCount()];
        double[] patch_v = new double[HDBlockModels.getMaxPatchCount()];
        BlockStep[] patch_step = new BlockStep[HDBlockModels.getMaxPatchCount()];
        int[] patch_id = new int[HDBlockModels.getMaxPatchCount()];
        int cur_patch = -1;
        double cur_patch_u;
        double cur_patch_v;
        double cur_patch_t;
        int[] subblock_xyz = new int[3];
        final MapIterator mapiter;
        final boolean isnether;
        boolean skiptoair;
        final int worldheight;
        final int heightmask;
        final LightLevels[] llcache;
        private final DynLongHashMap custom_meshes;
        private static final int FENCE_ALGORITHM = 1;
        private static final int CHEST_ALGORITHM = 2;
        private static final int REDSTONE_ALGORITHM = 3;
        private static final int GLASS_IRONFENCE_ALG = 4;
        private static final int WIRE_ALGORITHM = 5;
        private static final int DOOR_ALGORITHM = 6;

        public OurPerspectiveState(MapIterator mi, boolean isnether, int scaled) {
            this.mapiter = mi;
            this.isnether = isnether;
            this.worldheight = this.mapiter.getWorldHeight();
            int shift = 0;
            while (1 << shift < this.worldheight) {
                ++shift;
            }
            this.heightmask = (1 << shift) - 1;
            this.llcache = new LightLevels[4];
            for (int i = 0; i < this.llcache.length; ++i) {
                this.llcache[i] = new LightLevels();
            }
            this.custom_meshes = new DynLongHashMap();
            this.modscale = IsoHDPerspective.this.basemodscale << scaled;
            this.scalemodels = HDBlockModels.getModelsForScale(IsoHDPerspective.this.basemodscale << scaled);
        }

        private final void updateSemitransparentLight(LightLevels ll) {
            int emitted = 0;
            int sky = 0;
            for (int i = 0; i < semi_steps.length; ++i) {
                BlockStep s = semi_steps[i];
                this.mapiter.stepPosition(s);
                int v = this.mapiter.getBlockEmittedLight();
                if (v > emitted) {
                    emitted = v;
                }
                if ((v = this.mapiter.getBlockSkyLight()) > sky) {
                    sky = v;
                }
                this.mapiter.unstepPosition(s);
            }
            ll.sky = sky;
            ll.emitted = emitted;
        }

        private final void updateLightLevel(int blktypeid, LightLevels ll) {
            TexturePack.BlockTransparency bt = TexturePack.HDTextureMap.getTransparency(blktypeid);
            switch (bt) {
                case TRANSPARENT: {
                    ll.sky = this.mapiter.getBlockSkyLight();
                    ll.emitted = this.mapiter.getBlockEmittedLight();
                    break;
                }
                case OPAQUE: {
                    if (TexturePack.HDTextureMap.getTransparency(this.lastblocktypeid) != TexturePack.BlockTransparency.SEMITRANSPARENT) {
                        this.mapiter.unstepPosition(this.laststep);
                        if (this.mapiter.getY() < this.worldheight) {
                            ll.sky = this.mapiter.getBlockSkyLight();
                            ll.emitted = this.mapiter.getBlockEmittedLight();
                        } else {
                            ll.sky = 15;
                            ll.emitted = 0;
                        }
                        this.mapiter.stepPosition(this.laststep);
                        break;
                    }
                    this.mapiter.unstepPosition(this.laststep);
                    this.updateSemitransparentLight(ll);
                    this.mapiter.stepPosition(this.laststep);
                    break;
                }
                case SEMITRANSPARENT: {
                    this.updateSemitransparentLight(ll);
                    break;
                }
                default: {
                    ll.sky = this.mapiter.getBlockSkyLight();
                    ll.emitted = this.mapiter.getBlockEmittedLight();
                }
            }
        }

        @Override
        public final void getLightLevels(LightLevels ll) {
            this.updateLightLevel(this.blocktypeid, ll);
        }

        @Override
        public final void getLightLevelsAtStep(BlockStep step, LightLevels ll) {
            if (step == BlockStep.Y_MINUS && this.y == 0 || step == BlockStep.Y_PLUS && this.y == this.worldheight) {
                this.getLightLevels(ll);
                return;
            }
            BlockStep blast = this.laststep;
            this.mapiter.stepPosition(step);
            this.laststep = blast;
            this.updateLightLevel(this.mapiter.getBlockTypeID(), ll);
            this.mapiter.unstepPosition(step);
            this.laststep = blast;
        }

        @Override
        public final int getBlockTypeID() {
            return this.blocktypeid;
        }

        @Override
        public final int getBlockData() {
            return this.blockdata;
        }

        @Override
        public final int getBlockRenderData() {
            return this.blockrenderdata;
        }

        @Override
        public final BlockStep getLastBlockStep() {
            return this.laststep;
        }

        @Override
        public final double getScale() {
            return this.modscale;
        }

        @Override
        public final Vector3D getRayStart() {
            return this.top;
        }

        @Override
        public final Vector3D getRayEnd() {
            return this.bottom;
        }

        @Override
        public final int getPixelX() {
            return this.px;
        }

        @Override
        public final int getPixelY() {
            return this.py;
        }

        @Override
        public final MapIterator getMapIterator() {
            return this.mapiter;
        }

        @Override
        public int getSubmodelAlpha() {
            return this.subalpha;
        }

        private void raytrace_init() {
            this.dx = Math.abs(this.direction.x);
            this.dy = Math.abs(this.direction.y);
            this.dz = Math.abs(this.direction.z);
            this.dt_dx = 1.0 / this.dx;
            this.dt_dy = 1.0 / this.dy;
            this.dt_dz = 1.0 / this.dz;
            this.t = 0.0;
            this.n = 1;
            this.sx = IsoHDPerspective.fastFloor(this.top.x / 16.0);
            this.sy = IsoHDPerspective.fastFloor(this.top.y / 16.0);
            this.sz = IsoHDPerspective.fastFloor(this.top.z / 16.0);
            this.sdt_dx = 16.0 / this.dx;
            this.sdt_dy = 16.0 / this.dy;
            this.sdt_dz = 16.0 / this.dz;
            if (this.dx == 0.0) {
                this.x_inc = 0;
                this.st_next_x = Double.MAX_VALUE;
                this.stepx = BlockStep.X_PLUS;
                this.mxout = this.modscale;
            } else if (this.bottom.x > this.top.x) {
                this.x_inc = 1;
                this.n += IsoHDPerspective.fastFloor(this.bottom.x) - this.x;
                this.st_next_x = ((double)(IsoHDPerspective.fastFloor(this.top.x / 16.0) + 1) - this.top.x / 16.0) * this.sdt_dx;
                this.stepx = BlockStep.X_PLUS;
                this.mxout = this.modscale;
            } else {
                this.x_inc = -1;
                this.n += this.x - IsoHDPerspective.fastFloor(this.bottom.x);
                this.st_next_x = (this.top.x / 16.0 - (double)IsoHDPerspective.fastFloor(this.top.x / 16.0)) * this.sdt_dx;
                this.stepx = BlockStep.X_MINUS;
                this.mxout = -1;
            }
            if (this.dy == 0.0) {
                this.y_inc = 0;
                this.st_next_y = Double.MAX_VALUE;
                this.stepy = BlockStep.Y_PLUS;
                this.myout = this.modscale;
            } else if (this.bottom.y > this.top.y) {
                this.y_inc = 1;
                this.n += IsoHDPerspective.fastFloor(this.bottom.y) - this.y;
                this.st_next_y = ((double)(IsoHDPerspective.fastFloor(this.top.y / 16.0) + 1) - this.top.y / 16.0) * this.sdt_dy;
                this.stepy = BlockStep.Y_PLUS;
                this.myout = this.modscale;
            } else {
                this.y_inc = -1;
                this.n += this.y - IsoHDPerspective.fastFloor(this.bottom.y);
                this.st_next_y = (this.top.y / 16.0 - (double)IsoHDPerspective.fastFloor(this.top.y / 16.0)) * this.sdt_dy;
                this.stepy = BlockStep.Y_MINUS;
                this.myout = -1;
            }
            if (this.dz == 0.0) {
                this.z_inc = 0;
                this.st_next_z = Double.MAX_VALUE;
                this.stepz = BlockStep.Z_PLUS;
                this.mzout = this.modscale;
            } else if (this.bottom.z > this.top.z) {
                this.z_inc = 1;
                this.n += IsoHDPerspective.fastFloor(this.bottom.z) - this.z;
                this.st_next_z = ((double)(IsoHDPerspective.fastFloor(this.top.z / 16.0) + 1) - this.top.z / 16.0) * this.sdt_dz;
                this.stepz = BlockStep.Z_PLUS;
                this.mzout = this.modscale;
            } else {
                this.z_inc = -1;
                this.n += this.z - IsoHDPerspective.fastFloor(this.bottom.z);
                this.st_next_z = (this.top.z / 16.0 - (double)IsoHDPerspective.fastFloor(this.top.z / 16.0)) * this.sdt_dz;
                this.stepz = BlockStep.Z_MINUS;
                this.mzout = -1;
            }
            this.laststep = BlockStep.Y_MINUS;
            this.nonairhit = false;
            this.skiptoair = this.isnether;
        }

        private int generateFenceBlockData(int blkid) {
            int blockdata = 0;
            int id = this.mapiter.getBlockTypeIDAt(BlockStep.X_MINUS);
            if (id == blkid || id == 107 || id > 0 && TexturePack.HDTextureMap.getTransparency(id) == TexturePack.BlockTransparency.OPAQUE) {
                blockdata |= 1;
            }
            if ((id = this.mapiter.getBlockTypeIDAt(BlockStep.Z_MINUS)) == blkid || id == 107 || id > 0 && TexturePack.HDTextureMap.getTransparency(id) == TexturePack.BlockTransparency.OPAQUE) {
                blockdata |= 2;
            }
            if ((id = this.mapiter.getBlockTypeIDAt(BlockStep.X_PLUS)) == blkid || id == 107 || id > 0 && TexturePack.HDTextureMap.getTransparency(id) == TexturePack.BlockTransparency.OPAQUE) {
                blockdata |= 4;
            }
            if ((id = this.mapiter.getBlockTypeIDAt(BlockStep.Z_PLUS)) == blkid || id == 107 || id > 0 && TexturePack.HDTextureMap.getTransparency(id) == TexturePack.BlockTransparency.OPAQUE) {
                blockdata |= 8;
            }
            return blockdata;
        }

        private int generateChestBlockData(int blktype) {
            int blkdata = this.mapiter.getBlockData();
            ChestData cd = ChestData.SINGLE_WEST;
            switch (blkdata) {
                case 2: {
                    if (this.mapiter.getBlockTypeIDAt(BlockStep.X_MINUS) == blktype) {
                        cd = ChestData.LEFT_EAST;
                        break;
                    }
                    if (this.mapiter.getBlockTypeIDAt(BlockStep.X_PLUS) == blktype) {
                        cd = ChestData.RIGHT_EAST;
                        break;
                    }
                    cd = ChestData.SINGLE_EAST;
                    break;
                }
                case 4: {
                    if (this.mapiter.getBlockTypeIDAt(BlockStep.Z_MINUS) == blktype) {
                        cd = ChestData.RIGHT_NORTH;
                        break;
                    }
                    if (this.mapiter.getBlockTypeIDAt(BlockStep.Z_PLUS) == blktype) {
                        cd = ChestData.LEFT_NORTH;
                        break;
                    }
                    cd = ChestData.SINGLE_NORTH;
                    break;
                }
                case 5: {
                    if (this.mapiter.getBlockTypeIDAt(BlockStep.Z_MINUS) == blktype) {
                        cd = ChestData.LEFT_SOUTH;
                        break;
                    }
                    if (this.mapiter.getBlockTypeIDAt(BlockStep.Z_PLUS) == blktype) {
                        cd = ChestData.RIGHT_SOUTH;
                        break;
                    }
                    cd = ChestData.SINGLE_SOUTH;
                    break;
                }
                default: {
                    cd = this.mapiter.getBlockTypeIDAt(BlockStep.X_MINUS) == blktype ? ChestData.RIGHT_WEST : (this.mapiter.getBlockTypeIDAt(BlockStep.X_PLUS) == blktype ? ChestData.LEFT_WEST : ChestData.SINGLE_WEST);
                }
            }
            return cd.ordinal();
        }

        private int generateRedstoneWireBlockData() {
            int[] ids = new int[]{this.mapiter.getBlockTypeIDAt(BlockStep.Z_PLUS), this.mapiter.getBlockTypeIDAt(BlockStep.X_PLUS), this.mapiter.getBlockTypeIDAt(BlockStep.Z_MINUS), this.mapiter.getBlockTypeIDAt(BlockStep.X_MINUS)};
            int flags = 0;
            for (int i = 0; i < 4; ++i) {
                if (ids[i] != 55) continue;
                flags |= 1 << i;
            }
            switch (flags) {
                case 0: {
                    return 11;
                }
                case 15: {
                    return 0;
                }
                case 2: 
                case 8: 
                case 10: {
                    return 1;
                }
                case 1: 
                case 4: 
                case 5: {
                    return 2;
                }
                case 12: {
                    return 3;
                }
                case 9: {
                    return 4;
                }
                case 6: {
                    return 5;
                }
                case 3: {
                    return 6;
                }
                case 14: {
                    return 7;
                }
                case 11: {
                    return 8;
                }
                case 13: {
                    return 9;
                }
                case 7: {
                    return 10;
                }
            }
            return 0;
        }

        private int generateIronFenceGlassBlockData(int typeid) {
            int blockdata = 0;
            int id = this.mapiter.getBlockTypeIDAt(BlockStep.X_MINUS);
            if (id == typeid || id > 0 && TexturePack.HDTextureMap.getTransparency(id) == TexturePack.BlockTransparency.OPAQUE) {
                blockdata |= 1;
            }
            if ((id = this.mapiter.getBlockTypeIDAt(BlockStep.Z_MINUS)) == typeid || id > 0 && TexturePack.HDTextureMap.getTransparency(id) == TexturePack.BlockTransparency.OPAQUE) {
                blockdata |= 2;
            }
            if ((id = this.mapiter.getBlockTypeIDAt(BlockStep.X_PLUS)) == typeid || id > 0 && TexturePack.HDTextureMap.getTransparency(id) == TexturePack.BlockTransparency.OPAQUE) {
                blockdata |= 4;
            }
            if ((id = this.mapiter.getBlockTypeIDAt(BlockStep.Z_PLUS)) == typeid || id > 0 && TexturePack.HDTextureMap.getTransparency(id) == TexturePack.BlockTransparency.OPAQUE) {
                blockdata |= 8;
            }
            return blockdata;
        }

        private int generateDoorBlockData(int typeid) {
            int blockdata = 0;
            int topdata = this.mapiter.getBlockData();
            int bottomdata = 0;
            if ((topdata & 8) != 0) {
                blockdata |= 8;
                this.mapiter.stepPosition(BlockStep.Y_MINUS);
                bottomdata = this.mapiter.getBlockData();
                this.mapiter.unstepPosition(BlockStep.Y_MINUS);
            } else {
                bottomdata = topdata;
                this.mapiter.stepPosition(BlockStep.Y_PLUS);
                topdata = this.mapiter.getBlockData();
                this.mapiter.unstepPosition(BlockStep.Y_PLUS);
            }
            boolean onright = false;
            if ((topdata & 1) == 1) {
                blockdata |= 4;
                onright = true;
            }
            blockdata |= bottomdata & 3;
            if ((bottomdata & 4) > 0) {
                blockdata = onright ? blockdata & 8 | 0 | blockdata - 1 & 3 : blockdata & 8 | 4 | blockdata + 1 & 3;
            }
            return blockdata;
        }

        private final boolean containsID(int id, int[] linkids) {
            for (int i = 0; i < linkids.length; ++i) {
                if (id != linkids[i]) continue;
                return true;
            }
            return false;
        }

        private int generateWireBlockData(int[] linkids) {
            int blockdata = 0;
            int id = this.mapiter.getBlockTypeIDAt(BlockStep.X_MINUS);
            if (this.containsID(id, linkids)) {
                blockdata |= 1;
            }
            if (this.containsID(id = this.mapiter.getBlockTypeIDAt(BlockStep.Z_MINUS), linkids)) {
                blockdata |= 2;
            }
            if (this.containsID(id = this.mapiter.getBlockTypeIDAt(BlockStep.X_PLUS), linkids)) {
                blockdata |= 4;
            }
            if (this.containsID(id = this.mapiter.getBlockTypeIDAt(BlockStep.Z_PLUS), linkids)) {
                blockdata |= 8;
            }
            return blockdata;
        }

        private final boolean handleSubModel(short[] model, HDShaderState[] shaderstate, boolean[] shaderdone) {
            boolean firststep = true;
            while (!this.raytraceSubblock(model, firststep)) {
                boolean done = true;
                for (int i = 0; i < shaderstate.length; ++i) {
                    if (!shaderdone[i]) {
                        shaderdone[i] = shaderstate[i].processBlock(this);
                    }
                    done = done && shaderdone[i];
                }
                if (done) {
                    return true;
                }
                this.nonairhit = true;
                firststep = false;
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         */
        private final boolean handlePatches(RenderPatch[] patches, HDShaderState[] shaderstate, boolean[] shaderdone) {
            int hitcnt = 0;
            block5: for (int i = 0; i < patches.length; ++i) {
                double t;
                PatchDefinition pd = (PatchDefinition)patches[i];
                this.v0.x = (double)this.x + pd.x0;
                this.v0.y = (double)this.y + pd.y0;
                this.v0.z = (double)this.z + pd.z0;
                this.d_cross_uv.set(this.direction);
                this.d_cross_uv.crossProduct(pd.v);
                double det = pd.u.innerProduct(this.d_cross_uv);
                switch (pd.sidevis) {
                    case TOP: {
                        if (!(det < 1.0E-6)) break;
                        continue block5;
                    }
                    case BOTTOM: {
                        if (!(det > -1.0E-6)) break;
                        continue block5;
                    }
                    case BOTH: 
                    case FLIP: {
                        if (det > -1.0E-6 && det < 1.0E-6) continue block5;
                    }
                }
                double inv_det = 1.0 / det;
                this.vS.set(this.top);
                this.vS.subtract(this.v0);
                double u = inv_det * this.vS.innerProduct(this.d_cross_uv);
                if (u <= pd.umin || u >= pd.umax) continue;
                this.vS.crossProduct(pd.u);
                double v = inv_det * this.direction.innerProduct(this.vS);
                if (v <= pd.vmin || v >= pd.vmax || u + v >= pd.uplusvmax || !((t = inv_det * pd.v.innerProduct(this.vS)) > 1.0E-6)) continue;
                this.patch_t[hitcnt] = t;
                this.patch_u[hitcnt] = u;
                this.patch_v[hitcnt] = v;
                this.patch_id[hitcnt] = pd.textureindex;
                if (det > 0.0) {
                    this.patch_step[hitcnt] = pd.step.opposite();
                } else {
                    if (pd.sidevis == RenderPatchFactory.SideVisible.FLIP) {
                        this.patch_u[hitcnt] = 1.0 - u;
                    }
                    this.patch_step[hitcnt] = pd.step;
                }
                ++hitcnt;
            }
            if (hitcnt == 0) {
                return false;
            }
            BlockStep old_laststep = this.laststep;
            int i = 0;
            while (true) {
                if (i >= hitcnt) {
                    this.laststep = old_laststep;
                    return false;
                }
                double best_t = Double.MAX_VALUE;
                int best_patch = 0;
                for (int j = 0; j < hitcnt; ++j) {
                    if (!(this.patch_t[j] < best_t)) continue;
                    best_patch = j;
                    best_t = this.patch_t[j];
                }
                this.cur_patch = this.patch_id[best_patch];
                this.cur_patch_u = this.patch_u[best_patch];
                this.cur_patch_v = this.patch_v[best_patch];
                this.laststep = this.patch_step[best_patch];
                this.cur_patch_t = best_t;
                boolean done = true;
                for (int j = 0; j < shaderstate.length; ++j) {
                    if (!shaderdone[j]) {
                        shaderdone[j] = shaderstate[j].processBlock(this);
                    }
                    done = done && shaderdone[j];
                }
                this.cur_patch = -1;
                if (done) {
                    this.laststep = old_laststep;
                    return true;
                }
                this.nonairhit = true;
                this.patch_t[best_patch] = Double.MAX_VALUE;
                ++i;
            }
        }

        private final boolean visit_block(HDShaderState[] shaderstate, boolean[] shaderdone) {
            this.lastblocktypeid = this.blocktypeid;
            this.blocktypeid = this.mapiter.getBlockTypeID();
            if (this.skiptoair) {
                if (this.blocktypeid == 0) {
                    this.skiptoair = false;
                }
            } else if (this.nonairhit || this.blocktypeid != 0) {
                HDBlockModels.CustomBlockModel cbm;
                this.blockdata = this.mapiter.getBlockData();
                switch (HDBlockModels.getLinkAlgID(this.blocktypeid)) {
                    case 1: {
                        this.blockrenderdata = this.generateFenceBlockData(this.blocktypeid);
                        break;
                    }
                    case 2: {
                        this.blockrenderdata = this.generateChestBlockData(this.blocktypeid);
                        break;
                    }
                    case 3: {
                        this.blockrenderdata = this.generateRedstoneWireBlockData();
                        break;
                    }
                    case 4: {
                        this.blockrenderdata = this.generateIronFenceGlassBlockData(this.blocktypeid);
                        break;
                    }
                    case 5: {
                        this.blockrenderdata = this.generateWireBlockData(HDBlockModels.getLinkIDs(this.blocktypeid));
                        break;
                    }
                    case 6: {
                        this.blockrenderdata = this.generateDoorBlockData(this.blocktypeid);
                        break;
                    }
                    default: {
                        this.blockrenderdata = -1;
                    }
                }
                RenderPatch[] patches = this.scalemodels.getPatchModel(this.blocktypeid, this.blockdata, this.blockrenderdata);
                if (patches == null && (cbm = this.scalemodels.getCustomBlockModel(this.blocktypeid, this.blockdata)) != null && (patches = this.getCustomMesh()) == null) {
                    patches = cbm.getMeshForBlock(this.mapiter);
                    this.setCustomMesh(patches);
                }
                if (patches != null) {
                    return this.handlePatches(patches, shaderstate, shaderdone);
                }
                short[] model = this.scalemodels.getScaledModel(this.blocktypeid, this.blockdata, this.blockrenderdata);
                if (model != null) {
                    return this.handleSubModel(model, shaderstate, shaderdone);
                }
                boolean done = true;
                this.subalpha = -1;
                for (int i = 0; i < shaderstate.length; ++i) {
                    if (!shaderdone[i]) {
                        shaderdone[i] = shaderstate[i].processBlock(this);
                    }
                    done = done && shaderdone[i];
                }
                if (done) {
                    return true;
                }
                this.nonairhit = true;
            }
            return false;
        }

        private final boolean raytraceSkipEmpty(MapChunkCache cache) {
            while (cache.isEmptySection(this.sx, this.sy, this.sz)) {
                if (this.st_next_y <= this.st_next_x && this.st_next_y <= this.st_next_z) {
                    this.sy += this.y_inc;
                    this.t = this.st_next_y;
                    this.st_next_y += this.sdt_dy;
                    this.laststep = this.stepy;
                    if (this.sy >= 0) continue;
                    return false;
                }
                if (this.st_next_x <= this.st_next_y && this.st_next_x <= this.st_next_z) {
                    this.sx += this.x_inc;
                    this.t = this.st_next_x;
                    this.st_next_x += this.sdt_dx;
                    this.laststep = this.stepx;
                    continue;
                }
                this.sz += this.z_inc;
                this.t = this.st_next_z;
                this.st_next_z += this.sdt_dz;
                this.laststep = this.stepz;
            }
            return true;
        }

        private final boolean raytraceStepIterator() {
            if (this.t_next_y <= this.t_next_x && this.t_next_y <= this.t_next_z) {
                this.y += this.y_inc;
                this.t = this.t_next_y;
                this.t_next_y += this.dt_dy;
                this.laststep = this.stepy;
                this.mapiter.stepPosition(this.laststep);
                if ((this.y & ~this.heightmask) != 0) {
                    return false;
                }
            } else if (this.t_next_x <= this.t_next_y && this.t_next_x <= this.t_next_z) {
                this.x += this.x_inc;
                this.t = this.t_next_x;
                this.t_next_x += this.dt_dx;
                this.laststep = this.stepx;
                this.mapiter.stepPosition(this.laststep);
            } else {
                this.z += this.z_inc;
                this.t = this.t_next_z;
                this.t_next_z += this.dt_dz;
                this.laststep = this.stepz;
                this.mapiter.stepPosition(this.laststep);
            }
            return true;
        }

        private final void raytrace(MapChunkCache cache, HDShaderState[] shaderstate, boolean[] shaderdone) {
            this.raytrace_init();
            if (!this.raytraceSkipEmpty(cache)) {
                return;
            }
            this.raytrace_section_init();
            if (this.y < 0) {
                return;
            }
            this.mapiter.initialize(this.x, this.y, this.z);
            while (this.n > 0) {
                if (this.visit_block(shaderstate, shaderdone)) {
                    return;
                }
                if (!this.raytraceStepIterator()) {
                    return;
                }
                --this.n;
            }
        }

        private final void raytrace_section_init() {
            this.t -= 1.0E-6;
            double xx = this.top.x + this.t * this.direction.x;
            double yy = this.top.y + this.t * this.direction.y;
            double zz = this.top.z + this.t * this.direction.z;
            this.x = IsoHDPerspective.fastFloor(xx);
            this.y = IsoHDPerspective.fastFloor(yy);
            this.z = IsoHDPerspective.fastFloor(zz);
            this.t_next_x = this.st_next_x;
            this.t_next_y = this.st_next_y;
            this.t_next_z = this.st_next_z;
            this.n = 1;
            if (this.t_next_x != Double.MAX_VALUE) {
                if (this.stepx == BlockStep.X_PLUS) {
                    this.t_next_x = this.t + ((double)(this.x + 1) - xx) * this.dt_dx;
                    this.n += IsoHDPerspective.fastFloor(this.bottom.x) - this.x;
                } else {
                    this.t_next_x = this.t + (xx - (double)this.x) * this.dt_dx;
                    this.n += this.x - IsoHDPerspective.fastFloor(this.bottom.x);
                }
            }
            if (this.t_next_y != Double.MAX_VALUE) {
                if (this.stepy == BlockStep.Y_PLUS) {
                    this.t_next_y = this.t + ((double)(this.y + 1) - yy) * this.dt_dy;
                    this.n += IsoHDPerspective.fastFloor(this.bottom.y) - this.y;
                } else {
                    this.t_next_y = this.t + (yy - (double)this.y) * this.dt_dy;
                    this.n += this.y - IsoHDPerspective.fastFloor(this.bottom.y);
                }
            }
            if (this.t_next_z != Double.MAX_VALUE) {
                if (this.stepz == BlockStep.Z_PLUS) {
                    this.t_next_z = this.t + ((double)(this.z + 1) - zz) * this.dt_dz;
                    this.n += IsoHDPerspective.fastFloor(this.bottom.z) - this.z;
                } else {
                    this.t_next_z = this.t + (zz - (double)this.z) * this.dt_dz;
                    this.n += this.z - IsoHDPerspective.fastFloor(this.bottom.z);
                }
            }
        }

        private final boolean raytraceSubblock(short[] model, boolean firsttime) {
            boolean skip;
            if (firsttime) {
                this.mt = this.t + 1.0E-8;
                this.xx = this.top.x + this.mt * this.direction.x;
                this.yy = this.top.y + this.mt * this.direction.y;
                this.zz = this.top.z + this.mt * this.direction.z;
                this.mx = (int)((this.xx - (double)IsoHDPerspective.fastFloor(this.xx)) * (double)this.modscale);
                this.my = (int)((this.yy - (double)IsoHDPerspective.fastFloor(this.yy)) * (double)this.modscale);
                this.mz = (int)((this.zz - (double)IsoHDPerspective.fastFloor(this.zz)) * (double)this.modscale);
                this.mdt_dx = this.dt_dx / (double)this.modscale;
                this.mdt_dy = this.dt_dy / (double)this.modscale;
                this.mdt_dz = this.dt_dz / (double)this.modscale;
                this.mt_next_x = this.t_next_x;
                this.mt_next_y = this.t_next_y;
                this.mt_next_z = this.t_next_z;
                if (this.mt_next_x != Double.MAX_VALUE) {
                    this.togo = (this.t_next_x - this.t) / this.mdt_dx;
                    this.mt_next_x = this.mt + (this.togo - (double)IsoHDPerspective.fastFloor(this.togo)) * this.mdt_dx;
                }
                if (this.mt_next_y != Double.MAX_VALUE) {
                    this.togo = (this.t_next_y - this.t) / this.mdt_dy;
                    this.mt_next_y = this.mt + (this.togo - (double)IsoHDPerspective.fastFloor(this.togo)) * this.mdt_dy;
                }
                if (this.mt_next_z != Double.MAX_VALUE) {
                    this.togo = (this.t_next_z - this.t) / this.mdt_dz;
                    this.mt_next_z = this.mt + (this.togo - (double)IsoHDPerspective.fastFloor(this.togo)) * this.mdt_dz;
                }
                this.mtend = Math.min(this.t_next_x, Math.min(this.t_next_y, this.t_next_z));
            }
            this.subalpha = -1;
            boolean bl = skip = !firsttime;
            while (this.mt <= this.mtend) {
                block11: {
                    if (!skip) {
                        try {
                            int blkalpha = model[this.modscale * this.modscale * this.my + this.modscale * this.mz + this.mx];
                            if (blkalpha > 0) {
                                this.subalpha = blkalpha;
                                return false;
                            }
                            break block11;
                        }
                        catch (ArrayIndexOutOfBoundsException aioobx) {
                            return true;
                        }
                    }
                    skip = false;
                }
                if (this.mt_next_x <= this.mt_next_y && this.mt_next_x <= this.mt_next_z) {
                    this.mx += this.x_inc;
                    this.mt = this.mt_next_x;
                    this.mt_next_x += this.mdt_dx;
                    this.laststep = this.stepx;
                    if (this.mx != this.mxout) continue;
                    return true;
                }
                if (this.mt_next_y <= this.mt_next_x && this.mt_next_y <= this.mt_next_z) {
                    this.my += this.y_inc;
                    this.mt = this.mt_next_y;
                    this.mt_next_y += this.mdt_dy;
                    this.laststep = this.stepy;
                    if (this.my != this.myout) continue;
                    return true;
                }
                this.mz += this.z_inc;
                this.mt = this.mt_next_z;
                this.mt_next_z += this.mdt_dz;
                this.laststep = this.stepz;
                if (this.mz != this.mzout) continue;
                return true;
            }
            return true;
        }

        @Override
        public final int[] getSubblockCoord() {
            if (this.cur_patch >= 0) {
                double tt = this.cur_patch_t;
                double xx = this.top.x + tt * this.direction.x;
                double yy = this.top.y + tt * this.direction.y;
                double zz = this.top.z + tt * this.direction.z;
                this.subblock_xyz[0] = (int)((xx - (double)IsoHDPerspective.fastFloor(xx)) * (double)this.modscale);
                this.subblock_xyz[1] = (int)((yy - (double)IsoHDPerspective.fastFloor(yy)) * (double)this.modscale);
                this.subblock_xyz[2] = (int)((zz - (double)IsoHDPerspective.fastFloor(zz)) * (double)this.modscale);
            } else if (this.subalpha < 0) {
                double tt = this.t + 1.0E-7;
                double xx = this.top.x + tt * this.direction.x;
                double yy = this.top.y + tt * this.direction.y;
                double zz = this.top.z + tt * this.direction.z;
                this.subblock_xyz[0] = (int)((xx - (double)IsoHDPerspective.fastFloor(xx)) * (double)this.modscale);
                this.subblock_xyz[1] = (int)((yy - (double)IsoHDPerspective.fastFloor(yy)) * (double)this.modscale);
                this.subblock_xyz[2] = (int)((zz - (double)IsoHDPerspective.fastFloor(zz)) * (double)this.modscale);
            } else {
                this.subblock_xyz[0] = this.mx;
                this.subblock_xyz[1] = this.my;
                this.subblock_xyz[2] = this.mz;
            }
            return this.subblock_xyz;
        }

        @Override
        public int getTextureIndex() {
            return this.cur_patch;
        }

        @Override
        public double getPatchU() {
            return this.cur_patch_u;
        }

        @Override
        public double getPatchV() {
            return this.cur_patch_v;
        }

        @Override
        public final LightLevels getCachedLightLevels(int idx) {
            return this.llcache[idx];
        }

        public final RenderPatch[] getCustomMesh() {
            long key = this.mapiter.getBlockKey();
            return (RenderPatch[])this.custom_meshes.get(key);
        }

        public final void setCustomMesh(RenderPatch[] mesh) {
            long key = this.mapiter.getBlockKey();
            this.custom_meshes.put(key, mesh);
        }
    }

    private static enum ChestData {
        SINGLE_WEST,
        SINGLE_SOUTH,
        SINGLE_EAST,
        SINGLE_NORTH,
        LEFT_WEST,
        LEFT_SOUTH,
        LEFT_EAST,
        LEFT_NORTH,
        RIGHT_WEST,
        RIGHT_SOUTH,
        RIGHT_EAST,
        RIGHT_NORTH;

    }
}

