/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.forge.permissions;

import com.ForgeEssentials.api.permissions.PermissionsAPI;
import com.ForgeEssentials.api.permissions.query.PermQuery;
import com.ForgeEssentials.api.permissions.query.PermQueryPlayer;
import cpw.mods.fml.common.Loader;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import org.dynmap.Log;
import org.dynmap.forge.DynmapPlugin;
import org.dynmap.forge.permissions.PermissionProvider;

public class ForgeEssentialsPermissions
implements PermissionProvider {
    protected String name;

    public static ForgeEssentialsPermissions create(String name) throws NoClassDefFoundError {
        if (!Loader.isModLoaded((String)"ForgeEssentials")) {
            return null;
        }
        Log.info("Using ForgeEssentials Permissions for access control");
        Log.info("Web interface permissions only available for online users");
        return new ForgeEssentialsPermissions(name);
    }

    public ForgeEssentialsPermissions(String name) {
        this.name = name;
    }

    @Override
    public Set<String> hasOfflinePermissions(String player, Set<String> perms) {
        EntityPlayerMP p = MinecraftServer.func_71276_C().func_71203_ab().func_72361_f(player);
        HashSet<String> hasperms = null;
        if (p != null) {
            hasperms = new HashSet<String>();
            for (String perm : perms) {
                if (!PermissionsAPI.checkPermAllowed((PermQuery)new PermQueryPlayer((EntityPlayer)p, this.name + "." + perm))) continue;
                hasperms.add(perm);
            }
        }
        return hasperms;
    }

    @Override
    public boolean hasOfflinePermission(String player, String perm) {
        EntityPlayerMP p = MinecraftServer.func_71276_C().func_71203_ab().func_72361_f(player);
        if (p != null) {
            boolean rslt = PermissionsAPI.checkPermAllowed((PermQuery)new PermQueryPlayer((EntityPlayer)p, this.name + "." + perm));
            return rslt;
        }
        return DynmapPlugin.plugin.isOp(player);
    }

    @Override
    public boolean has(ICommandSender sender, String permission) {
        EntityPlayer player;
        EntityPlayer entityPlayer = player = sender instanceof EntityPlayer ? (EntityPlayer)sender : null;
        boolean rslt = player != null ? PermissionsAPI.checkPermAllowed((PermQuery)new PermQueryPlayer(player, this.name + "." + permission)) || PermissionsAPI.checkPermAllowed((PermQuery)new PermQueryPlayer(player, this.name + ".*")) : true;
        return rslt;
    }

    @Override
    public boolean hasPermissionNode(ICommandSender sender, String permission) {
        EntityPlayer player = sender instanceof EntityPlayer ? (EntityPlayer)sender : null;
        return player != null ? PermissionsAPI.checkPermAllowed((PermQuery)new PermQueryPlayer(player, permission)) : true;
    }
}

