/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.forge;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.chunk.storage.RegionFileCache;
import net.minecraft.world.gen.ChunkProviderServer;
import org.dynmap.DynmapChunk;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapWorld;
import org.dynmap.Log;
import org.dynmap.common.BiomeMap;
import org.dynmap.forge.ChunkSnapshot;
import org.dynmap.forge.DynmapPlugin;
import org.dynmap.forge.ForgeWorld;
import org.dynmap.forge.SnapshotCache;
import org.dynmap.hdmap.HDBlockModels;
import org.dynmap.renderer.RenderPatchFactory;
import org.dynmap.utils.BlockStep;
import org.dynmap.utils.DynIntHashMap;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.MapIterator;
import org.dynmap.utils.VisibilityLimit;

public class ForgeMapChunkCache
extends MapChunkCache {
    private static boolean init;
    private static Field unloadqueue;
    private static Field unloadqueue_mcpc;
    private static Method unloadqueue_mcpc_contains;
    private static Field currentchunkloader;
    private static Field updateEntityTick;
    private static Field chunksToRemove;
    private static Field pendingAnvilChunksCoordinates;
    private static Field pendingAnvilChunksMCPC;
    private static Field syncLockObject;
    private static Field chunkCoord;
    private static Field nbtTag;
    private World w;
    private DynmapWorld dw;
    private ChunkProviderServer cps;
    private int nsect;
    private List<DynmapChunk> chunks;
    private ListIterator<DynmapChunk> iterator;
    private int x_min;
    private int x_max;
    private int z_min;
    private int z_max;
    private int x_dim;
    private boolean biome;
    private boolean biomeraw;
    private boolean highesty;
    private boolean blockdata;
    private MapChunkCache.HiddenChunkStyle hidestyle = MapChunkCache.HiddenChunkStyle.FILL_AIR;
    private List<VisibilityLimit> visible_limits = null;
    private List<VisibilityLimit> hidden_limits = null;
    private boolean isempty = true;
    private int snapcnt;
    private ChunkSnapshot[] snaparray;
    private DynIntHashMap[] snaptile;
    private byte[][] sameneighborbiomecnt;
    private BiomeMap[][] biomemap;
    private boolean[][] isSectionNotEmpty;
    private static final BlockStep[] unstep;
    private static BiomeMap[] biome_to_bmap;
    private static NoCreateChunkLoader noCreateLoader;
    private static final EmptyChunk EMPTY;
    private static final PlainChunk STONE;
    private static final PlainChunk OCEAN;
    private static boolean ldchunk;
    private static boolean rdchunk;
    private boolean readChunkActive = true;

    private static final int getIndexInChunk(int cx, int cy, int cz) {
        return cy << 8 | cz << 4 | cx;
    }

    public static void init() {
        if (!init) {
            int i;
            Field[] f = ChunkProviderServer.class.getDeclaredFields();
            for (i = 0; i < f.length; ++i) {
                if (unloadqueue == null && f[i].getType().isAssignableFrom(Set.class)) {
                    unloadqueue = f[i];
                    unloadqueue.setAccessible(true);
                    continue;
                }
                if (unloadqueue_mcpc == null && f[i].getType().getSimpleName().endsWith("LongHashSet")) {
                    unloadqueue_mcpc = f[i];
                    try {
                        unloadqueue_mcpc_contains = f[i].getType().getDeclaredMethod("contains", Integer.TYPE, Integer.TYPE);
                    }
                    catch (SecurityException e) {
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    unloadqueue_mcpc.setAccessible(true);
                    continue;
                }
                if (currentchunkloader != null || !f[i].getType().isAssignableFrom(IChunkLoader.class)) continue;
                currentchunkloader = f[i];
                currentchunkloader.setAccessible(true);
            }
            f = WorldServer.class.getDeclaredFields();
            for (i = 0; i < f.length; ++i) {
                if (updateEntityTick != null || !f[i].getType().isAssignableFrom(Integer.TYPE)) continue;
                updateEntityTick = f[i];
                updateEntityTick.setAccessible(true);
            }
            f = AnvilChunkLoader.class.getDeclaredFields();
            for (i = 0; i < f.length; ++i) {
                if (chunksToRemove == null && f[i].getType().equals(List.class)) {
                    chunksToRemove = f[i];
                    chunksToRemove.setAccessible(true);
                    continue;
                }
                if (pendingAnvilChunksCoordinates == null && f[i].getType().equals(Set.class)) {
                    pendingAnvilChunksCoordinates = f[i];
                    pendingAnvilChunksCoordinates.setAccessible(true);
                    continue;
                }
                if (pendingAnvilChunksMCPC == null && f[i].getType().equals(LinkedHashMap.class)) {
                    pendingAnvilChunksMCPC = f[i];
                    pendingAnvilChunksMCPC.setAccessible(true);
                    continue;
                }
                if (syncLockObject != null || !f[i].getType().equals(Object.class)) continue;
                syncLockObject = f[i];
                syncLockObject.setAccessible(true);
            }
            if (unloadqueue == null && (unloadqueue_mcpc == null || unloadqueue_mcpc_contains == null) || currentchunkloader == null) {
                Log.severe("ERROR: cannot find unload queue or chunk provider field - dynmap cannot load chunks");
            }
            if (updateEntityTick == null) {
                Log.severe("ERROR: cannot find updateEntityTick - dynmap cannot drive entity cleanup when no players are active");
            }
            init = true;
        }
    }

    public ForgeMapChunkCache() {
        ForgeMapChunkCache.init();
    }

    public void setChunks(ForgeWorld dw, List<DynmapChunk> chunks) {
        this.dw = dw;
        this.w = dw.getWorld();
        if (dw.isLoaded()) {
            IChunkProvider cp = this.w.func_72863_F();
            if (cp instanceof ChunkProviderServer) {
                this.cps = (ChunkProviderServer)cp;
            } else {
                Log.severe("Error: world " + dw.getName() + " has unsupported chunk provider");
            }
        } else {
            chunks = new ArrayList<DynmapChunk>();
        }
        this.nsect = dw.worldheight >> 4;
        this.chunks = chunks;
        if (chunks.size() == 0) {
            this.x_min = 0;
            this.x_max = 0;
            this.z_min = 0;
            this.z_max = 0;
            this.x_dim = 1;
        } else {
            this.x_min = this.x_max = chunks.get((int)0).x;
            this.z_min = this.z_max = chunks.get((int)0).z;
            for (DynmapChunk c : chunks) {
                if (c.x > this.x_max) {
                    this.x_max = c.x;
                }
                if (c.x < this.x_min) {
                    this.x_min = c.x;
                }
                if (c.z > this.z_max) {
                    this.z_max = c.z;
                }
                if (c.z >= this.z_min) continue;
                this.z_min = c.z;
            }
            this.x_dim = this.x_max - this.x_min + 1;
        }
        this.snapcnt = this.x_dim * (this.z_max - this.z_min + 1);
        this.snaparray = new ChunkSnapshot[this.snapcnt];
        this.snaptile = new DynIntHashMap[this.snapcnt];
        this.isSectionNotEmpty = new boolean[this.snapcnt][];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Chunk loadChunkNoGenerate(int x, int z) {
        if (this.cps == null || currentchunkloader == null) {
            return null;
        }
        if (!ldchunk) {
            Log.info("Loading chunks without generating");
            ldchunk = true;
        }
        Chunk c = null;
        try {
            IChunkLoader cur_ccl = null;
            cur_ccl = (IChunkLoader)currentchunkloader.get(this.cps);
            currentchunkloader.set(this.cps, noCreateLoader);
            ForgeMapChunkCache.noCreateLoader.base = cur_ccl;
            ForgeMapChunkCache.noCreateLoader.ww = this.w;
            ForgeMapChunkCache.noCreateLoader.xx = x;
            ForgeMapChunkCache.noCreateLoader.zz = z;
            try {
                c = this.cps.func_73158_c(x, z);
            }
            catch (NoChunkFoundThrow ncft) {
                c = null;
            }
            finally {
                currentchunkloader.set(this.cps, cur_ccl);
                ForgeMapChunkCache.noCreateLoader.ww = null;
            }
        }
        catch (IllegalArgumentException iax) {
            c = null;
        }
        catch (IllegalAccessException iaxx) {
            c = null;
        }
        catch (NullPointerException npx) {
            c = null;
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NBTTagCompound readChunk(int x, int z) {
        if (this.cps == null || !(this.cps.field_73247_e instanceof AnvilChunkLoader) || (chunksToRemove == null || pendingAnvilChunksCoordinates == null) && pendingAnvilChunksMCPC == null || syncLockObject == null) {
            this.readChunkActive = false;
            return null;
        }
        this.readChunkActive = true;
        if (!rdchunk) {
            Log.info("Reading chunks without loading/activating");
            rdchunk = true;
        }
        try {
            NBTTagCompound rslt;
            AnvilChunkLoader acl;
            block21: {
                acl = (AnvilChunkLoader)this.cps.field_73247_e;
                List chunkstoremove = null;
                Set pendingcoords = null;
                LinkedHashMap pendingsavesmcpc = null;
                if (pendingAnvilChunksMCPC != null) {
                    pendingsavesmcpc = (LinkedHashMap)pendingAnvilChunksMCPC.get(acl);
                } else {
                    chunkstoremove = (List)chunksToRemove.get(acl);
                    pendingcoords = (Set)pendingAnvilChunksCoordinates.get(acl);
                }
                Object synclock = syncLockObject.get(acl);
                rslt = null;
                ChunkCoordIntPair coord = new ChunkCoordIntPair(x, z);
                Object object = synclock;
                synchronized (object) {
                    block20: {
                        if (pendingAnvilChunksMCPC == null) break block20;
                        Object rec = pendingsavesmcpc.get(coord);
                        if (rec == null) break block21;
                        if (chunkCoord == null) {
                            Field[] f;
                            for (Field ff : f = rec.getClass().getDeclaredFields()) {
                                if (chunkCoord == null && ff.getType().equals(ChunkCoordIntPair.class)) {
                                    chunkCoord = ff;
                                    continue;
                                }
                                if (nbtTag != null || !ff.getType().equals(NBTTagCompound.class)) continue;
                                nbtTag = ff;
                            }
                        }
                        rslt = (NBTTagCompound)nbtTag.get(rec);
                        break block21;
                    }
                    if (pendingcoords.contains(coord)) {
                        for (int i = 0; i < chunkstoremove.size(); ++i) {
                            ChunkCoordIntPair occ;
                            Object o = chunkstoremove.get(i);
                            if (chunkCoord == null) {
                                Field[] f;
                                for (Field ff : f = o.getClass().getDeclaredFields()) {
                                    if (chunkCoord == null && ff.getType().equals(ChunkCoordIntPair.class)) {
                                        chunkCoord = ff;
                                        continue;
                                    }
                                    if (nbtTag != null || !ff.getType().equals(NBTTagCompound.class)) continue;
                                    nbtTag = ff;
                                }
                            }
                            if (!(occ = (ChunkCoordIntPair)chunkCoord.get(o)).equals((Object)coord)) continue;
                            rslt = (NBTTagCompound)nbtTag.get(o);
                            break;
                        }
                    }
                }
            }
            if (rslt == null) {
                DataInputStream str = RegionFileCache.func_76549_c((File)acl.field_75825_d, (int)x, (int)z);
                if (str == null) {
                    return null;
                }
                rslt = CompressedStreamTools.func_74794_a((DataInput)str);
            }
            if (rslt != null) {
                rslt = rslt.func_74775_l("Level");
            }
            return rslt;
        }
        catch (Exception exc) {
            return null;
        }
    }

    private Object getNBTValue(NBTBase v) {
        Object val = null;
        switch (v.func_74732_a()) {
            case 1: {
                val = ((NBTTagByte)v).field_74756_a;
                break;
            }
            case 2: {
                val = ((NBTTagShort)v).field_74752_a;
                break;
            }
            case 3: {
                val = ((NBTTagInt)v).field_74748_a;
                break;
            }
            case 4: {
                val = ((NBTTagLong)v).field_74753_a;
                break;
            }
            case 5: {
                val = Float.valueOf(((NBTTagFloat)v).field_74750_a);
                break;
            }
            case 6: {
                val = ((NBTTagDouble)v).field_74755_a;
                break;
            }
            case 7: {
                val = ((NBTTagByteArray)v).field_74754_a;
                break;
            }
            case 8: {
                val = ((NBTTagString)v).field_74751_a;
                break;
            }
            case 9: {
                NBTTagList tl = (NBTTagList)v;
                ArrayList<Object> vlist = new ArrayList<Object>();
                for (int i = 0; i < tl.func_74745_c(); ++i) {
                    NBTBase tg = tl.func_74743_b(i);
                    vlist.add(this.getNBTValue(tg));
                }
                val = vlist;
                break;
            }
            case 10: {
                NBTTagCompound tc = (NBTTagCompound)v;
                HashMap<String, Object> vmap = new HashMap<String, Object>();
                for (Object t : tc.func_74758_c()) {
                    NBTBase tg = (NBTBase)t;
                    vmap.put(tg.func_74740_e(), this.getNBTValue(tg));
                }
                val = vmap;
                break;
            }
            case 11: {
                val = ((NBTTagIntArray)v).field_74749_a;
            }
        }
        return val;
    }

    @Override
    public int loadChunks(int max_to_load) {
        if (!this.dw.isLoaded()) {
            this.isempty = true;
            this.unloadChunks();
            return 0;
        }
        Set queue = null;
        Object queue_mcpc = null;
        IChunkProvider cp = this.w.func_72863_F();
        try {
            if (unloadqueue != null && this.cps != null) {
                queue = (Set)unloadqueue.get(this.cps);
            } else if (unloadqueue_mcpc != null && this.cps != null) {
                queue_mcpc = unloadqueue_mcpc.get(this.cps);
            }
        }
        catch (IllegalArgumentException iax) {
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
        int cnt = 0;
        if (this.iterator == null) {
            this.iterator = this.chunks.listIterator();
        }
        DynmapCore.setIgnoreChunkLoads(true);
        while (cnt < max_to_load && this.iterator.hasNext()) {
            long startTime = System.nanoTime();
            DynmapChunk chunk = this.iterator.next();
            boolean vis = true;
            if (this.visible_limits != null) {
                vis = false;
                for (VisibilityLimit limit : this.visible_limits) {
                    if (!limit.doIntersectChunk(chunk.x, chunk.z)) continue;
                    vis = true;
                    break;
                }
            }
            if (vis && this.hidden_limits != null) {
                for (VisibilityLimit limit : this.hidden_limits) {
                    if (!limit.doIntersectChunk(chunk.x, chunk.z)) continue;
                    vis = false;
                    break;
                }
            }
            ChunkSnapshot ss = null;
            DynIntHashMap tileData = null;
            SnapshotCache.SnapshotRec ssr = DynmapPlugin.plugin.sscache.getSnapshot(this.dw.getName(), chunk.x, chunk.z, this.blockdata, this.biome, this.biomeraw, this.highesty);
            if (ssr != null) {
                ss = ssr.ss;
                if (!vis) {
                    ss = this.hidestyle == MapChunkCache.HiddenChunkStyle.FILL_STONE_PLAIN ? STONE : (this.hidestyle == MapChunkCache.HiddenChunkStyle.FILL_OCEAN ? OCEAN : EMPTY);
                }
                int idx = chunk.x - this.x_min + (chunk.z - this.z_min) * this.x_dim;
                this.snaparray[idx] = ss;
                this.snaptile[idx] = ssr.tileData;
                this.endChunkLoad(startTime, MapChunkCache.ChunkStats.CACHED_SNAPSHOT_HIT);
                continue;
            }
            boolean wasLoaded = this.cps.func_73149_a(chunk.x, chunk.z);
            boolean didload = false;
            boolean isunloadpending = false;
            if (queue != null) {
                long coord = ChunkCoordIntPair.func_77272_a((int)chunk.x, (int)chunk.z);
                isunloadpending = queue.contains(coord);
            } else if (queue_mcpc != null) {
                try {
                    isunloadpending = (Boolean)unloadqueue_mcpc_contains.invoke(queue_mcpc, chunk.x, chunk.z);
                }
                catch (IllegalArgumentException e) {
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {
                    // empty catch block
                }
            }
            Chunk c = null;
            if (isunloadpending) {
                wasLoaded = true;
            }
            NBTTagCompound nbt = null;
            if (!wasLoaded) {
                nbt = this.readChunk(chunk.x, chunk.z);
                if (nbt == null && !this.readChunkActive) {
                    c = this.loadChunkNoGenerate(chunk.x, chunk.z);
                }
                didload = c != null || nbt != null;
            } else {
                c = cp.func_73158_c(chunk.x, chunk.z);
                didload = true;
            }
            if (didload) {
                tileData = new DynIntHashMap();
                boolean populated = true;
                if (!vis) {
                    ss = this.hidestyle == MapChunkCache.HiddenChunkStyle.FILL_STONE_PLAIN ? STONE : (this.hidestyle == MapChunkCache.HiddenChunkStyle.FILL_OCEAN ? OCEAN : EMPTY);
                } else if (!populated) {
                    ss = EMPTY;
                } else if (nbt != null) {
                    ss = new ChunkSnapshot(nbt, this.dw.worldheight);
                    NBTTagList tiles = nbt.func_74761_m("TileEntities");
                    if (tiles == null) {
                        tiles = new NBTTagList();
                    }
                    ArrayList<Object> vals = new ArrayList<Object>();
                    for (int tid = 0; tid < tiles.func_74745_c(); ++tid) {
                        int blkdat;
                        int tz;
                        int cz;
                        int ty;
                        NBTTagCompound tc = (NBTTagCompound)tiles.func_74743_b(tid);
                        int tx = tc.func_74762_e("x");
                        int cx = tx & 0xF;
                        int blkid = ss.getBlockTypeId(cx, ty = tc.func_74762_e("y"), cz = (tz = tc.func_74762_e("z")) & 0xF);
                        String[] te_fields = HDBlockModels.getTileEntityFieldsNeeded(blkid, blkdat = ss.getBlockData(cx, ty, cz));
                        if (te_fields == null) continue;
                        vals.clear();
                        for (String id : te_fields) {
                            Object val;
                            NBTBase v = tc.func_74781_a(id);
                            if (v == null || (val = this.getNBTValue(v)) == null) continue;
                            vals.add(id);
                            vals.add(val);
                        }
                        if (vals.size() <= 0) continue;
                        Object[] vlist = vals.toArray(new Object[vals.size()]);
                        tileData.put(ForgeMapChunkCache.getIndexInChunk(cx, ty, cz), vlist);
                    }
                    ssr = new SnapshotCache.SnapshotRec();
                    ssr.ss = ss;
                    ssr.tileData = tileData;
                    DynmapPlugin.plugin.sscache.putSnapshot(this.dw.getName(), chunk.x, chunk.z, ssr, this.blockdata, this.biome, this.biomeraw, this.highesty);
                } else {
                    ss = new ChunkSnapshot(c, this.dw.worldheight);
                    ArrayList<Object> vals = new ArrayList<Object>();
                    for (Object t : c.field_76648_i.values()) {
                        int blkdat;
                        TileEntity te = (TileEntity)t;
                        int cx = te.field_70329_l & 0xF;
                        int cz = te.field_70327_n & 0xF;
                        int blkid = ss.getBlockTypeId(cx, te.field_70330_m, cz);
                        String[] te_fields = HDBlockModels.getTileEntityFieldsNeeded(blkid, blkdat = ss.getBlockData(cx, te.field_70330_m, cz));
                        if (te_fields == null) continue;
                        NBTTagCompound tc = new NBTTagCompound();
                        try {
                            te.func_70310_b(tc);
                        }
                        catch (Exception x) {
                            // empty catch block
                        }
                        vals.clear();
                        for (String id : te_fields) {
                            Object val;
                            NBTBase v = tc.func_74781_a(id);
                            if (v == null || (val = this.getNBTValue(v)) == null) continue;
                            vals.add(id);
                            vals.add(val);
                        }
                        if (vals.size() <= 0) continue;
                        Object[] vlist = vals.toArray(new Object[vals.size()]);
                        tileData.put(ForgeMapChunkCache.getIndexInChunk(cx, te.field_70330_m, cz), vlist);
                    }
                    ssr = new SnapshotCache.SnapshotRec();
                    ssr.ss = ss;
                    ssr.tileData = tileData;
                    DynmapPlugin.plugin.sscache.putSnapshot(this.dw.getName(), chunk.x, chunk.z, ssr, this.blockdata, this.biome, this.biomeraw, this.highesty);
                }
                this.snaparray[chunk.x - this.x_min + (chunk.z - this.z_min) * this.x_dim] = ss;
                this.snaptile[chunk.x - this.x_min + (chunk.z - this.z_min) * this.x_dim] = tileData;
                if (nbt == null) {
                    if (!wasLoaded) {
                        if (this.cps != null) {
                            this.cps.func_73241_b(chunk.x, chunk.z);
                        }
                    } else if (isunloadpending && this.cps != null) {
                        this.cps.func_73241_b(chunk.x, chunk.z);
                    }
                }
                if (wasLoaded) {
                    this.endChunkLoad(startTime, MapChunkCache.ChunkStats.LOADED_CHUNKS);
                } else {
                    this.endChunkLoad(startTime, MapChunkCache.ChunkStats.UNLOADED_CHUNKS);
                }
            } else {
                this.endChunkLoad(startTime, MapChunkCache.ChunkStats.UNGENERATED_CHUNKS);
            }
            ++cnt;
        }
        DynmapCore.setIgnoreChunkLoads(false);
        if (!this.iterator.hasNext()) {
            this.isempty = true;
            for (int i = 0; i < this.snaparray.length; ++i) {
                if (this.snaparray[i] == null) {
                    this.snaparray[i] = EMPTY;
                    continue;
                }
                if (this.snaparray[i] == EMPTY) continue;
                this.isempty = false;
            }
            if (updateEntityTick != null) {
                try {
                    updateEntityTick.set(this.w, 0);
                }
                catch (Exception x) {
                    Log.severe("Cannot update updateEntityTick on world - " + x.getMessage());
                }
            }
        }
        return cnt;
    }

    @Override
    public boolean isDoneLoading() {
        if (!this.dw.isLoaded()) {
            return true;
        }
        if (this.iterator != null) {
            return !this.iterator.hasNext();
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.isempty;
    }

    @Override
    public void unloadChunks() {
        if (this.snaparray != null) {
            for (int i = 0; i < this.snaparray.length; ++i) {
                this.snaparray[i] = null;
            }
            this.snaparray = null;
        }
    }

    private void initSectionData(int idx) {
        this.isSectionNotEmpty[idx] = new boolean[this.nsect + 1];
        if (this.snaparray[idx] != EMPTY) {
            for (int i = 0; i < this.nsect; ++i) {
                if (this.snaparray[idx].isSectionEmpty(i)) continue;
                this.isSectionNotEmpty[idx][i] = true;
            }
        }
    }

    @Override
    public boolean isEmptySection(int sx, int sy, int sz) {
        int idx = sx - this.x_min + (sz - this.z_min) * this.x_dim;
        if (this.isSectionNotEmpty[idx] == null) {
            this.initSectionData(idx);
        }
        return !this.isSectionNotEmpty[idx][sy];
    }

    @Override
    public MapIterator getIterator(int x, int y, int z) {
        if (this.dw.getEnvironment().equals("the_end")) {
            return new OurEndMapIterator(x, y, z);
        }
        return new OurMapIterator(x, y, z);
    }

    @Override
    public void setHiddenFillStyle(MapChunkCache.HiddenChunkStyle style) {
        this.hidestyle = style;
    }

    @Override
    public void setVisibleRange(VisibilityLimit lim) {
        if (this.visible_limits == null) {
            this.visible_limits = new ArrayList<VisibilityLimit>();
        }
        this.visible_limits.add(lim);
    }

    @Override
    public void setHiddenRange(VisibilityLimit lim) {
        if (this.hidden_limits == null) {
            this.hidden_limits = new ArrayList<VisibilityLimit>();
        }
        this.hidden_limits.add(lim);
    }

    @Override
    public boolean setChunkDataTypes(boolean blockdata, boolean biome, boolean highestblocky, boolean rawbiome) {
        this.biome = biome;
        this.biomeraw = rawbiome;
        this.highesty = highestblocky;
        this.blockdata = blockdata;
        return true;
    }

    @Override
    public DynmapWorld getWorld() {
        return this.dw;
    }

    static /* synthetic */ byte[][] access$1002(ForgeMapChunkCache x0, byte[][] x1) {
        x0.sameneighborbiomecnt = x1;
        return x1;
    }

    static /* synthetic */ BiomeMap[][] access$1202(ForgeMapChunkCache x0, BiomeMap[][] x1) {
        x0.biomemap = x1;
        return x1;
    }

    static {
        int i;
        init = false;
        unloadqueue = null;
        unloadqueue_mcpc = null;
        unloadqueue_mcpc_contains = null;
        currentchunkloader = null;
        updateEntityTick = null;
        chunksToRemove = null;
        pendingAnvilChunksCoordinates = null;
        syncLockObject = null;
        chunkCoord = null;
        nbtTag = null;
        unstep = new BlockStep[]{BlockStep.X_MINUS, BlockStep.Y_MINUS, BlockStep.Z_MINUS, BlockStep.X_PLUS, BlockStep.Y_PLUS, BlockStep.Z_PLUS};
        noCreateLoader = new NoCreateChunkLoader();
        EMPTY = new EmptyChunk();
        STONE = new PlainChunk(1);
        OCEAN = new PlainChunk(9);
        ldchunk = false;
        rdchunk = false;
        BiomeGenBase[] b = BiomeGenBase.field_76773_a;
        BiomeMap[] bm = BiomeMap.values();
        biome_to_bmap = new BiomeMap[256];
        for (i = 0; i < biome_to_bmap.length; ++i) {
            ForgeMapChunkCache.biome_to_bmap[i] = BiomeMap.NULL;
        }
        block1: for (i = 0; i < b.length; ++i) {
            if (b[i] == null) continue;
            String bs = b[i].field_76791_y;
            for (int j = 0; j < bm.length; ++j) {
                if (!bm[j].toString().equals(bs)) continue;
                ForgeMapChunkCache.biome_to_bmap[i] = bm[j];
                continue block1;
            }
        }
    }

    private static class PlainChunk
    extends ChunkSnapshot {
        private int fillid;

        PlainChunk(int fillid) {
            super(256, 0, 0, 0L, 0L);
            this.fillid = fillid;
        }

        @Override
        public int getX() {
            return 0;
        }

        @Override
        public int getZ() {
            return 0;
        }

        @Override
        public int getBiome(int x, int z) {
            return -1;
        }

        @Override
        public final int getBlockTypeId(int x, int y, int z) {
            if (y < 64) {
                return this.fillid;
            }
            return 0;
        }

        @Override
        public final int getBlockData(int x, int y, int z) {
            return 0;
        }

        @Override
        public final int getBlockSkyLight(int x, int y, int z) {
            if (y < 64) {
                return 0;
            }
            return 15;
        }

        @Override
        public final int getBlockEmittedLight(int x, int y, int z) {
            return 0;
        }

        @Override
        public final int getHighestBlockYAt(int x, int z) {
            return 64;
        }

        @Override
        public boolean isSectionEmpty(int sy) {
            return sy < 4;
        }
    }

    private static class EmptyChunk
    extends ChunkSnapshot {
        public EmptyChunk() {
            super(256, 0, 0, 0L, 0L);
        }

        @Override
        public int getX() {
            return 0;
        }

        @Override
        public int getZ() {
            return 0;
        }

        @Override
        public final int getBlockTypeId(int x, int y, int z) {
            return 0;
        }

        @Override
        public final int getBlockData(int x, int y, int z) {
            return 0;
        }

        @Override
        public final int getBlockSkyLight(int x, int y, int z) {
            return 15;
        }

        @Override
        public final int getBlockEmittedLight(int x, int y, int z) {
            return 0;
        }

        @Override
        public final int getHighestBlockYAt(int x, int z) {
            return 0;
        }

        @Override
        public int getBiome(int x, int z) {
            return -1;
        }

        @Override
        public boolean isSectionEmpty(int sy) {
            return true;
        }
    }

    private class OurEndMapIterator
    extends OurMapIterator {
        OurEndMapIterator(int x0, int y0, int z0) {
            super(x0, y0, z0);
        }

        @Override
        public final int getBlockSkyLight() {
            return 15;
        }
    }

    public class OurMapIterator
    implements MapIterator {
        private int x;
        private int y;
        private int z;
        private int chunkindex;
        private int bx;
        private int bz;
        private ChunkSnapshot snap;
        private BlockStep laststep;
        private int typeid = -1;
        private int blkdata = -1;
        private final int worldheight;
        private final int x_base;
        private final int z_base;

        OurMapIterator(int x0, int y0, int z0) {
            this.x_base = ForgeMapChunkCache.this.x_min << 4;
            this.z_base = ForgeMapChunkCache.this.z_min << 4;
            if (ForgeMapChunkCache.this.biome) {
                this.biomePrep();
            }
            this.initialize(x0, y0, z0);
            this.worldheight = ForgeMapChunkCache.this.w.func_72800_K();
        }

        @Override
        public final void initialize(int x0, int y0, int z0) {
            this.x = x0;
            this.y = y0;
            this.z = z0;
            this.chunkindex = (this.x >> 4) - ForgeMapChunkCache.this.x_min + ((this.z >> 4) - ForgeMapChunkCache.this.z_min) * ForgeMapChunkCache.this.x_dim;
            this.bx = this.x & 0xF;
            this.bz = this.z & 0xF;
            this.snap = this.chunkindex >= ForgeMapChunkCache.this.snapcnt || this.chunkindex < 0 ? EMPTY : ForgeMapChunkCache.this.snaparray[this.chunkindex];
            this.laststep = BlockStep.Y_MINUS;
            if (this.y >= 0 && this.y < this.worldheight) {
                this.blkdata = -1;
                this.typeid = -1;
            } else {
                this.blkdata = 0;
                this.typeid = 0;
            }
        }

        @Override
        public final int getBlockTypeID() {
            if (this.typeid < 0) {
                this.typeid = this.snap.getBlockTypeId(this.bx, this.y, this.bz);
            }
            return this.typeid;
        }

        @Override
        public final int getBlockData() {
            if (this.blkdata < 0) {
                this.blkdata = this.snap.getBlockData(this.bx, this.y, this.bz);
            }
            return this.blkdata;
        }

        @Override
        public int getBlockSkyLight() {
            try {
                return this.snap.getBlockSkyLight(this.bx, this.y, this.bz);
            }
            catch (ArrayIndexOutOfBoundsException aioobx) {
                return 15;
            }
        }

        @Override
        public final int getBlockEmittedLight() {
            try {
                return this.snap.getBlockEmittedLight(this.bx, this.y, this.bz);
            }
            catch (ArrayIndexOutOfBoundsException aioobx) {
                return 0;
            }
        }

        private void biomePrep() {
            int i;
            if (ForgeMapChunkCache.this.sameneighborbiomecnt != null) {
                return;
            }
            int x_size = ForgeMapChunkCache.this.x_dim << 4;
            int z_size = ForgeMapChunkCache.this.z_max - ForgeMapChunkCache.this.z_min + 1 << 4;
            ForgeMapChunkCache.access$1002(ForgeMapChunkCache.this, new byte[x_size][]);
            ForgeMapChunkCache.access$1202(ForgeMapChunkCache.this, new BiomeMap[x_size][]);
            for (i = 0; i < x_size; ++i) {
                ((ForgeMapChunkCache)ForgeMapChunkCache.this).sameneighborbiomecnt[i] = new byte[z_size];
                ((ForgeMapChunkCache)ForgeMapChunkCache.this).biomemap[i] = new BiomeMap[z_size];
            }
            for (i = 0; i < x_size; ++i) {
                for (int j = 0; j < z_size; ++j) {
                    BiomeMap bm;
                    if (j == 0) {
                        this.initialize(i + this.x_base, 64, this.z_base);
                    } else {
                        this.stepPosition(BlockStep.Z_PLUS);
                    }
                    int bb = this.snap.getBiome(this.bx, this.bz);
                    ((ForgeMapChunkCache)ForgeMapChunkCache.this).biomemap[i][j] = bm = BiomeMap.byBiomeID(bb);
                    int cnt = 0;
                    if (i > 0) {
                        if (bm == ForgeMapChunkCache.this.biomemap[i - 1][j]) {
                            ++cnt;
                            byte[] byArray = ForgeMapChunkCache.this.sameneighborbiomecnt[i - 1];
                            int n = j;
                            byArray[n] = (byte)(byArray[n] + 1);
                        }
                        if (j > 0 && bm == ForgeMapChunkCache.this.biomemap[i - 1][j - 1]) {
                            ++cnt;
                            byte[] byArray = ForgeMapChunkCache.this.sameneighborbiomecnt[i - 1];
                            int n = j - 1;
                            byArray[n] = (byte)(byArray[n] + 1);
                        }
                        if (j < z_size - 1 && bm == ForgeMapChunkCache.this.biomemap[i - 1][j + 1]) {
                            ++cnt;
                            byte[] byArray = ForgeMapChunkCache.this.sameneighborbiomecnt[i - 1];
                            int n = j + 1;
                            byArray[n] = (byte)(byArray[n] + 1);
                        }
                    }
                    if (j > 0 && ForgeMapChunkCache.this.biomemap[i][j] == ForgeMapChunkCache.this.biomemap[i][j - 1]) {
                        ++cnt;
                        byte[] byArray = ForgeMapChunkCache.this.sameneighborbiomecnt[i];
                        int n = j - 1;
                        byArray[n] = (byte)(byArray[n] + 1);
                    }
                    ((ForgeMapChunkCache)ForgeMapChunkCache.this).sameneighborbiomecnt[i][j] = (byte)cnt;
                }
            }
        }

        @Override
        public final BiomeMap getBiome() {
            try {
                return ForgeMapChunkCache.this.biomemap[this.x - this.x_base][this.z - this.z_base];
            }
            catch (Exception ex) {
                return BiomeMap.NULL;
            }
        }

        @Override
        public final int getSmoothGrassColorMultiplier(int[] colormap) {
            int mult = 0xFFFFFF;
            try {
                int rx = this.x - this.x_base;
                int rz = this.z - this.z_base;
                BiomeMap bm = ForgeMapChunkCache.this.biomemap[rx][rz];
                if (ForgeMapChunkCache.this.sameneighborbiomecnt[rx][rz] >= 8) {
                    mult = bm.getModifiedGrassMultiplier(colormap[bm.biomeLookup()]);
                } else {
                    int raccum = 0;
                    int gaccum = 0;
                    int baccum = 0;
                    for (int xoff = -1; xoff < 2; ++xoff) {
                        for (int zoff = -1; zoff < 2; ++zoff) {
                            bm = ForgeMapChunkCache.this.biomemap[rx + xoff][rz + zoff];
                            int rmult = bm.getModifiedGrassMultiplier(colormap[bm.biomeLookup()]);
                            raccum += rmult >> 16 & 0xFF;
                            gaccum += rmult >> 8 & 0xFF;
                            baccum += rmult & 0xFF;
                        }
                    }
                    mult = raccum / 9 << 16 | gaccum / 9 << 8 | baccum / 9;
                }
            }
            catch (Exception x) {
                mult = 0xFFFFFF;
            }
            return mult;
        }

        @Override
        public final int getSmoothFoliageColorMultiplier(int[] colormap) {
            int mult = 0xFFFFFF;
            try {
                int rx = this.x - this.x_base;
                int rz = this.z - this.z_base;
                BiomeMap bm = ForgeMapChunkCache.this.biomemap[rx][rz];
                if (ForgeMapChunkCache.this.sameneighborbiomecnt[rx][rz] >= 8) {
                    mult = bm.getModifiedFoliageMultiplier(colormap[bm.biomeLookup()]);
                } else {
                    int raccum = 0;
                    int gaccum = 0;
                    int baccum = 0;
                    for (int xoff = -1; xoff < 2; ++xoff) {
                        for (int zoff = -1; zoff < 2; ++zoff) {
                            bm = ForgeMapChunkCache.this.biomemap[rx + xoff][rz + zoff];
                            int rmult = bm.getModifiedFoliageMultiplier(colormap[bm.biomeLookup()]);
                            raccum += rmult >> 16 & 0xFF;
                            gaccum += rmult >> 8 & 0xFF;
                            baccum += rmult & 0xFF;
                        }
                    }
                    mult = raccum / 9 << 16 | gaccum / 9 << 8 | baccum / 9;
                }
            }
            catch (Exception x) {
                mult = 0xFFFFFF;
            }
            return mult;
        }

        @Override
        public final int getSmoothColorMultiplier(int[] colormap, int[] swampmap) {
            int mult = 0xFFFFFF;
            try {
                int rx = this.x - this.x_base;
                int rz = this.z - this.z_base;
                BiomeMap bm = ForgeMapChunkCache.this.biomemap[rx][rz];
                if (ForgeMapChunkCache.this.sameneighborbiomecnt[rx][rz] >= 8) {
                    mult = bm == BiomeMap.SWAMPLAND ? swampmap[bm.biomeLookup()] : colormap[bm.biomeLookup()];
                } else {
                    int raccum = 0;
                    int gaccum = 0;
                    int baccum = 0;
                    for (int xoff = -1; xoff < 2; ++xoff) {
                        for (int zoff = -1; zoff < 2; ++zoff) {
                            bm = ForgeMapChunkCache.this.biomemap[rx + xoff][rz + zoff];
                            int rmult = bm == BiomeMap.SWAMPLAND ? swampmap[bm.biomeLookup()] : colormap[bm.biomeLookup()];
                            raccum += rmult >> 16 & 0xFF;
                            gaccum += rmult >> 8 & 0xFF;
                            baccum += rmult & 0xFF;
                        }
                    }
                    mult = raccum / 9 << 16 | gaccum / 9 << 8 | baccum / 9;
                }
            }
            catch (Exception x) {
                mult = 0xFFFFFF;
            }
            return mult;
        }

        @Override
        public final int getSmoothWaterColorMultiplier() {
            try {
                int rx = this.x - this.x_base;
                int rz = this.z - this.z_base;
                BiomeMap bm = ForgeMapChunkCache.this.biomemap[rx][rz];
                if (ForgeMapChunkCache.this.sameneighborbiomecnt[rx][rz] >= 8) {
                    return bm.getWaterColorMult();
                }
                int raccum = 0;
                int gaccum = 0;
                int baccum = 0;
                for (int xoff = -1; xoff < 2; ++xoff) {
                    for (int zoff = -1; zoff < 2; ++zoff) {
                        bm = ForgeMapChunkCache.this.biomemap[rx + xoff][rz + zoff];
                        int mult = bm.getWaterColorMult();
                        raccum += mult >> 16 & 0xFF;
                        gaccum += mult >> 8 & 0xFF;
                        baccum += mult & 0xFF;
                    }
                }
                return raccum / 9 << 16 | gaccum / 9 << 8 | baccum / 9;
            }
            catch (Exception x) {
                return 0xFFFFFF;
            }
        }

        @Override
        public final int getSmoothWaterColorMultiplier(int[] colormap) {
            int mult = 0xFFFFFF;
            try {
                int rx = this.x - this.x_base;
                int rz = this.z - this.z_base;
                BiomeMap bm = ForgeMapChunkCache.this.biomemap[rx][rz];
                if (ForgeMapChunkCache.this.sameneighborbiomecnt[rx][rz] >= 8) {
                    mult = colormap[bm.biomeLookup()];
                } else {
                    int raccum = 0;
                    int gaccum = 0;
                    int baccum = 0;
                    for (int xoff = -1; xoff < 2; ++xoff) {
                        for (int zoff = -1; zoff < 2; ++zoff) {
                            bm = ForgeMapChunkCache.this.biomemap[rx + xoff][rz + zoff];
                            int rmult = colormap[bm.biomeLookup()];
                            raccum += rmult >> 16 & 0xFF;
                            gaccum += rmult >> 8 & 0xFF;
                            baccum += rmult & 0xFF;
                        }
                    }
                    mult = raccum / 9 << 16 | gaccum / 9 << 8 | baccum / 9;
                }
            }
            catch (Exception x) {
                mult = 0xFFFFFF;
            }
            return mult;
        }

        @Override
        public final void stepPosition(BlockStep step) {
            this.typeid = -1;
            this.blkdata = -1;
            switch (step.ordinal()) {
                case 0: {
                    ++this.x;
                    ++this.bx;
                    if (this.bx != 16) break;
                    this.bx = 0;
                    ++this.chunkindex;
                    if (this.chunkindex >= ForgeMapChunkCache.this.snapcnt || this.chunkindex < 0) {
                        this.snap = EMPTY;
                        break;
                    }
                    this.snap = ForgeMapChunkCache.this.snaparray[this.chunkindex];
                    break;
                }
                case 1: {
                    ++this.y;
                    if (this.y < this.worldheight) break;
                    this.blkdata = 0;
                    this.typeid = 0;
                    break;
                }
                case 2: {
                    ++this.z;
                    ++this.bz;
                    if (this.bz != 16) break;
                    this.bz = 0;
                    this.chunkindex += ForgeMapChunkCache.this.x_dim;
                    if (this.chunkindex >= ForgeMapChunkCache.this.snapcnt || this.chunkindex < 0) {
                        this.snap = EMPTY;
                        break;
                    }
                    this.snap = ForgeMapChunkCache.this.snaparray[this.chunkindex];
                    break;
                }
                case 3: {
                    --this.x;
                    --this.bx;
                    if (this.bx != -1) break;
                    this.bx = 15;
                    --this.chunkindex;
                    if (this.chunkindex >= ForgeMapChunkCache.this.snapcnt || this.chunkindex < 0) {
                        this.snap = EMPTY;
                        break;
                    }
                    this.snap = ForgeMapChunkCache.this.snaparray[this.chunkindex];
                    break;
                }
                case 4: {
                    --this.y;
                    if (this.y >= 0) break;
                    this.blkdata = 0;
                    this.typeid = 0;
                    break;
                }
                case 5: {
                    --this.z;
                    --this.bz;
                    if (this.bz != -1) break;
                    this.bz = 15;
                    this.chunkindex -= ForgeMapChunkCache.this.x_dim;
                    this.snap = this.chunkindex >= ForgeMapChunkCache.this.snapcnt || this.chunkindex < 0 ? EMPTY : ForgeMapChunkCache.this.snaparray[this.chunkindex];
                }
            }
            this.laststep = step;
        }

        @Override
        public BlockStep unstepPosition() {
            BlockStep ls = this.laststep;
            this.stepPosition(unstep[ls.ordinal()]);
            return ls;
        }

        @Override
        public void unstepPosition(BlockStep s) {
            this.stepPosition(unstep[s.ordinal()]);
        }

        @Override
        public final void setY(int y) {
            this.laststep = y > this.y ? BlockStep.Y_PLUS : BlockStep.Y_MINUS;
            this.y = y;
            if (y < 0 || y >= this.worldheight) {
                this.blkdata = 0;
                this.typeid = 0;
            } else {
                this.blkdata = -1;
                this.typeid = -1;
            }
        }

        @Override
        public final int getX() {
            return this.x;
        }

        @Override
        public final int getY() {
            return this.y;
        }

        @Override
        public final int getZ() {
            return this.z;
        }

        @Override
        public final int getBlockTypeIDAt(BlockStep s) {
            if (s == BlockStep.Y_MINUS) {
                if (this.y > 0) {
                    return this.snap.getBlockTypeId(this.bx, this.y - 1, this.bz);
                }
            } else if (s == BlockStep.Y_PLUS) {
                if (this.y < this.worldheight - 1) {
                    return this.snap.getBlockTypeId(this.bx, this.y + 1, this.bz);
                }
            } else {
                BlockStep ls = this.laststep;
                this.stepPosition(s);
                int tid = this.snap.getBlockTypeId(this.bx, this.y, this.bz);
                this.unstepPosition();
                this.laststep = ls;
                return tid;
            }
            return 0;
        }

        @Override
        public BlockStep getLastStep() {
            return this.laststep;
        }

        @Override
        public int getWorldHeight() {
            return this.worldheight;
        }

        @Override
        public long getBlockKey() {
            return this.chunkindex * this.worldheight + this.y << 8 | this.bx << 4 | this.bz;
        }

        @Override
        public final boolean isEmptySection() {
            try {
                return !ForgeMapChunkCache.this.isSectionNotEmpty[this.chunkindex][this.y >> 4];
            }
            catch (Exception x) {
                ForgeMapChunkCache.this.initSectionData(this.chunkindex);
                return !ForgeMapChunkCache.this.isSectionNotEmpty[this.chunkindex][this.y >> 4];
            }
        }

        @Override
        public RenderPatchFactory getPatchFactory() {
            return HDBlockModels.getPatchDefinitionFactory();
        }

        @Override
        public Object getBlockTileEntityField(String fieldId) {
            try {
                int idx = ForgeMapChunkCache.getIndexInChunk(this.bx, this.y, this.bz);
                Object[] vals = (Object[])ForgeMapChunkCache.this.snaptile[this.chunkindex].get(idx);
                for (int i = 0; i < vals.length; i += 2) {
                    if (!vals[i].equals(fieldId)) continue;
                    return vals[i + 1];
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        @Override
        public int getBlockTypeIDAt(int xoff, int yoff, int zoff) {
            int xx = this.x + xoff;
            int yy = this.y + yoff;
            int zz = this.z + zoff;
            int idx = (xx >> 4) - ForgeMapChunkCache.this.x_min + ((zz >> 4) - ForgeMapChunkCache.this.z_min) * ForgeMapChunkCache.this.x_dim;
            try {
                return ForgeMapChunkCache.this.snaparray[idx].getBlockTypeId(xx & 0xF, yy, zz & 0xF);
            }
            catch (Exception x) {
                return 0;
            }
        }

        @Override
        public int getBlockDataAt(int xoff, int yoff, int zoff) {
            int xx = this.x + xoff;
            int yy = this.y + yoff;
            int zz = this.z + zoff;
            int idx = (xx >> 4) - ForgeMapChunkCache.this.x_min + ((zz >> 4) - ForgeMapChunkCache.this.z_min) * ForgeMapChunkCache.this.x_dim;
            try {
                return ForgeMapChunkCache.this.snaparray[idx].getBlockData(xx & 0xF, yy, zz & 0xF);
            }
            catch (Exception x) {
                return 0;
            }
        }

        @Override
        public Object getBlockTileEntityFieldAt(String fieldId, int xoff, int yoff, int zoff) {
            return null;
        }

        @Override
        public long getInhabitedTicks() {
            return this.snap.getInhabitedTicks();
        }
    }

    private static class NoCreateChunkLoader
    implements IChunkLoader {
        IChunkLoader base;
        World ww;
        int xx;
        int zz;

        private NoCreateChunkLoader() {
        }

        public Chunk func_75815_a(World w, int x, int z) throws IOException {
            Chunk c = this.base.func_75815_a(w, x, z);
            if (c == null && w == this.ww && x == this.xx && z == this.zz) {
                throw new NoChunkFoundThrow();
            }
            return c;
        }

        public void func_75816_a(World var1, Chunk var2) throws MinecraftException, IOException {
            this.base.func_75816_a(var1, var2);
        }

        public void func_75819_b(World var1, Chunk var2) {
            this.base.func_75819_b(var1, var2);
        }

        public void func_75817_a() {
            this.base.func_75817_a();
        }

        public void func_75818_b() {
            this.base.func_75818_b();
        }
    }

    private static class NoChunkFoundThrow
    extends Error {
        private static final long serialVersionUID = 207122916585582193L;

        private NoChunkFoundThrow() {
        }
    }
}

