/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.flat;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dynmap.Client;
import org.dynmap.Color;
import org.dynmap.ColorScheme;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapChunk;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapWorld;
import org.dynmap.JSONUtils;
import org.dynmap.MapManager;
import org.dynmap.MapTile;
import org.dynmap.MapType;
import org.dynmap.TileHashManager;
import org.dynmap.debug.Debug;
import org.dynmap.json.simple.JSONObject;
import org.dynmap.utils.BlockStep;
import org.dynmap.utils.DynmapBufferedImage;
import org.dynmap.utils.FileLockManager;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.MapIterator;
import org.dynmap.utils.TileFlags;

public class FlatMap
extends MapType {
    private String prefix;
    private String name;
    private ColorScheme colorScheme;
    private int maximumHeight = -1;
    private int ambientlight = 15;
    private int[] shadowscale = null;
    private boolean night_and_day;
    protected boolean transparency;
    private Texture textured = Texture.NONE;
    private boolean isbigmap;
    private String title;
    private String icon;
    private String bg_cfg;
    private String bg_day_cfg;
    private String bg_night_cfg;
    private int mapzoomin;
    private double shadowstrength;
    private static final int[] stepseq = new int[]{1, 3, 0, 2};

    public FlatMap(DynmapCore core, ConfigurationNode configuration) {
        this.name = configuration.getString("name", null);
        this.prefix = configuration.getString("prefix", this.name);
        this.colorScheme = ColorScheme.getScheme(core, (String)configuration.get("colorscheme"));
        this.maximumHeight = configuration.getInteger("maximumheight", 127);
        this.shadowstrength = configuration.getDouble("shadowstrength", 0.0);
        if (this.shadowstrength > 0.0) {
            this.shadowscale = new int[16];
            this.shadowscale[15] = 256;
            for (int i = 14; i >= 0; --i) {
                double v = (double)this.shadowscale[i + 1] * (1.0 - 0.2 * this.shadowstrength);
                this.shadowscale[i] = (int)v;
                if (this.shadowscale[i] > 256) {
                    this.shadowscale[i] = 256;
                }
                if (this.shadowscale[i] >= 0) continue;
                this.shadowscale[i] = 0;
            }
        }
        this.ambientlight = configuration.getInteger("ambientlight", 15);
        this.night_and_day = configuration.getBoolean("night-and-day", false);
        this.transparency = configuration.getBoolean("transparency", false);
        String tex = configuration.getString("textured", "none");
        this.textured = tex.equals("none") ? Texture.NONE : (tex.equals("dither") ? Texture.DITHER : Texture.SMOOTH);
        this.isbigmap = configuration.getBoolean("isbigmap", false);
        this.title = configuration.getString("title");
        this.icon = configuration.getString("icon");
        this.bg_cfg = configuration.getString("background");
        this.bg_day_cfg = configuration.getString("backgroundday");
        this.bg_night_cfg = configuration.getString("backgroundnight");
        this.mapzoomin = configuration.getInteger("mapzoomin", 3);
        this.setProtected(configuration.getBoolean("protected", false));
        this.setTileUpdateDelay(configuration.getInteger("tileupdatedelay", -1));
    }

    @Override
    public ConfigurationNode saveConfiguration() {
        ConfigurationNode cn = super.saveConfiguration();
        if (this.title != null) {
            cn.put("title", (Object)this.title);
        }
        cn.put("prefix", (Object)this.prefix);
        if (this.icon != null) {
            cn.put("icon", (Object)this.icon);
        }
        if (this.colorScheme != null) {
            cn.put("colorscheme", (Object)this.colorScheme.name);
        }
        cn.put("maximumheight", (Object)this.maximumHeight);
        cn.put("shadowstrength", (Object)this.shadowstrength);
        cn.put("ambientlgith", (Object)this.ambientlight);
        cn.put("night-and-day", (Object)this.night_and_day);
        cn.put("transparency", (Object)this.transparency);
        cn.put("protected", (Object)this.isProtected());
        if (this.tileupdatedelay > 0) {
            cn.put("tileupdatedelay", (Object)this.tileupdatedelay);
        }
        String txt = "none";
        if (this.textured == Texture.DITHER) {
            txt = "dither";
        } else if (this.textured == Texture.SMOOTH) {
            txt = "smooth";
        }
        cn.put("textured", (Object)txt);
        cn.put("isbigmap", (Object)this.isbigmap);
        if (this.bg_cfg != null) {
            cn.put("background", (Object)this.bg_cfg);
        }
        if (this.bg_day_cfg != null) {
            cn.put("backgroundday", (Object)this.bg_day_cfg);
        }
        if (this.bg_night_cfg != null) {
            cn.put("backgroundnight", (Object)this.bg_night_cfg);
        }
        cn.put("mapzoomin", (Object)this.mapzoomin);
        return cn;
    }

    @Override
    public List<TileFlags.TileCoord> getTileCoords(DynmapWorld w, int x, int y, int z) {
        return Collections.singletonList(new TileFlags.TileCoord(x >> 7, z >> 7));
    }

    @Override
    public List<TileFlags.TileCoord> getTileCoords(DynmapWorld w, int xmin, int ymin, int zmin, int xmax, int ymax, int zmax) {
        ArrayList<TileFlags.TileCoord> rslt = new ArrayList<TileFlags.TileCoord>();
        for (int i = xmin; i <= xmax; ++i) {
            for (int j = zmin; j < zmax; ++j) {
                rslt.add(new TileFlags.TileCoord(i, j));
            }
        }
        return rslt;
    }

    @Override
    public MapTile[] getAdjecentTiles(MapTile tile) {
        FlatMapTile t = (FlatMapTile)tile;
        DynmapWorld w = t.getDynmapWorld();
        int x = t.x;
        int y = t.y;
        int s = t.size;
        return new MapTile[]{new FlatMapTile(w, this, x, y - 1, s), new FlatMapTile(w, this, x + 1, y, s), new FlatMapTile(w, this, x, y + 1, s), new FlatMapTile(w, this, x - 1, y, s)};
    }

    @Override
    public List<DynmapChunk> getRequiredChunks(MapTile tile) {
        FlatMapTile t = (FlatMapTile)tile;
        int chunksPerTile = t.size / 16;
        int sx = t.x * chunksPerTile;
        int sz = t.y * chunksPerTile;
        ArrayList<DynmapChunk> result = new ArrayList<DynmapChunk>(chunksPerTile * chunksPerTile);
        for (int x = 0; x < chunksPerTile; ++x) {
            for (int z = 0; z < chunksPerTile; ++z) {
                result.add(new DynmapChunk(sx + x, sz + z));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean render(MapChunkCache cache, MapTile tile, File outputFile) {
        boolean tile_update;
        long crc;
        TileHashManager hashman;
        int[] argb_buf_day;
        DynmapBufferedImage im_day;
        boolean didwrite;
        FlatMapTile t;
        block43: {
            t = (FlatMapTile)tile;
            int maxheight = this.maximumHeight;
            int worldheight = tile.getDynmapWorld().worldheight - 1;
            if (maxheight < 0 || maxheight == 127) {
                maxheight = worldheight;
            }
            boolean isnether = t.getDynmapWorld().isNether() && maxheight == worldheight;
            didwrite = false;
            Color rslt = new Color();
            int[] pixel = new int[4];
            int[] pixel_day = null;
            DynmapBufferedImage im = DynmapBufferedImage.allocateBufferedImage(t.size, t.size);
            int[] argb_buf = im.argb_buf;
            im_day = null;
            argb_buf_day = null;
            if (this.night_and_day) {
                im_day = DynmapBufferedImage.allocateBufferedImage(t.size, t.size);
                argb_buf_day = im_day.argb_buf;
                pixel_day = new int[4];
            }
            MapIterator mapiter = cache.getIterator(t.x * t.size, worldheight, t.y * t.size);
            for (int x = 0; x < t.size; ++x) {
                mapiter.initialize(t.x * t.size + x, worldheight, t.y * t.size);
                for (int y = 0; y < t.size; ++y) {
                    Color c;
                    Color[] colors;
                    int blockType;
                    mapiter.setY(worldheight);
                    if (isnether) {
                        while ((blockType = mapiter.getBlockTypeID()) != 0) {
                            mapiter.stepPosition(BlockStep.Y_MINUS);
                            if (mapiter.getY() >= 0) continue;
                            mapiter.setY(worldheight);
                            blockType = mapiter.getBlockTypeID();
                            break;
                        }
                        if (blockType == 0) {
                            while ((blockType = mapiter.getBlockTypeID()) == 0) {
                                mapiter.stepPosition(BlockStep.Y_MINUS);
                                if (mapiter.getY() >= 0) continue;
                                mapiter.setY(0);
                                break;
                            }
                        }
                    } else {
                        int my = maxheight;
                        mapiter.setY(my);
                        while ((blockType = mapiter.getBlockTypeID()) == 0 && --my >= 0) {
                            mapiter.stepPosition(BlockStep.Y_MINUS);
                        }
                    }
                    int data = 0;
                    try {
                        if (this.colorScheme.datacolors[blockType] != null) {
                            data = mapiter.getBlockData();
                            colors = this.colorScheme.datacolors[blockType][data];
                        } else {
                            colors = this.colorScheme.colors[blockType];
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException aioobx) {
                        this.colorScheme.resizeColorArray(blockType);
                        colors = null;
                    }
                    if (colors != null && (c = this.textured == Texture.SMOOTH ? colors[4] : (this.textured == Texture.DITHER && (x + y & 1) == 1 ? colors[2] : colors[0])) != null) {
                        pixel[0] = c.getRed();
                        pixel[1] = c.getGreen();
                        pixel[2] = c.getBlue();
                        pixel[3] = c.getAlpha();
                        if (this.transparency && pixel[3] < 255) {
                            this.process_transparent(pixel, pixel_day, mapiter);
                        } else if (this.shadowscale != null && this.ambientlight < 15) {
                            if (mapiter.getY() < worldheight) {
                                mapiter.stepPosition(BlockStep.Y_PLUS);
                            }
                            if (this.night_and_day) {
                                pixel_day[0] = pixel[0];
                                pixel_day[1] = pixel[1];
                                pixel_day[2] = pixel[2];
                                pixel_day[3] = 255;
                            }
                            int light = Math.max(this.ambientlight, mapiter.getBlockEmittedLight());
                            pixel[0] = pixel[0] * this.shadowscale[light] >> 8;
                            pixel[1] = pixel[1] * this.shadowscale[light] >> 8;
                            pixel[2] = pixel[2] * this.shadowscale[light] >> 8;
                            pixel[3] = 255;
                        } else {
                            int ys = mapiter.getY();
                            boolean below = ys < 64;
                            float height = below ? (float)(64 - ys) / 64.0f : (float)(ys - 64) / (float)worldheight;
                            float step = 10.0f / (float)(worldheight + 1);
                            float scale = (float)((int)(height / step)) * step;
                            scale = (float)Math.pow(scale, 1.1f);
                            scale *= 0.8f;
                            if (below) {
                                pixel[0] = (int)((float)pixel[0] - (float)pixel[0] * scale);
                                pixel[1] = (int)((float)pixel[1] - (float)pixel[1] * scale);
                                pixel[2] = (int)((float)pixel[2] - (float)pixel[2] * scale);
                                pixel[3] = 255;
                            } else {
                                pixel[0] = (int)((float)pixel[0] + (float)(255 - pixel[0]) * scale);
                                pixel[1] = (int)((float)pixel[1] + (float)(255 - pixel[1]) * scale);
                                pixel[2] = (int)((float)pixel[2] + (float)(255 - pixel[2]) * scale);
                                pixel[3] = 255;
                            }
                            if (this.night_and_day) {
                                pixel_day[0] = pixel[0];
                                pixel_day[1] = pixel[1];
                                pixel_day[2] = pixel[2];
                                pixel_day[3] = 255;
                            }
                        }
                        rslt.setRGBA(pixel[0], pixel[1], pixel[2], pixel[3]);
                        argb_buf[t.size - y - 1 + x * t.size] = rslt.getARGB();
                        if (this.night_and_day) {
                            rslt.setRGBA(pixel_day[0], pixel_day[1], pixel_day[2], pixel[3]);
                            argb_buf_day[t.size - y - 1 + x * t.size] = rslt.getARGB();
                        }
                    }
                    mapiter.stepPosition(BlockStep.Z_PLUS);
                }
            }
            hashman = MapManager.mapman.hashman;
            crc = hashman.calculateTileHash(argb_buf);
            tile_update = false;
            FileLockManager.getWriteLock(outputFile);
            try {
                if (!outputFile.exists() || crc != hashman.getImageHashCode(tile.getKey(this.prefix), null, t.x, t.y)) {
                    Debug.debug("saving image " + outputFile.getPath());
                    if (!outputFile.getParentFile().exists()) {
                        outputFile.getParentFile().mkdirs();
                    }
                    try {
                        FileLockManager.imageIOWrite(im.buf_img, MapType.ImageFormat.FORMAT_PNG, outputFile);
                    }
                    catch (IOException e) {
                        Debug.error("Failed to save image: " + outputFile.getPath(), e);
                    }
                    catch (NullPointerException e) {
                        Debug.error("Failed to save image (NullPointerException): " + outputFile.getPath(), e);
                    }
                    MapManager.mapman.pushUpdate(tile.getDynmapWorld(), (Client.Update)new Client.Tile(tile.getFilename()));
                    hashman.updateHashCode(tile.getKey(this.prefix), null, t.x, t.y, crc);
                    tile.getDynmapWorld().enqueueZoomOutUpdate(outputFile);
                    tile_update = true;
                    didwrite = true;
                    break block43;
                }
                Debug.debug("skipping image " + outputFile.getPath() + " - hash match");
            }
            finally {
                FileLockManager.releaseWriteLock(outputFile);
                DynmapBufferedImage.freeBufferedImage(im);
            }
        }
        MapManager.mapman.updateStatistics(tile, this.prefix, true, tile_update, true);
        if (this.night_and_day) {
            block44: {
                File dayfile = new File(tile.getDynmapWorld().worldtilepath, tile.getDayFilename());
                crc = hashman.calculateTileHash(argb_buf_day);
                FileLockManager.getWriteLock(dayfile);
                try {
                    if (!dayfile.exists() || crc != hashman.getImageHashCode(tile.getKey(this.prefix), "day", t.x, t.y)) {
                        Debug.debug("saving image " + dayfile.getPath());
                        if (!dayfile.getParentFile().exists()) {
                            dayfile.getParentFile().mkdirs();
                        }
                        try {
                            FileLockManager.imageIOWrite(im_day.buf_img, MapType.ImageFormat.FORMAT_PNG, dayfile);
                        }
                        catch (IOException e) {
                            Debug.error("Failed to save image: " + dayfile.getPath(), e);
                        }
                        catch (NullPointerException e) {
                            Debug.error("Failed to save image (NullPointerException): " + dayfile.getPath(), e);
                        }
                        MapManager.mapman.pushUpdate(tile.getDynmapWorld(), (Client.Update)new Client.Tile(tile.getDayFilename()));
                        hashman.updateHashCode(tile.getKey(this.prefix), "day", t.x, t.y, crc);
                        tile.getDynmapWorld().enqueueZoomOutUpdate(dayfile);
                        tile_update = true;
                        didwrite = true;
                        break block44;
                    }
                    Debug.debug("skipping image " + dayfile.getPath() + " - hash match");
                    tile_update = false;
                }
                finally {
                    FileLockManager.releaseWriteLock(dayfile);
                    DynmapBufferedImage.freeBufferedImage(im_day);
                }
            }
            MapManager.mapman.updateStatistics(tile, this.prefix + "_day", true, tile_update, true);
        }
        return didwrite;
    }

    private void process_transparent(int[] pixel, int[] pixel_day, MapIterator mapiter) {
        int r = pixel[0];
        int g = pixel[1];
        int b = pixel[2];
        int a = pixel[3];
        int r_day = 0;
        int g_day = 0;
        int b_day = 0;
        int a_day = 0;
        if (pixel_day != null) {
            r_day = pixel[0];
            g_day = pixel[1];
            b_day = pixel[2];
            a_day = pixel[3];
        }
        if (a < 255) {
            a = a_day = 255 - ((255 - a) * (255 - a) >> 8);
        }
        if (this.shadowscale != null && this.ambientlight < 15) {
            boolean did_inc = false;
            if (mapiter.getY() < 127) {
                mapiter.stepPosition(BlockStep.Y_PLUS);
                did_inc = true;
            }
            if (this.night_and_day) {
                r_day = r;
                g_day = g;
                b_day = b;
                a_day = a;
            }
            int light = Math.max(this.ambientlight, mapiter.getBlockEmittedLight());
            r = r * this.shadowscale[light] >> 8;
            g = g * this.shadowscale[light] >> 8;
            b = b * this.shadowscale[light] >> 8;
            if (did_inc) {
                mapiter.stepPosition(BlockStep.Y_MINUS);
            }
        }
        if (a < 255) {
            pixel[3] = 0;
            pixel[2] = 0;
            pixel[1] = 0;
            pixel[0] = 0;
            if (pixel_day != null) {
                pixel_day[3] = 0;
                pixel_day[2] = 0;
                pixel_day[1] = 0;
                pixel_day[0] = 0;
            }
            mapiter.stepPosition(BlockStep.Y_MINUS);
            if (mapiter.getY() >= 0) {
                Color c;
                int blockType = mapiter.getBlockTypeID();
                int data = 0;
                Color[] colors = this.colorScheme.colors[blockType];
                if (this.colorScheme.datacolors[blockType] != null) {
                    data = mapiter.getBlockData();
                    colors = this.colorScheme.datacolors[blockType][data];
                }
                if (colors != null && (c = colors[0]) != null) {
                    pixel[0] = c.getRed();
                    pixel[1] = c.getGreen();
                    pixel[2] = c.getBlue();
                    pixel[3] = c.getAlpha();
                }
                this.process_transparent(pixel, pixel_day, mapiter);
            }
        }
        int na = 255 - a;
        pixel[0] = pixel[0] * na + (r *= a) >> 8;
        pixel[1] = pixel[1] * na + (g *= a) >> 8;
        pixel[2] = pixel[2] * na + (b *= a) >> 8;
        pixel[3] = 255;
        if (pixel_day != null) {
            na = 255 - a_day;
            pixel_day[0] = pixel_day[0] * na + (r_day *= a_day) >> 8;
            pixel_day[1] = pixel_day[1] * na + (g_day *= a_day) >> 8;
            pixel_day[2] = pixel_day[2] * na + (b_day *= a_day) >> 8;
            pixel_day[3] = 255;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public List<MapType> getMapsSharingRender(DynmapWorld w) {
        return Collections.singletonList(this);
    }

    @Override
    public List<String> getMapNamesSharingRender(DynmapWorld w) {
        return Collections.singletonList(this.name);
    }

    @Override
    public List<MapType.ZoomInfo> baseZoomFileInfo() {
        ArrayList<MapType.ZoomInfo> s = new ArrayList<MapType.ZoomInfo>();
        s.add(new MapType.ZoomInfo(this.getPrefix() + "_128", 0));
        if (this.night_and_day) {
            s.add(new MapType.ZoomInfo(this.getPrefix() + "_day_128", 0));
        }
        return s;
    }

    @Override
    public int baseZoomFileStepSize() {
        return 1;
    }

    @Override
    public MapType.MapStep zoomFileMapStep() {
        return MapType.MapStep.X_PLUS_Y_PLUS;
    }

    @Override
    public int[] zoomFileStepSequence() {
        return stepseq;
    }

    @Override
    public int getBigWorldShift() {
        return 5;
    }

    @Override
    public boolean isBigWorldMap(DynmapWorld w) {
        return w.bigworld || this.isbigmap;
    }

    @Override
    public void buildClientConfiguration(JSONObject worldObject, DynmapWorld world) {
        JSONObject o = new JSONObject();
        JSONUtils.s(o, "type", "FlatMapType");
        JSONUtils.s(o, "name", this.name);
        JSONUtils.s(o, "title", this.title);
        JSONUtils.s(o, "icon", this.icon);
        JSONUtils.s(o, "prefix", this.prefix);
        JSONUtils.s(o, "background", this.bg_cfg);
        JSONUtils.s(o, "nightandday", this.night_and_day);
        JSONUtils.s(o, "backgroundday", this.bg_day_cfg);
        JSONUtils.s(o, "backgroundnight", this.bg_night_cfg);
        JSONUtils.s(o, "bigmap", this.isBigWorldMap(world));
        JSONUtils.s(o, "protected", this.isProtected());
        JSONUtils.s(o, "mapzoomin", this.mapzoomin);
        JSONUtils.s(o, "mapzoomout", world.getExtraZoomOutLevels());
        if (MapManager.mapman.getCompassMode() != DynmapCore.CompassMode.PRE19) {
            JSONUtils.s(o, "compassview", "E");
        } else {
            JSONUtils.s(o, "compassview", "S");
        }
        JSONUtils.s(o, "image-format", MapType.ImageFormat.FORMAT_PNG.getFileExt());
        JSONUtils.a(worldObject, "maps", o);
    }

    @Override
    public void addMapTiles(List<MapTile> list, DynmapWorld w, int tx, int ty) {
        list.add(new FlatMapTile(w, this, tx, ty, 128));
    }

    public static class FlatMapTile
    extends MapTile {
        FlatMap map;
        public int x;
        public int y;
        public int size;
        private String fname;
        private String fname_day;

        public FlatMapTile(DynmapWorld world, FlatMap map, int x, int y, int size) {
            super(world);
            this.map = map;
            this.x = x;
            this.y = y;
            this.size = size;
        }

        public FlatMapTile(DynmapWorld world, String parm) throws Exception {
            super(world);
            String[] parms = parm.split(",");
            if (parms.length < 4) {
                throw new Exception("wrong parameter count");
            }
            this.x = Integer.parseInt(parms[0]);
            this.y = Integer.parseInt(parms[1]);
            this.size = Integer.parseInt(parms[2]);
            for (MapType t : world.maps) {
                if (!t.getName().equals(parms[3]) || !(t instanceof FlatMap)) continue;
                this.map = (FlatMap)t;
                break;
            }
            if (this.map == null) {
                throw new Exception("invalid map");
            }
        }

        @Override
        protected String saveTileData() {
            return String.format("%d,%d,%d,%s", this.x, this.y, this.size, this.map.getName());
        }

        @Override
        public String getFilename() {
            if (this.fname == null) {
                this.fname = this.world.bigworld ? this.map.prefix + "_" + this.size + "/" + (-(this.y + 1) >> 5) + "_" + (this.x >> 5) + "/" + -(this.y + 1) + "_" + this.x + ".png" : this.map.prefix + "_" + this.size + "_" + -(this.y + 1) + "_" + this.x + ".png";
            }
            return this.fname;
        }

        @Override
        public String getDayFilename() {
            if (this.fname_day == null) {
                this.fname_day = this.world.bigworld ? this.map.prefix + "_day_" + this.size + "/" + (-(this.y + 1) >> 5) + "_" + (this.x >> 5) + "/" + -(this.y + 1) + "_" + this.x + ".png" : this.map.prefix + "_day_" + this.size + "_" + -(this.y + 1) + "_" + this.x + ".png";
            }
            return this.fname_day;
        }

        public String toString() {
            return this.world.getName() + ":" + this.getFilename();
        }

        @Override
        public boolean render(MapChunkCache cache, String mapname) {
            return this.map.render(cache, this, MapManager.mapman.getTileFile(this));
        }

        @Override
        public List<DynmapChunk> getRequiredChunks() {
            return this.map.getRequiredChunks(this);
        }

        @Override
        public MapTile[] getAdjecentTiles() {
            return this.map.getAdjecentTiles(this);
        }

        @Override
        public int hashCode() {
            return this.x ^ this.y ^ this.size ^ this.map.getName().hashCode();
        }

        @Override
        public boolean equals(Object x) {
            if (x instanceof FlatMapTile) {
                return this.equals((FlatMapTile)x);
            }
            return false;
        }

        public boolean equals(FlatMapTile o) {
            return o.x == this.x && o.y == this.y && o.map == this.map;
        }

        @Override
        public String getKey(String prefix) {
            return this.world.getName() + "." + this.map.getPrefix();
        }

        @Override
        public boolean isHightestBlockYDataNeeded() {
            return true;
        }

        @Override
        public boolean isBiomeDataNeeded() {
            return false;
        }

        @Override
        public boolean isRawBiomeDataNeeded() {
            return false;
        }

        @Override
        public boolean isBlockTypeDataNeeded() {
            return true;
        }

        @Override
        public int tileOrdinalX() {
            return this.x;
        }

        @Override
        public int tileOrdinalY() {
            return this.y;
        }
    }

    private static enum Texture {
        NONE,
        SMOOTH,
        DITHER;

    }
}

