/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.zip.CRC32;
import org.dynmap.Log;
import org.dynmap.utils.LRULinkedHashMap;

public class TileHashManager {
    private File tiledir;
    private boolean enabled;
    private static final int MAX_CACHED_TILEHASHFILES = 25;
    private Object lock = new Object();
    private LRULinkedHashMap<TileHashFile, byte[]> tilehash = new LRULinkedHashMap(25);
    private LinkedList<byte[]> crcworkbufs = new LinkedList();
    private LinkedList<CRC32> crcs = new LinkedList();

    public TileHashManager(File tileroot, boolean enabled) {
        this.tiledir = tileroot;
        this.enabled = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getImageHashCode(String key, String subtype, int tx, int ty) {
        if (!this.enabled) {
            return -1L;
        }
        TileHashFile thf = new TileHashFile(key, subtype, tx >> 5, ty >> 5);
        Object object = this.lock;
        synchronized (object) {
            byte[] crcbuf = (byte[])this.tilehash.get(thf);
            if (crcbuf == null) {
                crcbuf = new byte[4096];
                Arrays.fill(crcbuf, (byte)-1);
                this.tilehash.put((byte[])thf, crcbuf);
                thf.readFromFile(this.tiledir, crcbuf);
            }
            return thf.getCRC(tx & 0x1F, ty & 0x1F, crcbuf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long calculateTileHash(int[] newbuf) {
        CRC32 crc32;
        byte[] crcworkbuf;
        if (!this.enabled) {
            return 0L;
        }
        Object object = this.lock;
        synchronized (object) {
            crcworkbuf = this.crcworkbufs.isEmpty() ? new byte[4 * newbuf.length] : this.crcworkbufs.removeFirst();
            if (this.crcs.isEmpty()) {
                crc32 = new CRC32();
            } else {
                crc32 = this.crcs.removeFirst();
                crc32.reset();
            }
        }
        if (crcworkbuf.length < 4 * newbuf.length) {
            crcworkbuf = new byte[4 * newbuf.length];
        }
        int off = 0;
        for (int i = 0; i < newbuf.length; ++i) {
            int v = newbuf[i];
            crcworkbuf[off++] = (byte)v;
            crcworkbuf[off++] = (byte)(v >> 8);
            crcworkbuf[off++] = (byte)(v >> 16);
            crcworkbuf[off++] = (byte)(v >> 24);
        }
        crc32.update(crcworkbuf, 0, 4 * newbuf.length);
        long v = crc32.getValue();
        Object object2 = this.lock;
        synchronized (object2) {
            this.crcworkbufs.addFirst(crcworkbuf);
            this.crcs.addFirst(crc32);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateHashCode(String key, String subtype, int tx, int ty, long newcrc) {
        if (!this.enabled) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            TileHashFile thf = new TileHashFile(key, subtype, tx >> 5, ty >> 5);
            byte[] crcbuf = (byte[])this.tilehash.get(thf);
            if (crcbuf == null) {
                crcbuf = new byte[4096];
                this.tilehash.put((byte[])thf, crcbuf);
                thf.readFromFile(this.tiledir, crcbuf);
            }
            thf.setCRC(tx & 0x1F, ty & 0x1F, crcbuf, newcrc);
            thf.writeToFile(this.tiledir, crcbuf);
        }
    }

    private static class TileHashFile {
        final String key;
        final String subtype;
        final int x;
        final int y;
        private File hf;

        TileHashFile(String key, String subtype, int x, int y) {
            this.key = key;
            this.subtype = subtype != null ? subtype : "";
            this.x = x;
            this.y = y;
        }

        public boolean equals(Object o) {
            if (!(o instanceof TileHashFile)) {
                return false;
            }
            TileHashFile fo = (TileHashFile)o;
            return this.x == fo.x && this.y == fo.y && this.key.equals(fo.key) && this.subtype.equals(fo.subtype);
        }

        public int hashCode() {
            return this.key.hashCode() ^ this.subtype.hashCode() ^ this.x << 16 ^ this.y;
        }

        public File getHashFile(File tiledir) {
            if (this.hf == null) {
                int idx = this.key.lastIndexOf(46);
                String k = idx > 0 ? this.key.substring(0, idx) + File.separatorChar + this.key.substring(idx + 1) : this.key;
                this.hf = new File(tiledir, k + (this.subtype.equals("") ? "" : "." + this.subtype) + "_" + this.x + "_" + this.y + ".hash");
            }
            return this.hf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeToFile(File tiledir, byte[] crcbuf) {
            RandomAccessFile fd = null;
            File f = this.getHashFile(tiledir);
            try {
                try {
                    fd = new RandomAccessFile(f, "rw");
                }
                catch (FileNotFoundException nfnx) {
                    File pf = f.getParentFile();
                    if (!pf.exists()) {
                        pf.mkdirs();
                    }
                    fd = new RandomAccessFile(f, "rw");
                }
                fd.seek(0L);
                fd.write(crcbuf);
            }
            catch (IOException iox) {
                Log.severe("Error writing hash file - " + this.getHashFile(tiledir).getPath() + " - " + iox.getMessage());
            }
            finally {
                if (fd != null) {
                    try {
                        fd.close();
                    }
                    catch (IOException iox) {}
                    fd = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFromFile(File tiledir, byte[] crcbuf) {
            RandomAccessFile fd = null;
            boolean success = false;
            try {
                fd = new RandomAccessFile(this.getHashFile(tiledir), "r");
                fd.seek(0L);
                fd.read(crcbuf);
                success = true;
            }
            catch (IOException iox) {
            }
            finally {
                if (fd != null) {
                    try {
                        fd.close();
                    }
                    catch (IOException iox) {}
                    fd = null;
                }
            }
            if (!success) {
                Arrays.fill(crcbuf, (byte)-1);
                this.writeToFile(tiledir, crcbuf);
            }
        }

        public long getCRC(int tx, int ty, byte[] crcbuf) {
            int off = 128 * (ty & 0x1F) + 4 * (tx & 0x1F);
            long crc = 0L;
            for (int i = 0; i < 4; ++i) {
                crc = (crc << 8) + (long)(0xFF & crcbuf[off + i]);
            }
            return crc;
        }

        public void setCRC(int tx, int ty, byte[] crcbuf, long crc) {
            int off = 128 * (ty & 0x1F) + 4 * (tx & 0x1F);
            for (int i = 0; i < 4; ++i) {
                crcbuf[off + i] = (byte)(crc >> (3 - i) * 8 & 0xFFL);
            }
        }
    }
}

