/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.neiaddons;

import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.bdew.neiaddons.ClientHandler;
import net.bdew.neiaddons.ItemFakeNBT;
import net.bdew.neiaddons.ServerHandler;
import net.bdew.neiaddons.api.NEIAddon;
import net.minecraftforge.common.Configuration;

@Mod(modid="NEIAddons", name="NEI Addons", version="1.10.4.64", dependencies="after:NotEnoughItems")
@NetworkMod(clientSideRequired=false, serverSideRequired=false)
public class NEIAddons {
    public static Logger log;
    public static final String modid = "NEIAddons";
    public static final String channel = "bdew.neiaddons";
    public static final int netVersion = 1;
    public static List<NEIAddon> addons;
    public static Configuration config;
    public static boolean fakeItemsOn;
    public static ItemFakeNBT fakeItem;

    public static void register(NEIAddon addon) {
        addons.add(addon);
    }

    public static void logInfo(String message, Object ... params) {
        log.log(Level.INFO, String.format(message, params));
    }

    public static void logWarning(String message, Object ... params) {
        log.log(Level.WARNING, String.format(message, params));
    }

    public static void logSevere(String message, Object ... params) {
        log.log(Level.SEVERE, String.format(message, params));
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        String cmt;
        log = event.getModLog();
        config = new Configuration(event.getSuggestedConfigurationFile());
        config.addCustomCategoryComment("Addons", "Controls loading of different addons, set to false to disable");
        addons = new ArrayList<NEIAddon>();
        if (event.getSide() == Side.CLIENT && (fakeItemsOn = config.get("general", "Enable fake items", false, cmt = "Enable to register fake items to work around NEI not showing items with metadata outside cheat mode").getBoolean(false))) {
            fakeItem = new ItemFakeNBT(config.getItem("Fake item", 10050).getInt());
        }
        if (event.getSide() == Side.CLIENT && !Loader.isModLoaded((String)"NotEnoughItems")) {
            NEIAddons.logSevere("NEI doesn't seem to be installed... NEI Addons require it to do anything useful client-side", new Object[0]);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NEIAddons.logInfo("Loading NEI Addons", new Object[0]);
        for (NEIAddon addon : addons) {
            if (config.get("Addons", addon.getName(), true).getBoolean(false)) {
                NEIAddons.logInfo("Loading %s Addon...", addon.getName());
                try {
                    addon.init(event.getSide());
                    if (!addon.isActive().booleanValue()) continue;
                    NEIAddons.logInfo("%s Addon successfully loadded", addon.getName());
                }
                catch (Exception e) {
                    NEIAddons.logSevere("Loading %s Addon - Failed:", addon.getName());
                    e.printStackTrace();
                }
                continue;
            }
            NEIAddons.logInfo("%s Addon disabled - skipping", addon.getName());
        }
        config.save();
        ServerHandler serverHandler = new ServerHandler();
        NetworkRegistry.instance().registerChannel((IPacketHandler)serverHandler, channel, Side.SERVER);
        GameRegistry.registerPlayerTracker((IPlayerTracker)serverHandler);
        if (event.getSide() == Side.CLIENT) {
            ClientHandler clientHandler = new ClientHandler();
            NetworkRegistry.instance().registerChannel((IPacketHandler)clientHandler, channel, Side.CLIENT);
            TickRegistry.registerTickHandler((ITickHandler)clientHandler, (Side)Side.CLIENT);
        }
        if (addons.size() > 0) {
            String addonslist = "Loaded Addons:";
            for (NEIAddon addon : addons) {
                addonslist = addonslist + "\n- " + addon.getName() + ": " + (addon.isActive() != false ? "Active" : "Inactive");
            }
            Loader.instance().activeModContainer().getMetadata().description = addonslist;
        } else {
            Loader.instance().activeModContainer().getMetadata().description = "No Addons loaded :(";
        }
    }
}

