/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.logic;

import codechicken.core.ClientUtils;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.lang.LangUtil;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import codechicken.wirelessredstone.core.RedstoneEther;
import codechicken.wirelessredstone.logic.TransceiverPart;
import codechicken.wirelessredstone.logic.WirelessRedstoneLogic;

public class TransmitterPart
extends TransceiverPart {
    public static Cuboid6[] extensionBB = new Cuboid6[24];

    static {
        Cuboid6 base = new Cuboid6(0.4375, 0.125, 0.25, 0.5625, 0.875, 0.375);
        int s = 0;
        while (s < 6) {
            int r = 0;
            while (r < 4) {
                TransmitterPart.extensionBB[s << 2 | r] = base.copy().apply(Rotation.sideOrientation((int)s, (int)r).at(Vector3.center));
                ++r;
            }
            ++s;
        }
    }

    @Override
    public ye getItem() {
        return new ye(WirelessRedstoneLogic.itemwireless, 1, 0);
    }

    @Override
    public void onNeighborChanged() {
        if (this.dropIfCantStay()) {
            return;
        }
        int gettingPowered = this.getPoweringLevel();
        if (!this.active() && gettingPowered > 0) {
            this.trySetState(true);
        } else if (this.active() && gettingPowered == 0) {
            this.trySetState(false);
        }
    }

    private void trySetState(boolean on) {
        if (on && this.disabled()) {
            return;
        }
        this.changeSpinState(on);
        this.setActive(on);
        RedstoneEther.server().setTransmitter(this.world(), this.x(), this.y(), this.z(), this.currentfreq, this.active());
        this.updateChange();
    }

    private void changeSpinState(boolean on) {
        if (on && this.spinoffset < 0) {
            int time;
            this.spinoffset = time = (int)((this.world().J() + (long)this.spinoffset) % 100000L);
        } else if (!on && this.spinoffset >= 0) {
            int time = (int)((this.world().J() - (long)this.spinoffset) % 100000L);
            this.spinoffset = -time;
        }
    }

    @Override
    public void jamTile() {
        super.jamTile();
        this.setActive(false);
        this.updateChange();
    }

    @Override
    public void unjamTile() {
        super.unjamTile();
        this.addToEther();
        this.onNeighborChanged();
    }

    @Override
    public Vector3 getFocalPoint() {
        return new Vector3(0.3125, 0.24, 0.0).apply(this.rotationT());
    }

    @Override
    public Vector3 getPearlPos() {
        return new Vector3(0.5, 0.74 + this.getFloating() * 0.04, 0.3125);
    }

    @Override
    public double getPearlSpin() {
        if (this.spinoffset < 0) {
            return RedstoneEther.getRotation(-this.spinoffset, this.currentfreq);
        }
        return RedstoneEther.getRotation(ClientUtils.getRenderTime() - (double)this.spinoffset, this.currentfreq);
    }

    public float getPearlLight() {
        float light = this.world().q(this.x(), this.y(), this.z());
        light = (this.deadmap & 1) == 1 || this.deadmap == 0 && (this.disabled() || !this.active() || this.currentfreq == 0) ? (light + 1.0f) * 0.25f : (light + 1.0f) * 0.5f;
        return light;
    }

    @Override
    public void setFreq(int newfreq) {
        super.setFreq(newfreq);
        this.changeSpinState(this.active());
    }

    private void resetRotation() {
        this.spinoffset = this.active() ? 0 : -1;
    }

    @Override
    public void addToEther() {
        this.resetRotation();
        this.updateChange();
        RedstoneEther.server().setTransmitter(this.world(), this.x(), this.y(), this.z(), this.currentfreq, this.active());
    }

    @Override
    public void removeFromEther() {
        RedstoneEther.server().remTransmitter(this.world(), this.x(), this.y(), this.z(), this.currentfreq);
    }

    @Override
    public String getGuiName() {
        return LangUtil.translateG((String)"item.wrcbe_logic:wirelesspart|0.name", (Object[])new Object[0]);
    }

    public String getType() {
        return "wrcbe-tran";
    }

    @Override
    public void read(MCDataInput packet) {
        super.read(packet);
        this.changeSpinState(this.active());
    }

    @Override
    public Cuboid6 getExtensionBB() {
        return extensionBB[this.shape()];
    }

    @Override
    public int modelId() {
        return 0;
    }
}

