/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.logic;

import codechicken.core.asm.InterfaceDependancies;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Vector3;
import codechicken.wirelessredstone.core.ITileWireless;
import codechicken.wirelessredstone.core.RedstoneEther;
import codechicken.wirelessredstone.core.WirelessRedstoneCore;
import codechicken.wirelessredstone.logic.RenderWireless;
import codechicken.wirelessredstone.logic.WirelessPart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.ILuaContext;
import dan200.computer.api.IPeripheral;

@InterfaceDependancies
public abstract class TransceiverPart
extends WirelessPart
implements ITileWireless,
IPeripheral {
    public byte deadmap;
    public int currentfreq;

    @Override
    public int getFreq() {
        return this.currentfreq;
    }

    @Override
    public void setFreq(int newfreq) {
        this.removeFromEther();
        this.currentfreq = newfreq;
        this.addToEther();
        if (this.disabled()) {
            RedstoneEther.server().jamNode(this.world(), this.x(), this.y(), this.z(), newfreq);
        }
        this.updateChange();
    }

    @Override
    public void load(by tag) {
        super.load(tag);
        this.currentfreq = tag.e("freq");
        this.deadmap = tag.c("deadmap");
    }

    @Override
    public void save(by tag) {
        super.save(tag);
        tag.a("freq", this.currentfreq);
        tag.a("deadmap", this.deadmap);
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        packet.writeShort(this.currentfreq);
    }

    @Override
    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        this.currentfreq = packet.readUShort();
    }

    @Override
    public void jamTile() {
        this.setDisabled(true);
        this.deadmap = (byte)this.world().s.nextInt(256);
        this.scheduleTick(3);
    }

    @Override
    public void unjamTile() {
        if (this.disabled()) {
            this.deadmap = (byte)this.world().s.nextInt(256);
            this.scheduleTick(3);
        }
        this.setDisabled(false);
    }

    public void scheduledTick() {
        this.deadmap = (byte)(this.deadmap >> 1);
        if (this.deadmap != 0) {
            this.scheduleTick(3);
        }
    }

    @Override
    public boolean activate(uf player, ata hit, ye held) {
        if (super.activate(player, hit, held)) {
            return true;
        }
        if (hit.e == (this.side() ^ 1) && !player.ah()) {
            if (this.world().I) {
                WirelessRedstoneCore.proxy.openTileWirelessGui(player, (ITileWireless)this.tile());
            }
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Vector3 pos, float frame, int pass) {
        super.renderDynamic(pos, frame, pass);
        if (pass == 0) {
            RenderWireless.renderFreq(pos, this);
        }
    }

    public void attach(IComputerAccess computer) {
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                if (arguments.length < 1) {
                    throw new Exception("Not Enough Arguments");
                }
                if (!(arguments[0] instanceof Double) || Math.floor((Double)arguments[0]) != (Double)arguments[0]) {
                    throw new Exception("Argument 0 is not a number");
                }
                int freq = ((Double)arguments[0]).intValue();
                if (freq < 0 || freq > 5000) {
                    throw new Exception("Invalid Frequency: " + freq);
                }
                if (!RedstoneEther.server().canBroadcastOnFrequency(this.owner, freq)) {
                    throw new Exception("Frequency: " + freq + " is private");
                }
                this.setFreq(freq);
                return null;
            }
            case 1: {
                return new Object[]{this.getFreq()};
            }
        }
        throw new Exception("derp?");
    }

    public boolean canAttachToSide(int side) {
        return (side & 6) != (this.side() & 6);
    }

    public void detach(IComputerAccess computer) {
    }

    public String[] getMethodNames() {
        return new String[]{"setFreq", "getFreq"};
    }
}

