/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.core;

import codechicken.core.ServerUtils;
import codechicken.core.commands.CoreCommand;
import codechicken.wirelessredstone.core.FreqParam;
import codechicken.wirelessredstone.core.RedstoneEther;

public class ParamSet
extends FreqParam {
    @Override
    public void printHelp(CoreCommand.WCommandSender listener) {
        listener.sendChatToPlayer("Usage: freq set [public | shared | private] [value].");
        listener.sendChatToPlayer("Eg. freq set public. Sets frequencies 1 to [value] as public.");
        listener.sendChatToPlayer("Eg. freq set shared. Sets frequencies [public+1] to [value] as shared.");
        listener.sendChatToPlayer("Eg. freq set private. Gives each player [value] private frequencies.");
    }

    @Override
    public String getName() {
        return "set";
    }

    @Override
    public void handleCommand(String playername, String[] subArray, CoreCommand.WCommandSender listener) {
        int num;
        RedstoneEther ether = RedstoneEther.get(false);
        if (subArray.length != 3) {
            listener.sendChatToPlayer("Invalid number of parameters.");
            return;
        }
        try {
            num = Integer.parseInt(subArray[2]);
        }
        catch (NumberFormatException ne) {
            listener.sendChatToPlayer("Invalid Value.");
            return;
        }
        if (subArray[1].equals("public")) {
            if (num < 1 || num > 5000) {
                listener.sendChatToPlayer("Invalid Frequency.");
                return;
            }
            ether.setLastPublicFrequency(num);
            ServerUtils.sendChatToOps((String)(String.valueOf(playername) + ": Frequencies 1-" + ether.getLastPublicFrequency() + " are now public."));
            if (num >= ether.getLastSharedFrequency()) {
                ServerUtils.sendChatToOps((String)(String.valueOf(playername) + ": The shared frequency range was made public."));
            } else {
                ServerUtils.sendChatToOps((String)(String.valueOf(playername) + ": Frequencies " + (num + 1) + "-" + ether.getLastSharedFrequency() + " are now shared."));
            }
        } else if (subArray[1].equals("shared")) {
            if (num < 1 || num > 5000) {
                listener.sendChatToPlayer("Invalid Frequency.");
                return;
            }
            boolean wasPublic = ether.getLastPublicFrequency() >= ether.getLastSharedFrequency();
            ether.setLastSharedFrequency(num);
            if (ether.getLastSharedFrequency() >= num) {
                if (!wasPublic) {
                    ServerUtils.sendChatToOps((String)(String.valueOf(playername) + ": The shared frequency range was removed."));
                } else {
                    ServerUtils.sendChatToOps((String)(String.valueOf(playername) + ": Frequencies " + (ether.getLastPublicFrequency() + 1) + "-" + num + " are now shared."));
                }
            }
        } else if (subArray[1].equals("private")) {
            if (num < 0 || num > 5000) {
                listener.sendChatToPlayer("Invalid Quantity.");
                return;
            }
            ether.setNumPrivateFreqs(num);
            ServerUtils.sendChatToOps((String)(String.valueOf(playername) + ": All players are now allowed " + num + " private frequencies."));
        } else {
            listener.sendChatToPlayer("Invalid param");
        }
    }
}

