/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.core;

import codechicken.core.commands.CoreCommand;
import codechicken.wirelessredstone.core.FreqParam;
import codechicken.wirelessredstone.core.RedstoneEther;

public class ParamPrivate
extends FreqParam {
    @Override
    public void printHelp(CoreCommand.WCommandSender listener) {
        listener.sendChatToPlayer("Usage: freq private [params...]");
        listener.sendChatToPlayer("freq private [username | all]. Returns the private freqs owned by [username]");
        listener.sendChatToPlayer("freq private [username] [freq]. Sets the owner of [freq] as [username]");
        listener.sendChatToPlayer("freq private [freq]. Returns the owner of [freq]");
        listener.sendChatToPlayer("freq private clear [freq | username | all]. Removes the owner of [freq]");
    }

    @Override
    public String getName() {
        return "private";
    }

    @Override
    public void handleCommand(String playername, String[] subArray, CoreCommand.WCommandSender listener) {
        RedstoneEther ether = RedstoneEther.get(false);
        if (subArray.length == 1) {
            listener.sendChatToPlayer("Invalid number of parameters.");
            return;
        }
        if (subArray[1].equals("all")) {
            StringBuilder returnString = new StringBuilder();
            int freq2 = 1;
            while (freq2 <= 5000) {
                if (ether.isFreqPrivate(freq2)) {
                    if (returnString.length() > 0) {
                        returnString.append(", ");
                    }
                    returnString.append(freq2);
                }
                ++freq2;
            }
            if (returnString.length() == 0) {
                listener.sendChatToPlayer("There are no private frequencies.");
            } else {
                listener.sendChatToPlayer("The following freqs are private: " + returnString);
            }
            return;
        }
        if (subArray[1].equals("clear")) {
            if (subArray.length == 2) {
                listener.sendChatToPlayer("Invalid number of parameters.");
                return;
            }
            int freq = -1;
            try {
                freq = Integer.parseInt(subArray[2]);
            }
            catch (NumberFormatException freq2) {
                // empty catch block
            }
            if (freq != -1) {
                if (freq < 1 || freq > 5000) {
                    listener.sendChatToPlayer("Invalid Frequency.");
                    return;
                }
                if (freq <= ether.getLastPublicFrequency()) {
                    listener.sendChatToPlayer(String.valueOf(freq) + " is public anyway.");
                    return;
                }
                if (!ether.isFreqPrivate(freq)) {
                    listener.sendChatToPlayer(String.valueOf(freq) + " isn't private.");
                    return;
                }
                ether.removeFreqOwner(freq);
                listener.sendChatToPlayer(String.valueOf(freq) + " is now shared.");
                return;
            }
            String scanPlayer = subArray[2];
            StringBuilder returnString = new StringBuilder();
            freq = 1;
            while (freq <= 5000) {
                if (ether.isFreqPrivate(freq) && (scanPlayer.equals("all") || ether.getFreqOwner(freq).equalsIgnoreCase(scanPlayer))) {
                    if (returnString.length() > 0) {
                        returnString.append(", ");
                    }
                    returnString.append(freq);
                    ether.removeFreqOwner(freq);
                }
                ++freq;
            }
            if (returnString.length() == 0) {
                if (scanPlayer.equals("all")) {
                    listener.sendChatToPlayer("There are no private frequencies.");
                } else {
                    listener.sendChatToPlayer(String.valueOf(scanPlayer) + " doesn't own any frequencies.");
                }
            } else {
                listener.sendChatToPlayer("The following freqs are now shared: " + returnString);
            }
            return;
        }
        int freq = -1;
        try {
            freq = Integer.parseInt(subArray[1]);
        }
        catch (NumberFormatException scanPlayer) {
            // empty catch block
        }
        if (freq != -1) {
            if (freq < 1 || freq > 5000) {
                listener.sendChatToPlayer("Invalid Frequency.");
                return;
            }
            if (freq <= ether.getLastPublicFrequency()) {
                listener.sendChatToPlayer(String.valueOf(freq) + " is public.");
                return;
            }
            if (!ether.isFreqPrivate(freq)) {
                listener.sendChatToPlayer(String.valueOf(freq) + " isn't private.");
                return;
            }
            listener.sendChatToPlayer(String.valueOf(freq) + " is owned by " + ether.getFreqOwner(freq) + ".");
            return;
        }
        String scanPlayer = subArray[1];
        if (subArray.length == 2) {
            StringBuilder returnString = new StringBuilder();
            freq = 1;
            while (freq <= 5000) {
                if (ether.isFreqPrivate(freq) && ether.getFreqOwner(freq).equalsIgnoreCase(scanPlayer)) {
                    if (returnString.length() > 0) {
                        returnString.append(", ");
                    }
                    returnString.append(freq);
                }
                ++freq;
            }
            if (returnString.length() == 0) {
                listener.sendChatToPlayer(String.valueOf(scanPlayer) + " doesn't own any frequencies.");
            } else {
                listener.sendChatToPlayer(String.valueOf(scanPlayer) + " owns the following freqs: " + returnString);
            }
            return;
        }
        try {
            freq = Integer.parseInt(subArray[2]);
        }
        catch (NumberFormatException ne) {
            listener.sendChatToPlayer("Invalid Frequency.");
            return;
        }
        if (freq < 1 || freq > 5000) {
            listener.sendChatToPlayer("Invalid Frequency.");
            return;
        }
        if (freq <= ether.getLastPublicFrequency()) {
            listener.sendChatToPlayer(String.valueOf(freq) + " is public.");
            return;
        }
        if (freq > ether.getLastSharedFrequency()) {
            listener.sendChatToPlayer(String.valueOf(freq) + " is not in the shared range.");
            return;
        }
        ether.setFreqOwner(freq, scanPlayer);
        if (ether.isFreqPrivate(freq) && ether.getFreqOwner(freq).equalsIgnoreCase(scanPlayer)) {
            listener.sendChatToPlayer(String.valueOf(freq) + " is now owned by " + scanPlayer + ".");
        } else {
            listener.sendChatToPlayer(String.valueOf(scanPlayer) + " already owns " + ether.getNumPrivateFreqs() + " frequencies.");
        }
    }
}

