/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.core;

import codechicken.core.CommonUtils;
import codechicken.core.ServerUtils;
import codechicken.core.commands.CoreCommand;
import codechicken.wirelessredstone.core.FreqParam;
import codechicken.wirelessredstone.core.RedstoneEther;
import codechicken.wirelessredstone.core.RedstoneEtherServer;

public class ParamJam
extends FreqParam {
    public static String[] examples = new String[]{"Eg. freq jam codechicken 100-250", "Eg. freq jam codechicken all", "Eg. freq jam codechicken default", "Eg. freq jam 100-250", "Eg. freq jam codechicken 500"};

    @Override
    public void printHelp(CoreCommand.WCommandSender listener) {
        listener.sendChatToPlayer("Usage: freq jam [playername] [frequency range | all | default].");
        listener.sendChatToPlayer("Jam [playername] from [frequency range].");
        listener.sendChatToPlayer(examples[rand.nextInt(4)]);
    }

    @Override
    public String getName() {
        return "jam";
    }

    @Override
    public void handleCommand(String playername, String[] subArray, CoreCommand.WCommandSender listener) {
        ParamJam.jamOpenCommand(playername, (String[])CommonUtils.subArray((Object[])subArray, (int)1), listener, true);
    }

    public static void jamOpenCommand(String playername, String[] subArray, CoreCommand.WCommandSender listener, boolean jam) {
        int endfreq;
        int startfreq;
        String jamPlayer;
        RedstoneEtherServer ether = RedstoneEther.server();
        if (subArray.length == 0) {
            listener.sendChatToPlayer("Invalid number of parameters.");
            return;
        }
        if (subArray.length == 1 && ServerUtils.getPlayer((String)playername) == null) {
            listener.sendChatToPlayer("No such Player.");
            return;
        }
        String range = subArray[subArray.length - 1];
        String string = jamPlayer = subArray.length == 1 ? playername : subArray[0];
        if (range.equals("all")) {
            startfreq = 1;
            endfreq = 5000;
        } else if (range.equals("default")) {
            startfreq = ether.getLastSharedFrequency() + 1;
            endfreq = 5000;
        } else {
            int[] freqrange = RedstoneEther.parseFrequencyRange(range);
            startfreq = freqrange[0];
            endfreq = freqrange[1];
        }
        if (startfreq < 1 || endfreq > 5000 || endfreq < startfreq) {
            listener.sendChatToPlayer("Invalid Frequency Range.");
            return;
        }
        ether.setFrequencyRangeCommand(jamPlayer, startfreq, endfreq, jam);
        StringBuilder returnstring = new StringBuilder();
        if (jam) {
            returnstring.append("jammed from");
        } else {
            returnstring.append("granted");
        }
        if (startfreq == endfreq) {
            if (startfreq <= ether.getLastPublicFrequency()) {
                listener.sendChatToPlayer("You can't jam someone from public frequencies.");
                return;
            }
            returnstring.append(" frequency: ").append(startfreq).append(".");
        } else {
            int publicend = ether.getLastPublicFrequency();
            if (startfreq <= publicend && endfreq <= publicend) {
                listener.sendChatToPlayer("You can't jam someone from public frequencies.");
                return;
            }
            if (startfreq <= publicend) {
                startfreq = publicend + 1;
            }
            returnstring.append(" frequencies: ").append(startfreq).append("-").append(endfreq).append(".");
        }
        String opstring = String.valueOf(jamPlayer) + " was " + returnstring;
        String playerstring = String.valueOf(CommonUtils.colourPrefix((int)14)) + "You have been " + returnstring;
        ServerUtils.sendChatToOps((String)(String.valueOf(playername) + ": " + opstring));
        jv player = ServerUtils.getPlayer((String)jamPlayer);
        if (player != null) {
            ServerUtils.sendChatTo((jv)player, (String)playerstring);
        }
    }
}

