/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.addons;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.ColourARGB;
import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.math.MathHelper;
import codechicken.lib.render.ManagedTextureFX;
import codechicken.lib.render.TextureUtils;
import codechicken.wirelessredstone.addons.RedstoneEtherAddons;
import codechicken.wirelessredstone.core.RedstoneEther;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;

public class TriangTexManager {
    private static Colour[] texRing = new Colour[256];
    private static Colour[] texGrad = new Colour[256];
    private static int[] imageData = new int[256];
    private static ManagedTextureFX[] textures = new ManagedTextureFX[256];
    private static ColourRGBA pr = new ColourRGBA(-16776961);
    private static ColourRGBA pb = new ColourRGBA(65535);
    private static ColourRGBA pg = new ColourRGBA(-2139062017);
    private static ColourRGBA pd = new ColourRGBA(0x404040FF);
    private static HashMap<Integer, Integer> freqslotmap = new HashMap(256);
    private static LinkedList<Integer> freeslots = new LinkedList();
    private static HashSet<Integer> activetextures = new HashSet(256);
    private static HashSet<Integer> visibletextures = new HashSet(256);
    private static ColourRGBA[] pointercolours = new ColourRGBA[]{pb, pr, pr, pr, pr, pr, pr, pr, pb, pr, pr, pr, pb, pb};
    private static ColourRGBA[] pointersidecolours = new ColourRGBA[]{pg, pg, pg, pg, pg, pg, pd, pg, pd, pd, pd, pd, pg, pg};

    static {
        int i = 1;
        while (i < textures.length) {
            freeslots.add(i);
            ++i;
        }
        i = 0;
        while (i < textures.length) {
            TriangTexManager.textures[i] = new ManagedTextureFX(16, "wrcbe_addons:triang_" + i);
            textures[i].setAtlas(1);
            ++i;
        }
    }

    public static void loadTextures() {
        texRing = TextureUtils.loadTextureColours((bjo)new bjo("wrcbe_addons", "textures/items/triangRing.png"));
        texGrad = TextureUtils.loadTextureColours((bjo)new bjo("wrcbe_addons", "textures/items/triangGrad.png"));
        TriangTexManager.processTexture(-1, 0);
    }

    public static ms getIconFromDamage(int damage) {
        return TriangTexManager.textures[TriangTexManager.getIconIndexFromDamage((int)damage)].texture;
    }

    public static int getIconIndexFromDamage(int freq) {
        if (freq == 0) {
            return 0;
        }
        visibletextures.add(freq);
        Integer iconindex = freqslotmap.get(freq);
        if (iconindex == null) {
            iconindex = TriangTexManager.allocateSlot(freq);
        }
        return iconindex;
    }

    private static int allocateSlot(int damage) {
        if (freeslots.isEmpty()) {
            throw new RuntimeException("More than 256 different triangulators!");
        }
        int slot = freeslots.remove(0);
        freqslotmap.put(damage, slot);
        return slot;
    }

    private static void processTexture(int freq, int iconindex) {
        int colour = freq <= 0 ? -1 : RedstoneEther.get(true).getFreqColour(freq);
        TriangTexManager.mergeTexturesWithColour(new ColourARGB(colour));
        if (freq > 0) {
            TriangTexManager.writePointer(freq);
        }
        textures[iconindex].setData(imageData);
    }

    private static void mergeTexturesWithColour(ColourARGB texcolour) {
        int i = 0;
        while (i < 256) {
            Colour colour = TriangTexManager.texGrad[i].a == 0 ? texRing[i] : texGrad[i].copy().multiply((Colour)texcolour);
            TriangTexManager.imageData[i] = colour.argb();
            ++i;
        }
    }

    private static void writePointer(int freq) {
        int p;
        int row;
        int col;
        if (RedstoneEther.get(true).isPlayerJammed((uf)atv.w().h) || !RedstoneEtherAddons.client().isTriangOn(freq)) {
            return;
        }
        int id = RedstoneEther.get(true).getFreqColourId(freq);
        ColourRGBA pcolour = id < 0 ? pr : pointercolours[id];
        ColourRGBA scolour = id < 0 ? pg : pointersidecolours[id];
        float angle = RedstoneEtherAddons.client().getTriangAngle(freq);
        double cos = MathHelper.cos((double)angle);
        double sin = MathHelper.sin((double)angle);
        int i = -4;
        while (i <= 4) {
            col = (int)(8.5 + cos * (double)i * 0.3);
            row = (int)(7.5 - sin * (double)i * 0.3 * 0.5);
            p = row * 16 + col;
            TriangTexManager.imageData[p] = scolour.argb();
            ++i;
        }
        i = -8;
        while (i <= 16) {
            col = (int)(8.5 + sin * (double)i * 0.3);
            row = (int)(7.5 + cos * (double)i * 0.3 * 0.5);
            p = row * 16 + col;
            ColourRGBA c = i < 0 ? scolour : pcolour;
            TriangTexManager.imageData[p] = c.argb();
            ++i;
        }
    }

    public static void processAllTextures() {
        HashSet<Integer> wasActive = new HashSet<Integer>(activetextures);
        for (int freq : visibletextures) {
            int slot = freqslotmap.get(freq);
            if (!wasActive.remove(freq)) {
                RedstoneEtherAddons.client().setTriangRequired((uf)atv.w().h, freq, true);
                freeslots.remove(slot);
                activetextures.add(freq);
            }
            TriangTexManager.processTexture(freq, slot);
        }
        for (int freq : wasActive) {
            RedstoneEtherAddons.client().setTriangRequired((uf)atv.w().h, freq, false);
            freeslots.add(freqslotmap.get(freq));
            activetextures.remove(freq);
        }
        visibletextures.clear();
    }
}

