/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.ticketmachine;

import com.google.common.base.Preconditions;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;
import openmods.GenericInventory;
import openmods.api.IHasGui;
import openmods.api.IIconProvider;
import openmods.api.IInventoryCallback;
import openmods.api.IPlaceAwareTile;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableBoolean;
import openmods.sync.SyncableString;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.ColorUtils;
import openmods.utils.ItemUtils;
import openperipheral.addons.ticketmachine.BlockTicketMachine;
import openperipheral.addons.ticketmachine.ContainerTicketMachine;
import openperipheral.addons.ticketmachine.GuiTicketMachine;
import openperipheral.api.Arg;
import openperipheral.api.Freeform;
import openperipheral.api.LuaCallable;
import openperipheral.api.LuaType;
import openperipheral.api.OnTick;
import openperipheral.api.Optionals;

@Freeform
public class TileEntityTicketMachine
extends SyncedTileEntity
implements ISidedInventory,
IInventoryCallback,
IPlaceAwareTile,
IHasGui,
IIconProvider {
    private static final int SLOT_PAPER = 0;
    private static final int SLOT_INK = 1;
    private static final int SLOT_OUTPUT = 2;
    private final Item ticketItem;
    protected GenericInventory inventory = new GenericInventory("ticketmachine", false, 3);
    protected SyncableBoolean hasTicket;
    protected SyncableString owner;

    protected void createSyncedFields() {
        this.hasTicket = new SyncableBoolean();
        this.owner = new SyncableString();
    }

    public TileEntityTicketMachine() {
        this.inventory.addCallback((IInventoryCallback)this);
        ItemStack ticketStack = GameRegistry.findItemStack((String)"Railcraft", (String)"routing.ticket", (int)1);
        this.ticketItem = ticketStack != null ? ticketStack.func_77973_b() : null;
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.inventory.func_70298_a(i, j);
    }

    public ItemStack func_70304_b(int i) {
        return this.inventory.func_70304_b(i);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory.func_70299_a(i, itemstack);
    }

    public String func_70303_b() {
        return this.inventory.func_70303_b();
    }

    public boolean func_94042_c() {
        return this.inventory.func_94042_c();
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.inventory.func_70300_a(entityplayer);
    }

    public void func_70295_k_() {
        this.inventory.func_70295_k_();
    }

    public void func_70305_f() {
        this.inventory.func_70305_f();
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        switch (i) {
            case 0: {
                return itemstack.func_77973_b() == Item.field_77759_aK;
            }
            case 1: {
                ColorUtils.ColorMeta color = ColorUtils.stackToColor((ItemStack)itemstack);
                return color != null && color.vanillaId == 0;
            }
        }
        return false;
    }

    @OnTick
    @LuaCallable(returnTypes={LuaType.BOOLEAN}, description="Create a new ticket to the specified destination")
    public boolean createTicket(@Arg(name="destination", description="The destination for the ticket", type=LuaType.STRING) String destination, @Arg(name="amount", type=LuaType.NUMBER) @Optionals Integer amount) {
        if (amount == null) {
            amount = 1;
        } else {
            Preconditions.checkArgument((amount > 0 && amount <= 64 ? 1 : 0) != 0, (Object)"Amount must be between 1 and 64");
        }
        ItemStack paperStack = this.inventory.func_70301_a(0);
        Preconditions.checkState((this.func_94041_b(0, paperStack) && paperStack.field_77994_a >= amount ? 1 : 0) != 0, (Object)"Not enough paper");
        ItemStack inkStack = this.inventory.func_70301_a(1);
        Preconditions.checkState((this.func_94041_b(1, inkStack) && inkStack.field_77994_a >= amount ? 1 : 0) != 0, (Object)"Not enough ink");
        ItemStack output = this.inventory.func_70301_a(2);
        ItemStack newTicket = new ItemStack(this.ticketItem);
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)newTicket);
        tag.func_74778_a("owner", this.owner.getValue());
        tag.func_74778_a("dest", destination);
        if (output == null) {
            this.func_70299_a(2, newTicket);
        } else if (ItemStack.func_77970_a((ItemStack)output, (ItemStack)newTicket) && output.func_77969_a(newTicket) && output.field_77994_a + amount <= output.func_77976_d()) {
            output.field_77994_a += amount.intValue();
        } else {
            throw new IllegalArgumentException("No place in output slot");
        }
        this.func_70298_a(0, amount);
        this.func_70298_a(1, amount);
        this.field_70331_k.func_72908_a((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5, "openperipheraladdons:ticketmachine", 0.3f, 0.6f);
        this.sync();
        return true;
    }

    @LuaCallable(returnTypes={LuaType.STRING}, description="Returns owner of this machine")
    public String getOwner() {
        return this.owner.getValue();
    }

    public int[] func_94128_d(int side) {
        return new int[]{1, 0, 2};
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 2;
    }

    public void onInventoryChanged(IInventory inventory, int slotNumber) {
        boolean nowHasTicket;
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        boolean bl = nowHasTicket = inventory.func_70301_a(2) != null;
        if (nowHasTicket != this.hasTicket.getValue()) {
            this.hasTicket.setValue(nowHasTicket);
        }
    }

    public void onSynced(Set<ISyncableObject> changes) {
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public void onBlockPlacedBy(EntityPlayer player, ForgeDirection side, ItemStack stack, float hitX, float hitY, float hitZ) {
        this.owner.setValue(player.field_71092_bJ);
    }

    public Icon getIcon(ForgeDirection rotatedDir) {
        if (rotatedDir == ForgeDirection.SOUTH) {
            return this.hasTicket.getValue() ? BlockTicketMachine.iconFrontTicket : BlockTicketMachine.iconFrontEmpty;
        }
        return null;
    }

    public Object getServerGui(EntityPlayer player) {
        return new ContainerTicketMachine((IInventory)player.field_71071_by, this);
    }

    public Object getClientGui(EntityPlayer player) {
        return new GuiTicketMachine(new ContainerTicketMachine((IInventory)player.field_71071_by, this));
    }

    public boolean canOpenGui(EntityPlayer player) {
        return true;
    }

    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        this.inventory.writeToNBT(tag);
    }

    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.inventory.readFromNBT(tag);
    }
}

