/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.sensors;

import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import dan200.turtle.api.ITurtleUpgrade;
import dan200.turtle.api.TurtleSide;
import dan200.turtle.api.TurtleUpgradeType;
import dan200.turtle.api.TurtleVerb;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import openperipheral.adapter.AdapterManager;
import openperipheral.addons.OpenPeripheralAddons;
import openperipheral.addons.sensors.ISensorEnvironment;

public class TurtleUpgradeSensor
implements ITurtleUpgrade {
    public int getUpgradeID() {
        return 180;
    }

    public String getAdjective() {
        return StatCollector.func_74838_a((String)"openperipheral.turtle.sensor.adjective");
    }

    public TurtleUpgradeType getType() {
        return TurtleUpgradeType.Peripheral;
    }

    public ItemStack getCraftingItem() {
        return new ItemStack((Block)OpenPeripheralAddons.Blocks.sensor);
    }

    public boolean isSecret() {
        return false;
    }

    public IHostedPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        return AdapterManager.createHostedPeripheral((Object)new TurtleSensorEnvironment(turtle));
    }

    public boolean useTool(ITurtleAccess turtle, TurtleSide side, TurtleVerb verb, int direction) {
        return false;
    }

    public Icon getIcon(ITurtleAccess turtle, TurtleSide side) {
        return OpenPeripheralAddons.Blocks.sensor.turtleIcon;
    }

    private static class TurtleSensorEnvironment
    implements ISensorEnvironment {
        private ITurtleAccess turtle;

        public TurtleSensorEnvironment(ITurtleAccess turtle) {
            this.turtle = turtle;
        }

        @Override
        public boolean isTurtle() {
            return true;
        }

        @Override
        public Vec3 getLocation() {
            return this.turtle.getPosition();
        }

        public World getWorld() {
            return this.turtle.getWorld();
        }

        @Override
        public int getSensorRange() {
            return 30;
        }
    }
}

