/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.sensors;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import openperipheral.addons.sensors.ISensorEnvironment;
import openperipheral.api.Arg;
import openperipheral.api.IPeripheralAdapter;
import openperipheral.api.LuaCallable;
import openperipheral.api.LuaMethod;
import openperipheral.api.LuaType;
import openperipheral.api.Prefixed;
import openperipheral.util.EntityUtils;

@Prefixed(value={"target"})
public class AdapterSensor
implements IPeripheralAdapter {
    public Class<?> getTargetClass() {
        return ISensorEnvironment.class;
    }

    private static AxisAlignedBB getBoundingBox(Vec3 location, double range) {
        return AxisAlignedBB.func_72332_a().func_72299_a(location.field_72450_a, location.field_72448_b, location.field_72449_c, location.field_72450_a + 1.0, location.field_72448_b + 1.0, location.field_72449_c + 1.0).func_72314_b(range, range, range);
    }

    private static List<Integer> listEntities(ISensorEnvironment env, Class<? extends Entity> entityClass) {
        List mobs = env.getWorld().func_72872_a(entityClass, AdapterSensor.getBoundingBox(env.getLocation(), env.getSensorRange()));
        ArrayList ids = Lists.newArrayList();
        for (EntityLiving mob : mobs) {
            ids.add(mob.field_70157_k);
        }
        return ids;
    }

    private static Map<String, Object> getEntityInfo(ISensorEnvironment sensor, int mobId) {
        Entity mob = sensor.getWorld().func_73045_a(mobId);
        return mob != null ? EntityUtils.entityToMap((Entity)mob, (Vec3)sensor.getLocation()) : null;
    }

    @LuaMethod(returnType=LuaType.TABLE, onTick=false, description="Get the usernames of all the players in range")
    public List<String> getPlayerNames(ISensorEnvironment env) {
        List players = env.getWorld().func_72872_a(EntityPlayer.class, AdapterSensor.getBoundingBox(env.getLocation(), env.getSensorRange()));
        ArrayList names = Lists.newArrayList();
        for (EntityPlayer player : players) {
            names.add(player.field_71092_bJ);
        }
        return names;
    }

    @LuaCallable(returnTypes={LuaType.TABLE}, description="Get the ids of all the mobs in range")
    public List<Integer> getMobIds(ISensorEnvironment env) {
        return AdapterSensor.listEntities(env, EntityLiving.class);
    }

    @LuaCallable(returnTypes={LuaType.TABLE}, description="Get the ids of all the minecarts in range")
    public List<Integer> getMinecartIds(ISensorEnvironment env) {
        return AdapterSensor.listEntities(env, EntityMinecart.class);
    }

    @LuaCallable(returnTypes={LuaType.TABLE}, description="Get full details of a particular player if they're in range")
    public Map<?, ?> getPlayerData(ISensorEnvironment env, @Arg(type=LuaType.STRING, name="username", description="The players username") String username) {
        EntityPlayer player = env.getWorld().func_72924_a(username);
        return player != null ? EntityUtils.entityToMap((Entity)player, (Vec3)env.getLocation()) : null;
    }

    @LuaCallable(returnTypes={LuaType.TABLE}, description="Get full details of a particular mob if it's in range")
    public Map<String, Object> getMobData(ISensorEnvironment sensor, @Arg(type=LuaType.NUMBER, name="mobId", description="The mob id retrieved from getMobIds()") int mobId) {
        return AdapterSensor.getEntityInfo(sensor, mobId);
    }

    @LuaCallable(returnTypes={LuaType.TABLE}, description="Get full details of a particular minecart if it's in range")
    public Map<?, ?> getMinecartData(ISensorEnvironment sensor, @Arg(type=LuaType.NUMBER, name="minecartId", description="The minecart id retrieved from getMobIds()") int minecartId) {
        return AdapterSensor.getEntityInfo(sensor, minecartId);
    }

    @LuaCallable(returnTypes={LuaType.TABLE}, description="Get a table of information about the surrounding area. Includes whether each block is UNKNOWN, AIR, LIQUID or SOLID")
    public Map<Integer, Map<String, Object>> sonicScan(ISensorEnvironment env) {
        int range = 1 + env.getSensorRange() / 6;
        World world = env.getWorld();
        HashMap results = Maps.newHashMap();
        Vec3 sensorPos = env.getLocation();
        int sx = (int)sensorPos.field_72450_a;
        int sy = (int)sensorPos.field_72448_b;
        int sz = (int)sensorPos.field_72449_c;
        int i = 0;
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    String type = "UNKNOWN";
                    if ((x != 0 || y != 0 || z != 0) && world.func_72899_e(sx + x, sy + y, sz + z)) {
                        Vec3 targetPos;
                        int bX = sx + x;
                        int bY = sy + y;
                        int bZ = sz + z;
                        int id = world.func_72798_a(bX, bY, bZ);
                        Block block = Block.field_71973_m[id];
                        if (id != 0 && block != null && sensorPos.func_72438_d(targetPos = Vec3.func_72443_a((double)bX, (double)bY, (double)bZ)) <= (double)range) {
                            if (id == 0) {
                                type = "AIR";
                            } else if (block.field_72018_cp.func_76224_d()) {
                                type = "LIQUID";
                            } else if (block.field_72018_cp.func_76220_a()) {
                                type = "SOLID";
                            }
                        }
                    }
                    HashMap tmp = Maps.newHashMap();
                    tmp.put("x", x);
                    tmp.put("y", y);
                    tmp.put("z", z);
                    tmp.put("type", type);
                    results.put(++i, tmp);
                }
            }
        }
        return results;
    }
}

