/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.ForgeSubscribe;
import openperipheral.addons.glasses.Drawable;
import openperipheral.addons.glasses.ItemGlasses;
import openperipheral.addons.glasses.SurfaceClient;
import openperipheral.addons.glasses.TerminalEvent;

public class TerminalManagerClient {
    private final Table<Long, String, SurfaceClient> surfaces = HashBasedTable.create();

    private void tryDrawSurface(long guid, String player, float partialTicks) {
        SurfaceClient surface = (SurfaceClient)this.surfaces.get((Object)guid, (Object)player);
        if (surface != null) {
            for (Drawable drawable : surface) {
                drawable.draw(partialTicks);
            }
        }
    }

    @ForgeSubscribe
    public void onRenderGameOverlay(RenderGameOverlayEvent evt) {
        Long guid;
        EntityClientPlayerMP player;
        ItemStack helmet;
        if (evt.type == RenderGameOverlayEvent.ElementType.HELMET && evt instanceof RenderGameOverlayEvent.Post && (helmet = ItemGlasses.getGlassesItem((EntityPlayer)(player = Minecraft.func_71410_x().field_71439_g))) != null && (guid = ItemGlasses.extractGuid(helmet)) != null) {
            this.tryDrawSurface(guid, "GLOBAL", evt.partialTicks);
            this.tryDrawSurface(guid, "PRIVATE", evt.partialTicks);
        }
    }

    @ForgeSubscribe
    public void onTerminalData(TerminalEvent.TerminalDataEvent evt) {
        String playerName = evt.isPrivate ? "PRIVATE" : "GLOBAL";
        SurfaceClient surface = (SurfaceClient)this.surfaces.get((Object)evt.terminalId, (Object)playerName);
        if (surface == null) {
            surface = new SurfaceClient(evt.terminalId, evt.isPrivate);
            this.surfaces.put((Object)evt.terminalId, (Object)playerName, (Object)surface);
        }
        surface.interpretCommandList((List)evt.commands);
    }
}

