/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import dan200.computer.api.ILuaObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import openmods.structured.ElementField;
import openmods.structured.IStructureContainer;
import openmods.structured.StructuredDataMaster;
import openperipheral.addons.glasses.Drawable;
import openperipheral.api.Arg;
import openperipheral.api.Freeform;
import openperipheral.api.LuaCallable;
import openperipheral.api.LuaType;
import openperipheral.util.LuaObjectBuilder;
import openperipheral.util.Property;

@Freeform
public class SurfaceServer
extends StructuredDataMaster<DrawableWrapper, ElementField> {
    public final String playerName;

    public SurfaceServer(String playerName) {
        this.playerName = playerName;
    }

    public synchronized void setDeleted(DrawableWrapper d) {
        this.removeContainer(d.containerId);
    }

    public synchronized ILuaObject getById(int id) {
        return ((DrawableWrapper)this.containers.get((Object)Integer.valueOf((int)id))).luaWrapper;
    }

    @LuaCallable(description="Clear all the objects from the screen")
    public synchronized void clear() {
        this.removeAll();
    }

    @LuaCallable(returnTypes={LuaType.TABLE}, description="Get the Ids of all the objects on the screen")
    public synchronized Integer[] getAllIds() {
        return this.containers.keySet().toArray(new Integer[this.containers.size()]);
    }

    @LuaCallable(returnTypes={LuaType.TABLE}, description="Get all objects on the screen")
    public synchronized Map<Integer, ILuaObject> getAllObjects() {
        HashMap result = Maps.newHashMap();
        for (Map.Entry e : this.containers.entrySet()) {
            result.put(e.getKey(), ((DrawableWrapper)e.getValue()).luaWrapper);
        }
        return result;
    }

    private synchronized ILuaObject addDrawable(Drawable drawable) {
        DrawableWrapper wrapper = new DrawableWrapper(drawable);
        wrapper.containerId = this.addContainer(wrapper);
        return wrapper.luaWrapper;
    }

    @LuaCallable(returnTypes={LuaType.OBJECT}, description="Add a new text object to the screen")
    public ILuaObject addText(@Arg(name="x", description="The x position from the top left", type=LuaType.NUMBER) short x, @Arg(name="y", description="The y position from the top left", type=LuaType.NUMBER) short y, @Arg(name="text", description="The text to display", type=LuaType.STRING) String text, @Arg(name="color", description="The text color", type=LuaType.NUMBER) int color) {
        return this.addDrawable(new Drawable.Text(x, y, text, color));
    }

    @LuaCallable(returnTypes={LuaType.OBJECT}, description="Add a new box to the screen")
    public ILuaObject addBox(@Arg(name="x", description="The x position from the top left", type=LuaType.NUMBER) short x, @Arg(name="y", description="The y position from the top left", type=LuaType.NUMBER) short y, @Arg(name="width", description="The width of the box", type=LuaType.NUMBER) short width, @Arg(name="height", description="The height of the box", type=LuaType.NUMBER) short height, @Arg(name="color", description="The color of the box", type=LuaType.NUMBER) int color, @Arg(name="opacity", description="The opacity of the box (from 0 to 1)", type=LuaType.NUMBER) float opacity) {
        return this.addDrawable(new Drawable.SolidBox(x, y, width, height, color, opacity));
    }

    @LuaCallable(returnTypes={LuaType.OBJECT}, description="Add a new gradient box to the screen")
    public ILuaObject addGradientBox(@Arg(name="x", description="The x position from the top left", type=LuaType.NUMBER) short x, @Arg(name="y", description="The y position from the top left", type=LuaType.NUMBER) short y, @Arg(name="width", description="The width of the box", type=LuaType.NUMBER) short width, @Arg(name="height", description="The height of the box", type=LuaType.NUMBER) short height, @Arg(name="color", description="The color of the box", type=LuaType.NUMBER) int color, @Arg(name="opacity", description="The opacity of the box (from 0 to 1)", type=LuaType.NUMBER) float alpha, @Arg(name="color", description="The color of the other side of the box", type=LuaType.NUMBER) int color2, @Arg(name="opacity", description="The opacity of the other side of the box (from 0 to 1)", type=LuaType.NUMBER) float alpha2, @Arg(name="gradient", description="The gradient direction (1 for horizontal, 2 for vertical)", type=LuaType.NUMBER) int gradient) {
        return this.addDrawable(new Drawable.GradientBox(x, y, width, height, color, alpha, color2, alpha2, gradient));
    }

    @LuaCallable(returnTypes={LuaType.OBJECT}, description="Add an icon of an item to the screen")
    public ILuaObject addIcon(@Arg(name="x", description="The x position from the top left", type=LuaType.NUMBER) short x, @Arg(name="y", description="The y position from the top left", type=LuaType.NUMBER) short y, @Arg(name="id", description="The id of the item to draw", type=LuaType.NUMBER) short id, @Arg(name="meta", description="The meta of the item to draw", type=LuaType.NUMBER) short meta) {
        return this.addDrawable(new Drawable.ItemIcon(x, y, id, meta));
    }

    @LuaCallable(returnTypes={LuaType.OBJECT}, description="Add a box textured like a liquid to the screen")
    public ILuaObject addLiquid(@Arg(name="x", description="The x position from the top left", type=LuaType.NUMBER) short x, @Arg(name="y", description="The y position from the top left", type=LuaType.NUMBER) short y, @Arg(name="width", description="The width of the liquid box", type=LuaType.NUMBER) short width, @Arg(name="height", description="The height of the liquid box", type=LuaType.NUMBER) short height, @Arg(name="string", description="The name of the fluid to render", type=LuaType.STRING) String id) {
        return this.addDrawable(new Drawable.LiquidIcon(x, y, width, height, id));
    }

    public class DrawableWrapper
    implements IStructureContainer<ElementField>,
    LuaObjectBuilder.IAccessCallback {
        public int containerId;
        public final Drawable target;
        public final ILuaObject luaWrapper;
        public final Map<Field, ElementField> fields = Maps.newHashMap();

        public DrawableWrapper(Drawable target) {
            this.target = target;
            this.luaWrapper = LuaObjectBuilder.build(target.getClass(), (LuaObjectBuilder.IAccessCallback)this);
        }

        public void setField(Field field, Object value) {
            ElementField fieldWrapper = this.fields.get(field);
            Preconditions.checkNotNull((Object)fieldWrapper, (Object)"LOGIC FAIL. BLAME MOD DEVS");
            SurfaceServer.this.markElementModified(fieldWrapper.elementId);
            fieldWrapper.set(value);
        }

        public Object getField(Field field) {
            ElementField fieldWrapper = this.fields.get(field);
            Preconditions.checkNotNull((Object)fieldWrapper, (Object)"LOGIC FAIL. BLAME MOD DEVS");
            return fieldWrapper.get();
        }

        public int getType() {
            return this.target.getTypeId();
        }

        public List<ElementField> createElements() {
            ArrayList result = Lists.newArrayList();
            for (Field field : this.target.getClass().getFields()) {
                field.setAccessible(true);
                if (!field.isAnnotationPresent(Property.class)) continue;
                ElementField fieldWrapper = new ElementField((Object)this.target, field);
                result.add(fieldWrapper);
                this.fields.put(field, fieldWrapper);
            }
            return result;
        }

        public void onElementAdded(ElementField element, int index) {
            element.elementId = index;
        }
    }
}

