/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import openmods.structured.ElementField;
import openmods.structured.IStructureContainer;
import openmods.structured.IStructureContainerFactory;
import openmods.structured.StructuredDataSlave;
import openperipheral.addons.glasses.Drawable;
import openperipheral.addons.glasses.TerminalEvent;
import openperipheral.util.Property;

public class SurfaceClient
extends StructuredDataSlave<DrawableWrapper, ElementField>
implements Iterable<Drawable> {
    private static final IStructureContainerFactory<DrawableWrapper> FACTORY = new IStructureContainerFactory<DrawableWrapper>(){

        public DrawableWrapper createContainer(int type) {
            Drawable newDrawable = Drawable.createFromTypeId(type);
            return new DrawableWrapper(newDrawable);
        }
    };
    public final long terminalId;
    public final boolean isPrivate;

    public SurfaceClient(long terminalId, boolean isPrivate) {
        super(FACTORY);
        this.terminalId = terminalId;
        this.isPrivate = isPrivate;
    }

    protected void onConsistencyCheckFail() {
        new TerminalEvent.TerminalResetEvent(this.terminalId, this.isPrivate).sendToServer();
    }

    @Override
    public Iterator<Drawable> iterator() {
        final Iterator it = this.containers.values().iterator();
        return new Iterator<Drawable>(){

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Drawable next() {
                return ((DrawableWrapper)it.next()).target;
            }

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }
        };
    }

    public static class DrawableWrapper
    implements IStructureContainer<ElementField> {
        public int containerId;
        public final Drawable target;

        public DrawableWrapper(Drawable target) {
            this.target = target;
        }

        public int getType() {
            return this.target.getTypeId();
        }

        public List<ElementField> createElements() {
            ArrayList result = Lists.newArrayList();
            for (Field field : this.target.getClass().getFields()) {
                field.setAccessible(true);
                if (!field.isAnnotationPresent(Property.class)) continue;
                result.add(new ElementField((Object)this.target, field));
            }
            return result;
        }

        public void onElementAdded(ElementField element, int index) {
            element.elementId = index;
        }
    }
}

