/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumArmorMaterial;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import openmods.utils.ItemUtils;
import openmods.utils.MiscUtils;
import openperipheral.addons.Config;
import openperipheral.addons.OpenPeripheralAddons;
import openperipheral.addons.glasses.TerminalManagerServer;
import openperipheral.addons.glasses.TerminalUtils;

public class ItemGlasses
extends ItemArmor {
    public ItemGlasses() {
        super(Config.itemGlassesId, EnumArmorMaterial.CHAIN, 0, 0);
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77637_a(OpenPeripheralAddons.tabOpenPeripheralAddons);
        this.func_77655_b("openperipheral.glasses");
    }

    public static Long extractGuid(ItemStack stack) {
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
        if (!tag.func_74764_b("openp")) {
            return null;
        }
        NBTTagCompound openp = tag.func_74775_l("openp");
        return TerminalUtils.extractGuid(openp);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        Long guid = ItemGlasses.extractGuid(itemStack);
        if (guid != null) {
            list.add(StatCollector.func_74837_a((String)"openperipheral.misc.key", (Object[])new Object[]{TerminalUtils.formatTerminalId(guid)}));
        }
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, int layer) {
        switch (MiscUtils.getHoliday()) {
            case 1: {
                return "openperipheraladdons:textures/models/glasses_valentines.png";
            }
            case 2: {
                return "openperipheraladdons:textures/models/glasses_halloween.png";
            }
            case 3: {
                return "openperipheraladdons:textures/models/glasses_christmas.png";
            }
        }
        return "openperipheraladdons:textures/models/glasses.png";
    }

    public void func_94581_a(IconRegister register) {
        this.field_77791_bV = register.func_94245_a("openperipheraladdons:glasses");
    }

    public void onArmorTickUpdate(World world, EntityPlayer player, ItemStack itemStack) {
        Long guid;
        if (!world.field_72995_K && (guid = ItemGlasses.extractGuid(itemStack)) != null) {
            TerminalManagerServer.instance.onGlassesTick(player, guid);
        }
    }

    static ItemStack getGlassesItem(EntityPlayer player) {
        if (player == null) {
            return null;
        }
        ItemStack headSlot = player.field_71071_by.func_70440_f(3);
        if (headSlot == null || !(headSlot.func_77973_b() instanceof ItemGlasses)) {
            return null;
        }
        return headSlot;
    }
}

