/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import openperipheral.addons.glasses.GlassesRenderingUtils;
import openperipheral.util.Property;
import org.lwjgl.opengl.GL11;

public abstract class Drawable {
    @Property
    public short x;
    @Property
    public short y;
    @Property
    public short z;

    protected Drawable() {
    }

    protected Drawable(short x, short y) {
        this.x = x;
        this.y = y;
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(float partialTicks) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)this.x, (double)this.y, (double)this.z);
        this.drawContents(partialTicks);
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    protected abstract void drawContents(float var1);

    protected abstract Type getType();

    public int getTypeId() {
        return this.getType().ordinal();
    }

    public static Drawable createFromTypeId(int id) {
        Type type = Type.TYPES[id];
        return type.create();
    }

    public static class Text
    extends Drawable {
        @Property
        public String text;
        @Property
        public int color;
        @Property
        public double alpha = 1.0;
        @Property
        public float scale = 1.0f;

        private Text() {
        }

        public Text(short x, short y, String text, int color) {
            super(x, y);
            this.text = text;
            this.color = color;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        protected void drawContents(float partialTicks) {
            FontRenderer fontRenderer = FMLClientHandler.instance().getClient().field_71466_p;
            GL11.glScalef((float)this.scale, (float)this.scale, (float)this.scale);
            fontRenderer.func_78276_b(this.text, 0, 0, (int)(this.alpha * 255.0) << 24 | this.color);
        }

        @Override
        public Type getType() {
            return Type.TEXT;
        }
    }

    public static class LiquidIcon
    extends Drawable {
        @Property
        public short width;
        @Property
        public short height;
        @Property
        public String fluid;
        @Property
        public float alpha = 1.0f;

        private LiquidIcon() {
        }

        public LiquidIcon(short x, short y, short width, short height, String fluid) {
            super(x, y);
            this.width = width;
            this.height = height;
            this.fluid = fluid;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        protected void drawContents(float partialTicks) {
            Fluid drawLiquid = FluidRegistry.getFluid((String)this.fluid);
            if (drawLiquid == null) {
                return;
            }
            Icon fluidIcon = drawLiquid.getFlowingIcon();
            if (fluidIcon == null) {
                return;
            }
            int iconWidth = fluidIcon.func_94211_a();
            int iconHeight = fluidIcon.func_94216_b();
            if (iconWidth <= 0 || iconHeight <= 0) {
                return;
            }
            TextureManager render = FMLClientHandler.instance().getClient().field_71446_o;
            render.func_110577_a(TextureMap.field_110575_b);
            float xIterations = (float)this.width / (float)iconWidth;
            float yIterations = (float)this.height / (float)iconHeight;
            for (float xIteration = 0.0f; xIteration < xIterations; xIteration += 1.0f) {
                for (float yIteration = 0.0f; yIteration < yIterations; yIteration += 1.0f) {
                    float xDrawSize = Math.min(xIterations - xIteration, 1.0f);
                    float yDrawSize = Math.min(yIterations - yIteration, 1.0f);
                    GlassesRenderingUtils.drawTexturedQuadAdvanced(xIteration * (float)iconWidth, yIteration * (float)iconHeight, fluidIcon, xDrawSize * (float)iconWidth, yDrawSize * (float)iconHeight, xDrawSize, yDrawSize, this.alpha);
                }
            }
        }

        @Override
        public Type getType() {
            return Type.LIQUID;
        }
    }

    public static class ItemIcon
    extends Drawable {
        @Property
        public float scale = 1.0f;
        @Property
        public float angle = 30.0f;
        @Property
        public int id;
        @Property
        public int meta;
        private static ItemStack drawStack = new ItemStack(0, 1, 0);

        private ItemIcon() {
        }

        public ItemIcon(short x, short y, int id, int meta) {
            super(x, y);
            this.id = id;
            this.meta = meta;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        protected void drawContents(float partialTicks) {
            Item item;
            ItemIcon.drawStack.field_77993_c = this.id;
            try {
                item = drawStack.func_77973_b();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return;
            }
            if (item == null) {
                return;
            }
            drawStack.func_77964_b(this.meta);
            FontRenderer renderer = FMLClientHandler.instance().getClient().field_71466_p;
            if (item instanceof ItemBlock) {
                GlassesRenderingUtils.renderRotatingBlockIntoGUI(renderer, drawStack, 1, 1, this.scale, this.angle);
            } else {
                GlassesRenderingUtils.renderItemIntoGUI(renderer, drawStack, 0, 0, this.scale);
            }
        }

        @Override
        public Type getType() {
            return Type.ITEM;
        }
    }

    public static class GradientBox
    extends Drawable {
        @Property
        public short width;
        @Property
        public short height;
        @Property
        public int color1;
        @Property
        public float opacity1;
        @Property
        public int color2;
        @Property
        public float opacity2;
        @Property
        public int gradient;

        private GradientBox() {
        }

        public GradientBox(short x, short y, short width, short height, int color1, float opacity1, int color2, float opacity2, int gradient) {
            super(x, y);
            this.width = width;
            this.height = height;
            this.color1 = color1;
            this.opacity1 = opacity1;
            if (gradient == 0) {
                this.color2 = color1;
                this.opacity2 = opacity1;
            } else {
                this.color2 = color2;
                this.opacity2 = opacity2;
            }
            this.gradient = gradient;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        protected void drawContents(float partialTicks) {
            GL11.glEnable((int)3042);
            GL11.glDisable((int)3553);
            GL11.glDisable((int)3008);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glShadeModel((int)7425);
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            tessellator.func_78384_a(this.color1, (int)(this.opacity1 * 255.0f));
            if (this.gradient == 1) {
                tessellator.func_78377_a(0.0, (double)this.height, 0.0);
                tessellator.func_78377_a((double)this.width, (double)this.height, 0.0);
            } else {
                tessellator.func_78377_a((double)this.width, (double)this.height, 0.0);
                tessellator.func_78377_a((double)this.width, 0.0, 0.0);
            }
            tessellator.func_78384_a(this.color2, (int)(this.opacity2 * 255.0f));
            if (this.gradient == 1) {
                tessellator.func_78377_a((double)this.width, 0.0, 0.0);
                tessellator.func_78377_a(0.0, 0.0, 0.0);
            } else {
                tessellator.func_78377_a(0.0, 0.0, 0.0);
                tessellator.func_78377_a(0.0, (double)this.height, 0.0);
            }
            tessellator.func_78381_a();
            GL11.glShadeModel((int)7424);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)3008);
        }

        @Override
        public Type getType() {
            return Type.GRADIENT;
        }
    }

    public static class SolidBox
    extends Drawable {
        @Property
        public short width;
        @Property
        public short height;
        @Property
        public int color;
        @Property
        public float opacity;

        private SolidBox() {
        }

        public SolidBox(short x, short y, short width, short height, int color, float opacity) {
            super(x, y);
            this.width = width;
            this.height = height;
            this.color = color;
            this.opacity = opacity;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        protected void drawContents(float partialTicks) {
            GL11.glEnable((int)3042);
            GL11.glDisable((int)3553);
            GL11.glDisable((int)3008);
            GL11.glBlendFunc((int)770, (int)771);
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            tessellator.func_78384_a(this.color, (int)(this.opacity * 255.0f));
            tessellator.func_78377_a(0.0, 0.0, 0.0);
            tessellator.func_78377_a(0.0, (double)this.height, 0.0);
            tessellator.func_78377_a((double)this.width, (double)this.height, 0.0);
            tessellator.func_78377_a((double)this.width, 0.0, 0.0);
            tessellator.func_78381_a();
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)3008);
        }

        @Override
        public Type getType() {
            return Type.BOX;
        }
    }

    private static enum Type {
        GRADIENT{

            @Override
            public Drawable create() {
                return new GradientBox();
            }
        }
        ,
        BOX{

            @Override
            public Drawable create() {
                return new SolidBox();
            }
        }
        ,
        TEXT{

            @Override
            public Drawable create() {
                return new Text();
            }
        }
        ,
        LIQUID{

            @Override
            public Drawable create() {
                return new LiquidIcon();
            }
        }
        ,
        ITEM{

            @Override
            public Drawable create() {
                return new ItemIcon();
            }
        };

        public static final Type[] TYPES;

        public abstract Drawable create();

        static {
            TYPES = Type.values();
        }
    }
}

