/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.core;

import codechicken.core.CommonUtils;
import codechicken.lib.config.ConfigFile;
import codechicken.lib.config.SimpleProperties;
import codechicken.lib.vec.BlockCoord;
import codechicken.wirelessredstone.core.RedstoneEther;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class SaveManager {
    private RandomAccessFile freqMapFile;
    private RandomAccessFile smallSectorFile;
    private RandomAccessFile largeSectorFile;
    private RandomAccessFile rwfile;
    protected static SimpleProperties freqProp;
    protected static SimpleProperties generalProp;
    private static ConfigFile globalconfig;
    private static File activeMapFile;
    private ArrayList<Boolean> usedSmallSectors;
    private ArrayList<Boolean> usedLargeSectors;
    private int[] freqMapOffsets;
    private long lastcleanuptime;
    private int dimension;
    private static ArrayList<Map.Entry<Integer, Integer>>[] freqDimensionHashes;
    private static boolean hashChanged;
    private static boolean loadinginfo;
    private static HashMap<Integer, SaveManager> managers;
    private final int largesectorsize = 256;
    private final int largesectornodes = 21;
    private final int smallsectorsize = 64;
    private final int smallsectornodes = 5;
    private final int largesectoroffset = Short.MAX_VALUE;
    private final int maxsmallnodes = 5;
    private final int cleanuptimeneeded = 300000;

    public static SaveManager getInstance(int dimension) {
        return managers.get(dimension);
    }

    public static void reloadSave(abw world, int dimension) {
        managers.put(dimension, new SaveManager(world, dimension));
    }

    public static void unloadSave(int dimension) {
        SaveManager m = managers.remove(dimension);
        if (m != null) {
            m.unload();
        }
    }

    public static void resetWorld(abw world) {
        try {
            if (managers.size() == 0) {
                File etherdir = SaveManager.getEtherDir(world, 0);
                File file = new File(etherdir, "fprop.dat");
                if (!file.exists()) {
                    file.createNewFile();
                }
                freqProp = new SimpleProperties(file, true);
                file = new File(etherdir, "gprop.dat");
                if (!file.exists()) {
                    file.createNewFile();
                }
                generalProp = new SimpleProperties(file, true);
                generalProp.load();
                file = new File(etherdir, "dimMap.dat");
                if (!file.exists()) {
                    file.createNewFile();
                }
                activeMapFile = file;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private SaveManager(abw world, int dimension) {
        try {
            this.dimension = dimension;
            File etherdir = SaveManager.getEtherDir(world, dimension);
            File file = new File(etherdir, "fmap.dat");
            boolean newlycreated = false;
            if (!file.exists()) {
                file.createNewFile();
                newlycreated = true;
            }
            this.freqMapFile = new RandomAccessFile(file, "rw");
            if (newlycreated) {
                for (int i = 0; i < 5000; ++i) {
                    this.freqMapFile.writeShort(-1);
                }
            }
            if (!(file = new File(etherdir, "node1.dat")).exists()) {
                file.createNewFile();
            }
            this.smallSectorFile = new RandomAccessFile(file, "rw");
            file = new File(etherdir, "node2.dat");
            if (!file.exists()) {
                file.createNewFile();
            }
            this.largeSectorFile = new RandomAccessFile(file, "rw");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static File getEtherDir(abw world, int dimension) {
        File dir = new File(CommonUtils.getWorldSaveLocation((abw)world, (int)dimension), "RedstoneEther");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    private void setFreqSector(int freq, int sector) {
        try {
            this.freqMapOffsets[freq - 1] = sector;
            this.freqMapFile.seek((freq - 1) * 2);
            this.freqMapFile.writeShort(sector);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void seekSector(int sector) {
        try {
            if (sector >= Short.MAX_VALUE) {
                this.rwfile = this.largeSectorFile;
                this.rwfile.seek((sector -= Short.MAX_VALUE) * 256);
            } else {
                this.rwfile = this.smallSectorFile;
                this.rwfile.seek(sector * 64);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void setSectorUsed(int sector, boolean used) {
        ArrayList<Boolean> usedsectors;
        ArrayList<Boolean> arrayList = usedsectors = sector >= Short.MAX_VALUE ? this.usedLargeSectors : this.usedSmallSectors;
        if (sector >= Short.MAX_VALUE) {
            sector -= Short.MAX_VALUE;
        }
        usedsectors.set(sector, used);
    }

    private int getNewSector(boolean large) {
        try {
            if (large) {
                RandomAccessFile file = this.largeSectorFile;
                long prevpos = file.getFilePointer();
                file.seek(file.length());
                file.writeShort(-1);
                file.write(new byte[254]);
                file.seek(prevpos);
                this.usedLargeSectors.add(false);
                return (int)file.length() / 256 - 1 + Short.MAX_VALUE;
            }
            RandomAccessFile file = this.smallSectorFile;
            long prevpos = file.getFilePointer();
            file.seek(file.length());
            file.writeShort(-1);
            file.write(new byte[62]);
            file.seek(prevpos);
            this.usedSmallSectors.add(false);
            return (int)file.length() / 64 - 1;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private int getUnusedSector(int numnodes) {
        boolean largesector = numnodes > 5;
        ArrayList<Boolean> usedsectors = largesector ? this.usedLargeSectors : this.usedSmallSectors;
        for (int i = 0; i < usedsectors.size(); ++i) {
            if (usedsectors.get(i).booleanValue()) continue;
            return i + (largesector ? Short.MAX_VALUE : 0);
        }
        return this.getNewSector(numnodes > 5);
    }

    private void setNextSector(int sector, int nextsector) {
        this.seekSector(sector);
        try {
            this.rwfile.writeShort((short)nextsector);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void setSectorLength(int sector, int numnodes) {
        this.seekSector(sector);
        try {
            this.rwfile.skipBytes(2);
            this.rwfile.writeShort((short)numnodes);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private int getNextSector(int sector) {
        this.seekSector(sector);
        try {
            int nextsector = this.rwfile.readShort() & 0xFFFF;
            if (nextsector == 65535) {
                nextsector = -1;
            }
            return nextsector;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private int getSectorLength(int sector) {
        this.seekSector(sector);
        try {
            this.rwfile.skipBytes(2);
            return this.rwfile.readShort() & 0xFFFF;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void markSectorStackUnused(int firstsector) {
        int nextsector = firstsector;
        while (nextsector != -1) {
            int sector = nextsector;
            this.setSectorUsed(sector, false);
            this.setNextSector(sector, -1);
            nextsector = this.getNextSector(nextsector);
        }
    }

    private void writeNodes(int freq, int numnodes, ArrayList<BlockCoord> nodes) {
        try {
            int nextsector = this.freqMapOffsets[freq - 1];
            if (nextsector == -1) {
                nextsector = this.getUnusedSector(numnodes);
                this.setSectorUsed(nextsector, true);
                this.setFreqSector(freq, nextsector);
            } else {
                this.markSectorStackUnused(nextsector);
                this.setSectorUsed(nextsector, true);
            }
            while (true) {
                int writtennodes;
                int nodespersector;
                this.seekSector(nextsector);
                this.rwfile.skipBytes(4);
                int thissector = nextsector;
                boolean largesector = nextsector >= Short.MAX_VALUE;
                int n = nodespersector = largesector ? 21 : 5;
                for (writtennodes = 0; writtennodes != nodespersector && numnodes > 0; --numnodes, ++writtennodes) {
                    BlockCoord node = nodes.get(nodes.size() - numnodes);
                    this.rwfile.writeInt(node.x);
                    this.rwfile.writeInt(node.y);
                    this.rwfile.writeInt(node.z);
                }
                this.setSectorLength(thissector, writtennodes);
                if (numnodes == 0) {
                    this.setNextSector(thissector, -1);
                    break;
                }
                nextsector = this.getUnusedSector(numnodes);
                this.setSectorUsed(nextsector, true);
                this.setNextSector(thissector, nextsector);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void saveFreq(int freq, int activetransmitters, TreeMap<BlockCoord, Boolean> transmittermap, Map<Integer, Integer> dimensionHash) {
        try {
            SaveManager.freqDimensionHashes[freq] = new ArrayList<Map.Entry<Integer, Integer>>(dimensionHash.entrySet());
            hashChanged = true;
            int numnodes = 0;
            ArrayList<BlockCoord> nodes = new ArrayList<BlockCoord>(activetransmitters);
            Iterator<BlockCoord> iterator = transmittermap.keySet().iterator();
            while (iterator.hasNext() && numnodes < activetransmitters) {
                BlockCoord node = iterator.next();
                if (!transmittermap.get(node).booleanValue()) continue;
                nodes.add(node);
                ++numnodes;
            }
            if (numnodes == 0) {
                this.setFreqSector(freq, -1);
                return;
            }
            this.writeNodes(freq, numnodes, nodes);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void loadFreqMap() {
        try {
            this.freqMapOffsets = new int[5000];
            this.freqMapFile.seek(0L);
            for (int freq = 1; freq <= 5000; ++freq) {
                this.freqMapOffsets[freq - 1] = this.freqMapFile.readShort() & 0xFFFF;
                if (this.freqMapOffsets[freq - 1] != 65535) continue;
                this.freqMapOffsets[freq - 1] = -1;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void initSectors() {
        int i;
        int numlargesectors;
        int numsmallsectors;
        try {
            numsmallsectors = (int)(this.smallSectorFile.length() / 64L);
            numlargesectors = (int)(this.largeSectorFile.length() / 256L);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.usedSmallSectors = new ArrayList(numsmallsectors);
        for (i = 0; i < numsmallsectors; ++i) {
            this.usedSmallSectors.add(false);
        }
        this.usedLargeSectors = new ArrayList(numlargesectors);
        for (i = 0; i < numlargesectors; ++i) {
            this.usedLargeSectors.add(false);
        }
    }

    private void loadNodes() {
        for (int freq = 1; freq <= 5000; ++freq) {
            RedstoneEther.server().setDimensionTransmitterCount(freq, this.dimension, 0);
            int nextsector = this.freqMapOffsets[freq - 1];
            if (nextsector == -1) continue;
            do {
                this.seekSector(nextsector);
                this.setSectorUsed(nextsector, true);
                int numnodes = this.getSectorLength(nextsector);
                for (int j = 0; j < numnodes; ++j) {
                    try {
                        RedstoneEther.server().loadTransmitter(this.dimension, this.rwfile.readInt(), this.rwfile.readInt(), this.rwfile.readInt(), freq);
                        continue;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            } while ((nextsector = this.getNextSector(nextsector)) != -1);
            RedstoneEther.server().setFreqClean(freq, this.dimension);
        }
    }

    public void removeTrailingSectors() {
        try {
            int i;
            if (this.lastcleanuptime != 0L && System.currentTimeMillis() - this.lastcleanuptime < 300000L) {
                return;
            }
            int lastusedsector = -1;
            for (i = 0; i < this.usedLargeSectors.size(); ++i) {
                if (!this.usedLargeSectors.get(i).booleanValue()) continue;
                lastusedsector = i;
            }
            for (i = this.usedLargeSectors.size() - 1; i > lastusedsector; --i) {
                this.usedLargeSectors.remove(i);
            }
            this.largeSectorFile.setLength((lastusedsector + 1) * 256);
            for (i = 0; i < this.usedSmallSectors.size(); ++i) {
                if (!this.usedSmallSectors.get(i).booleanValue()) continue;
                lastusedsector = i;
            }
            for (i = this.usedSmallSectors.size() - 1; i > lastusedsector; --i) {
                this.usedSmallSectors.remove(i);
            }
            this.smallSectorFile.setLength((lastusedsector + 1) * 64);
            this.lastcleanuptime = System.currentTimeMillis();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void loadEther() {
        this.loadFreqMap();
        this.initSectors();
        this.loadNodes();
        this.lastcleanuptime = 0L;
        this.removeTrailingSectors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadFreqInfo() {
        freqProp.load();
        loadinginfo = true;
        Iterator iterator = SaveManager.freqProp.propertyMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            boolean success = false;
            try {
                Integer val = Integer.parseInt(((String)entry.getKey()).substring(0, ((String)entry.getKey()).indexOf(46)));
                if (val == null) continue;
                int freq = val;
                if (((String)entry.getKey()).endsWith(".colour") || ((String)entry.getKey()).endsWith(".c")) {
                    Integer val2 = Integer.parseInt((String)entry.getValue());
                    if (val2 == null) continue;
                    int colourindex = val2;
                    RedstoneEther.server().setFreqColour(freq, colourindex);
                    success = true;
                    continue;
                }
                if (((String)entry.getKey()).endsWith(".name") || ((String)entry.getKey()).endsWith(".n")) {
                    RedstoneEther.server().setFreqName(freq, (String)entry.getValue());
                    success = true;
                    continue;
                }
                if (!((String)entry.getKey()).endsWith(".owner")) continue;
                RedstoneEther.server().setFreqOwner(freq, (String)entry.getValue());
                success = true;
            }
            catch (Exception e) {}
            continue;
            finally {
                if (success) continue;
                iterator.remove();
            }
        }
        loadinginfo = false;
        freqProp.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadDimensionHash() {
        if (activeMapFile.length() == 0L) {
            return;
        }
        try {
            DataInputStream din = new DataInputStream(new FileInputStream(activeMapFile));
            try {
                try {
                    while (true) {
                        RedstoneEther.server().setDimensionTransmitterCount(din.readShort(), din.readInt(), din.readInt());
                    }
                }
                catch (EOFException eof) {
                    din.close();
                }
            }
            catch (Throwable throwable) {
                din.close();
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void saveDimensionHash() {
        if (!hashChanged) {
            return;
        }
        try {
            DataOutputStream dout = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(activeMapFile)));
            for (int freq = 1; freq <= 5000; ++freq) {
                ArrayList<Map.Entry<Integer, Integer>> map = freqDimensionHashes[freq];
                if (map == null) continue;
                for (Map.Entry<Integer, Integer> entry : map) {
                    if (entry.getValue() <= 0) continue;
                    dout.writeShort(freq);
                    dout.writeInt(entry.getKey());
                    dout.writeInt(entry.getValue());
                }
            }
            dout.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ConfigFile config() {
        return globalconfig;
    }

    public static boolean isLoading() {
        return loadinginfo;
    }

    public static void unloadAll() {
        for (SaveManager manager : managers.values()) {
            manager.unload();
        }
        managers.clear();
    }

    private void unload() {
        try {
            this.freqMapFile.close();
            this.smallSectorFile.close();
            this.largeSectorFile.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        freqDimensionHashes = new ArrayList[5001];
        hashChanged = false;
        managers = new HashMap();
        globalconfig = new ConfigFile(new File(CommonUtils.getMinecraftDir() + "/config", "WirelessRedstone.cfg")).setComment("Wireless Redstone Chicken Bones Edition Configuration File:Deleting any element will restore it to it's default value:Block ID's will be automatically generated the first time it's run");
    }
}

