/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.core;

import codechicken.core.CommonUtils;
import codechicken.core.ServerUtils;
import codechicken.lib.math.MathHelper;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Vector3;
import codechicken.wirelessredstone.core.ITileWireless;
import codechicken.wirelessredstone.core.RedstoneEtherClient;
import codechicken.wirelessredstone.core.RedstoneEtherFrequency;
import codechicken.wirelessredstone.core.RedstoneEtherServer;
import codechicken.wirelessredstone.core.SaveManager;
import codechicken.wirelessredstone.core.WRCoreSPH;
import codechicken.wirelessredstone.core.WirelessReceivingDevice;
import codechicken.wirelessredstone.core.WirelessTransmittingDevice;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.TreeSet;

public abstract class RedstoneEther {
    public final boolean remote;
    protected RedstoneEtherFrequency[] freqarray;
    protected HashMap<Integer, DimensionalEtherHash> ethers = new HashMap();
    protected int publicfrequencyend;
    protected int sharedfrequencyend;
    protected int numprivatefreqs;
    protected HashSet<WirelessReceivingDevice> receivingdevices = new HashSet();
    protected HashMap<String, boolean[]> playerJammedMap;
    protected HashMap<Integer, String> privateFreqs;
    protected int processingAddittions = Integer.MAX_VALUE;
    protected HashMap<BlockCoord, Integer> backupmap;
    protected HashMap<of, Integer> jammedentities;
    public static final int numfreqs = 5000;
    public static final int jammerrange = SaveManager.config().getTag("core.jammer.range").setComment("Range In Blocks").getIntValue(10);
    public static final int jammerrangePow2 = jammerrange * jammerrange;
    public static final int jammertimeout = SaveManager.config().getTag("core.jammer.timeout").setComment("Timeout In Seconds:Applies to both blocks and players").getIntValue(60) * 20;
    public static final int jammerrandom = jammertimeout / 3;
    public static final int jammerentitywait = SaveManager.config().getTag("core.jammer.entitydelay").getIntValue(5) * 20;
    public static final int jammerentityretry = SaveManager.config().getTag("core.jammer.entityretry").setComment("Jam an entity again after x seconds").getIntValue(10) * 20;
    public static final int jammerblockwait = SaveManager.config().getTag("core.jammer.blockdelay").setComment("Delay in seconds before jamming the first time").getIntValue(10) * 20;
    public static ye[] coloursetters;
    public static final int numcolours = 14;
    public static final float minrps = 0.02f;
    public static final float maxrps = 2.98f;
    public static final double gradrps = 5.960000038146972E-4;
    public static final String[] localdyenames;
    public static final String[] fulldyenames;
    public static final int[] colours;
    private static RedstoneEtherServer serverEther;
    private static RedstoneEtherClient clientEther;

    public static int pythagorasPow2(BlockCoord node1, BlockCoord node2) {
        return (node1.x - node2.x) * (node1.x - node2.x) + (node1.y - node2.y) * (node1.y - node2.y) + (node1.z - node2.z) * (node1.z - node2.z);
    }

    public static double pythagorasPow2(BlockCoord node, Vector3 point) {
        return ((double)node.x - point.x) * ((double)node.x - point.x) + ((double)node.y - point.y) * ((double)node.y - point.y) + ((double)node.z - point.z) * ((double)node.z - point.z);
    }

    public static void loadServerWorld(abw world) {
        int dimension = CommonUtils.getDimension((abw)world);
        if (serverEther == null) {
            new RedstoneEtherServer().init(world);
        }
        serverEther.addEther(world, dimension);
    }

    public static void unloadServerWorld(abw world) {
        int dimension = CommonUtils.getDimension((abw)world);
        if (serverEther != null) {
            serverEther.remEther(world, dimension);
        }
    }

    public static void loadClientEther(abw world) {
        new RedstoneEtherClient().init(world);
        clientEther.addEther(world, CommonUtils.getDimension((abw)world));
    }

    public static void unloadServer() {
        if (serverEther != null && RedstoneEther.serverEther.ethers.isEmpty()) {
            serverEther.unload();
            serverEther = null;
        }
    }

    public static RedstoneEther get(boolean remote) {
        return remote ? clientEther : serverEther;
    }

    @SideOnly(value=Side.CLIENT)
    public static RedstoneEtherClient client() {
        return clientEther;
    }

    public static RedstoneEtherServer server() {
        return serverEther;
    }

    public static void registerColourSetters(ye[] colours) {
        if (coloursetters != null) {
            throw new IllegalStateException("Colour Setters Already Set");
        }
        if (colours.length != 15) {
            throw new IllegalStateException("Not 15 colours in setter!");
        }
        coloursetters = colours;
    }

    public static ye[] getColourSetters() {
        if (coloursetters == null) {
            coloursetters = new ye[]{new ye(yc.aY, 1, 1), new ye(yc.aY, 1, 2), new ye(yc.aY, 1, 3), new ye(yc.aY, 1, 4), new ye(yc.aY, 1, 5), new ye(yc.aY, 1, 6), new ye(yc.aY, 1, 7), new ye(yc.aY, 1, 8), new ye(yc.aY, 1, 9), new ye(yc.aY, 1, 10), new ye(yc.aY, 1, 11), new ye(yc.aY, 1, 12), new ye(yc.aY, 1, 13), new ye(yc.aY, 1, 14), new ye(yc.aE, 1)};
        }
        return coloursetters;
    }

    public static asp getTile(abw world, BlockCoord node) {
        return world.r(node.x, node.y, node.z);
    }

    public static int[] parseFrequencyRange(String freqstring) {
        String[] splitstring = freqstring.split("-");
        if (splitstring.length == 1) {
            try {
                return new int[]{Integer.parseInt(splitstring[0]), Integer.parseInt(splitstring[0])};
            }
            catch (NumberFormatException numberformatexception) {
                return new int[]{-1, -1};
            }
        }
        if (splitstring.length == 2) {
            try {
                return new int[]{Integer.parseInt(splitstring[0]), Integer.parseInt(splitstring[1])};
            }
            catch (NumberFormatException numberformatexception1) {
                return new int[]{-1, -1};
            }
        }
        return new int[]{-1, -1};
    }

    public static int getRandomTimeout(Random rand) {
        return jammertimeout + rand.nextInt(jammerrandom * 2) - jammerrandom;
    }

    public static float getRotation(double renderTime, int freq) {
        if (freq == 0) {
            return 0.0f;
        }
        float spinangle = (float)(renderTime / 20.0 * (5.960000038146972E-4 * (double)freq + (double)0.02f));
        return spinangle * 6.2832f;
    }

    public static double getSineWave(double renderTime, int speed) {
        return MathHelper.sin((double)(renderTime * 0.017453 * (double)speed));
    }

    protected RedstoneEther(boolean client) {
        this.remote = client;
    }

    public void init(abw world) {
        if (world.I) {
            clientEther = (RedstoneEtherClient)this;
        } else {
            serverEther = (RedstoneEtherServer)this;
        }
        this.freqarray = new RedstoneEtherFrequency[5001];
        for (int freq = 1; freq <= 5000; ++freq) {
            this.freqarray[freq] = new RedstoneEtherFrequency(this, freq);
        }
        this.jammedentities = new HashMap();
        this.playerJammedMap = new HashMap();
        this.privateFreqs = new HashMap();
    }

    protected void addEther(abw world, int dimension) {
        DimensionalEtherHash dimensionalEther = new DimensionalEtherHash();
        this.ethers.put(dimension, dimensionalEther);
        for (int freq = 1; freq <= 5000; ++freq) {
            this.freqarray[freq].addEther(world, dimension);
        }
    }

    public void remEther(abw world, int dimension) {
        this.ethers.remove(dimension);
        for (int freq = 1; freq <= 5000; ++freq) {
            this.freqarray[freq].remEther(dimension);
        }
    }

    public void loadTransmitter(int dimension, int x, int y, int z, int freq) {
        BlockCoord node = new BlockCoord(x, y, z);
        this.ethers.get((Object)Integer.valueOf((int)dimension)).transmittingblocks.put(node, new TXNodeInfo(freq, true));
        this.freqarray[freq].loadTransmitter(node, dimension);
    }

    public boolean isFreqOn(int freq) {
        return this.freqarray[freq].isOn();
    }

    public boolean isPlayerJammed(uf player) {
        Integer timeout = this.jammedentities.get(player);
        return timeout != null && timeout > 0;
    }

    public abstract void jamEntity(of var1, boolean var2);

    private boolean[] getJammedFreqs(String username) {
        boolean[] jammedFreqs = this.playerJammedMap.get(username = username.toLowerCase());
        if (jammedFreqs == null) {
            this.playerJammedMap.put(username, new boolean[5001]);
            this.loadJammedFrequencies(username);
            jammedFreqs = this.playerJammedMap.get(username);
        }
        return jammedFreqs;
    }

    protected void loadJammedFrequencies(String username) {
    }

    public boolean canBroadcastOnFrequency(uf player, int freq) {
        return this.canBroadcastOnFrequency(player.bu, freq);
    }

    public boolean canBroadcastOnFrequency(String username, int freq) {
        if (freq == 0) {
            return true;
        }
        if (freq > 5000 || freq <= 0) {
            return false;
        }
        if (freq <= this.publicfrequencyend) {
            return true;
        }
        if (username != null && this.getJammedFreqs(username)[freq - 1]) {
            return false;
        }
        if (this.privateFreqs.containsKey(freq)) {
            return this.privateFreqs.get(freq).equalsIgnoreCase(username);
        }
        return true;
    }

    public String getJammedFrequencies(String username) {
        int endfreq = this.publicfrequencyend;
        StringBuilder jammedfreqs = new StringBuilder();
        do {
            int[] jammedrange = this.getNextFrequencyRange(username, endfreq + 1, true);
            int startfreq = jammedrange[0];
            endfreq = jammedrange[1];
            if (startfreq == -1) break;
            if (jammedfreqs.length() != 0) {
                jammedfreqs.append(',');
            }
            if (startfreq == endfreq) {
                jammedfreqs.append(startfreq);
                continue;
            }
            jammedfreqs.append(startfreq);
            jammedfreqs.append('-');
            jammedfreqs.append(endfreq);
        } while (endfreq <= 5000);
        return jammedfreqs.toString();
    }

    public int[] getNextFrequencyRange(String username, int beginfreq, boolean jammed) {
        boolean[] jammedFreqs = this.getJammedFreqs(username);
        int currentfreq = beginfreq;
        int startfreq = -1;
        while (true) {
            if (currentfreq > 5000) {
                if (startfreq != -1) {
                    return new int[]{startfreq, 5000};
                }
                return new int[]{-1, -1};
            }
            if (jammedFreqs[currentfreq - 1] == jammed) {
                if (startfreq == -1) {
                    startfreq = currentfreq;
                }
            } else if (startfreq != -1) {
                return new int[]{startfreq, currentfreq - 1};
            }
            ++currentfreq;
        }
    }

    public void setLastPublicFrequency(int freq) {
        this.publicfrequencyend = freq;
        if (!this.remote) {
            SaveManager.generalProp.setProperty("PublicFrequencies", freq);
            WRCoreSPH.sendPublicFrequencyTo(null, this.publicfrequencyend);
        }
        this.verifyPrivateFreqs();
        if (freq > this.sharedfrequencyend) {
            this.setLastSharedFrequency(freq);
        }
    }

    private void verifyPrivateFreqs() {
        Iterator<Integer> iterator = this.privateFreqs.keySet().iterator();
        while (iterator.hasNext()) {
            int freq = iterator.next();
            if (freq > this.publicfrequencyend && freq <= this.sharedfrequencyend) continue;
            iterator.remove();
            if (this.remote) continue;
            WRCoreSPH.sendSetFreqOwner(freq, "");
        }
    }

    public void setLastSharedFrequency(int freq) {
        int prevEnd = Math.max(this.sharedfrequencyend, this.publicfrequencyend);
        this.sharedfrequencyend = freq;
        if (!this.remote) {
            SaveManager.generalProp.setProperty("SharedFrequencies", freq);
            WRCoreSPH.sendSharedFrequencyTo(null, this.publicfrequencyend);
        }
        this.verifyPrivateFreqs();
        for (String username : this.playerJammedMap.keySet()) {
            if (!this.getJammedFrequencies(username).equals("" + (prevEnd + 1) + "-" + 5000)) continue;
            this.setFrequencyRange(username, 1, 5000, false);
            this.setFrequencyRange(username, this.sharedfrequencyend + 1, 5000, true);
        }
    }

    public void setNumPrivateFreqs(int num) {
        this.numprivatefreqs = num;
        if (!this.remote) {
            SaveManager.generalProp.setProperty("PrivateFrequencies", num);
        }
    }

    public int getLastPublicFrequency() {
        return this.publicfrequencyend;
    }

    public int getLastSharedFrequency() {
        return this.sharedfrequencyend;
    }

    public int getNumPrivateFreqs() {
        return this.numprivatefreqs;
    }

    public void setFrequencyRange(String username, int firstfreq, int lastfreq, boolean jam) {
        jv player;
        if (!this.remote && (player = ServerUtils.getPlayer((String)username)) != null) {
            WRCoreSPH.sendSetFrequencyRangeTo((uf)player, firstfreq, lastfreq, jam);
        }
        if (lastfreq > 5000) {
            lastfreq = 5000;
        }
        boolean[] jammedFreqs = this.getJammedFreqs(username);
        for (int settingfreq = firstfreq; settingfreq <= lastfreq; ++settingfreq) {
            jammedFreqs[settingfreq - 1] = jam;
        }
    }

    public int getFreqColour(int freq) {
        int id = this.getFreqColourId(freq);
        if (id == -1) {
            return -1;
        }
        return colours[id];
    }

    public int getFreqColourId(int freq) {
        if (freq == 0 || this.freqarray == null || this.freqarray[freq] == null) {
            return -1;
        }
        return this.freqarray[freq].getColourId();
    }

    public String getFreqColourName(int freq, boolean local) {
        int id = this.getFreqColourId(freq);
        return local ? localdyenames[id] : fulldyenames[id];
    }

    public void setFreqColour(int freq, int colourid) {
        this.freqarray[freq].setColour(colourid);
    }

    public String getFreqName(int freq) {
        if (freq == 0) {
            return null;
        }
        return this.freqarray[freq].getName();
    }

    public void setFreqName(int freq, String name) {
        this.freqarray[freq].setName(name);
    }

    public ArrayList<String> getMatchingAllowedNames(uf player, String match) {
        ArrayList<String> allnames = new ArrayList<String>();
        for (int freq = 1; freq <= 5000; ++freq) {
            String name = this.freqarray[freq].getName();
            if (name == null || name.equals("") || !this.canBroadcastOnFrequency(player, freq) || name.length() < match.length() || !name.substring(0, match.length()).equalsIgnoreCase(match)) continue;
            allnames.add(name);
        }
        return allnames;
    }

    public ArrayList<String> getAllowedNames(uf player) {
        ArrayList<String> allnames = new ArrayList<String>();
        for (int freq = 1; freq <= 5000; ++freq) {
            String name = this.freqarray[freq].getName();
            if (name == null || name.equals("") || !this.canBroadcastOnFrequency(player, freq)) continue;
            allnames.add(name);
        }
        return allnames;
    }

    public ArrayList<String> getAllNames() {
        ArrayList<String> allnames = new ArrayList<String>();
        for (int freq = 1; freq <= 5000; ++freq) {
            String name = this.freqarray[freq].getName();
            if (name == null || name.equals("")) continue;
            allnames.add(name);
        }
        return allnames;
    }

    public int getFreqByName(String slotname) {
        for (int freq = 1; freq <= 5000; ++freq) {
            String name = this.freqarray[freq].getName();
            if (name == null || !name.equals(slotname)) continue;
            return freq;
        }
        return -1;
    }

    public ArrayList<Integer> getPrivateFrequencies(String username) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Map.Entry<Integer, String> entry : this.privateFreqs.entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(username)) continue;
            list.add(entry.getKey());
        }
        return list;
    }

    public boolean isFreqPrivate(int freq) {
        return this.privateFreqs.containsKey(freq);
    }

    public String getFreqOwner(int freq) {
        return this.privateFreqs.get(freq);
    }

    public void removeFreqOwner(int freq) {
        this.privateFreqs.remove(freq);
        if (!this.remote) {
            SaveManager.freqProp.removeProperty(freq + ".owner");
            WRCoreSPH.sendSetFreqOwner(freq, "");
        }
    }

    public void setFreqOwner(int freq, String username) {
        if (username == null || username.equals("")) {
            this.removeFreqOwner(freq);
        } else {
            this.privateFreqs.put(freq, username);
            if (!this.remote && this.getPrivateFrequencies(username).size() < this.numprivatefreqs) {
                this.privateFreqs.put(freq, username);
                if (!SaveManager.isLoading()) {
                    SaveManager.freqProp.setProperty(freq + ".owner", username);
                }
                WRCoreSPH.sendSetFreqOwner(freq, username);
            }
        }
    }

    public abstract void setFreq(ITileWireless var1, int var2);

    static {
        localdyenames = new String[]{"red", "green", "brown", "blue", "purple", "cyan", "silver", "gray", "pink", "lime", "yellow", "lightBlue", "magenta", "orange"};
        fulldyenames = new String[]{"Red", "Green", "Brown", "Blue", "Purple", "Cyan", "Light Gray", "Gray", "Pink", "Lime", "Yellow", "Light Blue", "Magenta", "Orange"};
        colours = new int[]{-5033684, -13408768, -11456486, -14339694, -8704066, -14125417, -8092540, -12369085, -2588264, -12464844, -2175190, -10057261, -3975987, -1341372};
        SaveManager.config().getTag("core.jammer").useBraces();
    }

    static class DimensionalEtherHash {
        TreeMap<BlockCoord, TXNodeInfo> transmittingblocks = new TreeMap();
        TreeMap<BlockCoord, Integer> recievingblocks = new TreeMap();
        HashSet<WirelessTransmittingDevice> transmittingdevices = new HashSet();
        ArrayList<RedstoneEtherFrequency> freqsToSave = new ArrayList();
        TreeSet<BlockCoord> jammerset = new TreeSet();
        TreeMap<BlockCoord, Integer> jammednodes = new TreeMap();

        DimensionalEtherHash() {
        }
    }

    public static class TXNodeInfo {
        public int freq;
        public boolean on;

        public TXNodeInfo(int freq2, boolean b) {
            this.freq = freq2;
            this.on = b;
        }
    }
}

