/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.core;

import codechicken.core.commands.CoreCommand;
import codechicken.wirelessredstone.core.FreqParam;
import codechicken.wirelessredstone.core.RedstoneEther;

public class ParamGet
extends FreqParam {
    @Override
    public void printHelp(CoreCommand.WCommandSender listener) {
        listener.sendChatToPlayer("Usage: freq get [public | shared | private].");
        listener.sendChatToPlayer("Eg. freq get public. Returns the public frequency range.");
        listener.sendChatToPlayer("Eg. freq get shared. Returns the shared frequency range.");
        listener.sendChatToPlayer("Eg. freq get private. Returns the number of private freqs each player can have.");
    }

    @Override
    public String getName() {
        return "get";
    }

    @Override
    public void handleCommand(String playername, String[] subArray, CoreCommand.WCommandSender listener) {
        RedstoneEther ether = RedstoneEther.get(false);
        if (subArray.length != 2) {
            listener.sendChatToPlayer("Invalid number of parameters.");
            return;
        }
        if (subArray[1].equals("public")) {
            listener.sendChatToPlayer("Frequencies 1-" + ether.getLastPublicFrequency() + " are public.");
        } else if (subArray[1].equals("shared")) {
            if (ether.getLastPublicFrequency() >= ether.getLastSharedFrequency()) {
                listener.sendChatToPlayer("There are no shared frequencies.");
            } else {
                listener.sendChatToPlayer("Frequencies " + (ether.getLastPublicFrequency() + 1) + "-" + ether.getLastSharedFrequency() + " are shared.");
            }
        } else if (subArray[1].equals("private")) {
            listener.sendChatToPlayer("All players are allowed " + ether.getNumPrivateFreqs() + " private frequencies.");
        } else {
            listener.sendChatToPlayer("Invalid param");
        }
    }
}

