/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.addons;

import codechicken.core.ClientUtils;
import codechicken.core.ServerUtils;
import codechicken.wirelessredstone.addons.EntityWirelessTracker;
import codechicken.wirelessredstone.addons.RedstoneEtherAddons;
import codechicken.wirelessredstone.addons.RemoteTexManager;
import codechicken.wirelessredstone.addons.TriangTexManager;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;

public class WRAddonEventHandler
implements ITickHandler,
IPlayerTracker {
    public void onPlayerLogin(uf player) {
        RedstoneEtherAddons.server().onLogin(player);
    }

    public void onPlayerLogout(uf player) {
        RedstoneEtherAddons.server().onLogout(player);
    }

    public void onPlayerChangedDimension(uf player) {
        RedstoneEtherAddons.server().onDimensionChange(player);
    }

    public void onPlayerRespawn(uf player) {
        RedstoneEtherAddons.server().onLogin(player);
    }

    public void tickStart(EnumSet<TickType> type, Object ... tickData) {
        if (type.contains(TickType.WORLD)) {
            RedstoneEtherAddons.server().processSMPMaps((abw)tickData[0]);
        }
        if (type.contains(TickType.SERVER)) {
            RedstoneEtherAddons.server().processTrackers();
        }
        if (type.contains(TickType.CLIENT) && ClientUtils.inWorld()) {
            TriangTexManager.processAllTextures();
        }
    }

    public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
        if (type.contains(TickType.SERVER)) {
            RedstoneEtherAddons.server().tickTriangs();
            RedstoneEtherAddons.server().updateREPTimeouts();
        }
        if (type.contains(TickType.CLIENT) && ClientUtils.inWorld()) {
            RedstoneEtherAddons.client().tick();
        }
    }

    public EnumSet<TickType> ticks() {
        return EnumSet.of(TickType.WORLD, TickType.SERVER, TickType.CLIENT, TickType.RENDER);
    }

    public String getLabel() {
        return "WR-CBE Addons";
    }

    @ForgeSubscribe
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.world.I) {
            RedstoneEtherAddons.loadClientManager();
        } else {
            RedstoneEtherAddons.loadServerWorld();
        }
    }

    @ForgeSubscribe
    public void onChunkUnload(ChunkEvent.Unload event) {
        adr chunk = event.getChunk();
        for (int i = 0; i < chunk.j.length; ++i) {
            for (int j = 0; j < chunk.j[i].size(); ++j) {
                Object o = chunk.j[i].get(j);
                if (!(o instanceof EntityWirelessTracker)) continue;
                ((EntityWirelessTracker)o).onChunkUnload();
            }
        }
    }

    @ForgeSubscribe
    @SideOnly(value=Side.CLIENT)
    public void onTextureLoad(TextureStitchEvent.Pre event) {
        if (event.map.g == 1) {
            RemoteTexManager.load(event.map);
            TriangTexManager.loadTextures();
        }
    }

    @ForgeSubscribe
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.world.I) {
            return;
        }
        if (!ServerUtils.mc().o()) {
            RedstoneEtherAddons.unloadServer();
        }
    }
}

