/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.addons;

import codechicken.lib.packet.PacketCustom;
import codechicken.wirelessredstone.addons.ClientMapInfo;
import codechicken.wirelessredstone.addons.EntityREP;
import codechicken.wirelessredstone.addons.EntityWirelessTracker;
import codechicken.wirelessredstone.addons.GuiWirelessSniffer;
import codechicken.wirelessredstone.addons.RedstoneEtherAddons;
import codechicken.wirelessredstone.addons.WirelessMapNodeStorage;
import codechicken.wirelessredstone.core.FreqCoord;

public class WRAddonCPH
implements PacketCustom.IClientPacketHandler {
    public void handlePacket(PacketCustom packet, bcw nethandler, atv mc) {
        this.handlePacket(mc.f, (uf)mc.h, packet);
    }

    private void handlePacket(bdd world, uf player, PacketCustom packet) {
        switch (packet.getType()) {
            case 53: {
                WRAddonCPH.processSnifferFreqUpdate(packet);
                break;
            }
            case 54: {
                WRAddonCPH.processSnifferEtherCopy(packet);
                break;
            }
            case 55: {
                RedstoneEtherAddons.client().setTriangAngle(packet.readUShort(), packet.readFloat());
                break;
            }
            case 56: {
                WRAddonCPH.processMapInfo((abw)world, player, packet);
                break;
            }
            case 57: {
                WRAddonCPH.processMapUpdate((abw)world, player, packet);
                break;
            }
            case 59: {
                if (packet.readBoolean()) {
                    this.throwREP(packet.readInt(), packet.readInt(), world, player);
                    break;
                }
                world.b(packet.readInt());
                break;
            }
            case 60: {
                this.processTrackerUpdate(packet, world, player);
                break;
            }
            case 61: {
                if (packet.readBoolean()) {
                    this.throwTracker(world, player, packet.readInt(), packet.readInt(), packet.readUShort());
                    break;
                }
                world.b(packet.readInt());
            }
        }
    }

    private void throwTracker(bdd world, uf player, int entityID, int throwerID, int freq) {
        nn thrower = world.a(throwerID);
        if (throwerID == player.k) {
            thrower = player;
        }
        if (thrower != null && thrower instanceof og) {
            EntityWirelessTracker tracker = new EntityWirelessTracker((abw)world, 0, (of)((og)thrower));
            tracker.k = entityID;
            world.a(entityID, (nn)tracker);
            world.a(thrower, "random.bow", 0.5f, 0.4f / (world.s.nextFloat() * 0.4f + 0.8f));
        }
    }

    private void processTrackerUpdate(PacketCustom packet, bdd world, uf player) {
        int entityID = packet.readInt();
        int freq = packet.readUShort();
        boolean attached = packet.readBoolean();
        nn e = world.a(entityID);
        if (e != null && e.M) {
            e = null;
        }
        if (!(e instanceof EntityWirelessTracker)) {
            if (e != null) {
                throw new IllegalStateException("EntityID mapped to non tracker");
            }
            e = new EntityWirelessTracker((abw)world, freq);
            e.k = entityID;
            world.a(entityID, e);
        }
        EntityWirelessTracker tracker = (EntityWirelessTracker)e;
        if (attached) {
            int attachedEntityID = packet.readInt();
            Object attachedEntity = attachedEntityID == player.k ? player : world.a(attachedEntityID);
            if (attachedEntity == null) {
                return;
            }
            tracker.attached = true;
            tracker.attachedEntity = attachedEntity;
            tracker.attachedX = packet.readFloat();
            tracker.attachedY = packet.readFloat();
            tracker.attachedZ = packet.readFloat();
            tracker.attachedYaw = packet.readFloat();
        } else {
            tracker.attachedEntity = null;
            tracker.attached = false;
            tracker.u = packet.readFloat();
            tracker.v = packet.readFloat();
            tracker.w = packet.readFloat();
            tracker.x = packet.readFloat();
            tracker.y = packet.readFloat();
            tracker.z = packet.readFloat();
            tracker.b(tracker.u, tracker.v, tracker.w);
            tracker.h(tracker.x, tracker.y, tracker.z);
            tracker.attachmentCounter = packet.readUShort();
            tracker.item = packet.readBoolean();
        }
    }

    private void throwREP(int entityID, int throwerID, bdd world, uf player) {
        nn thrower = world.a(throwerID);
        if (throwerID == player.k) {
            thrower = player;
        }
        if (thrower != null && thrower instanceof of) {
            EntityREP rep = new EntityREP((abw)world, (of)thrower);
            rep.k = entityID;
            world.a(entityID, (nn)rep);
        }
    }

    private static void processSnifferFreqUpdate(PacketCustom packet) {
        awe currentscreen = atv.w().n;
        if (currentscreen == null || !(currentscreen instanceof GuiWirelessSniffer)) {
            return;
        }
        GuiWirelessSniffer sniffergui = (GuiWirelessSniffer)currentscreen;
        sniffergui.setEtherFreq(packet.readUShort(), packet.readBoolean());
    }

    private static void processSnifferEtherCopy(PacketCustom packet) {
        awe currentscreen = atv.w().n;
        if (currentscreen == null || !(currentscreen instanceof GuiWirelessSniffer)) {
            return;
        }
        GuiWirelessSniffer sniffergui = (GuiWirelessSniffer)currentscreen;
        sniffergui.setEtherCopy(packet.readByteArray(packet.readUShort()));
    }

    private static void processMapUpdate(abw world, uf player, PacketCustom packet) {
        WirelessMapNodeStorage mapstorage = RedstoneEtherAddons.client().getMapNodes();
        int numaddednodes = packet.readUShort();
        for (int i = 0; i < numaddednodes; ++i) {
            FreqCoord node = new FreqCoord(packet.readShort(), -1, packet.readShort(), packet.readUShort());
            mapstorage.nodes.add(node);
        }
        int numremovednodes = packet.readUShort();
        for (int i = 0; i < numremovednodes; ++i) {
            FreqCoord node = new FreqCoord(packet.readShort(), -1, packet.readShort(), packet.readUShort());
            mapstorage.nodes.remove(node);
        }
        int numremotes = packet.readUShort();
        mapstorage.devices.clear();
        for (int i = 0; i < numremotes; ++i) {
            mapstorage.devices.add(new FreqCoord(packet.readInt(), -1, packet.readInt(), packet.readUShort()));
        }
    }

    private static void processMapInfo(abw world, uf player, PacketCustom packet) {
        short mapno = packet.readShort();
        int xCenter = packet.readInt();
        int zCenter = packet.readInt();
        byte scale = packet.readByte();
        RedstoneEtherAddons.client().setMPMapInfo(mapno, new ClientMapInfo(xCenter, zCenter, scale));
    }

    public static void sendOpenSniffer() {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 50);
        packet.writeBoolean(true);
        packet.sendToServer();
    }

    public static void sendCloseSniffer() {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 50);
        packet.writeBoolean(false);
        packet.sendToServer();
    }

    public static void sendSetRemote(boolean active) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 51);
        packet.writeBoolean(active);
        packet.sendToServer();
    }

    public static void sendSyncTriang(int freq, boolean required) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 52);
        packet.writeShort(freq);
        packet.writeBoolean(required);
        packet.sendToServer();
    }

    public static void sendResetMap() {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 58);
        packet.sendToServer();
    }
}

