/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.addons;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.ColourARGB;
import codechicken.lib.render.TextureDataHolder;
import codechicken.lib.render.TextureSpecial;
import codechicken.lib.render.TextureUtils;
import codechicken.wirelessredstone.core.RedstoneEther;

public class RemoteTexManager {
    private static Colour[] texGrad;
    private static Colour[] texOff;
    private static Colour[] texOn;
    private static int[] imageData;
    private static TextureSpecial[] icons;

    public static void load(bik registrar) {
        int i;
        for (i = 0; i < icons.length; ++i) {
            RemoteTexManager.icons[i] = TextureUtils.getTextureSpecial((mt)registrar, (String)("wrcbe_addons:remote_" + i));
        }
        texOn = TextureUtils.loadTextureColours((bjo)new bjo("wrcbe_addons", "textures/items/remoteOn.png"));
        texOff = TextureUtils.loadTextureColours((bjo)new bjo("wrcbe_addons", "textures/items/remoteOff.png"));
        texGrad = TextureUtils.loadTextureColours((bjo)new bjo("wrcbe_addons", "textures/items/remoteGrad.png"));
        for (i = 0; i < 14; ++i) {
            RemoteTexManager.processTexture(RedstoneEther.colours[i], false, RemoteTexManager.getIconIndex(i, false));
            RemoteTexManager.processTexture(RedstoneEther.colours[i], true, RemoteTexManager.getIconIndex(i, true));
        }
        RemoteTexManager.processTexture(-1, false, RemoteTexManager.getIconIndex(-1, false));
        RemoteTexManager.processTexture(-1, true, RemoteTexManager.getIconIndex(-1, true));
    }

    private static void processTexture(int colour, boolean on, int i) {
        RemoteTexManager.mergeTexturesWithColour((Colour)new ColourARGB(colour), on);
        icons[i].addTexture(new TextureDataHolder(imageData, 16).copyData());
    }

    public static ms getIcon(int colourid, boolean on) {
        return icons[RemoteTexManager.getIconIndex(colourid, on)];
    }

    public static int getIconIndex(int colourid, boolean on) {
        return colourid + 1 + (on ? 15 : 0);
    }

    private static void mergeTexturesWithColour(Colour texcolour, boolean on) {
        for (int i = 0; i < 256; ++i) {
            Colour colour = RemoteTexManager.texGrad[i].a == 0 ? (on ? texOn[i] : texOff[i]) : texGrad[i].copy().multiply(texcolour);
            RemoteTexManager.imageData[i] = colour.argb();
        }
    }

    static {
        imageData = new int[256];
        icons = new TextureSpecial[30];
    }
}

