/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.addons;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.ColourARGB;
import codechicken.wirelessredstone.addons.GuiWirelessSniffer;
import codechicken.wirelessredstone.core.RedstoneEther;
import codechicken.wirelessredstone.core.WRCoreCPH;

public class GuiPrivateSniffer
extends GuiWirelessSniffer {
    public GuiPrivateSniffer() {
        this.title = "Private Sniffer";
    }

    protected void a(int mousex, int mousey, int button) {
        int freq = this.getFreqMouseOver(mousex, mousey);
        if (freq == 0) {
            super.a(mousex, mousey, button);
            return;
        }
        if (RedstoneEther.get(true).canBroadcastOnFrequency((uf)this.f.h, freq) && freq > RedstoneEther.get(true).getLastPublicFrequency() && freq <= RedstoneEther.get(true).getLastSharedFrequency()) {
            String name = RedstoneEther.get(true).isFreqPrivate(freq) ? "" : this.f.h.bu;
            WRCoreCPH.sendSetFreqOwner(freq, name);
        }
    }

    @Override
    public String getFreqTip(int freq) {
        if (RedstoneEther.get(true).isPlayerJammed((uf)this.f.h)) {
            return "Jammed " + freq;
        }
        if (RedstoneEther.get(true).isFreqPrivate(freq)) {
            return (RedstoneEther.get(true).getFreqOwner(freq).equalsIgnoreCase(this.f.h.bu) ? "Owned " : "Private ") + freq;
        }
        if (!RedstoneEther.get(true).canBroadcastOnFrequency((uf)this.f.h, freq)) {
            return "Jammed " + freq;
        }
        if (freq <= RedstoneEther.get(true).getLastPublicFrequency()) {
            return "Public " + freq;
        }
        if (freq <= RedstoneEther.get(true).getLastSharedFrequency()) {
            return "Shared " + freq;
        }
        return "" + freq;
    }

    @Override
    public Colour getColour(int freq) {
        if (RedstoneEther.get(true).isPlayerJammed((uf)this.f.h) || !RedstoneEther.get(true).canBroadcastOnFrequency((uf)this.f.h, freq)) {
            return colourJammed;
        }
        if (RedstoneEther.get(true).isFreqPrivate(freq) && RedstoneEther.get(true).getFreqOwner(freq).equalsIgnoreCase(this.f.h.bu)) {
            return colourPOff.copy().interpolate((Colour)colourPOn, (double)((float)this.brightness[freq - 1] / 64.0f));
        }
        Colour colour = colourOff.copy().interpolate((Colour)colourOn, (double)((float)this.brightness[freq - 1] / 64.0f));
        if (freq <= RedstoneEther.get(true).getLastPublicFrequency()) {
            colour.interpolate((Colour)colourJammed, 0.5);
        }
        return colour;
    }

    @Override
    public Colour getBorder(int freq) {
        if (RedstoneEther.get(true).isPlayerJammed((uf)this.f.h) || !RedstoneEther.get(true).canBroadcastOnFrequency((uf)this.f.h, freq)) {
            return borderJammed;
        }
        if (RedstoneEther.get(true).isFreqPrivate(freq) && RedstoneEther.get(true).getFreqOwner(freq).equalsIgnoreCase(this.f.h.bu)) {
            return borderPOff.copy().interpolate((Colour)borderPOn, (double)((float)this.brightness[freq - 1] / 64.0f));
        }
        Object border = RedstoneEther.get(true).getFreqColourId(freq) != -1 ? new ColourARGB(RedstoneEther.get(true).getFreqColour(freq)) : borderOff.copy().interpolate((Colour)borderOn, (double)((float)this.brightness[freq - 1] / 64.0f));
        if (freq <= RedstoneEther.get(true).getLastPublicFrequency()) {
            border.interpolate((Colour)borderJammed, 0.7);
        }
        return border;
    }
}

