/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api.research;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchPage;

public class ResearchItem {
    public final String key;
    public final String category;
    public final AspectList tags;
    public String[] parents = null;
    public String[] parentsHidden = null;
    public String[] siblings = null;
    public final int displayColumn;
    public final int displayRow;
    public final ItemStack icon_item;
    public final ResourceLocation icon_resource;
    private int complexity;
    private boolean isSpecial;
    private boolean isRound;
    private boolean isStub;
    private boolean isVirtual;
    private boolean isHidden;
    private boolean isConcealed;
    private boolean isLost;
    private boolean isAutoUnlock;
    private ResearchPage[] pages = null;

    public ResearchItem(String par1, String par2) {
        this.key = par1;
        this.category = par2;
        this.tags = new AspectList();
        this.icon_resource = null;
        this.icon_item = null;
        this.displayColumn = 0;
        this.displayRow = 0;
        this.setVirtual();
    }

    public ResearchItem(String par1, String par2, AspectList tags, int par3, int par4, int par5, ResourceLocation icon) {
        this.key = par1;
        this.category = par2;
        this.tags = tags;
        this.icon_resource = icon;
        this.icon_item = null;
        this.displayColumn = par3;
        this.displayRow = par4;
        this.complexity = par5;
        if (this.complexity < 1) {
            this.complexity = 1;
        }
        if (this.complexity > 5) {
            this.complexity = 5;
        }
    }

    public ResearchItem(String par1, String par2, AspectList tags, int par3, int par4, int par5, ItemStack icon) {
        this.key = par1;
        this.category = par2;
        this.tags = tags;
        this.icon_item = icon;
        this.icon_resource = null;
        this.displayColumn = par3;
        this.displayRow = par4;
        this.complexity = par5;
        if (this.complexity < 0) {
            this.complexity = 0;
        }
        if (this.complexity > 5) {
            this.complexity = 5;
        }
    }

    public ResearchItem setSpecial() {
        this.isSpecial = true;
        return this;
    }

    public ResearchItem setStub() {
        this.isStub = true;
        return this;
    }

    public ResearchItem setHidden() {
        this.isHidden = true;
        return this;
    }

    public ResearchItem setConcealed() {
        this.isConcealed = true;
        return this;
    }

    public ResearchItem setLost() {
        this.isLost = true;
        return this;
    }

    public ResearchItem setVirtual() {
        this.isVirtual = true;
        return this;
    }

    public ResearchItem setParents(String ... par) {
        this.parents = par;
        return this;
    }

    public ResearchItem setParentsHidden(String ... par) {
        this.parentsHidden = par;
        return this;
    }

    public ResearchItem setSiblings(String ... sib) {
        this.siblings = sib;
        return this;
    }

    public ResearchItem setPages(ResearchPage ... par) {
        this.pages = par;
        return this;
    }

    public ResearchPage[] getPages() {
        return this.pages;
    }

    public ResearchItem registerResearchItem() {
        ResearchCategories.addResearch(this);
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public String getName() {
        return StatCollector.func_74838_a((String)("tc.research_name." + this.key));
    }

    @SideOnly(value=Side.CLIENT)
    public String getText() {
        return StatCollector.func_74838_a((String)("tc.research_text." + this.key));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isSpecial() {
        return this.isSpecial;
    }

    public boolean isStub() {
        return this.isStub;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean isConcealed() {
        return this.isConcealed;
    }

    public boolean isLost() {
        return this.isLost;
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    public boolean isAutoUnlock() {
        return this.isAutoUnlock;
    }

    public ResearchItem setAutoUnlock() {
        this.isAutoUnlock = true;
        return this;
    }

    public boolean isRound() {
        return this.isRound;
    }

    public ResearchItem setRound() {
        this.isRound = true;
        return this;
    }

    public int getComplexity() {
        return this.complexity;
    }

    public ResearchItem setComplexity(int complexity) {
        this.complexity = complexity;
        return this;
    }

    public Aspect getResearchPrimaryTag() {
        Aspect aspect = null;
        int highest = 0;
        if (this.tags != null) {
            for (Aspect tag : this.tags.getAspects()) {
                if (this.tags.getAmount(tag) <= highest) continue;
                aspect = tag;
                highest = this.tags.getAmount(tag);
            }
        }
        return aspect;
    }
}

