/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.worldgen;

import java.util.Random;
import mods.railcraft.common.blocks.aesthetics.cube.BlockCube;
import mods.railcraft.common.blocks.aesthetics.cube.EnumCube;
import mods.railcraft.common.worldgen.WorldGenQuarry;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.EnumHelper;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class QuarryPopulator {
    public static final PopulateChunkEvent.Populate.EventType EVENT_TYPE = (PopulateChunkEvent.Populate.EventType)EnumHelper.addEnum(PopulateChunkEvent.Populate.EventType.class, (String)"RAILCRAFT_QUARRY", (Class[])new Class[0], (Object[])new Object[0]);
    private static QuarryPopulator instance;
    private final WorldGenQuarry quarry = new WorldGenQuarry(BlockCube.getBlock(), EnumCube.QUARRIED_STONE.ordinal());

    public static QuarryPopulator instance() {
        if (instance == null) {
            instance = new QuarryPopulator();
        }
        return instance;
    }

    private QuarryPopulator() {
    }

    @ForgeSubscribe
    public void generate(PopulateChunkEvent.Pre event) {
        if (!TerrainGen.populate((IChunkProvider)event.chunkProvider, (World)event.world, (Random)event.rand, (int)event.chunkX, (int)event.chunkZ, (boolean)event.hasVillageGenerated, (PopulateChunkEvent.Populate.EventType)EVENT_TYPE)) {
            return;
        }
        this.generateQuarry(event.world, event.rand, event.chunkX, event.chunkZ);
    }

    public void generateQuarry(World world, Random rand, int chunkX, int chunkZ) {
        int y;
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        if (this.canGen(world, rand, x, z) && world.func_72798_a(x, y = world.func_72825_h(x, z) - 3, z) == Block.field_71979_v.field_71990_ca) {
            this.quarry.func_76484_a(world, rand, x, y, z);
        }
    }

    private boolean canGen(World world, Random rand, int x, int z) {
        BiomeGenBase biome = world.func_72807_a(x, z);
        if (!BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
            return false;
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FROZEN)) {
            return false;
        }
        return rand.nextDouble() <= 0.025;
    }
}

