/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.network;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.blocks.tracks.TrackFactory;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.RailcraftPacket;
import net.minecraft.block.Block;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PacketTileEntity
extends RailcraftPacket {
    private RailcraftTileEntity tile;

    public PacketTileEntity() {
    }

    public PacketTileEntity(RailcraftTileEntity tile) {
        this.tile = tile;
    }

    @Override
    public Packet getPacket() {
        Packet pkt = super.getPacket();
        pkt.field_73287_r = true;
        return pkt;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        data.writeInt(this.tile.field_70329_l);
        data.writeInt(this.tile.field_70330_m);
        data.writeInt(this.tile.field_70327_n);
        data.writeShort(this.tile.getId());
        this.tile.writePacketData(data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readData(DataInputStream data) throws IOException {
        World world = Game.getWorld();
        if (world == null) {
            return;
        }
        int x = data.readInt();
        int y = data.readInt();
        int z = data.readInt();
        short id = data.readShort();
        if (id < 0 || y < 0 || !world.func_72899_e(x, y, z)) {
            return;
        }
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof RailcraftTileEntity) {
            this.tile = (RailcraftTileEntity)te;
            if (this.tile.getId() != id) {
                this.tile = null;
            }
        } else {
            this.tile = null;
        }
        if (this.tile == null) {
            int blockId = world.func_72798_a(x, y, z);
            Block blockTrack = RailcraftBlocks.getBlockTrack();
            if (blockTrack != null && blockTrack.field_71990_ca == blockId) {
                this.tile = TrackFactory.makeTrackTile(id);
                world.func_72837_a(x, y, z, (TileEntity)this.tile);
            } else {
                world.func_72932_q(x, y, z);
                te = world.func_72796_p(x, y, z);
                if (te instanceof RailcraftTileEntity) {
                    this.tile = (RailcraftTileEntity)te;
                }
            }
        }
        if (this.tile == null) {
            return;
        }
        try {
            this.tile.readPacketData(data);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            if (Game.IS_DEBUG) {
                throw ex;
            }
            Game.logError(Level.SEVERE, "Exception in PacketTileEntity.readData: {0}", ex);
        }
    }

    @Override
    public int getID() {
        return RailcraftPacket.PacketType.TILE_ENTITY.ordinal();
    }
}

