/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.misc;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.misc.Timer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public final class AdjacentTileCache {
    private static final int DELAY_MIN = 20;
    private static final int DELAY_MAX = 2400;
    private static final int DELAY_STEP = 2;
    private final Timer[] timer = new Timer[6];
    private final TileEntity[] cache = new TileEntity[6];
    private final int[] delay = new int[6];
    private final TileEntity source;
    private Set listeners = new LinkedHashSet();

    public AdjacentTileCache(TileEntity tile) {
        this.source = tile;
        Arrays.fill(this.delay, 20);
        for (int i = 0; i < this.timer.length; ++i) {
            this.timer[i] = new Timer();
        }
    }

    public void addListener(ICacheListener listener) {
        this.listeners.add(listener);
    }

    private TileEntity searchSide(ForgeDirection side) {
        return MiscTools.getBlockTileEntityOnSide(this.source.field_70331_k, this.source.field_70329_l, this.source.field_70330_m, this.source.field_70327_n, side);
    }

    public void refresh() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            this.getTileOnSide(side);
        }
    }

    public void purge() {
        Arrays.fill(this.cache, null);
        Arrays.fill(this.delay, 20);
        for (Timer t : this.timer) {
            t.reset();
        }
        this.changed();
        for (ICacheListener listener : this.listeners) {
            listener.purge();
        }
    }

    public void onNeighborChange() {
        Arrays.fill(this.delay, 20);
    }

    protected void setTile(int side, TileEntity tile) {
        if (this.cache[side] != tile) {
            this.cache[side] = tile;
            this.changed();
        }
    }

    private void changed() {
        for (ICacheListener listener : this.listeners) {
            listener.changed();
        }
    }

    public TileEntity getTileOnSide(ForgeDirection side) {
        int s = side.ordinal();
        if (this.cache[s] != null) {
            if (this.cache[s].func_70320_p() || !MiscTools.areCoordinatesOnSide(this.source.field_70329_l, this.source.field_70330_m, this.source.field_70327_n, side, this.cache[s].field_70329_l, this.cache[s].field_70330_m, this.cache[s].field_70327_n)) {
                this.setTile(s, null);
            } else {
                return this.cache[s];
            }
        }
        if (this.timer[s].hasTriggered(this.source.field_70331_k, this.delay[s])) {
            this.setTile(s, this.searchSide(side));
            if (this.cache[s] == null) {
                this.incrementDelay(s);
            } else {
                this.delay[s] = 20;
            }
        }
        return this.cache[s];
    }

    private void incrementDelay(int side) {
        int n = side;
        this.delay[n] = this.delay[n] + 2;
        if (this.delay[side] > 2400) {
            this.delay[side] = 2400;
        }
    }

    public static interface ICacheListener {
        public void changed();

        public void purge();
    }
}

