/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.modules;

import cpw.mods.fml.common.registry.GameRegistry;
import ic2.api.recipe.Recipes;
import java.util.ArrayList;
import java.util.logging.Level;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.detector.BlockDetector;
import mods.railcraft.common.blocks.detector.EnumDetector;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.items.ItemPlate;
import mods.railcraft.common.items.ItemRailcraft;
import mods.railcraft.common.items.RailcraftPartItems;
import mods.railcraft.common.modules.AbstractModule;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import mods.railcraft.common.plugins.ic2.IC2Plugin;
import mods.railcraft.common.util.crafting.RotorRepairRecipe;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ModuleIC2
extends AbstractModule {
    public static Item lapotronUpgrade;

    @Override
    public boolean canModuleLoad() {
        return IC2Plugin.isModInstalled();
    }

    @Override
    public void printLoadError() {
        Game.log(Level.FINER, "Module disabled: {0}, IC2 not detected", this);
    }

    @Override
    public void initFirst() {
        int id;
        ItemStack stack;
        BlockDetector.registerBlock();
        RailcraftBlocks.registerBlockMachineGamma();
        EnumMachineGamma type = EnumMachineGamma.ENERGY_LOADER;
        if (type.isAvaliable()) {
            stack = type.getItem();
            RailcraftLanguage.instance().registerItemName(stack, type.getTag());
        }
        if ((type = EnumMachineGamma.ENERGY_UNLOADER).isAvaliable()) {
            stack = type.getItem();
            RailcraftLanguage.instance().registerItemName(stack, type.getTag());
        }
        if ((id = RailcraftConfig.getItemId("ic2.upgrade.lapotron")) > 0) {
            lapotronUpgrade = new ItemRailcraft(id).func_77655_b("railcraft.upgrade.lapotron").func_77625_d(9);
            GameRegistry.registerItem((Item)lapotronUpgrade, (String)"railcraft.upgrade.lapotron");
            RailcraftLanguage.instance().registerItemName(lapotronUpgrade, "ic2.upgrade.lapotron");
            ItemRegistry.registerItemStack("ic2.upgrade.lapotron", new ItemStack(lapotronUpgrade));
        }
        EnumCart.ENERGY_BATBOX.setup();
        EnumCart.ENERGY_MFE.setup();
        EnumCart.ENERGY_CESU.setup();
        EnumMachineAlpha alpha = EnumMachineAlpha.TURBINE;
        if (alpha.register()) {
            CraftingPlugin.addShapedOreRecipe(alpha.getItem(3), "BPB", "P P", "BPB", Character.valueOf('P'), ItemPlate.getPlate(ItemPlate.EnumPlate.STEEL), Character.valueOf('B'), "blockSteel");
            RailcraftPartItems.getTurbineRotor();
            CraftingPlugin.addRecipe(new RotorRepairRecipe());
        }
    }

    @Override
    public void postInit() {
        ArrayList reIron;
        if (RailcraftConfig.getRecipeConfig("ic2.refinedIron.disable")) {
            reIron = OreDictionary.getOres((String)"ingotRefinedIron");
            reIron.clear();
        }
        if (RailcraftConfig.getRecipeConfig("ic2.refinedIron.useSteel")) {
            reIron = OreDictionary.getOres((String)"ingotRefinedIron");
            reIron.addAll(OreDictionary.getOres((String)"ingotSteel"));
        }
        ModuleIC2.createRecipes();
    }

    private static void createRecipes() {
        int id;
        ItemStack mfe;
        ItemStack cesu;
        ItemStack batbox;
        BlockDetector blockDetector = BlockDetector.getBlock();
        if (blockDetector != null) {
            ItemStack stack = EnumDetector.ENERGY.getItem();
            Object tin = ItemPlate.getPlate(ItemPlate.EnumPlate.TIN);
            if (tin == null) {
                tin = "ingotTin";
            }
            CraftingPlugin.addShapedOreRecipe(stack, false, "XXX", "XPX", "XXX", Character.valueOf('X'), tin, Character.valueOf('P'), Block.field_72044_aK);
        }
        if ((batbox = IC2Plugin.getItem("batBox")) != null) {
            EnumCart cart = EnumCart.ENERGY_BATBOX;
            cart.setContents(batbox);
            ItemStack stack = cart.getCartItem();
            if (stack != null) {
                CraftingPlugin.addShapedRecipe(stack, "E", "M", Character.valueOf('E'), batbox, Character.valueOf('M'), Item.field_77773_az);
                CraftingPlugin.addShapelessRecipe(new ItemStack(Item.field_77773_az), stack);
            }
        }
        if ((cesu = IC2Plugin.getItem("cesuUnit")) != null) {
            EnumCart cart = EnumCart.ENERGY_CESU;
            cart.setContents(batbox);
            ItemStack stack = cart.getCartItem();
            if (stack != null) {
                CraftingPlugin.addShapedRecipe(stack, "E", "M", Character.valueOf('E'), cesu, Character.valueOf('M'), Item.field_77773_az);
                CraftingPlugin.addShapelessRecipe(new ItemStack(Item.field_77773_az), stack);
            }
        }
        if ((mfe = IC2Plugin.getItem("mfeUnit")) != null) {
            EnumCart cart = EnumCart.ENERGY_MFE;
            cart.setContents(batbox);
            ItemStack stack = cart.getCartItem();
            if (stack != null) {
                CraftingPlugin.addShapedRecipe(stack, "E", "M", Character.valueOf('E'), mfe, Character.valueOf('M'), Item.field_77773_az);
                CraftingPlugin.addShapelessRecipe(new ItemStack(Item.field_77773_az), stack);
            }
        }
        ItemStack battery = IC2Plugin.getItem("reBattery");
        ItemStack machine = IC2Plugin.getItem("machine");
        ItemStack detector = blockDetector != null ? EnumDetector.ENERGY.getItem() : new ItemStack(Block.field_72044_aK);
        if (battery != null && machine != null) {
            if (EnumMachineGamma.ENERGY_LOADER.isAvaliable()) {
                Recipes.advRecipes.addRecipe(EnumMachineGamma.ENERGY_LOADER.getItem(), "BLB", "BIB", "BDB", Character.valueOf('D'), detector, Character.valueOf('B'), battery, Character.valueOf('I'), machine, Character.valueOf('L'), new ItemStack((Block)Block.field_94340_cs));
            }
            if (EnumMachineGamma.ENERGY_UNLOADER.isAvaliable()) {
                Recipes.advRecipes.addRecipe(EnumMachineGamma.ENERGY_UNLOADER.getItem(), "BDB", "BIB", "BLB", Character.valueOf('D'), detector, Character.valueOf('B'), battery, Character.valueOf('I'), machine, Character.valueOf('L'), new ItemStack((Block)Block.field_94340_cs));
            }
        }
        if ((id = RailcraftConfig.getItemId("ic2.upgrade.lapotron")) > 0) {
            ItemStack lapotron = IC2Plugin.getItem("lapotronCrystal");
            ItemStack glassCable = IC2Plugin.getItem("glassFiberCableItem");
            ItemStack circuit = IC2Plugin.getItem("advancedCircuit");
            if (lapotron != null && glassCable != null && circuit != null) {
                lapotron.func_77946_l();
                Recipes.advRecipes.addRecipe(new ItemStack(lapotronUpgrade), "GGG", "wLw", "GCG", Character.valueOf('G'), new ItemStack(Block.field_71946_M, 1, 0), Character.valueOf('w'), glassCable, Character.valueOf('C'), circuit, Character.valueOf('L'), lapotron);
            }
        }
    }

    public static ItemStack getLapotronUpgrade() {
        if (lapotronUpgrade == null) {
            return null;
        }
        return new ItemStack(lapotronUpgrade);
    }
}

