/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import java.util.Locale;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.items.ItemRailcraft;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;

public class ItemCircuit
extends ItemRailcraft {
    private static Item item;

    public static Item getCircuitItem() {
        if (item != null) {
            return item;
        }
        String tag = "railcraft.part.circuit";
        int id = RailcraftConfig.getItemId(tag);
        item = new ItemCircuit(id);
        GameRegistry.registerItem((Item)item, (String)tag);
        for (EnumCircuit circuit : EnumCircuit.VALUES) {
            ItemStack stack = new ItemStack(item, 1, circuit.ordinal());
            RailcraftLanguage.instance().registerItemName(stack, item.func_77667_c(stack));
            ItemRegistry.registerItemStack(item.func_77667_c(stack), stack);
        }
        CraftingPlugin.addShapedRecipe(new ItemStack(item, 1, EnumCircuit.CONTROLLER.ordinal()), " #S", "BGR", "SRL", Character.valueOf('L'), new ItemStack(Item.field_77756_aW, 1, 4), Character.valueOf('#'), Item.field_77742_bb, Character.valueOf('G'), Item.field_77717_p, Character.valueOf('S'), new ItemStack(Block.field_72101_ab, 1, 14), Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('B'), Item.field_77761_aM);
        CraftingPlugin.addShapedRecipe(new ItemStack(item, 1, EnumCircuit.RECEIVER.ordinal()), " #S", "BGR", "SRL", Character.valueOf('L'), new ItemStack(Item.field_77756_aW, 1, 4), Character.valueOf('#'), Item.field_77742_bb, Character.valueOf('G'), Item.field_77717_p, Character.valueOf('S'), new ItemStack(Block.field_72101_ab, 1, 13), Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('B'), Item.field_77761_aM);
        CraftingPlugin.addShapedRecipe(new ItemStack(item, 1, EnumCircuit.SIGNAL.ordinal()), " #S", "BGR", "SRL", Character.valueOf('L'), new ItemStack(Item.field_77756_aW, 1, 4), Character.valueOf('#'), Item.field_77742_bb, Character.valueOf('G'), Item.field_77717_p, Character.valueOf('S'), new ItemStack(Block.field_72101_ab, 1, 4), Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('B'), Item.field_77761_aM);
        return item;
    }

    public static ItemStack getControllerCircuit() {
        return ItemCircuit.getControllerCircuit(1);
    }

    public static ItemStack getControllerCircuit(int qty) {
        return new ItemStack(ItemCircuit.getCircuitItem(), qty, EnumCircuit.CONTROLLER.ordinal());
    }

    public static ItemStack getReceiverCircuit() {
        return ItemCircuit.getReceiverCircuit(1);
    }

    public static ItemStack getReceiverCircuit(int qty) {
        return new ItemStack(ItemCircuit.getCircuitItem(), qty, EnumCircuit.RECEIVER.ordinal());
    }

    public static ItemStack getSignalCircuit() {
        return ItemCircuit.getSignalCircuit(1);
    }

    public static ItemStack getSignalCircuit(int qty) {
        return new ItemStack(ItemCircuit.getCircuitItem(), qty, EnumCircuit.SIGNAL.ordinal());
    }

    public ItemCircuit(int id) {
        super(id);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77655_b("railcraft.part.circuit");
    }

    @Override
    public void func_94581_a(IconRegister iconRegister) {
        for (EnumCircuit gear : EnumCircuit.VALUES) {
            gear.icon = iconRegister.func_94245_a("railcraft:part.circuit." + gear.name().toLowerCase(Locale.ENGLISH));
        }
    }

    public void func_77633_a(int id, CreativeTabs tab, List list) {
        for (EnumCircuit circuit : EnumCircuit.VALUES) {
            list.add(new ItemStack((Item)this, 1, circuit.ordinal()));
        }
    }

    public Icon func_77617_a(int damage) {
        if (damage >= EnumCircuit.VALUES.length) {
            return EnumCircuit.RECEIVER.icon;
        }
        return EnumCircuit.VALUES[damage].icon;
    }

    public String func_77667_c(ItemStack stack) {
        int damage = stack.func_77960_j();
        if (damage < 0 || damage >= EnumCircuit.VALUES.length) {
            return "";
        }
        switch (EnumCircuit.VALUES[damage]) {
            case CONTROLLER: {
                return "railcraft.part.circuit.controller";
            }
            case RECEIVER: {
                return "railcraft.part.circuit.receiver";
            }
            case SIGNAL: {
                return "railcraft.part.circuit.signal";
            }
        }
        return "";
    }

    public static enum EnumCircuit {
        CONTROLLER,
        RECEIVER,
        SIGNAL;

        public static EnumCircuit[] VALUES;
        private Icon icon;

        static {
            VALUES = EnumCircuit.values();
        }
    }
}

