/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.gui.tooltips;

import com.google.common.collect.ForwardingList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.gui.tooltips.ToolTipLine;
import mods.railcraft.common.util.misc.Game;

public class ToolTip
extends ForwardingList {
    private final List delegate = new ArrayList();
    private final long delay;
    private long mouseOverStart;

    public ToolTip() {
        this.delay = 0L;
    }

    public ToolTip(int delay) {
        this.delay = delay;
    }

    protected final List delegate() {
        return this.delegate;
    }

    public boolean add(String line) {
        return this.add(new ToolTipLine(line));
    }

    public void onTick(boolean mouseOver) {
        if (this.delay == 0L) {
            return;
        }
        if (mouseOver) {
            if (this.mouseOverStart == 0L) {
                this.mouseOverStart = System.currentTimeMillis();
            }
        } else {
            this.mouseOverStart = 0L;
        }
    }

    public boolean isReady() {
        if (this.delay == 0L) {
            return true;
        }
        if (this.mouseOverStart == 0L) {
            return false;
        }
        return System.currentTimeMillis() - this.mouseOverStart >= this.delay;
    }

    public void refresh() {
    }

    public List convertToStrings() {
        ArrayList<String> tips = new ArrayList<String>(this.size());
        Iterator i$ = this.iterator();
        while (i$.hasNext()) {
            ToolTipLine line = (ToolTipLine)i$.next();
            tips.add(line.text);
        }
        return tips;
    }

    public static ToolTip buildToolTip(String tipTag, String ... vars) {
        if (!RailcraftLanguage.hasTag(tipTag)) {
            return null;
        }
        try {
            String[] tips;
            ToolTip toolTip = new ToolTip(750);
            String text = RailcraftLanguage.translate(tipTag);
            for (String var : vars) {
                String[] pair = var.split("=");
                text = text.replace(pair[0], pair[1]);
            }
            for (String tip : tips = text.split("\n")) {
                tip = tip.trim();
                toolTip.add(new ToolTipLine(tip));
            }
            return toolTip;
        }
        catch (RuntimeException ex) {
            Game.logError("Failed to parse tooltip: " + tipTag, ex);
            throw ex;
        }
    }
}

