/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.fluids;

import com.google.common.collect.ForwardingList;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mods.railcraft.common.fluids.tanks.StandardTank;
import mods.railcraft.common.util.misc.AdjacentTileCache;
import mods.railcraft.common.util.misc.ITileFilter;
import mods.railcraft.common.util.network.PacketBuilder;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TankManager
extends ForwardingList
implements IFluidHandler,
List {
    public static final ITileFilter TANK_FILTER = new ITileFilter(){

        @Override
        public boolean matches(TileEntity tile) {
            return tile instanceof IFluidHandler;
        }
    };
    private static final byte NETWORK_DATA = 2;
    private List tanks = new ArrayList();
    private List prevFluidStacks = new ArrayList();

    public TankManager() {
    }

    public TankManager(StandardTank ... tanks) {
        this.addAll(Arrays.asList(tanks));
    }

    protected List delegate() {
        return this.tanks;
    }

    @Override
    public boolean add(StandardTank tank) {
        boolean added = this.tanks.add(tank);
        int index = this.tanks.indexOf((Object)tank);
        tank.setTankIndex(index);
        this.prevFluidStacks.add(tank.getFluid() == null ? null : tank.getFluid().copy());
        return added;
    }

    public void writeTanksToNBT(NBTTagCompound data) {
        NBTTagList tagList = new NBTTagList();
        for (byte slot = 0; slot < this.tanks.size(); slot = (byte)((byte)(slot + 1))) {
            StandardTank tank = (StandardTank)((Object)this.tanks.get(slot));
            if (tank.getFluid() == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("tank", slot);
            tank.writeToNBT(tag);
            tagList.func_74742_a((NBTBase)tag);
        }
        data.func_74782_a("tanks", (NBTBase)tagList);
    }

    public void readTanksFromNBT(NBTTagCompound data) {
        NBTTagList tagList = data.func_74761_m("tanks");
        for (int tagIndex = 0; tagIndex < tagList.func_74745_c(); ++tagIndex) {
            NBTTagCompound tag = (NBTTagCompound)tagList.func_74743_b(tagIndex);
            byte slot = tag.func_74771_c("tank");
            if (slot < 0 || slot >= this.tanks.size()) continue;
            ((StandardTank)((Object)this.tanks.get(slot))).readFromNBT(tag);
        }
    }

    public void writePacketData(DataOutputStream data) throws IOException {
        for (int i = 0; i < this.tanks.size(); ++i) {
            this.writePacketData(data, i);
        }
    }

    public void writePacketData(DataOutputStream data, int tankIndex) throws IOException {
        if (tankIndex >= this.tanks.size()) {
            return;
        }
        StandardTank tank = (StandardTank)((Object)this.tanks.get(tankIndex));
        FluidStack fluidStack = tank.getFluid();
        if (fluidStack != null) {
            data.writeShort(fluidStack.fluidID);
            data.writeInt(fluidStack.amount);
        } else {
            data.writeShort(-1);
        }
    }

    public void readPacketData(DataInputStream data) throws IOException {
        for (int i = 0; i < this.tanks.size(); ++i) {
            this.readPacketData(data, i);
        }
    }

    public void readPacketData(DataInputStream data, int tankIndex) throws IOException {
        if (tankIndex >= this.tanks.size()) {
            return;
        }
        StandardTank tank = (StandardTank)((Object)this.tanks.get(tankIndex));
        short fluidId = data.readShort();
        if (fluidId != -1) {
            tank.setFluid(new FluidStack((int)fluidId, data.readInt()));
        } else {
            tank.setFluid(null);
        }
    }

    public void initGuiData(Container container, ICrafting player, int tankIndex) {
        if (tankIndex >= this.tanks.size()) {
            return;
        }
        FluidStack fluidStack = ((StandardTank)((Object)this.tanks.get(tankIndex))).getFluid();
        int fluidId = -1;
        int fluidAmount = 0;
        if (fluidStack != null && fluidStack.amount > 0) {
            fluidId = fluidStack.getFluid().getID();
            fluidAmount = fluidStack.amount;
        }
        player.func_71112_a(container, tankIndex * 2 + 0, fluidId);
        PacketBuilder.instance().sendGuiIntegerPacket((EntityPlayer)player, container.field_75152_c, tankIndex * 2 + 1, fluidAmount);
    }

    public void updateGuiData(Container container, List crafters, int tankIndex) {
        for (int i = 0; i < crafters.size(); ++i) {
            FluidStack prev;
            ICrafting crafter = (ICrafting)crafters.get(i);
            EntityPlayer player = (EntityPlayer)crafters.get(i);
            FluidStack fluidStack = ((StandardTank)((Object)this.tanks.get(tankIndex))).getFluid();
            if (fluidStack == null ^ (prev = (FluidStack)this.prevFluidStacks.get(tankIndex)) == null) {
                int fluidId = -1;
                int fluidAmount = 0;
                if (fluidStack != null) {
                    fluidId = fluidStack.fluidID;
                    fluidAmount = fluidStack.amount;
                }
                crafter.func_71112_a(container, tankIndex * 2 + 0, fluidId);
                PacketBuilder.instance().sendGuiIntegerPacket(player, container.field_75152_c, tankIndex * 2 + 1, fluidAmount);
                continue;
            }
            if (fluidStack == null || prev == null) continue;
            if (fluidStack.getFluid() != prev.getFluid()) {
                crafter.func_71112_a(container, tankIndex * 2 + 0, fluidStack.fluidID);
            }
            if (fluidStack.amount == prev.amount) continue;
            PacketBuilder.instance().sendGuiIntegerPacket(player, container.field_75152_c, tankIndex * 2 + 1, fluidStack.amount);
        }
        StandardTank tank = (StandardTank)((Object)this.tanks.get(tankIndex));
        this.prevFluidStacks.set(tankIndex, tank.getFluid() == null ? null : tank.getFluid().copy());
    }

    public void processGuiUpdate(int messageId, int data) {
        int tankIndex = messageId / 2;
        if (tankIndex >= this.tanks.size()) {
            return;
        }
        FluidStack fluidStack = ((StandardTank)((Object)this.tanks.get(tankIndex))).getFluid();
        if (fluidStack == null) {
            fluidStack = new FluidStack(-1, 0);
            ((StandardTank)((Object)this.tanks.get(tankIndex))).setFluid(fluidStack);
        }
        int fluidId = fluidStack.fluidID;
        int amount = fluidStack.amount;
        boolean newLiquid = false;
        switch (messageId % 2) {
            case 0: {
                fluidId = data;
                newLiquid = true;
                break;
            }
            case 1: {
                amount = data;
            }
        }
        if (newLiquid) {
            fluidStack = new FluidStack(fluidId, 0);
            ((StandardTank)((Object)this.tanks.get(tankIndex))).setFluid(fluidStack);
        }
        fluidStack.amount = amount;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.fill(0, resource, doFill);
    }

    public int fill(int tankIndex, FluidStack resource, boolean doFill) {
        if (tankIndex < 0 || tankIndex >= this.tanks.size() || resource == null) {
            return 0;
        }
        return ((StandardTank)((Object)this.tanks.get(tankIndex))).fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(0, maxDrain, doDrain);
    }

    public FluidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        if (tankIndex < 0 || tankIndex >= this.tanks.size()) {
            return null;
        }
        return ((StandardTank)((Object)this.tanks.get(tankIndex))).drain(maxDrain, doDrain);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        for (StandardTank tank : this.tanks) {
            if (!this.tankCanDrainFluid((IFluidTank)tank, resource)) continue;
            return tank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection direction) {
        FluidTankInfo[] info = new FluidTankInfo[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            info[i] = this.get(i).getInfo();
        }
        return info;
    }

    public FluidTankInfo[] getTankInfo() {
        return this.getTankInfo(ForgeDirection.UNKNOWN);
    }

    public StandardTank get(int tankIndex) {
        if (tankIndex < 0 || tankIndex >= this.tanks.size()) {
            return null;
        }
        return (StandardTank)((Object)this.tanks.get(tankIndex));
    }

    public void setCapacity(int tankIndex, int capacity) {
        StandardTank tank = this.get(tankIndex);
        tank.setCapacity(capacity);
        FluidStack fluidStack = tank.getFluid();
        if (fluidStack != null && fluidStack.amount > capacity) {
            fluidStack.amount = capacity;
        }
    }

    public void outputLiquid(AdjacentTileCache cache, ITileFilter filter, ForgeDirection[] sides, int tankIndex, int amount) {
        for (ForgeDirection side : sides) {
            IFluidHandler tank;
            TileEntity tile = cache.getTileOnSide(side);
            if (!filter.matches(tile) || (tank = TankManager.getTankFromTile(tile)) == null) continue;
            this.outputLiquid((IFluidHandler)tile, side, tankIndex, amount);
        }
    }

    public void outputLiquid(IFluidHandler[] outputs, int tankIndex, int amount) {
        for (int side = 0; side < 6; ++side) {
            IFluidHandler nearbyTank = outputs[side];
            if (nearbyTank == null) continue;
            this.outputLiquid(nearbyTank, ForgeDirection.getOrientation((int)side), tankIndex, amount);
        }
    }

    public static IFluidHandler getTankFromTile(TileEntity tile) {
        IFluidHandler tank = null;
        if (tile instanceof IFluidHandler) {
            tank = (IFluidHandler)tile;
        }
        return tank;
    }

    private void outputLiquid(IFluidHandler tank, ForgeDirection side, int tankIndex, int amount) {
        int used;
        FluidStack available = this.drain(tankIndex, amount, false);
        if (available != null && (used = tank.fill(side.getOpposite(), available, true)) > 0) {
            this.drain(tankIndex, used, true);
        }
    }

    private boolean tankAcceptsFluid(IFluidTank tank, FluidStack fluidStack) {
        if (fluidStack == null) {
            return false;
        }
        return tank.fill(fluidStack, false) > 0;
    }

    private boolean tankCanDrainFluid(IFluidTank tank, FluidStack fluidStack) {
        if (fluidStack == null) {
            return false;
        }
        FluidStack drained = tank.drain(1, false);
        return drained != null && drained.amount > 0;
    }
}

