/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.fluids;

import java.util.HashSet;
import java.util.Set;
import mods.railcraft.common.fluids.FluidHelper;
import mods.railcraft.common.fluids.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.FluidStack;

public class BucketHandler {
    public static BucketHandler INSTANCE = new BucketHandler();
    public final Set allowedFluids = new HashSet();

    private BucketHandler() {
        this.allowedFluids.add(Fluids.CREOSOTE.get());
    }

    @ForgeSubscribe
    public void onBucketFill(FillBucketEvent event) {
        ItemStack result = this.fillCustomBucket(event.world, event.target, event.current);
        if (result == null) {
            return;
        }
        event.result = result;
        event.setResult(Event.Result.ALLOW);
    }

    private ItemStack fillCustomBucket(World world, MovingObjectPosition pos, ItemStack stack) {
        int blockId = world.func_72798_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
        FluidStack fluidStack = FluidHelper.drainBlock(blockId, world, pos.field_72311_b, pos.field_72312_c, pos.field_72309_d, false);
        if (fluidStack == null) {
            return null;
        }
        if (!this.allowedFluids.contains(fluidStack.getFluid())) {
            return null;
        }
        ItemStack filled = FluidHelper.fillContainer(fluidStack, stack);
        if (filled != null) {
            FluidHelper.drainBlock(blockId, world, pos.field_72311_b, pos.field_72312_c, pos.field_72309_d, true);
        }
        return filled;
    }
}

