/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.emblems;

import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.aesthetics.post.EnumPost;
import mods.railcraft.common.blocks.aesthetics.post.ItemPost;
import mods.railcraft.common.emblems.ItemEmblem;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.EnumColor;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class EmblemPostEmblemRecipe
implements IRecipe {
    private ItemStack postTemplate;
    private ItemStack emblemPostTemplate;

    public ItemStack getEmblemPost() {
        if (this.emblemPostTemplate == null) {
            this.emblemPostTemplate = EnumPost.EMBLEM.getItem();
        }
        return this.emblemPostTemplate;
    }

    public ItemStack getPost() {
        if (this.postTemplate == null) {
            this.postTemplate = EnumPost.METAL.getItem();
        }
        return this.postTemplate;
    }

    private boolean isEmblem(ItemStack stack) {
        return ItemEmblem.item != null && stack.field_77993_c == ItemEmblem.item.field_77779_bT;
    }

    private boolean isPost(ItemStack stack) {
        if (stack.field_77993_c == RailcraftBlocks.getBlockPostMetal().field_71990_ca) {
            return true;
        }
        return InvTools.isItemEqual(stack, this.getPost(), true, false);
    }

    public boolean func_77569_a(InventoryCrafting craftingGrid, World var2) {
        int numPost = 0;
        int numEmblem = 0;
        for (int slot = 0; slot < craftingGrid.func_70302_i_(); ++slot) {
            ItemStack stack = craftingGrid.func_70301_a(slot);
            if (stack == null) continue;
            if (this.isPost(stack)) {
                ++numPost;
                continue;
            }
            if (this.isEmblem(stack)) {
                ++numEmblem;
                continue;
            }
            return false;
        }
        return numPost == 1 && numEmblem == 1;
    }

    public ItemStack func_77572_b(InventoryCrafting craftingGrid) {
        ItemStack post = null;
        ItemStack emblem = null;
        for (int slot = 0; slot < craftingGrid.func_70302_i_(); ++slot) {
            ItemStack stack = craftingGrid.func_70301_a(slot);
            if (stack == null) continue;
            if (this.isPost(stack)) {
                post = stack;
                continue;
            }
            if (this.isEmblem(stack)) {
                emblem = stack;
                continue;
            }
            return null;
        }
        if (post == null) {
            return null;
        }
        ItemStack result = EnumPost.EMBLEM.getItem();
        ItemPost.setEmblem(result, ItemEmblem.getEmblemIdentifier(emblem));
        if (post.field_77993_c == RailcraftBlocks.getBlockPostMetal().field_71990_ca) {
            InvTools.setItemColor(result, EnumColor.fromId(post.func_77960_j()));
        }
        return result;
    }

    public int func_77570_a() {
        return 2;
    }

    public ItemStack func_77571_b() {
        return this.getEmblemPost();
    }
}

